unit finddlg;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls;

type
  TFindDialog = class(TForm)
    Bevel1: TBevel;
    Label1: TLabel;
    EditName: TEdit;
    ListBoxFound: TListBox;
    Label2: TLabel;
    ButtonStart: TButton;
    Label3: TLabel;
    LabelScanning: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    LabelHits: TLabel;
    ButtonCancel: TButton;
    Label4: TLabel;
    procedure ButtonCancelClick(Sender: TObject);
    procedure ButtonStartClick(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    filename: string;
    UserCancel: boolean;
    UserStart: boolean;
    function Execute: boolean;
    procedure AddItem(text: string);
    { Public declarations }

  end;

var
  FindDialog: TFindDialog;

implementation

{$R *.dfm}


function TFindDialog.Execute: boolean;
begin
  UserCancel:=false;
  UserStart:=false;
  ButtonStart.enabled:=true;
  EditName.enabled:=true;
  EditName.color:=clWindow;
  LabelScanning.caption:='';
  LabelHits.Caption:='';
  ListBoxFound.Items.clear;

  show;
  while (NOT UserCancel) AND (NOT UserStart) do
  begin
    application.ProcessMessages;
  end;
  if UserCancel then hide;
  result:=UserStart;
end;


procedure TFindDialog.AddItem(text: string);
begin
  ListboxFound.items.add(text);
  if ListboxFound.items.count > 5 then
    ListboxFound.TopIndex:=FindDialog.ListboxFound.items.count-5;
  LabelHits.Caption:=inttostr(ListBoxFound.Items.count);
end;


procedure TFindDialog.ButtonCancelClick(Sender: TObject);
begin
  UserCancel:=true;
end;

procedure TFindDialog.ButtonStartClick(Sender: TObject);
begin
  EditName.enabled:=false;
  EditName.color:=clInactiveBorder;
  ButtonStart.enabled:=false;
  ButtonCancel.SetFocus;
  filename:=EditName.text;
  if filename = '' then filename:='*';
  if pos('.', filename) = 0 then filename:='*'+filename+'*';
  UserStart:=true;
end;

procedure TFindDialog.FormShow(Sender: TObject);
begin
  EditName.SetFocus;
end;

end.
