unit drvdlg;

interface

uses
  SysUtils, Windows, Messages, Classes, Graphics, Controls,
  StdCtrls, ExtCtrls, Forms, ComCtrls, diskfs, helpers, sysinfo, devices,
  Buttons;

type
  TDriveDlg = class(TForm)
    ButtonOK: TButton;
    Button2: TButton;
    PageControl1: TPageControl;
    TabsheetLogicalDrv: TTabSheet;
    TabSheetPhysicalDrv: TTabSheet;
    Label1: TLabel;
    Panel1: TPanel;
    Button3: TButton;
    ButtonPreview: TButton;
    ListView1: TListView;
    ListView2: TListView;
    ComboBoxFAT: TComboBox;
    LabelFAT: TLabel;
    CheckBoxSkipBadClus: TCheckBox;
    ButtonFind: TBitBtn;
    procedure FormActivate(Sender: TObject);
    procedure PageControl1Change(Sender: TObject);
    procedure ButtonFindClick(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure ButtonPreviewClick(Sender: TObject);
    procedure ListView1Click(Sender: TObject);
    procedure ListView2Click(Sender: TObject);
    procedure ListView1DblClick(Sender: TObject);
    procedure ComboBoxFATChange(Sender: TObject);
  public
    DrvSelected: byte;
    useFAT: byte;
    SkipBadClus: boolean;
    function Execute: boolean;
  private
    procedure CheckControls;
    procedure UpdateDlgOptions;
  end;

var
  DriveDlg: TDriveDlg;

implementation

uses main, pdiskio, ldiskio, secdlg, statusdlg, predrdlg;

{$R *.DFM}

const
  LVM_FIRST              = $1000;      // ListView messages
  LVM_SETTEXTCOLOR       = (LVM_FIRST + 36);

  

function TDriveDlg.Execute: boolean;
begin
  if drivedlg.showmodal <> idCancel then
  begin
    DrvSelected:=ListView1.itemindex;
    useFAT:=ComboBoxFAT.itemindex;
    SkipBadClus:=CheckBoxSkipBadClus.checked;

    result:=true;
  end else result:=false;
end;

procedure TDriveDlg.FormActivate(Sender: TObject);
var
  i: integer;
  size: real;
  DevIdx: integer;
  sDev, volname: string;
  ListItem: TListItem;
begin
  ButtonOK.enabled:=false;
  ButtonPreview.enabled:=false;
  ButtonFind.enabled:=false;

  listview2.clear;
  listview1.clear;

  { list physical devices... }
  for i:=0 to MainForm.DevList.count-1 do
  begin
    with MainForm.devList.GetDevice(i) do
    begin
      if (driver = DRIVER_TYPE_PHYS) then
      begin
        ListItem := ListView2.Items.Add;
        case DevType of
          DEVICE_TYPE_FLOPPY:       ListItem.ImageIndex := 0;
          DEVICE_TYPE_REMOVABLE:    ListItem.ImageIndex := 0;
          DEVICE_TYPE_FIXED:        ListItem.ImageIndex := 1;
          else  ListItem.ImageIndex := 1;
        end;
        ListItem.Caption :=name;
      end;
    end;
  end;

  { list logical drives... }
  for i:=0 to MainForm.DrvList.count-1 do
  begin
    with MainForm.drvList.GetDrive(i) do
    begin
        ListItem := ListView1.Items.Add;
        case dev.DevType of
            DEVICE_TYPE_UNKNOWN:       ListItem.ImageIndex := 1;
            DEVICE_TYPE_FLOPPY,
            DEVICE_TYPE_REMOVABLE:     ListItem.ImageIndex := 0;
            DEVICE_TYPE_FIXED:         ListItem.ImageIndex := 1;
            DEVICE_TYPE_REMOTE:        ListItem.ImageIndex := 3;
            DEVICE_TYPE_CDROM:         ListItem.ImageIndex := 2;
            DEVICE_TYPE_RAMDISK:       ListItem.ImageIndex := 1;
            else                       ListItem.ImageIndex := 1;
        end;
        {if (condition AND drv_cond_virtual <> 0) then
          SendMessage(listitem.handle, LVM_SETTEXTCOLOR, 0, RGB(255, 0, 0));}
        volname:=name;
        if volname = '' then volname:='NONAME';
        devIdx:=MainForm.DevList.IndexOf(dev);
        if devIdx <> -1 then
          sDev:=MainForm.DevList.GetDeviceText(devIdx, false)
        else sDev:='';
        ListItem.Caption :=  volname+'   on '+sDev;
      end;
  end;
end;


procedure TDriveDlg.UpdateDlgOptions;
var
  i: integer;
  drv: TCustomDrive;
begin
  ComboBoxFAT.clear;
  if listview1.itemindex >= 0 then
  begin
    drv:=Mainform.DrvList.GetDrive(ListView1.itemindex);
    if drv is TFATdrive then
    begin
      ComboBoxFAT.items.add('no');
      for i:=1 to (Drv as TFATDrive).BootSec.BPB_NumFATs do
        ComboBoxFAT.items.add(inttostr(i));
      ComboBoxFAT.itemindex:=(Drv as TFATDrive).useFAT;
      ComboBoxFAT.enabled:=true;
    end else ComboBoxFAT.enabled:=false;
  end;
end;

procedure TDriveDlg.ComboBoxFATChange(Sender: TObject);
var
  drv: TCustomDrive;
begin
  if listview1.itemindex >= 0 then
  begin
    drv:=Mainform.DrvList.GetDrive(ListView1.itemindex);
    (drv as TFATDrive).useFAT:=ComboBoxFAT.itemindex;
  end;
end;


procedure TDriveDlg.CheckControls;
begin
  if pagecontrol1.activepage = TabSheetLogicalDrv then
  begin
    // logical drives...
    if listview1.itemindex >= 0 then
    begin
      LabelFAT.enabled:=true;
      ComboBoxFAT.enabled:=true;
      CheckboxSkipBadClus.enabled:=true;
      ButtonFind.enabled:=true;
      ButtonOK.enabled:=true;
      ButtonPreview.enabled:=true;
      UpdateDlgOptions;
    end else
    begin
      LabelFAT.enabled:=false;
      ComboBoxFAT.Clear;
      ComboBoxFAT.enabled:=false;
      CheckboxSkipBadClus.enabled:=false;
      ButtonFind.enabled:=false;
      ButtonOK.enabled:=false;
      ButtonPreview.enabled:=false;
    end;
  end else
  begin
    // physical drives...
    LabelFAT.enabled:=false;
    ComboBoxFAT.Clear;
    ComboBoxFAT.enabled:=false;
    CheckboxSkipBadClus.enabled:=false;
    ButtonPreview.Enabled:=false;
    if listview2.itemindex >= 0 then
    begin
      ButtonFind.enabled:=true;
      //ButtonOK.enabled:=true;
    end else
    begin
      ButtonFind.enabled:=false;
      ButtonOK.enabled:=false;
    end;
  end;
end;

procedure TDriveDlg.PageControl1Change(Sender: TObject);
begin
  CheckControls;
end;


// Find logical drive...
procedure TDriveDlg.ButtonFindClick(Sender: TObject);
var
  dev: TDevice;
begin
  if pagecontrol1.activepage = TabSheetLogicalDrv then
  begin
    Dev:=Mainform.DrvList.GetDrive(drivedlg.listview1.itemindex).Dev;
  end else Dev:=Mainform.DevList.GetDevice(drivedlg.listview2.itemindex);

  with SectorDialog do
  begin
    totalsec:=dev.TotalSec;
    startsec:=0;
    if (dev.TotalSec < 100000) then endsec:=dev.TotalSec-1
      else endsec:=100000;
    bytesPerSec:=dev.BytesPerSec;
  end;
  if sectordialog.execute then
  begin
    dev.FindLostDrives(MainForm.devList, sectordialog.startsec, sectordialog.endsec); 
    PageControl1.ActivePage:=TabsheetLogicalDrv;
  end;
end;


procedure TDriveDlg.Button3Click(Sender: TObject);
var
  i: integer;
  dev: TDevice;
begin
  if MessageBox(windowhandle, pchar('This will '+
      ' also clear all ''lost drives'' that have been found from the list!'+#13#10
      +'Are you sure to proceed? '),
      'Rescan for drives', mb_applmodal + mb_IconInformation + mb_yesno) = idyes then
  begin
    Mainform.detectDrives;
    FormActivate(Sender);
  end;
end;

procedure TDriveDlg.ButtonPreviewClick(Sender: TObject);
begin
  PreviewDrvDialog.drv:=Mainform.DrvList.GetDrive(listview1.itemindex);
  PreviewDrvDialog.Execute;
end;


procedure TDriveDlg.ListView1Click(Sender: TObject);
begin
  CheckControls;
end;

procedure TDriveDlg.ListView2Click(Sender: TObject);
begin
  CheckControls;
end;

procedure TDriveDlg.ListView1DblClick(Sender: TObject);
begin
  CheckControls;
  modalresult:=mrOK;
end;


end.
