unit dinfodlg;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls, 
  Buttons, ExtCtrls, devices;

type
  TDriveInfoDialog = class(TForm)
    OKBtn: TButton;
    Bevel1: TBevel;
    LabelCyl: TLabel;
    LabelHeads: TLabel;
    LabelSecPerTrk: TLabel;
    LabelSectors: TLabel;
    LabelBytesPerSec: TLabel;
    EditCyl: TEdit;
    EditHeads: TEdit;
    EditSectors: TEdit;
    EditBytesPerSec: TEdit;
    EditSecPerTrk: TEdit;
    Label1: TLabel;
    EditName: TEdit;
  private
    { Private declarations }
  public
    { Public declarations }
    function Execute(dev: TDevice): boolean;
  end;

var
  DriveInfoDialog: TDriveInfoDialog;

implementation

uses pdiskio, ldiskio;

{$R *.DFM}

function TDriveInfoDialog.Execute(dev: TDevice): boolean;
var
  phys: TPhysDriveParams;
  log: TLogDriveParams;
begin
  with dev do
  begin
    EditName.text:=dev.name;
    if driver = DRIVER_TYPE_PHYS then
    begin
      GetPhysDriveParams(drv, @phys);
      EditCyl.text:=Format('%D',[phys.TracksPerHead]);
      EditHeads.text:=Format('%D',[phys.Heads]);
      EditSecPerTrk.text:=Format('%D',[phys.SectorsPerTrack]);
      EditSectors.text:=Format('%D',[phys.TotalPhysSec]);
      EditBytesPerSec.text:=Format('%D',[phys.BytesPerSector]);
    end else
    begin
      GetLogDriveParams(drv, @log);
      EditCyl.text:=Format('%D',[log.TracksPerHead]);
      EditHeads.text:=Format('%D',[log.heads]);
      EditSecPerTrk.text:=Format('%D',[log.SectorsPerTrack]);
      EditSectors.text:=Format('%D',[log.TotalPhysSec]);
      EditBytesPerSec.text:=Format('%D',[log.BytesPerSector]);
    end;
    showmodal;
  end;
  result:=modalresult = mrOK;
end;

end.
