unit clusdlg;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, ComCtrls, diskfs;

type
  TClusterDialog = class(TForm)
    OKBtn: TButton;
    CancelBtn: TButton;
    GroupBox1: TGroupBox;
    TrackBarStartClus: TTrackBar;
    GroupBox2: TGroupBox;
    TrackBarEndClus: TTrackBar;
    EditStartClus: TEdit;
    EditEndClus: TEdit;
    Label1: TLabel;
    Button1: TButton;
    LabelSize: TLabel;
    procedure TrackBarStartClusChange(Sender: TObject);
    procedure TrackBarEndClusChange(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure updateSize;
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }  
    totalclus: longword; // total clusters
    startclus: longword; // starting cluster
    endclus: longword;   // ending cluster
    bytesPerClus: word;  // bytes per cluster
    function Execute: boolean;
  end;

var
  ClusterDialog: TClusterDialog;

implementation

{$R *.DFM}




procedure TClusterDialog.TrackBarStartClusChange(Sender: TObject);
begin
  if trackbarstartclus.position <= trackbarendclus.position then
  begin
    EditStartClus.text:=inttostr(round((totalclus-2) *
      (Trackbarstartclus.position / Trackbarstartclus.max))+2);
    updatesize;
  end;
end;

procedure TClusterDialog.TrackBarEndClusChange(Sender: TObject);
begin
  if trackbarstartclus.position <= trackbarendclus.position then
  begin
    EditEndClus.text := inttostr(round((totalclus-2) *
      (TrackbarEndclus.position / TrackbarEndclus.max))+2+1);
    updateSize;
  end;
end;

procedure TClusterDialog.UpdateSize;
var
  startclus, endclus: longint;
  code: integer;
begin
    val(editstartclus.text, startclus, code);
    if code = 0 then
    begin
      val(editendclus.text, endclus, code);
      if code = 0 then
      begin
        labelSize.caption:=inttostr(
          round((endclus-startclus+1) / 1024 * BytesPerClus / 1024) )+' MB';
      end;
    end;
end;


{ Note: the CountofClusters value is exactly the count of data clusters starting at cluster 2.
  The maximum valid cluster number for the volume is CountofClusters + 1, and the "count of clusters including the two reserved
  clusters" is CountofClusters + 2. }
procedure TClusterDialog.FormActivate(Sender: TObject);
begin
  GroupBox1.caption:='Start cluster (min. 2)';
  GroupBox2.caption:='End cluster (max. '+inttostr(TotalClus+1)+')';
  TrackbarstartclusChange(sender);
  TrackbarEndclusChange(sender);

  updateSize;
end;

procedure TClusterDialog.Button1Click(Sender: TObject);
begin
  updatesize;
end;

function TClusterDialog.Execute: boolean;
var
  code: integer;
  startc, endc: longword;
begin
  if ClusterDialog.ShowModal = mrOK then
  begin
    val(clusterdialog.editstartclus.text, startc, code);
    if code = 0 then startclus:=startc;

    val(clusterdialog.editendclus.text, endc, code);
    if code = 0 then endclus:=endc;
  end else result:=false;
end;


end.
