unit predrdlg;
 
interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls, 
  Buttons, ExtCtrls, ComCtrls, main, devices;

type
  TPreviewDrvDialog = class(TForm)
    OKBtn: TButton;
    Bevel1: TBevel;
    Label1: TLabel;
    EditPhysSec: TEdit;
    Label2: TLabel;
    EditSecPerClus: TEdit;
    Label3: TLabel;
    EditFAT: TEdit;
    Label4: TLabel;
    EditOEM: TEdit;
    Label5: TLabel;
    EditVolLabel: TEdit;
    Label6: TLabel;
    EditTotalSec: TEdit;
    ListView1: TListView;
    Label7: TLabel;
  private
    { Private declarations }
  public
    drv: TCustomDrive;
    function Execute: boolean;
      { Public declarations }
  end;

var
  PreviewDrvDialog: TPreviewDrvDialog;

implementation

uses diskfs, drvdlg, helpers;

{$R *.DFM}



function TPreviewDrvDialog.Execute;
var
  i, j, count: integer;
  res: boolean;
  recno: word;
  entry: Tdirentry;
  lfname: string;
  cluster: longword;
  ListItem: TListItem;
  volname: string;
  recsec: longword;
begin
   if drv is TFATdrive then
   begin
      with (drv as TFATDrive), (drv as TFATDrive).BootSec do
      begin
        EditPhysSec.text    := inttostr(partofs);
        EditOEM.text        := BS_oemname;
        EditTotalSec.text   := inttostr(TotSec);
        EditSecPerClus.text := inttostr(BPB_SecPerClus);
        if FATtype = fat32 then volname:=bs32_vollab
          else volname:=pbootsec(@BootSec)^.bs_vollab;
        EditVolLabel.text   := volname;
        case FATtype of
           FATnone: EditFAT.text :='none';
           FAT12:   EditFAT.text :='FAT12';
           FAT16:   EditFAT.text :='FAT16';
           FAT32:   EditFAT.text :='FAT32';
        end;

      { Write files to ListView control }
      with listview1 do
      begin
        clear;
        count:=0; recno:=0; cluster:=RootClus; recsec:=FirstRootDirSecNum;
        repeat
          res:=FindNextEntry(cluster, recsec, recno, entry, lfname, false);
          if (res) AND (entry.DIR_attr AND (attrVolume) =0)
            AND (lfname <> '.') AND (lfname <> '..') then
          begin
            listitem:=items.add;
            listitem.caption:=lfname;
            if (entry.DIR_attr AND attrSubDir) <> 0 then
            begin
              listitem.subitems.add('');
              ListItem.ImageIndex:=idxFolderClosed
            end else
            begin
              listitem.subitems.add(longwordToStr(entry.DIR_filesize));
              ListItem.ImageIndex:=idxFile;
            end;
            listitem.subitems.add(fsTimeDate2Str(entry.DIR_WrtTime, entry.DIR_WrtDate));
            inc(count);
          end;
        until not res;
      end;
    end;

    showmodal;

  end;
end;

end.
