// The Initial Developer of the Original Code is
// Copyright (C) 2003 Joseph Leung Yat Chun(lycj@yahoo.com)
// All Rights Reserved
{Qz Html Support version 1.7}
{***************************************************************************}
{* 1.6 Made some modification to the redraw so it may fix the draw issue   *}
{* If it is still not working, try the one mentioned in                    *}
{* http://www.quickzip.org/forums/viewtopic.php?p=881#881                  *}
{* and post a message there.                                               *}
{***************************************************************************}
{* The contents of this file are subject to the Mozilla Public License     *}
{* Version 1.1 (the "License"); you may not use this file except in        *}
{* compliance with the License. You may obtain a copy of the License at    *}
{* http://www.mozilla.org/MPL/                                             *}
{*                                                                         *}
{* Software distributed under the License is distributed on an "AS IS"     *}
{* basis, WITHOUT WARRANTY OF ANY KIND, either express or implied. See the *}
{* License for the specific language governing rights and limitations      *}
{* under the License.                                                      *}
{*                                                                         *}
{* The Original Code is ______________________________________.            *}
{*                                                                         *}
{* The Initial Developer of the Original Code is _Leung Yat Chun, Joseph_. *}
{* Portions created by ______________________ are Copyright (C) _2003____  *}
{* _Leung Yat Chun,Joseph_. All Rights Reserved.                           *}
{*                                                                         *}
{* Contributor(s): ______________________________________.                 *}
{*                                                                         *}
{* Alternatively, the contents of this file may be used under the terms    *}
{* of the _LGPL_license (the  "[___] License"), in which case the          *}
{* provisions of [_LGPL_] License are applicable instead of those          *}
{* above.  If you wish to allow use of your version of this file only      *}
{* under the terms of the [LGPL] License and not to allow others to use    *}
{* your version of this file under the MPL, indicate your decision by      *}
{* deleting  the provisions above and replace  them with the notice and    *}
{* other provisions required by the [LGPL] License.  If you do not delete  *}
{* the provisions above, a recipient may use your version of this file     *}
{* under either the MPL or the [LGPL] License."                            *}
{***************************************************************************}
unit QzMiniHtml2;
{*********************************************************}
{*                    QzMiniHTML2.pas                    *}
{*                 Quick Zip HTML support                *}
{*     Copyright (c) 2003 Joseph Leung Yat Chun          *}
{*                 All rights reserved.                  *}
{*********************************************************}
{* How to install?                                       *}
{ 1.Remove previous version.                             *}
{ 2.Add QzMiniHtml2 and QzHtmlLabel2 , QzHtmlEdit2,      *}
{       QzHtmlEditor2, QzHtmlScrollBox2, QzHtmlCheckBox2 *}
{   to a Run Time Package (e.g. QzHtmlR), Compile it.    *}
{ 3.Add QzHtmlPropertyEditor to a Design Time Package    *}
{   (e.g. QzHtmlD), Compile it.                          *}
{   Design Time Package is toggle in Options\UsageOptions*}
{ 4.Install the Run Time Package (QzHtmlR)               *}
{                                                        *}
{ Delphi 7 version of packages is included               *}
{*********************************************************}
{* How to use?                                           *}
{  PQzMiniHtml2 (Draw on Canvas)                        *}
{  1.Drop QzMiniHtml2 on a Form.                         *}
{  2.Place the following line to init QzMiniHtml2        *}
{  3.QzMiniHtml2.Color := clWhite;                       *}
{    QzMiniHtml2.Canvas := yourCanvas;                   *}
{    QzMiniHtml2.Owner := Image1;                        *}
{    QzMiniHtml22.Width := yourCanvas.idth ;             *}
{    QzMiniHtml22.Height := yourCanvas.Height;           *}
{    QzMiniHtml22.Top := 0;                              *}
{    QzMiniHtml22.Left := 0;                             *}
{  4.Assign your text to Lines andthen call              *}
{    LoadFromLines                                       *}
{                                                        *}
{  PQzHtmlLabel2                                        *}
{  1.Drop QzHtmlLabel2 on a Form.                        *}
{  2.Setup Width and Height.                             *}
{  3.Use the <...> next to Caption to launch Editor or   *}
{    Assign text to QzHtmlLabel2.Html                    *}
{*********************************************************}
{* How to Enable Mouse Support?                          *}
{                                                        *}
{  URL HighLighting support :                            *}
{    QzMiniHtml21.MouseKBHandler1 :=                     *}
{               TNormalHandler.Create(Self,QzMiniHtml21);*}
{  Selection Block Support : (Not good...)               *}
{    QzMiniHtml2.MouseKBHandler2 :=                      *}
{               TBlockHandler.Create(Self,QzMiniHtml21); *}
{ Then Call QzMiniHtml2.MouseMove, MouseUp and MouseDown *}
{ when mouseaction on your form (or parent?)             *}
{*********************************************************}
{* How it Works?                                         *}
{ Each <> and text are assigned to aTag inside TagList.  *}
{ Then Update and Draw                                   *}
{ E.g. <p align="right">This is <b>a</b> Test.</p>       *}
{P1.) Convert to..                                      *}
{ TagList==>aPSTag+AText+ASpace+AText+ASpace+aBSTag+AText*}
{           +ABETag+AText+APETag                         *}
{P2.) Call Update and Call NextLine when needed.        *}
{   PaPSTag.Update will update all AText/ASpace.align   *}
{     to "right".                                        *}
{   PaText/aSpace.Update will update their width/height.*}
{   PaBSTag will update Font type in AText to bold.     *}
{P3.) Call Draw (to cache)                              *}
{   PNon Visible Tag (aInvisTag) draw nothing.          *}
{   PVisible Tag draws according their top/left         *}
{P4.) Draw on Canvas from cache                         *}
{*********************************************************}
{* To Do List                                            *}
{* Load Image from http (by InDy perhaps)                *}
{* Support Gif                                           *}
{*********************************************************}

interface

uses
   Dialogs,Forms, Windows, Messages, SysUtils, StrUtils, Classes, Controls, Graphics,
   StdCtrls,ShellApi,ExtCtrls,JPEG;

const TagSeperateSize = 0;
      DefaultFontsize = 8;
      DefaultFontName = 'MS Sans Serif';
      INDENTSIZE      = 50;
      HidTxtInUnkTag  = FALSE;
      LINESPACING     = TRUE;    //Support for WordWrap - Speed up if FALSE
      Border          = 5;
      TransparentColor= '#F1FEEF';
type
   TSelectionEvent = procedure ( Sender : TObject; Href : string) of object;
   THtmlUpdateEvent = procedure(Sender: TObject; newHtml : string; HKey : char) of object;
   TLinkClickedEvent = procedure(Sender: TObject; href : string; var Handled : boolean) of object;
   TFormElementClickedEvent = procedure(Sender: TObject; fmName, fmMethod, fmAction, inputName, inputType, inputValue : string) of object;
   TDynamicUpdateEvent = procedure ( Sender : TObject; dynamicID : string; var Text : string) of object;
   TUserDefinedUpdateEvent = procedure ( Sender : TObject; itemID,ItemType : string;
                             var Width, Height : integer;var variable1,variable2,variable3 : string) of object;
   TUserDefinedDrawEvent = procedure ( Sender : TObject; itemID,ItemType : string; Canvas : TCanvas; Rect : TRect;
                                         variable1,variable2,variable3 : string) of object;

   THTMLFlag    = (HTMLText, HTMLGraphic);
   TTextStyle   = (isNormal, isSubScript, isSuperScript); 
   THTMLFlags   = set of THTMLFlag;
   THTMLTagInfo = record
      Html: string;
      flags: THTMLFlags;
   end;

   TQzHtmlRec = class
             Html : string;
             Hotkey : Char;
             FHtmlUpdate : THtmlUpdateEvent;
             Owner : TComponent;
             constructor Create(o : TComponent);
             procedure SetHtml(input : string; HKey : char);
              end;

   TCurrentState = class
                     Font : TFont;
                     Visible : boolean;
                     BackGroundColor : TColor;
                     Indent : integer;
                     TargetURL : string;
                     Align : string;
                     FontColor,ActiveColor,VisitedColor,URLColor : TColor;
                     ListItemShowType : string;
                     fmName, fmMethod, fmAction : string;
                     Selected : boolean;
                     TextStyle : TTextStyle;
                     owner : TComponent;
                     StateTagList : TList;

                     procedure InitState;
                     procedure AddTag(Tag : TObject);
                     procedure RemoveTag(TagClass : TClass);
                     constructor Create(o : TComponent);
                     destructor Destroy; override;
                   end;
   TQzMiniHtml2 = class(TComponent)
                  private
                     FDynamicUpdate : TDynamicUpdateEvent;
                     FLinkClicked   : TLinkClickedEvent;
                     FFormElementClicked : TFormElementClickedEvent;
                     FUserDefinedUpdate : TUserDefinedUpdateEvent;
                     FUserDefinedDraw : TUserDefinedDrawEvent;
                     InputHtml : TQzHtmlRec;
                     function SplitSelected(splitwhich : integer) : integer;
                     procedure SetCaption(value : TQzHtmlRec);
                     function GetCaption : TQzHtmlRec;
                  public
                     currentState, selectionState : TCurrentState;
                     Lines : TStrings;
                     Canvas : TCanvas;
                     TagList : TList;
                     Focused : integer;
                     Color : TColor;
                     Owner : TComponent;
                     CacheBitmap : TBitmap;
                     Selecting : boolean;
                     LastCheckTime : Cardinal;
                     SelectStartFrom,SelectEndAt : integer;
                     MouseKBHandler1,MouseKBHandler2,MouseKBHandler3 : TComponent;
                     width, height, Left, Top, LineHeight : integer;
                     ScrollLeft,ScrollTop : integer;
                     LastPos, StartPos, EndPos, CurrentPos : TPoint;
                     constructor Create(AOwner: TComponent); override;
                     destructor Destroy; override;
                     procedure Readnexttag(text : string; var beforetag, aftertag, tagname, tagvars : string);
                     function processtag(variables : tstrings; tag : string) : TObject;
                     function Extractvariables(input : string) : tstrings;
                     procedure LoadFromLines;
                     procedure LoadFromCaption;
                     procedure LoadFromFiles(filename : string);
                     procedure LoadFromStream(Stream: TStream);
                     procedure PrintText(text : string;isURL : boolean);
                     procedure NextLine;
                     procedure Update; overload;
                     procedure Update(index : integer); overload;
                     procedure Draw; overload;
                     procedure Draw(index : integer); overload;
                     procedure ReDraw;
                     procedure Clear;
                     procedure ClearCache(Left,Top,Right,Bottom : integer); overload;
                     procedure ClearCache; overload;
                     procedure UnSelectAll;
                     procedure UpdateSelection(StartPos,EndPos : TPoint);
                     procedure ScrollDown(Pixel : integer);
                     procedure ScrollUp(Pixel : integer);
                     function GetHeight(s : string; FontType : TFont) : integer;
                     function GetWidth(s : string; FontType : TFont) : integer;
                     function GetHtml : string;
                     function TotalSelected : integer;

                     procedure Bold; overload; 
                     function  Bold(SelectionText : string; SelectionState : TCurrentState) : string; overload;
                     procedure Underline;

                     procedure MouseMove(Sender: TObject; Shift: TShiftState; X,Y: Integer);
                     procedure MouseDown(Sender: TObject; Button: TMouseButton;
                                         Shift: TShiftState; X, Y: Integer);
                     procedure MouseUp(Sender: TObject; Button: TMouseButton;
                                         Shift: TShiftState; X, Y: Integer);
                     property Caption : TQzHtmlRec read GetCaption write SetCaption;
                 published
                     property OnDynamicUpdate : TDynamicUpdateEvent read FDynamicUpdate write FDynamicUpdate;
                     property OnLinkClicked   : TLinkClickedEvent read FLinkClicked write FLinkClicked;
                     property OnFormElementClicked : TFormElementClickedEvent read FFormElementClicked write FFormElementClicked;
                     property OnUserDefinedUpdate : TUserDefinedUpdateEvent read FUserDefinedUpdate write FUserDefinedUpdate;
                     property OnUserDefinedDraw : TUserDefinedDrawEvent read FUserDefinedDraw write FUserDefinedDraw;
                   end;

////////////////////////////////////////////////////////////////////////////////
   atag      = class(TObject)
               public
                  tagName : string;
                  aHtml : TQzMiniHtml2;
                  Width, Height : integer;
                  Left, Top, LineNumber : integer;
                  variables : tstrings;
                  LineHeight : integer;
                  Selected : boolean;
                  Visible : boolean;
                  constructor Create(AOwner: TComponent; Tag1 : string); overload; virtual;
                  constructor Create(AOwner: TComponent);overload; virtual;
                  function GetHtml : string; virtual;
                  procedure SetHtml(commands : tstrings); virtual;
                  procedure Draw(aCanvas : Tcanvas); virtual;
                  procedure Update; overload; virtual;
                  procedure Update(var CurrentState : TCurrentState); overload; virtual;
                  function IsIn(aPoint : TPoint) : boolean; overload; virtual;
                  function IsIn(aRect  : TRect) : boolean; overload; virtual;
                end;
////////////////////////////////////////////////////////////////////////////////
   aVisTag   = class(aTag)
               public
               FontColor, URLColor, ActiveColor, VisitedColor : TColor;
               BackGroundColor : TColor;
               TargetURL : string;
               Visited, MouseOver : boolean;
               Font : TFont;
               align : string;
               constructor Create(AOwner: TComponent; Tag1 : string); override;
               destructor Destroy; override;
               procedure Select; virtual;
               procedure UnSelect; virtual;
               procedure Update; override;
               function IsIn(aPoint : TPoint) : boolean; overload; override;
               function IsIn(aRect  : TRect) : boolean; overload; override;
               end;
   aInVisTag = class(aTag)
               public
               procedure UpdateFontColor(Sender : aInVisTag; Tag : aVisTag; FontColor, URLColor, ActiveColor, VisitedColor : TColor);
               end;
 aInVisLNTag = class(aInVisTag);
 aLNInVisTag = class(aInVisTag);
 aDynamicTag = class(aInvisTag)
               public
               id : string;
               function GetHtml : string; override;
               procedure SetHtml(commands : tstrings); override;
               end;
////////////////////////////////////////////////////////////////////////////////
   aHtmlSTag = class(aInvisTag);
   aHtmlETag = class(aInVisTag);
   aHeadSTag = class(aInvisTag)
               public
                  procedure Update; override;
                  procedure Update(var CurrentState : TCurrentState); overload; override;
               end;
   aHeadETag = class(aInVisTag)
               public
                  procedure Update; override;
               end;
 aScriptSTag = class(aInvisTag)
               public
                  procedure Update; override;
                  procedure Update(var CurrentState : TCurrentState); overload; override;
               end;
 aScriptETag = class(aInVisTag)
               public
                  procedure Update; override;
               end;
   aBodySTag = class(aInvisTag)
               public
                  BackGroundColor, FontColor, URLColor, ActiveColor, VisitedColor : TColor;
                  procedure SetHtml(commands : tstrings); override;
                  function GetHtml : string; override;
                  procedure Update; override;
                  procedure Update(var CurrentState : TCurrentState); overload; override;
                  constructor Create(AOwner: TComponent; Tag1 : string); override;
                  procedure Draw(aCanvas : Tcanvas); override;
               end;
   aBodyETag = class(aInVisTag)
               public
                  procedure Update; override;
               end;
   aFontSTag = class(aInvisTag)
               public
                  FontName : String;
                  absoluteFontSize : boolean;
                  FontSize : integer;
                  FontColor : TColor;
                  procedure SetHtml(commands : tstrings); override;
                  function GetHtml : string; override;
                  procedure Update; override;
                  procedure Update(var CurrentState : TCurrentState); overload; override;
                  constructor Create(AOwner: TComponent; Tag1 : string); override;
               end;
   aFontETag = class(aInVisTag)
               public
                  procedure Update; override;
               end;
aBlockquoteSTag = class(aLNInVisTag)
                  public
                  procedure Update; override;
                  procedure Update(var CurrentState : TCurrentState); overload; override;
                  end;
aBlockquoteETag = class(aInVisLNTag)
                  public
                  procedure Update; override;
                  end;
   aPSTag    = class(aLNInVisTag)
               public
                  Align : string;
                  BackGroundColor : TColor;
                  StartHeight,EndHeight : integer;
                  procedure SetHtml(commands : tstrings); override;
                  function GetHtml : string; override;
                  procedure Update; override;
                  procedure Update(var CurrentState : TCurrentState); overload; override;
                  procedure Draw(aCanvas : Tcanvas); override;
               end;
   aPETag    = class(aInVisLNTag)
               public
                  procedure Update; override;
               end;
   aBRTag   = class(aInVisLNTag);
   aUSTag   = class(aInVisTag)
               public
                  procedure Update; override;
                  procedure Update(var CurrentState : TCurrentState); overload; override;
               end;
   aUETag   = class(aInVisTag)
               public
                  procedure Update; override;
               end;
   aBSTag   = class(aInVisTag)
               public
                  procedure Update; override;
                  procedure Update(var CurrentState : TCurrentState); overload; override;
               end;
   aBETag   = class(aInVisTag)
               public
                  procedure Update; override;
               end;
   aSSTag   = class(aInVisTag)
               public
                  procedure Update; override;
                  procedure Update(var CurrentState : TCurrentState); overload; override;
               end;
   aSETag   = class(aInVisTag)
               public
                  procedure Update; override;
               end;
   aISTag   = class(aInVisTag)
               public
                  procedure Update; override;
                  procedure Update(var CurrentState : TCurrentState); overload; override;
               end;
   aIETag   = class(aInVisTag)
               public
                  procedure Update; override;
               end;
   aASTag   = class(aInVisTag)
               public
                  TargetURL : string;
                  procedure SetHtml(commands : tstrings); override;
                  function GetHtml : string; override;
                  procedure Update; override;
                  procedure Update(var CurrentState : TCurrentState); overload; override;
               end;
   aAETag   = class(aInVisTag)
               public
                  procedure Update; override;
               end;
   aULSTag   = class(aInVisLNTag)
               public
                  ShowType : string;
                  procedure SetHtml(commands : tstrings); override;
                  function GetHtml : string; override;
                  procedure Update; override;
                  procedure Update(var CurrentState : TCurrentState); overload; override;
               end;
   aULETag   = class(aInVisTag)
               public
                  procedure Update; override;
               end;
   aOLSTag   = class(aInVisLNTag)
               public
                  procedure Update; override;
                  procedure Update(var CurrentState : TCurrentState); overload; override;
               end;
   aOLETag   = class(aInVisTag)
               public
                  procedure Update; override;
               end;
   aSubSTag  = class(aInVisTag)
               public
                  procedure Update; override;
                  procedure Update(var CurrentState : TCurrentState); overload; override;
               end;
   aSubETag  = class(aInVisTag)
               public
                  procedure Update; override;
               end;
   aSupSTag  = class(aInVisTag)
               public
                  procedure Update; override;
                  procedure Update(var CurrentState : TCurrentState); overload; override;
               end;
   aSupETag  = class(aInVisTag)
               public
                  procedure Update; override;
               end;
  aTitleSTag = class(aInVisLNTag);
  aTitleETag = class(aInVisLNTag);
   aLIETag   = class(aInVisLNTag);


aTableSTag = class(aLNInVisTag)
               public
                 tblWidth : integer;
                 tblBorder : integer;
                 bgColor : TColor;
                 procedure SetHtml(commands : tstrings); override;
                 procedure Update; override;
//                 function GetHtml : string; override;
               end;
aTableETag = class(aInVisLNTag)
               public
               end;
   aTRSTag = class(aInVisTag)
               public
                 ColCount, rowTop : integer;
                 tblWidth : integer;
                 tblBorder : integer;
                 bgColor : TColor;
                 procedure SetHtml(commands : tstrings); override;
                 procedure Update; override;
//                 function GetHtml : string; override;
                 //procedure Draw(aCanvas : Tcanvas); override;
               end;

   aTRETag = class(aLNInvisTag)
               public
//                 procedure update; override;
               end;
   aTDSTag = class(aVisTag)
               public
                 //MiniHtml : TQzMiniHtml2;
                 tblBorder : integer;
                 bgColor : TColor;
                 tblWidth : integer;
                 colCount : integer;
                 colNumber : integer;
                 Html : string;
                 procedure SetHtml(commands : tstrings); override;
                 procedure Update; override;
                 procedure Draw(aCanvas : Tcanvas); override;
                 //function GetHtml : string; override;
               end;
   aTDETag = class(aInvisTag);

aTxtHideSTag = class(aLNInVisTag)
               public
                 TagName : string;
                 constructor Create(AOwner: TComponent;Tag : string); overload; override;
                 procedure Update; override;
                 procedure Update(var CurrentState : TCurrentState); overload; override;
               end;

aTxtHideETag = class(aInVisLNTag)
               public
                 TagName : string;
                 procedure Update; override;
                 constructor Create(AOwner: TComponent;Tag : string); overload; override;
               end;
   aFormSTag = class(aLNInvisTag)
               public
                  fmName, fmMethod, fmAction : string;
                  procedure SetHtml(commands : tstrings); override;
                  function GetHtml : string; override;
                  procedure Update; override;
                  procedure Update(var CurrentState : TCurrentState); overload; override;
               end;

   aFormETag = class(aInvisLNTag)
               public
                  procedure Update; override;
               end;
aUnknownSTag = class(aTxtHideSTag);
aUnknownETag = class(aTxtHideETag);
aSelectionSTag = class(aInvisTag)
                 public
                  function GetHtml : string; override;
                  procedure Update; override;
                  procedure Update(var CurrentState : TCurrentState); overload; override;
                 end;

aSelectionETag = class(aInvisTag)
                 public
                  function GetHtml : string; override;
                  procedure Update; override;
                 end;

////////////////////////////////////////////////////////////////////////////////
   aSpace    = class(aVisTag)
               public
                  Text : string;
                  procedure Draw(aCanvas : Tcanvas); override;
                  procedure Update; override;
               end;
   aText     = class(aVisTag)
               public
                  Text : string;
                  SelStart, SelStop : integer;
                  SelStartX, SelStopX : integer;
                  TextStyle : TTextStyle; 
                  procedure Draw(aCanvas : Tcanvas); override;
                  function GetHtml : string; override;
                  procedure Update; override;
                  procedure Select(TopLeft, BottomRight : TPoint; CheckLeftside, CheckRightside : boolean); overload; 
                  procedure UnSelect; override;
                  constructor Create(AOwner: TComponent;input : string); override;
               end;
   aPicture  = class(aVisTag)
               public
                  Align : string;
                  PictureURL, Cache : string;
                  ActualHeight, ActualWidth : integer;
                  Text : string;
                  procedure Draw(aCanvas : Tcanvas); override;
                  constructor Create(AOwner: TComponent; Tag1 : string); override;
                  function GetHtml : string; override;
                  procedure Update; override;
               end;
   aHorizontalRule = class(aVisTag)
               public
                  rwidth, size : integer;
                  noshade : boolean;
                  procedure SetHtml(commands : tstrings); override;
                  procedure Draw(aCanvas : Tcanvas); override;
                  constructor Create(AOwner: TComponent; width : integer); overload;
                  function GetHtml : string; override;
                  procedure Update; override;
               end;
   aLISTag = class(aVisTag)
              public
                  ShowType : string;
                  Counter : integer;
                  procedure Draw(aCanvas : Tcanvas); override;
                  procedure Update; override;
               end;

aFormElement = class(aVisTag)
               public
                  fmName, fmMethod, fmAction : string;
                  inputName, inputType, inputValue : string;
                  checked : boolean;
                  procedure SetHtml(commands : tstrings); override;
                  procedure Draw(aCanvas : Tcanvas); override;
                  function GetHtml : string; override;
                  procedure Update; override;                  
               end;
aUserDefined = class(aVisTag)
               public
                 variable1, variable2, variable3 : string;
                 itemID,ItemType : string;
                 procedure SetHtml(commands : tstrings); override;
                 procedure Draw(aCanvas : Tcanvas); override;
                 function GetHtml : string; override;
                 procedure Update; override;
               end;

THandler       = class(TComponent)
                  public
                     aMiniHtml : TQzMiniHtml2;
                     constructor Create(AOwner: TComponent; aHtml : TQzMiniHtml2); overload;  virtual;
                     procedure MouseMove(Sender: TObject; Shift: TShiftState; X,Y: Integer); virtual;
                     procedure MouseDown(Sender: TObject; Button: TMouseButton;
                                         Shift: TShiftState; X, Y: Integer); virtual;
                     procedure MouseUp(Sender: TObject; Button: TMouseButton;
                                         Shift: TShiftState; X, Y: Integer); virtual;
                  end;
TBlockHandler = class(THandler)
                 public
                     procedure MouseMove(Sender: TObject; Shift: TShiftState; X,Y: Integer); override;
                     procedure MouseDown(Sender: TObject; Button: TMouseButton;
                                         Shift: TShiftState; X, Y: Integer); override;
                     procedure MouseUp(Sender: TObject; Button: TMouseButton;
                                         Shift: TShiftState; X, Y: Integer); override;
                 end;

TNormalHandler = class(THandler)
                  public
                     procedure MouseMove(Sender: TObject; Shift: TShiftState; X,Y: Integer); override;
                     procedure MouseDown(Sender: TObject; Button: TMouseButton;
                                         Shift: TShiftState; X, Y: Integer); override;
                     procedure MouseUp(Sender: TObject; Button: TMouseButton;
                                         Shift: TShiftState; X, Y: Integer); override;
                  end;
TFormElementHandler = class(THandler)
                  public
                     procedure MouseDown(Sender: TObject; Button: TMouseButton;
                                         Shift: TShiftState; X, Y: Integer); override;
                  end;
const MaxBuiltinTags = 33;
const BuiltinTags: array[1..MaxBuiltinTags] of THTMLTagInfo = (
(Html:'html'       ; flags: [                          ]),
(Html:'head'       ; flags: [                          ]),
(Html:'script'     ; flags: [                          ]),
(Html:'body'       ; flags: [                          ]),
(Html:'font'       ; flags: [                          ]),
(Html:'blockquote' ; flags: [                          ]),
(Html:'indent'     ; flags: [                          ]),
(Html:'p'          ; flags: [                          ]),
(Html:'div'        ; flags: [                          ]),
(Html:'br'         ; flags: [                          ]),
(Html:'u'          ; flags: [                          ]),
(Html:'b'          ; flags: [                          ]),
(Html:'s'          ; flags: [                          ]),
(Html:'i'          ; flags: [                          ]),
(Html:'a'          ; flags: [                          ]),
(Html:'ul'         ; flags: [                          ]),
(Html:'ol'         ; flags: [                          ]),
(Html:'li'         ; flags: [                          ]),
(Html:'title'      ; flags: [                          ]),
(Html:'img'        ; flags: [                          ]),
(Html:'hr'         ; flags: [                          ]),
(Html:'dynamic'    ; flags: [                          ]),
(Html:'html'       ; flags: [                          ]),
(Html:'input'      ; flags: [                          ]),
(Html:'user'       ; flags: [                          ]),
(Html:'selection'  ; flags: [                          ]),
(Html:'hi'         ; flags: [                          ]),
(Html:'sub'        ; flags: [                          ]),
(Html:'sup'        ; flags: [                          ]),
(Html:'table'      ; flags: [                          ]),
(Html:'tr'         ; flags: [                          ]),
(Html:'td'         ; flags: [                          ]),
(Html:'th'         ; flags: [                          ])
);
////////////////////////////////////////////////////////////////////////////////
function Tcolor2Webcolor(acolor : tcolor) : string;
function Webcolor2TColor(colorstring : string) : TColor;
function LocateTag(Tag : string; flags: THTMLFlags) : integer;
function CountCharInStr(str : string; chr : char) : integer;
function DrawHtmlOnCanvas(Canvas : TCanvas; Left,Top,Width : integer; Html : string) : integer;
function CalcHeight(Html : string; width : integer) : integer;

procedure Register;

implementation
{$R QzHtml2.Res}
var MouseOver : TObject;
function LocateTag(Tag : string; flags: THTMLFlags) : integer;
var i : integer;
    k : string;
begin
    Result := 0;
    if Tag = '' then exit;
    if Tag[1] = '<' then k := (Copy(Tag,2,Length(Tag)-2)) else
                         k := lowercase(Tag);

    if length(k) > 0 then
    if k[1] = '/' then k := Copy(k,2,Length(Tag)-1);

    for i := 1 to MaxBuiltinTags do
      if BuiltinTags[i].Html = k then
        begin
          if flags = BuiltInTags[i].flags then
            if Tag[1] = '/' then
             result := i*-1 else
             result := i;
             exit;
        end;
end;

function replace(source : string; fromm, too : string) : string;
var i : integer;
begin
        Result := AnsiReplaceText(source,fromm,too);
{        i := pos(fromm,'^' + source);
        if i <> 0 then
        begin
        dec(i);
        if i = 0 then
        result := too + copy(source,length(fromm),length(source)-length(fromm)+1);
        result := copy(source,0,i-1) + too + copy(source,i + length(fromm),length(source)-i-length(fromm)+1);
        end else
        result := source;
        if Result <> Source then Result := Replace(result,fromm,too);}
end;

procedure runwww(wwwpath : string);
begin
        if pos('mailto://',wwwpath) <> 0 then
        shellexecute(0,'open',pchar(
        'mailto:'+copy(wwwpath,10,length(wwwpath)-9)),'',
        '',SW_SHOWNORMAL) else
        shellexecute(0,'open',pchar(
        wwwpath),'',
        '',SW_SHOWNORMAL);
end;

function Tcolor2Webcolor(acolor : tcolor) : string;
begin
        Result := format('#%s%s%s',
        [inttohex(GetRValue(aColor),2),
        inttohex(GetGValue(aColor),2),
        inttohex(GetBValue(aColor),2)]);
end;

function Webcolor2TColor(colorstring : string) : TColor;
var
    Red,Green,Blue : integer;
begin
        try
        if (colorstring = '') or (pos('<',colorstring) > 0)
        or (pos('<',colorstring) > 0) then Result := clBlack else
        if colorstring[1] = '#' then
        begin
        Red := StrtoInt('$' + Copy(colorstring,2,2));
        Green := StrtoInt('$' + Copy(colorstring,4,2));
        Blue := StrtoInt('$' + Copy(colorstring,6,2));
        Result := RGB(Red,Green,Blue);
        end else
        Result := StringtoColor(Colorstring);

        except
        on E: EConvertError do
        begin end;
        on e: Exception do
        begin end;
        end;

end;

function CheckSelected(Selection : TRect; Tag : aTag) : boolean;
begin
  Result := False;
  if Tag is aVisTag then
    begin
     Result := aVisTag(Tag).IsIn(Selection);
    end;
end;

function PercentToSize(screenwidth : integer;Width : string; Default : integer) : integer;
var k : string;
begin
  k := Trim(Width);
  if Pos('%',k) = Length(k) then
    Result := ScreenWidth * StrToIntDef(Copy(k,0,Length(k)-1),100) div 100 else
    Result := StrToIntDef(Width,0);
  if Result = 0 then
    Result := Default;
  Result := Result - (Border * 2)
end;

function CountCharInStr(str : string; chr : char) : integer;
var i : integer;
begin
  Result := 0;
  for i := 1 to length(str) do
    if str[i] = chr then Inc(Result);
end;

function DrawHtmlOnCanvas(Canvas : TCanvas; Left,Top,Width : integer; Html : string) : integer;
var MiniHtml : TQzMiniHtml2;
begin
  MiniHtml := TQzMiniHtml2.Create(nil);
  MiniHtml.Canvas := Canvas;
  MiniHtml.Left   := Left;
  MiniHtml.Top    := Top;
  MiniHtml.Width  := Width;
  MiniHtml.height := Canvas.ClipRect.Bottom;
  MiniHtml.Lines.Text := Html;
  MiniHtml.LoadFromLines;
  Result := MiniHtml.CacheBitmap.Height;
  MiniHtml.Free;
end;

function CalcHeight(Html : string; width : integer) : integer;
var MiniHtml : TQzMiniHtml2;
begin
  MiniHtml := TQzMiniHtml2.Create(nil);
  MiniHtml.Canvas := MiniHtml.CacheBitmap.Canvas;
  MiniHtml.Left   := 0;
  MiniHtml.Top    := 0;
  MiniHtml.Width  := Width;
  MiniHtml.height := 1000;
  MiniHtml.Lines.Text := Html;
  MiniHtml.LoadFromLines;
  Result := MiniHtml.CacheBitmap.Height;
  MiniHtml.Free;
end;


procedure TCurrentState.InitState;
var i : integer;
begin
  Font       := TFont.create;
  Font.Style := [];
  Font.Name  := DefaultFontName;
  Font.Size  := DefaultFontSize;
  TargetURL  := '';
  BackGroundColor := WebColor2TColor(TransparentColor);
  FontColor    := clBlack;
  ActiveColor  := clRed;
  VisitedColor := clPurple;
  URLColor   := clBlue;
  Selected   := false;
  TextStyle  := isNormal;
  Align      := '';
  Indent     := 0;
  Visible := true;
  for i := 0 to StateTagList.Count -1 do
    aTag(StateTagList.items[i]).update(Self);
end;

procedure TCurrentState.AddTag(Tag : TObject);
begin
  if (Tag is aTag) then
    begin
    StateTagList.Add(Tag);
    InitState;
    end;
end;

procedure TCurrentState.RemoveTag(TagClass : TClass);
var i : integer;
    Tag : aTag;
begin
  for i := StateTagList.count -1 downto 0 do
    begin
      Tag := StateTagList.items[i];
      if (Tag is TagClass) then
        begin
          StateTagList.delete(i);
          InitState;
          exit;
        end;
    end;
end;

constructor TCurrentState.Create(o : TComponent);
begin
  Owner := o;
  If not assigned(StateTagList) then
    StateTagList := TList.Create;
  InitState;
end;

destructor TCurrentState.Destroy;
begin
  StateTagList.Free;
  inherited Destroy;
end;

constructor TQzHtmlRec.Create(o : TComponent);
begin
  inherited Create;
  Owner := o;
end;

procedure TQzHtmlRec.SetHtml(input : string; HKey : char);
begin
  Html := Input;
  HotKey := Hkey;
  TQzMiniHtml2(Owner).LoadFromCaption;
  if Assigned(FHtmlUpdate) then FHtmlUpdate(Owner,Input,HKey);

end;

{constructor TQzHtmlRec.Create(aMiniHtml : TComponent);
begin
  inherited Create;
  Owner := aMiniHtml;
end;

procedure TQzHtmlRec.SetHtml(html : string);
begin
  inputHtmlSyntax := html;
  TQzMiniHtml2(Owner).LoadFromCaption;
end;
}
procedure aVisTag.Select;
begin
  Selected := True;
end;

procedure aVisTag.UnSelect;
begin
  Selected := False;
end;

procedure AText.Select(TopLeft, BottomRight : TPoint; CheckLeftside, CheckRightside : boolean);
var charwidth : array of integer;
    index,total : integer;
    x1,x2,y1,y2 : integer;
function GetWidth(text : string) : integer;
begin
  try
  Result := aHtml.GetWidth(text,Font);
  finally
    Font.free;
  end;
end;
procedure fillCharWidth;
var i : integer;
begin
  SetLength(charwidth,Length(Text));
  for i := 1 to Length(Text) do
    CharWidth[i-1] := GetWidth(Text[i]);
end;
begin
  SelStart := -1;
  SelStop  := -1;
  if CheckLeftside then
    begin
      X1 := TopLeft.X;
      X2 := BottomRight.X;
    end else
    begin
      X2 := TopLeft.X;
      X1 := BottomRight.X;
    end;

  if TopLeft.Y < BottomRight.Y then
    begin
      Y1 := TopLeft.Y;
      Y2 := BottomRight.Y;
    end else
    begin
      Y2 := TopLeft.Y;
      Y1 := BottomRight.Y;
    end;
  fillCharWidth;

  If (X1 > Left) {and (X2 >= Left + Width)} then
  if CheckLeftSide then
  begin
  total := 0;
  index := 1;
  while (X1 > Left + total) and (index < Length(Text)) do
     begin
      Inc(Total,CharWidth[index-1]);
      Inc(index);
     end;
     SelStart := index;
     SelStartX := Left + Total;
     if SelStop = -1 then
     begin
      SelStopX := Width;
      SelStop := Length(Text);
     end;
  end;

  If CheckRightside then
  If (X2 <= Left + Width){ and (X2 < Left + Width)} then
  begin
    total := 0;
    index := Length(Text);
    while (BottomRight.X < Left + Width - Total) and (index > 0) do
     begin
      Inc(Total,CharWidth[index-1]);
      Dec(index);
     end;
     SelStop := index;
     SelStopX := Left + Width - Total;

     if SelStart = -1 then
      begin
      SelStartX := Left;
      SelStart := 1;
      end;

  end;
  //Selected := (SelStop - SelStart > 0)
end;

procedure AText.UnSelect;
begin
  Selected := False;
  SelStart := -1;
  SelStop := -1;
end;

function aTag.IsIn(aPoint : TPoint) : boolean;
begin
  Result := False;
end;

function aTag.IsIn(aRect  : TRect) : boolean;
begin
  Result := False;
end;

function aVisTag.IsIn(aPoint : TPoint) : boolean;
begin
  Result := False;
  if (height > 0) and (width > 0) then
  with aPoint do
  begin
  If ((X >= aHtml.Left+Left) and (X <= aHtml.Left+Left+width)) then
  If (Y >= Top-aHtml.Top+Height-LineHeight)  and (Y <= Top-aHtml.Top+Height)   then
    Result := True;
  end;
end;

function aVisTag.IsIn(aRect  : TRect) : boolean;
begin
  Result := False;
  if (height > 0) and (width > 0) then
  begin
  If IsIn(aRect.TopLeft) or IsIn(aRect.BottomRight) then
    Result := True;
  If ((aHtml.Left+Left>aRect.Left) and (aHtml.Left+Left+Width<aRect.Right))
  or ((aHtml.Left+Left<aRect.Left) and (aHtml.Left+Left+Width>aRect.Right)) then
  If ((Top-aHtml.Top+Height-LineHeight>aRect.Top) and (Top-aHtml.Top+Height<aRect.Bottom))
  or ((Top-aHtml.Top+Height-LineHeight<aRect.Top) and (Top-aHtml.Top+Height>aRect.Bottom)) then
    Result := True;
  end;
end;

procedure aInvisTag.UpdateFontColor(Sender : aInVisTag; Tag : aVisTag; FontColor, URLColor, ActiveColor, VisitedColor : TColor);
begin
      if FontColor <> -1 then Tag.FontColor := FontColor;
      if ActiveColor <> -1 then Tag.ActiveColor := ActiveColor;
      if VisitedColor <> -1 then Tag.VisitedColor := VisitedColor;
      if URLColor <> -1 then Tag.URLColor := URLColor;
end;

procedure aTag.SetHtml(commands : tstrings);
begin

end;

procedure aDynamicTag.SetHtml(commands : tstrings);
begin
  if commands.IndexOfName('id') <> -1 then
       ID := commands.Values['id'];
end;

procedure aBodySTag.SetHtml(commands : tstrings);
begin
  if commands.IndexOfName('bgcolor') <> -1 then
       BackgroundColor := WebColor2TColor(commands.Values['bgcolor']);
  if commands.IndexOfName('text') <> -1 then
       FontColor := WebColor2TColor(commands.Values['text']);
  if commands.IndexOfName('link') <> -1 then
       URLColor := WebColor2TColor(commands.Values['link']);
  if commands.IndexOfName('vlink') <> -1 then
       ActiveColor := WebColor2TColor(commands.Values['vlink']);
  if commands.IndexOfName('alink') <> -1 then
       VisitedColor := WebColor2TColor(commands.Values['alink']);
end;

procedure aFontSTag.SetHtml(commands : tstrings);
var sizecmd : string;
    positive : boolean;
begin
  if commands.IndexOfName('face') <> -1 then
    fontname := commands.Values['face'];
  if commands.IndexOfName('name') <> -1 then
    fontname := commands.Values['name'];
  if commands.IndexOfName('color') <> -1 then
    fontcolor:= WebColor2TColor(commands.Values['color']);
  if commands.IndexOfName('size') <> -1 then
    begin
       sizecmd := commands.Values['size'];
       absoluteFontsize := true;
       positive := true;

       if (pos('+',sizecmd) <> 0) then
          begin
            absoluteFontsize := false;
            positive := true;
            sizecmd := Replace(sizecmd,'+',' ');
          end else
       if (pos('-',sizecmd) <> 0) then
          begin
            absoluteFontsize := false;
            positive := false;
            sizecmd := Replace(sizecmd,'-',' ');
          end;

        if positive and not absoluteFontsize then
          FontSize := DefaultFontSize + StrToIntDef(commands.Values['size'],0) else
        if not positive and not absoluteFontsize then
          FontSize := DefaultFontSize - StrToIntDef(commands.Values['size'],0) else
          FontSize := StrToIntDef(commands.Values['size'],DefaultFontSize);

    end;
end;

procedure aPSTag.SetHtml(commands : tstrings);
begin
  if commands.IndexOfName('align') <> -1 then
    Align := commands.Values['align'];
  if commands.IndexOfName('bgcolor') <> -1 then
    BackgroundColor := WebColor2TColor(commands.Values['bgcolor']);
end;

procedure aASTag.SetHtml(commands : tstrings);
begin
  if commands.IndexOfName('href') <> -1 then
    TargetURL := commands.Values['href'];
end;

procedure aULSTag.SetHtml(commands : tstrings);
begin
  if commands.IndexOfName('type') <> -1 then
    ShowType := commands.Values['type'];
end;

procedure aFormSTag.SetHtml(commands : tstrings);
begin
  if commands.IndexOfName('name') <> -1 then
    fmName := commands.Values['name'];
  if commands.IndexOfName('name') <> -1 then
    fmMethod := commands.Values['method'];
  if commands.IndexOfName('name') <> -1 then
    fmAction := commands.Values['action'];
end;

procedure aTableSTag.SetHtml(commands : tstrings);
begin
  tblWidth := aHtml.Width;
  if commands.IndexOfName('width') <> -1 then
    tblWidth := PercentToSize(aHtml.Width,commands.Values['width'],aHtml.width) else
  tblBorder := 1;
  if commands.IndexOfName('border') <> -1 then
    tblBorder := strtointdef(commands.Values['border'],1);
  bgColor := WebColor2TColor(TransparentColor);
  if commands.IndexOfName('bgcolor') <> -1 then
    bgcolor := WebColor2TColor(commands.Values['bgcolor']);
end;

procedure aTRSTag.SetHtml(commands : tstrings);
begin
  bgColor := WebColor2TColor(TransparentColor);
  if commands.IndexOfName('bgcolor') <> -1 then
    bgcolor := WebColor2TColor(commands.Values['bgcolor']);
end;

procedure aTDSTag.SetHtml(commands : tstrings);
begin
  bgColor := WebColor2TColor(TransparentColor);
  if commands.IndexOfName('bgcolor') <> -1 then
    bgcolor := WebColor2TColor(commands.Values['bgcolor']);
  if commands.IndexOfName('height') <> -1 then
    height := StrtoIntDef(commands.Values['bgcolor'],50);
end;


procedure aHorizontalRule.SetHtml(commands : tstrings);
begin
    Size := 4;
  if commands.IndexOfName('size') <> -1 then
    Size := strtointdef(commands.Values['size'],4);
  if commands.IndexOfName('width') <> -1 then
    rWidth := PercentToSize(aHtml.Width,commands.Values['width'],aHtml.width) else
  rWidth := PercentToSize(aHtml.Width,'a',aHtml.width);
  NoShade := commands.IndexOfName('noshade') <> -1;
end;

procedure aFormElement.SetHtml(commands : tstrings);
begin
  if commands.IndexOfName('name') <> -1 then
    inputName := commands.Values['name'];
  if commands.IndexOfName('type') <> -1 then
    inputType := commands.Values['type'];
  if commands.IndexOfName('value') <> -1 then
    inputValue := commands.Values['value'];
  if commands.IndexOfName('checked') <> -1 then
    checked := true;
end;

procedure aUserDefined.SetHtml(commands : tstrings);
begin
  if commands.IndexOfName('id') <> -1 then
    itemID := commands.Values['id'];
  if commands.IndexOfName('type') <> -1 then
    itemType := commands.Values['type'];
  if commands.IndexOfName('var1') <> -1 then
    variable1 := commands.Values['var1'];
  if commands.IndexOfName('var2') <> -1 then
    variable2 := commands.Values['var2'];
  if commands.IndexOfName('var3') <> -1 then
    variable3 := commands.Values['var3'];
end;
////////////////////////////////////////////////////////////////////////////////
function aTag.GetHtml : string;
begin
  Result := TagName;
end;

function aDynamicTag.GetHtml : string;
var k : string;
begin
  k := '<dynamic';
  if (variables.IndexOfName('id') <> -1) then
  k := k + Format(' id="%s"',[ID]);
  k := k + '>';
  Result := '';//k
end;

function aBodySTag.GetHtml : string;
var k : string;
begin
  k := '<body';
  if (variables.IndexOfName('bgcolor') <> -1) then
  k := k + Format(' bgcolor="%s"',[Tcolor2webcolor(BackGroundColor)]);
  if (variables.IndexOfName('text') <> -1) then
  k := k + Format(' text="%s"',[Tcolor2webcolor(FontColor)]);
  if (variables.IndexOfName('link') <> -1) then
  k := k + Format(' link="%s"',[Tcolor2webcolor(URLColor)]);
  if (variables.IndexOfName('vlink') <> -1) then
  k := k + Format(' vlink="%s"',[Tcolor2webcolor(ActiveColor)]);
  if (variables.IndexOfName('alink') <> -1) then
  k := k + Format(' alink="%s"',[Tcolor2webcolor(VisitedColor)]);
  k := k + '>';
  Result := k;
end;

function aFontSTag.GetHtml : string;
var k : string;
begin
  k := '<font';
  if (variables.IndexOfName('face') <> -1) or (variables.IndexOfName('name') <> -1) then
  if FontName <> '' then k := k + Format(' face="%s"',[FontName]);
  if (variables.IndexOfName('size') <> -1) then
  k := k + Format(' size="%s"',[Inttostr(FontSize)]);
  if (variables.IndexOfName('color') <> -1) then
  k := k + Format(' color="%s"',[Tcolor2webcolor(FontColor)]);
  k := k + '>';
  Result := k;
end;

function aPSTag.GetHtml : string;
var k : string;
begin
  k := '<p';
  if (variables.IndexOfName('align') <> -1) then
  k := k + Format(' align="%s"',[Align]);
    if (variables.IndexOfName('bgcolor') <> -1) then
  k := k + Format(' bgcolor="%s"',[Tcolor2webcolor(BackGroundColor)]);
  result := k + '>';
end;

function aASTag.GetHtml : string;
var k : string;
begin
  k := '<a';
  if (variables.IndexOfName('href') <> -1) then
  if TargetURL <> '' then k := k + Format(' href="%s"',[TargetURL]);
  k := k + '>';
  result := k;
end;

function aULSTag.GetHtml : string;
var k : string;
begin
  k := '<ul';
  if (variables.IndexOfName('type') <> -1) then
  if ShowType <> '' then k := k + Format(' type="%s"',[ShowType]);
  k := k + '>';
  result := k;
end;

function aFormSTag.GetHtml : string;
var k : string;
begin
  k := '<form';
  if (variables.IndexOfName('name') <> -1) then
  if fmName <> '' then k := k + Format(' name="%s"',[fmName]);
  if (variables.IndexOfName('method') <> -1) then
  if fmMethod <> '' then k := k + Format(' method="%s"',[fmMethod]);
  if (variables.IndexOfName('action') <> -1) then
  if fmAction <> '' then k := k + Format(' name="%s"',[fmAction]);
  k := k + '>';
  result := k;
end;

function aSelectionSTag.GetHtml : string;
begin
  Result := '';
end;

function aSelectionETag.GetHtml : string;
begin
  Result := '';
end;


//////////////////////////////////////////////////////////////////////////////

function aText.GetHtml : string;
begin
  Result := Text;
end;

function aPicture.GetHtml : string;
var k : string;
begin
  k := Format('<img src="%s"',[PictureURL]);
  if Width <> -1 then k := k + Format(' width="%d"',[Width]);
  if Height <> -1 then k := k + Format(' height="%d"',[Height]);
  k := k + '>';
  Result := k;
end;

function aHorizontalRule.GetHtml : string;
var k : string;
begin
  k := '<hr';
  if variables.IndexOfName('size') <> -1 then
    k := k + Format(' size="%d"',[size]);
  if variables.IndexOfName('width') <> -1 then
    k := k + Format(' width="%d"',[rwidth]);
  if variables.IndexOfName('noshade') <> -1 then
    k := k + ' noshade';
  k := k + '>';
  result := k;
end;

function aFormElement.GetHtml : string;
var k : string;
begin
  k := '<input';
  if (variables.IndexOfName('name') <> -1) then
  if inputName <> '' then k := k + Format(' name="%s"',[inputName]);
  if (variables.IndexOfName('type') <> -1) then
  if inputType <> '' then k := k + Format(' method="%s"',[inputType]);
  if (variables.IndexOfName('value') <> -1) then
  if inputType <> '' then k := k + Format(' value="%s"',[inputValue]);
  if (variables.IndexOfName('checked') <> -1) then k := k + 'checked';
  k := k + '>';
  result := k;
end;

function aUserDefined.GetHtml : string;
var k : string;
begin
  k := '<user';
  if (variables.IndexOfName('id') <> -1) then
  if itemID <> '' then k := k + Format(' id="%s"',[itemID]);
  if (variables.IndexOfName('type') <> -1) then
  if itemType <> '' then k := k + Format(' type="%s"',[itemType]);
  if (variables.IndexOfName('variable1') <> -1) then
  if variable1 <> '' then k := k + Format(' var1="%s"',[variable1]);
  if (variables.IndexOfName('variable2') <> -1) then
  if variable2 <> '' then k := k + Format(' var2="%s"',[variable2]);
  if (variables.IndexOfName('variable3') <> -1) then
  if variable3 <> '' then k := k + Format(' var3="%s"',[variable3]);
  k := k + '>';
  result := k;
end;

////////////////////////////////////////////////////////////////////////////////
procedure aTag.Update(var CurrentState : TCurrentState);
begin

end;

procedure aScriptSTag.Update(var CurrentState : TCurrentState);
begin
  CurrentState.visible := false;
end;

procedure aHeadSTag.Update(var CurrentState : TCurrentState);
begin
  CurrentState.visible := false;
end;

procedure aBodySTag.Update(var CurrentState : TCurrentState);
begin
      if (variables.IndexOfName('text') <> -1) then
          CurrentState.FontColor := FontColor;
      if (variables.IndexOfName('link') <> -1) then
          CurrentState.UrlColor := URLColor;
      if (variables.IndexOfName('alink') <> -1) then
          CurrentState.ActiveColor := ActiveColor;
      if (variables.IndexOfName('vlink') <> -1) then
          CurrentState.VisitedColor := VisitedColor;
      if (variables.IndexOfName('bgcolor') <> -1) then
        begin
          aHtml.Color := BackGroundColor;
          CurrentState.BackGroundColor := BackGroundColor;
        end;
end;

procedure aPSTag.Update(var CurrentState : TCurrentState);
begin
     if (variables.IndexOfName('bgcolor') <> -1) then
         CurrentState.BackGroundColor := BackGroundColor;
     if (variables.IndexOfName('align') <> -1) then
         CurrentState.Align := Align;
end;

procedure aFontSTag.Update(var CurrentState : TCurrentState);
begin
         if (variables.IndexOfName('color') <> -1) then
         CurrentState.Fontcolor := FontColor;
         if (variables.IndexOfName('name') <> -1) or (variables.IndexOfName('Face') <> -1) then
         CurrentState.Font.Name := FontName;
         if (variables.IndexOfName('size') <> -1) then
         CurrentState.Font.Size := FontSize;
end;

procedure aBlockquoteSTag.Update(var CurrentState : TCurrentState);
begin
  Inc(CurrentState.Indent,INDENTSIZE);
end;

procedure aUSTag.Update(var CurrentState : TCurrentState);
begin
  CurrentState.Font.Style := CurrentState.Font.Style + [fsUnderline];
end;

procedure aBSTag.Update(var CurrentState : TCurrentState);
begin
  CurrentState.Font.Style := CurrentState.Font.Style + [fsBold];
end;

procedure aSSTag.Update(var CurrentState : TCurrentState);
begin
  CurrentState.Font.Style := CurrentState.Font.Style + [fsStrikeOut];
end;

procedure aISTag.Update(var CurrentState : TCurrentState);
begin
  CurrentState.Font.Style := CurrentState.Font.Style + [fsItalic];
end;

procedure aASTag.Update(var CurrentState : TCurrentState);
begin
  CurrentState.TargetURL := TargetURL;
end;

procedure aULSTag.Update(var CurrentState : TCurrentState);
begin
  CurrentState.ListItemShowType := ShowType;
end;

procedure aOLSTag.Update(var CurrentState : TCurrentState);
begin
  CurrentState.ListItemShowType := 'number';
end;

procedure aSubSTag.Update(var CurrentState : TCurrentState);
begin
  CurrentState.TextStyle := isSubScript;
end;

procedure aSupSTag.Update(var CurrentState : TCurrentState);
begin
  CurrentState.TextStyle := isSuperScript;
end;

procedure aFormSTag.Update(var CurrentState : TCurrentState);
begin
  CurrentState.fmName := fmName;
  CurrentState.fmMethod := fmMethod;
  CurrentState.fmAction := fmAction;
end;

procedure aTxtHideSTag.Update(var CurrentState : TCurrentState);
begin
  CurrentState.visible := not HidTxtInUnkTag;
end;

procedure aSelectionSTag.Update(var CurrentState : TCurrentState);
begin
  CurrentState.Selected := true;
  with CurrentState do
  begin
  aHtml.SelectionState.Font  := Font;
  aHtml.SelectionState.Visible := Visible;
  aHtml.SelectionState.BackGroundColor := BackGroundColor;
  aHtml.SelectionState.Indent := Indent;
  aHtml.SelectionState.TargetURL := TargetURL;
  aHtml.SelectionState.Align := Align;
  aHtml.SelectionState.FontColor := FontColor;
  aHtml.SelectionState.ActiveColor := ActiveColor;
  aHtml.SelectionState.VisitedColor := VisitedColor;
  aHtml.SelectionState.URLColor := URLColor;
  aHtml.SelectionState.ListItemShowType := ListItemShowType;
  aHtml.SelectionState.fmName := fmName;
  aHtml.SelectionState.fmMethod := fmMethod;
  aHtml.SelectionState.fmAction := fmAction;
  aHtml.SelectionState.Selected := True;
  end;
end;



////////////////////////////////////////////////////////////////////////////////
procedure aTag.Update;
begin
end;

procedure aHeadSTag.Update;
begin
   aHtml.currentState.AddTag(Self);
end;

procedure aHeadETag.Update;
begin
   aHtml.currentState.RemoveTag(aHeadSTag);
end;

procedure aScriptSTag.Update;
begin
   aHtml.currentState.AddTag(Self);
end;

procedure aScriptETag.Update;
begin
   aHtml.currentState.RemoveTag(aScriptSTag);
end;

procedure aBodySTag.Update;
begin
   aHtml.currentState.AddTag(Self);
end;

procedure aBodyETag.Update;
begin
   aHtml.currentState.RemoveTag(aBodySTag);
end;

procedure aPSTag.Update;
begin
   aHtml.currentState.AddTag(Self);
end;

procedure aPETag.Update;
begin
   aHtml.currentState.RemoveTag(aPSTag);
end;

procedure aFontSTag.Update;
begin
   aHtml.currentState.AddTag(Self);
end;

procedure aFontETag.Update;
begin
   aHtml.currentState.RemoveTag(aFontSTag);
end;

procedure aBlockquoteSTag.Update;
begin
   aHtml.currentState.AddTag(Self);
end;

procedure aBlockquoteETag.Update;
begin
   aHtml.currentState.RemoveTag(aBlockquoteSTag);
end;

procedure aUSTag.Update;
begin
   aHtml.currentState.AddTag(Self);
end;

procedure aUETag.Update;
begin
   aHtml.currentState.RemoveTag(aUSTag);
end;

procedure aBSTag.Update;
begin
   aHtml.currentState.AddTag(Self);
end;

procedure aBETag.Update;
begin
   aHtml.currentState.RemoveTag(aBSTag);
end;

procedure aSSTag.Update;
begin
   aHtml.currentState.AddTag(Self);
end;

procedure aSETag.Update;
begin
   aHtml.currentState.RemoveTag(aSSTag);
end;

procedure aISTag.Update;
begin
   aHtml.currentState.AddTag(Self);
end;

procedure aIETag.Update;
begin
  aHtml.currentState.RemoveTag(aISTag);
end;

procedure aASTag.Update;
begin
   aHtml.currentState.AddTag(Self);
end;

procedure aAETag.Update;
begin
  aHtml.currentState.RemoveTag(aASTag);
end;

procedure aULSTag.Update;
begin
   aHtml.currentState.AddTag(Self);
end;

procedure aULETag.Update;
begin
  aHtml.currentState.RemoveTag(aULSTag);
end;

procedure aOLSTag.Update;
var index,Level,counter : integer;
    tag : atag;
begin
  index := aHtml.TagList.IndexOf(Self) + 1;
  Level := 1;
  Counter := 0;
  while (index < aHtml.TagList.Count) and (level > 0) do
   begin
      tag := aHtml.TagList.Items[index];
      if (tag is aOLSTag) then Inc(Level) else
      if (tag is aOLETag) then Dec(Level) else
      if (tag is aLISTag) then
        begin
         Inc(Counter);
         aLISTag(tag).Counter := Counter;
        end;
      Inc(Index);
   end;
  aHtml.currentState.AddTag(Self);
end;

procedure aOLETag.Update;
begin
  aHtml.currentState.RemoveTag(aOLSTag);
end;

procedure aSubSTag.Update;
begin
   aHtml.currentState.AddTag(Self);
end;

procedure aSubETag.Update;
begin
  aHtml.currentState.RemoveTag(aSubSTag);
end;

procedure aSupSTag.Update;
begin
   aHtml.currentState.AddTag(Self);
end;

procedure aSupETag.Update;
begin
  aHtml.currentState.RemoveTag(aSupSTag);
end;

procedure aTableSTag.Update;
var index, level : integer;
    tag : aTag;
begin
  index := aHtml.TagList.IndexOf(Self) + 1;
  Level := 1;
  Height := 0;
  while (index < aHtml.TagList.Count) and (level > 0) do
   begin
      tag := aHtml.TagList.Items[index];
      if (tag is aTableSTag) then Inc(Level) else
      if (tag is aTableETag) then Dec(Level) else
      if (tag is aTrSTag) then
        begin
         aTrStag(Tag).tblWidth := tblWidth;
         aTrStag(Tag).tblBorder := tblBorder;
         aTrStag(Tag).bgColor := bgColor;
         aTrStag(Tag).rowTop := Top + Height;
         aTrStag(Tag).Update;
         Inc(Height,aTrSTag(Tag).Height);
        end;
      Inc(Index);
   end;
end;

procedure aTRSTag.Update;
var index, level, colPos : integer;
    tag : aTag;
begin
  index := aHtml.TagList.IndexOf(Self) + 1;
  Level := 1;
  ColCount := 0;
  Height := -1;
  while (index < aHtml.TagList.Count) and (level > 0) do
   begin
      tag := aHtml.TagList.Items[index];
      if (tag is aTrSTag) then Inc(Level) else
      if (tag is aTrETag) then Dec(Level) else
      if (tag is aTdSTag) then
        begin
         Inc(ColCount);
         aTdStag(Tag).ColNumber := ColCount;
        end;
      Inc(Index);
   end;

  index := aHtml.TagList.IndexOf(Self) + 1;
  Level := 1;
  colPos := Border;
  while (index < aHtml.TagList.Count) and (level > 0) do
   begin
      tag := aHtml.TagList.Items[index];
      if (tag is aTrSTag) then Inc(Level) else
      if (tag is aTrETag) then Dec(Level) else
      if (tag is aTdSTag) then
        begin
         aTdStag(Tag).ColCount := ColCount;

         aTdStag(Tag).tblWidth := tblWidth;
         aTdStag(Tag).Update;

         aTDStag(Tag).Top  := rowTop;
         aTDStag(Tag).Left := ColPos;
         colPos := aTDStag(Tag).Left + aTDStag(Tag).Width;
         if aTDSTag(Tag).Height > Height then
           Height := aTDSTag(Tag).Height;
        end;
      Inc(Index);
   end;

  index := aHtml.TagList.IndexOf(Self) + 1;
  Level := 1;
  colPos := Border;
  while (index < aHtml.TagList.Count) and (level > 0) do
   begin
      tag := aHtml.TagList.Items[index];
      if (tag is aTrSTag) then Inc(Level) else
      if (tag is aTrETag) then Dec(Level) else
      if (tag is aTdSTag) then
        begin
         aTdStag(Tag).Height := Height;
         aTdStag(Tag).tblBorder := tblBorder;
         if aTdStag(Tag).variables.IndexOfName('bgcolor') = -1 then
            aTdStag(Tag).bgColor := bgColor;
        end;
      Inc(Index);
   end;
end;

procedure aTDSTag.Update;
begin
{
  if MiniHtml.Lines.Text <> Html then
  begin
  if ColCount > 0 then
    MiniHtml.Width := tblWidth div ColCount;
  MiniHtml.Lines.Text := Html;
  MiniHtml.LoadFromLines;
  end;
  Height := MiniHtml.CacheBitmap.Height;
}
 if ColCount = 0 then ColCount := 1;

 if variables.IndexOfName('width') <> -1 then
    Width := PercentToSize(aHtml.Width,variables.Values['width'],tblWidth) else
    Width := ((tblWidth - Border - Border) div ColCount);

  //Inc(Width,2);
  if variables.IndexOfName('height') = -1 then
     Height := CalcHeight(Html,Width);
end;

procedure aTxtHideSTag.Update;
begin
   aHtml.currentState.AddTag(Self);
end;

procedure aTxtHideETag.Update;
begin
  aHtml.currentState.RemoveTag(aTxtHideSTag);
end;

procedure aFormSTag.Update;
begin
   aHtml.currentState.AddTag(Self);
end;

procedure aFormETag.Update;
begin
  aHtml.currentState.RemoveTag(aFormSTag);
end;

procedure aSelectionSTag.Update;
begin
   aHtml.currentState.AddTag(Self);
   aHtml.ScrollTop := Top;
   if aHtml.CacheBitmap.Height > aHtml.Height then
   if Top + aHtml.height >= aHtml.cachebitmap.height then
    aHtml.ScrollTop := aHtml.CacheBitmap.Height - aHtml.height else
    aHtml.ScrollTop := Top;
end;

procedure aSelectionETag.Update;
begin
  aHtml.currentState.RemoveTag(aSelectionSTag);
  aHtml.SelectionState.Font.Style  :=
            aHtml.CurrentState.Font.Style + aHtml.SelectionState.Font.Style;
end;

//////////////////////////////////////////////////////////////////////////////
procedure aVisTag.Update;
begin
    Font            := aHtml.CurrentState.Font;
    Font.Style      := aHtml.CurrentState.Font.Style;
    Font.Name       := aHtml.CurrentState.Font.Name;
    Font.Size       := aHtml.CurrentState.Font.Size;
    FontColor       := aHtml.CurrentState.FontColor;
    ActiveColor     := aHtml.CurrentState.ActiveColor;
    VisitedColor    := aHtml.CurrentState.VisitedColor;
    URLColor        := aHtml.CurrentState.URLColor;
    Visible         := aHtml.CurrentState.Visible;
    BackGroundColor := aHtml.CurrentState.BackGroundColor;
    TargetURL       := aHtml.CurrentState.TargetURL;
    Align           := aHtml.CurrentState.Align;
    Selected        := aHtml.CurrentState.Selected;
end;

procedure aSpace.Update;
begin
    inherited Update;
    if not Visible then
    begin
    Width := 0;
    Height := 0;
    end else
    begin
    Width := aHtml.GetWidth(' ',Font);
    Height := aHtml.GetHeight(' ',Font);
    end;
end;

procedure aText.Update;
begin
    inherited Update;
    TextStyle := aHtml.Currentstate.TextStyle;
    if not Visible then
    begin
    Width := 0;
    Height := 0;
    end else
    begin
    Width := aHtml.GetWidth(Text,Font);
    Height := aHtml.GetHeight(Text,Font);
    end;
end;

function CheckEnvVar(Input : string) : String;
  var i : integer;
      k,l : string;
begin
    i := pos('%',Input);
    Result := Input;
    if i <> 0 then
    begin
    k := Copy(input,i+1,length(input)-i);
    i := pos('%',k);
    if i <> 0 then
      begin
        k := Copy(k,0,i-1);
        SetLength(Result, MAX_PATH);
        l := GetEnvironmentVariable(k);
        Result := Replace(Input,'%' + k + '%',l);
      end;
    end;
end;

procedure aPicture.Update;
var pic : TImage;
function DecodeFilename : string;
var url,protocol,value : string;
    i : integer;
begin
    inherited Update;
    if (Variables.IndexOfName('src') <> -1) then
       url := Variables.Values['src'];
    PictureURL := url;
    Result := url;
    if url <> '' then
    begin
    i := pos(':',url);
    if i <> 0 then
       protocol := copy(url,0,i-1);
    Inc(i);
    while (url[i] = '/') and (i < Length(url)) do
        Inc(i);

    value := Copy(url,i,length(url)-i+1);
    if protocol = 'file' then
       begin
       value := Replace(value,'|',':');
       value := Replace(value,'/','\');
       Result := value;
       end else
    if protocol = 'http' then
       begin
       // Not Yet
       //Result := DecodeFilename;
       end;
    end;
    Result := Replace(Result,'%app%',Extractfilepath(paramstr(0)));
    Result := CheckEnvVar(Result);
end;
begin
    if not Visible then
    begin
    Width := 0;
    Height := 0;
    end else
    begin
    pic := TImage.Create(nil);
    try
       pic.autosize := true;
       Cache := DecodeFilename;
       if fileexists(cache) then
       Pic.Picture.LoadFromFile(Cache);
       if (Variables.IndexOfName('height') = -1) then
           Height := Pic.Height else
           Height := StrToIntDef(Variables.Values['height'],Height);
       if (Variables.IndexOfName('width') = -1)  then
           Width := Pic.Width else
           Width := StrToIntDef(Variables.Values['height'],Width);
    finally
    pic.free;
    end;
    end;
end;

procedure aHorizontalRule.Update;
begin
    inherited Update;
    if not Visible then
    begin
    Width := 0;
    Height := 0;
    end else
    begin
    Height := Size + (20);
    Width := aHtml.width;
    end;
end;

procedure aLISTag.Update;
begin
    inherited Update;
    if not Visible then
    begin
    Width := 0;
    Height := 0;
    end else
    begin
    Width := INDENTSIZE;
    Height := aHtml.GetHeight('Test',Font);
    end;
end;

procedure aFormElement.Update;
begin
    //inherited Update;
    fmName := aHtml.currentState.fmName;
    fmMethod := aHtml.currentState.fmMethod;
    fmAction := aHtml.currentState.fmAction;
    Font.size := 8;
    Font.Name := 'Arial';
    if (inputType = 'submit') or (inputType = 'button') then
     begin
      Width  := aHtml.GetWidth('  '+inputValue,Font);
      Height := aHtml.GetHeight(inputValue,Font)+2;
     end else
    if inputType = 'checkbox' then
     begin
      Width := 16;
      Height := 12;
     end;

end;

procedure aUserDefined.Update;
begin
  Width := 0;
  Height := 0;
  If Assigned(aHtml.FUserDefinedUpdate) then
    aHtml.FUserDefinedUpdate(Self,ItemID,ItemType,Width,Height,
                                    Variable1,Variable2,Variable3);
end;

////////////////////////////////////////////////////////////////////////////////
constructor aTag.Create(AOwner : TComponent);
begin
    Create(AOwner);
end;

constructor aTag.Create(AOwner: TComponent; Tag1 : string);
begin
//    inherited Create(AOwner);
    TagName := Tag1;
end;



constructor aVisTag.Create(AOwner: TComponent; Tag1 : string);
begin
    inherited Create(AOwner,Tag1);
    Selected := False;
    Font := TFont.create;
    Font.Name := DEFAULTFONTNAME;
    Font.Size := DEFAULTFONTSIZE;
    FontColor := clBlack;
    URLColor  := clBlue;
    ActiveColor := clRed;
    VisitedColor := clPurple;
    BackGroundColor := ClNone;
    Visible := True;
end;

constructor aBodySTag.Create(AOwner: TComponent; Tag1 : string);
begin
  inherited Create(AOwner,Tag1);
  BackGroundColor := clNone;
  FontColor := clBlack;
  URLColor  := clBlue;
  ActiveColor := clRed;
  VisitedColor := clPurple;
end;

constructor aFontSTag.Create(AOwner: TComponent; Tag1 : string);
begin
  inherited Create(AOwner,Tag1);
  FontColor := clBlack;
  FontSize := DefaultFontSize;
  FontName := DefaultFontName;
end;

constructor aText.Create(AOwner: TComponent;input : string);
begin
  inherited Create(AOwner,input);
  Font.Name := DefaultFontName;
  Font.Size := DefaultFontSize;
  Font.Style := [];
  Text := '';
  SelStart := -1;
  SelStop := -1;
  Text := input;
end;

constructor aPicture.Create(AOwner: TComponent; Tag1 : string);
begin
  inherited Create(AOwner,Tag1);
  Align := '';
  PictureURL := '';
  Text := '';
end;

constructor aHorizontalRule.Create(AOwner: TComponent; width : integer);
begin
  inherited Create(AOwner);
  width := aHtml.width;
  size := 5;
  noshade := false;
end;

constructor aTxtHideSTag.Create(AOwner: TComponent;Tag : string);
begin
  inherited Create(AOwner);
  TagName := Tag;
end;

constructor aTxtHideETag.Create(AOwner: TComponent;Tag : string);
begin
  inherited Create(AOwner);
  if pos('/',Tag) = 1 then TagName := Copy(Tag,2,Length(Tag)-1) else
  TagName := Tag;
end;

{
constructor aTdSTag.Create(AOwner: TComponent; Tag1 : string);
begin
  inherited Create(AOwner,Tag1);
  MiniHtml := TQzMiniHtml2.Create(nil);
end;

destructor aTdSTag.Destroy;
begin
  MiniHtml.free;
  inherited Destroy;
end;
}

destructor aVisTag.Destroy;
begin
//    Font.Free;
end;
////////////////////////////////////////////////////////////////////////////////
procedure aTag.Draw(aCanvas : Tcanvas);
begin

end;

procedure aBodySTag.Draw(aCanvas : Tcanvas);
begin
   aCanvas.Brush.Color := BackGroundColor;
   aCanvas.FillRect(aHtml.CacheBitmap.Canvas.ClipRect);
end;

procedure aPSTag.Draw(aCanvas : Tcanvas);
var index,Level : integer;
    tag : atag;
begin
  index := aHtml.TagList.IndexOf(Self)+1;
  Level := 1;
  StartHeight := 10000;
  if (variables.IndexOfName('bgcolor') <> -1) then
  begin
  while (index <= aHtml.TagList.Count -1) and (level > 0) do
   begin
      tag := aHtml.TagList.Items[index];
      if (tag is aPSTag) then Inc(Level) else
      if (tag is aPETag) then Dec(Level) else
      if (tag is aVisTag) then
        begin
         if StartHeight > aVisTag(tag).Top then
         StartHeight := aVisTag(tag).Top;
         if EndHeight < aVisTag(tag).Top + aVisTag(tag).Height then
         EndHeight := aVisTag(tag).Top + aVisTag(tag).Height;
        end;
      Inc(Index);
   end;
  aCanvas.Brush.Color := BackgroundColor;
  aCanvas.Pen.Color := BackGroundColor;
  aCanvas.Rectangle(Border,StartHeight,aHtml.width-Border,EndHeight);
  end;
end;

procedure aTDSTag.Draw(aCanvas : TCanvas);
begin
  aCanvas.Pen.Width := tblBorder;
  aCanvas.Brush.Color := bgColor;
  aCanvas.FillRect(Rect(Left + tblBorder,Top + tblBorder,Left+Width - tblBorder - tblBorder,Top+Height - tblBorder - tblBorder));
  aCanvas.Brush.Style := bsClear;
  aCanvas.Pen.Color := clBlack;
  //aCanvas.Pen.Style := psInsideFrame;
  DrawHtmlOnCanvas(aCanvas,Left,Top,Width,Html);
  aCanvas.Rectangle(Left-tblBorder,Top-tblBorder,Left+Width,Top+Height);
end;

procedure aSpace.Draw(aCanvas : Tcanvas);
begin

  if not Visible then exit;
  aCanvas.Font := Font;

  aCanvas.Pen.Color := aHtml.currentState.BackGroundColor;
  if BackGroundColor=clNone then BackGroundColor := aHtml.currentState.BackGroundColor;
  aCanvas.Brush.Color := BackGroundColor;
  if Selected then
   begin
    aCanvas.Font.Color := BackGroundColor;
    aCanvas.Brush.Color := clActiveCaption;
    aCanvas.Pen.Color := clActiveCaption;
   end;
  //aCanvas.Pen.Color := clBlack;
  //aCanvas.Rectangle(Left,Top+Height-LineHeight,Left+Width,Top+Height);

  if TargetURL <> '' then
  begin
    if MouseOver then
      aCanvas.Font.Color := ActiveColor else
    if Visited then
      aCanvas.Font.Color := VisitedColor else
     aCanvas.Font.Color := URLColor;
    aCanvas.Font.Style := aCanvas.Font.Style + [fsUnderline];

  end;
  If (fsUnderline in Font.Style) then
  aCanvas.TextOut(Left,Top,' ');
end;

procedure aText.Draw(aCanvas : Tcanvas);
var x1, x2, y1, y2 : integer;
procedure DrawText(Left,Top : integer; Text : string);
var k : string;
begin
  k := Replace(Text,#13#10,'');
  Case TextStyle of
  isNormal : aCanvas.TextOut(Left,Top,k);
  isSuperScript : begin aCanvas.Font.Size := Font.Size div 2;
                  aCanvas.TextOut(Left,Top-(Font.Size div 2),k); end;
  isSubScript : begin aCanvas.Font.Size := Font.Size div 2;
                  aCanvas.TextOut(Left,Top+(Font.Size div 2),k); end;
  end;
end;
begin
  if not Visible then exit;

  aCanvas.Font := Font;

  if TargetURL <> '' then
    if MouseOver then
      aCanvas.Font.Color := ActiveColor else
    if Visited then
      aCanvas.Font.Color := VisitedColor else
    aCanvas.Font.Color := URLColor else
  aCanvas.Font.Color := FontColor;
  if aCanvas.Font.Color <> FontColor then aCanvas.Font.Style := aCanvas.Font.Style + [fsUnderline];

  aCanvas.Pen.Color := WebColor2TColor(TransparentColor);

  if BackGroundColor=clNone then BackGroundColor := WebColor2TColor(TransparentColor);

  aCanvas.Brush.Color := BackGroundColor;
  aCanvas.Rectangle(Left,Top+Height-LineHeight,Left+Width,Top+Height);


    if SelStart = -1 then
      x1 := Left else
      x1 := SelStartX;
    y1 := Top+Height-LineHeight;
    if SelStop = -1 then
      x2 := Left+Width else
      x2 := SelStopX;
    y2 := Top + Height;

  if Selected then
   begin
//    *Debug*
//    SelStart := 2;
//    SelStop := 6;
//    SelStartX := Left + 4;
//    SelStopX := Left + 8;
//    *Debug*
    DrawText(Left,Top,Text);

    aCanvas.Font.Color := aHtml.Color;
    aCanvas.Brush.Color := clActiveCaption;
    aCanvas.Pen.Color := clActiveCaption;

   if SelStop - SelStart <> 0 then
        DrawText(x1,Top,Copy(Text,SelStart,SelStop-SelStart+1))
      else
    DrawText(Left,Top,Text);

   end else  DrawText(Left,Top,Text);
end;

procedure aPicture.Draw(aCanvas : Tcanvas);
var pic : TImage;
    bitmap, bitmap2 : tbitmap;
begin

  if not Visible then exit;
    if cache <> '' then
        begin
         pic := TImage.Create(nil);
         bitmap := tbitmap.Create;
         bitmap2 := tbitmap.Create;
         pic.AutoSize := true;

         if fileexists(cache) then
            pic.Picture.LoadFromFile(cache);

         pic.Transparent := true;

         bitmap.Assign(pic.Picture.Graphic);
         bitmap.Transparent := true;
         bitmap.TransparentColor := clWhite;

         if (Variables.IndexOfName('width') <> -1) or
                            (Variables.IndexOfName('height') <> -1) then
         begin
         Bitmap2.Width := Width;
         Bitmap2.Height := Height;
         bitmap2.Transparent := true;
         bitmap2.TransparentColor := clWhite;

         StretchBlt(Bitmap2.Canvas.Handle,0,0,Bitmap2.Width,Bitmap2.Height,
                        Bitmap.Canvas.Handle,0,0,Bitmap.Width,Bitmap.Height,
                        SRCCOPY);

         acanvas.CopyRect(Rect(Left,Top,
            Left + Width,Top + Height),
            bitmap2.Canvas,rect(0,0,Width,Height));

         end else
         acanvas.CopyRect(Rect(Left,Top,
            Left + Width,Top + Height),
            bitmap.Canvas,rect(0,0,Width,Height));

         Bitmap.Free;
         Pic.Free;
         Bitmap2.Free;
         end;
end;

procedure aHorizontalRule.Draw(aCanvas : TCanvas);
var x2,y2 : integer;
begin

  aCanvas.Font := Font;
  if not Visible then exit;
    if Selected then
    begin
    aCanvas.Brush.Color := clActiveCaption;
    aCanvas.Pen.Color := clActiveCaption;
    aCanvas.Rectangle(Left,Top+Height-LineHeight,Left+Width,Top+Height);
    aCanvas.Pen.Color := BackGroundColor;
    end
    else
    begin
    aCanvas.Brush.Color := BackGroundColor;
    aCanvas.Pen.Color := BackGroundColor;
    aCanvas.Rectangle(Left,Top+Height-LineHeight,Left+Width,Top+Height);
    aCanvas.Pen.Color := clBlack;
    end;

    if NOSHADE then
    aCanvas.Brush.Color := clGray;

    x2 := (aHtml.width - rWidth) div 2;
    y2 := Top+Height;
    aCanvas.Rectangle(x2,5+Top,Left+aHtml.width-x2-Border,5+Top+Size);
end;

procedure aLISTag.Draw(aCanvas : TCanvas);
begin
  if not Visible then exit;

  aCanvas.Font := Font;

  if BackGroundColor = clNone then BackGroundColor := aHtml.Color;
  aCanvas.Brush.Color := BackGroundColor;
  aCanvas.Pen.Color := aCanvas.Brush.Color;
  if Selected then
   begin
    aCanvas.Font.Color := aCanvas.Brush.Color;
    aCanvas.Brush.Color := clActiveCaption;
    aCanvas.Pen.Color := clActiveCaption;
   end;

  aCanvas.Rectangle(Left,Top+Height-LineHeight,Left+Width+20,Top+Height);

  with aHtml.CurrentState do
  if ListItemShowType = 'number' then
      aCanvas.TextOut(Left+(INDENTSIZE div 2),Top,Inttostr(Counter)+'.') else
  begin
  aCanvas.Brush.Color := clBlack;
  aCanvas.Brush.Style := bsSolid;

  if (ListItemShowType = '') or (ListItemShowType = 'round') then
      aCanvas.Ellipse(Left+(INDENTSIZE div 2),Top+4,
              Left+(INDENTSIZE div 2)+Font.Size,Top+Font.Size+4) else
  if (ListItemShowType = 'square') or (ListItemShowType = 'disk')then
      aCanvas.Rectangle(Left+Left+(INDENTSIZE div 2),Top+4,
              Left+(INDENTSIZE div 2)+Font.Size,Top+Font.Size+4);


  end;
end;

procedure aFormElement.Draw(aCanvas : TCanvas);
procedure DrawCheckBox;
var btnRect : TRect;
    btnState: integer;
begin
    acanvas.Brush.Color := BackGroundColor;
    btnRect := Rect(Left,Top,Left+Width,Top+Height);
    acanvas.FillRect(btnrect);
    btnState := DFCS_BUTTONCHECK or DFCS_FLAT;
    if checked then btnState := btnState or DFCS_CHECKED;
    DrawFrameControl(aCanvas.handle, btnRect, DFC_BUTTON, btnState)
end;
procedure DrawButton;
var btnRect : TRect;
    btnState: integer;
    k : string;
begin
    btnRect := Rect(Left,Top,Left+Width,Top+Height);
    aCanvas.Brush.Color := clBtnFace;
    aCanvas.Pen.Style := psClear;
    aCanvas.Rectangle(btnRect);

    DrawEdge(acanvas.Handle, btnRect, EDGE_RAISED, BF_FLAT or BF_RECT or BF_ADJUST);
    aCanvas.Font.Name := 'Arial';
    aCanvas.Font.Size := 8;
    aCanvas.Font.Color := clBlack;
    k := inputValue;
    if k <> '' then
      k[1] := Uppercase(k[1])[1];
    DrawText(acanvas.Handle, Pchar(k), -1, btnRect, DT_SINGLELINE or DT_CENTER or DT_VCENTER);
end;
begin
  if (inputType = 'submit') or(inputType = 'button') then DrawButton
  else if inputType = 'checkbox' then DrawCheckBox;
end;

procedure aUserDefined.Draw(aCanvas : TCanvas);
var aRect : TRect;
begin
  aRect := Rect(Left,Top,Left+Width,Top+Height);
  aCanvas.Lock;
  if assigned(aHtml.FUserDefinedDraw) then
  aHtml.FUserDefinedDraw(Self,itemID,itemType,aCanvas,aRect,
                Variable1,Variable2,Variable3);
  aCanvas.UnLock;
end;

////////////////////////////////////////////////////////////////////////////////

constructor TQzMiniHtml2.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  TagList := TList.create;
  Lines := TStringList.Create;
  CacheBitmap := TBitmap.Create;
  CacheBitmap.Width := Width;
  Focused := -1;
  SelectStartFrom := -1;
  SelectEndAt := -1;
  Selecting := False;
  //BackGroundColor := clWhite;
  InputHtml := TQzHtmlRec.Create(Self);
  CurrentState := TCurrentState.Create(Self);
  SelectionState  := TCurrentState.Create(Self);
  //InputHtml.Html := '<b>Test</b>';
end;

destructor TQzMiniHtml2.Destroy;
begin
  TagList.free;
  Lines.Free;
  CacheBitmap.Free;
  InputHtml.Free;
  CurrentState.Free;
  inherited Destroy;
end;
function TQzMiniHtml2.processtag(variables : tstrings; tag : string) : TObject;
var newTag : aTag;
    Tag1 : String;
    TagName : string;
   // nwd : word;
begin
  Tag1 := Lowercase(Tag);
  TagName := '<' + Tag1 + '>';
 // nwd := 0;
  if Tag1 = '' then
    begin
      Result := nil;
      exit;
    end else
  begin
  Case LocateTag(Tag1,[]) of
   0 : begin Result := nil; exit; end;
   1 : newTag := aHtmlSTag.Create(Self,TagName);
   2 : newTag := aHeadSTag.Create(Self,TagName);
   3 : newTag := aScriptSTag.Create(Self,TagName);
   4 : newTag := aBodySTag.Create(Self,TagName);
   5 : newTag := aFontSTag.Create(Self,TagName);
 6,7 : newTag := aBlockquoteSTag.Create(Self,TagName);
 8,9 : newTag := aPSTag.Create(Self,TagName);
  10 : newTag := aBrTag.Create(Self,TagName);
  11 : newTag := aUSTag.Create(Self,TagName);
  12 : newTag := aBSTag.Create(Self,TagName);
  13 : newTag := aSSTag.Create(Self,TagName);
  14 : newTag := aISTag.Create(Self,TagName);
  15 : newTag := aASTag.Create(Self,TagName);
  16 : newTag := aUlSTag.Create(Self,TagName);
  17 : newTag := aOlSTag.Create(Self,TagName);
  18 : newTag := aLiSTag.Create(Self,TagName);
  19 : newTag := aTitleSTag.Create(Self,TagName);
  20 : newTag := aPicture.Create(Self,TagName);
  21 : newTag := aHorizontalRule.Create(Self,TagName);
  22 : newTag := aDynamicTag.Create(Self,TagName);
  23 : newTag := aFormSTag.Create(Self,TagName);
  24 : newTag := aFormElement.Create(Self,TagName);
  25 : newTag := aUserDefined.Create(Self,TagName);
26,27: newTag := aSelectionSTag.Create(Self,TagName);
  28 : newTag := aSubSTag.Create(Self,TagName);
  29 : newTag := aSupSTag.Create(Self,TagName);
  30 : newTag := aTableSTag.Create(Self,TagName);
  31 : newTag := aTrSTag.Create(Self,TagName);
33,32: newTag := aTdSTag.Create(Self,TagName);
/////////////////////////////////////////////////////////////
  -1 : newTag := aHtmlETag.Create(Self,TagName);
  -2 : newTag := aHeadETag.Create(Self,TagName);
  -3 : newTag := aScriptETag.Create(Self,TagName);
  -4 : newTag := aBodyETag.Create(Self,TagName);
  -5 : newTag := aFontETag.Create(Self,TagName);
-7,-6: newTag := aBlockquoteETag.Create(Self,TagName);
-8,-9: newTag := aPETag.Create(Self,TagName);
 -10 : newTag := aBrTag.Create(Self,TagName);
 -11 : newTag := aUETag.Create(Self,TagName);
 -12 : newTag := aBETag.Create(Self,TagName);
 -13 : newTag := aSETag.Create(Self,TagName);
 -14 : newTag := aIETag.Create(Self,TagName);
 -15 : newTag := aAETag.Create(Self,TagName);
 -16 : newTag := aUlETag.Create(Self,TagName);
 -17 : newTag := aOlETag.Create(Self,TagName);
 -18 : newTag := aLiETag.Create(Self,TagName);
 -19 : newTag := aTitleETag.Create(Self,TagName);
 -22 : newTag := aDynamicTag.Create(Self,TagName);
 -23 : newTag := aFormETag.Create(Self,TagName);
 -26,
  -27: newTag := aSelectionETag.Create(Self,TagName);
 -28 : newTag := aSubETag.Create(Self,TagName);
 -29 : newTag := aSupETag.Create(Self,TagName);
 -30 : newTag := aTableETag.Create(Self,TagName);
 -31 : newTag := aTrETag.Create(Self,TagName);
 -32
  -33: newTag := aTdETag.Create(Self,TagName);
  else begin Result := nil; exit; end;
  end;

  newTag.aHtml := self;
  if (newTag is aVisTag) then
    aVisTag(newTag).BackGroundColor := CurrentState.BackGroundColor;
  newTag.variables := TStringList.Create;
  newTag.variables.addstrings(variables);
  newTag.SetHtml(variables);
  TagList.Add(newTag);
  Result := newTag;
  end;
end;

procedure TQzMiniHtml2.PrintText(text : string; isURL : boolean);
var newTag : aTag;
    i : integer;
    k,newtext : string;
begin
  k := Replace(text,'&nbsp;',' ');
  k := Replace(k,'&lt;','<');
  k := Replace(k,'&gt;','>');
  k := Replace(k,'&amp;','&');
  k := Replace(k,'&quot;','"');
  k := Replace(k,'&copy;','(c)');

  while (k <> '') do
     begin
     //k := Trim(k);
     i := pos(' ',k);
     if (i <> 0) and (not isURL) and (LINESPACING) then
      begin
       newtext := Copy(k,0,i-1);
       k := Copy(k,i+1,length(k)-i);
      end else
      begin
       newtext := k;
       k := '';
      end;

     if newtext <> '' then
     begin
     newTag := aText.Create(Owner,newtext);
     aText(newTag).Text := newtext;
     newTag.aHtml := self;
     TagList.Add(newTag);
     end;

     if i <> 0 then
     begin
     newTag := aSpace.Create(Owner,' ');
     newTag.aHtml := self;
     TagList.Add(newTag);
     end;

     end;
end;

procedure TQzMiniHtml2.LoadFromStream(Stream: TStream);
const ReadPerTurn = 100;
var i : integer;
    k,dyna : string;
    tagname,tagvar,beforetag,aftertag : string;
    variables : Tstrings;
    Tag : aTag;
function haveNonClosingTag(input : string) : boolean;
begin
    Result := False;
    if (pos('<',input) <> -1) and (pos('>',input) = -1) then
      Result := true;
end;
function ReadMore : string;
var k : string;
    Buf : array [0..ReadPerTurn-1] of Char;
    i : integer;
begin
    For i := 0 to ReadPerTurn-1 do
      Buf[i] := #0;
    While (Stream.Read(Buf,ReadPerTurn) <> 0) do
      begin
        k := k + Buf;
        if not haveNonClosingTag(k) then
          begin
            Result := k;
            exit;
          end;
      end;
    Result :=Buf;
end;
begin
  CurrentState.BackGroundColor := Color;
  CurrentState.StateTagList.Clear;
  CurrentState.InitState;
  SelectionState.InitState;
  TagList.Clear;

  Stream.Position := 0;

  k := k + ReadMore;
  While (k <> '') do
    begin
      Readnexttag(k,beforetag,aftertag,tagname,tagvar);
      if (TagList.Count > 0) then
          begin
            Tag := (TagList.Last);
            if (Tag is aASTag) or (Tag is aScriptSTag) then
            PrintText(beforetag, true) else
            PrintText(beforetag, false);
          end else PrintText(beforetag, false);

      variables := Extractvariables(tagvar);
      Tag := aTag(processtag(variables,tagname));

      if (Tag is aDynamicTag) then
        begin
          dyna := '<font name="MS Sans Serif" size="8" color="#000000">&lt;'+aDynamicTag(Tag).id + '&gt;</font>';
          If Assigned(FDynamicUpdate) then
                  FDynamicUpdate(Self,aDynamicTag(Tag).id,dyna);
          if dyna <> '' then aftertag := dyna + aftertag;
        end else
      if (Tag is aTDSTag) then
        begin
          while (k <> '') and (pos('</td>',aftertag) = 0) do
            begin
               k := ReadMore;
               aftertag := aftertag + k;
            end;
         if (pos('</td>',aftertag) <> 0) then
           begin
               aTDSTag(Tag).Html := Copy(aftertag,1,pos('</td>',aftertag)-1);
               aftertag := Copy(aftertag,pos('</td>',aftertag)+5,length(aftertag)-pos('</td>',aftertag)-4);
           end else
           begin
               Move(aftertag,aTDSTag(Tag).Html,length(aftertag));
               aftertag := '';
           end;
        end;

      k := aftertag + ReadMore;
    end;
    Update;
    Draw;
    if ScrollTop + Height > CacheBitmap.Height then ScrollTop := 0;
    ReDraw;
end;

procedure TQzMiniHtml2.LoadFromLines;
var aMemoryStream : TMemoryStream;
begin
  aMemoryStream := TMemoryStream.Create;
  try
  aMemoryStream.Position := 0;
  Lines.SaveToStream(aMemoryStream);
  LoadFromStream(aMemoryStream);
  finally
  aMemoryStream.Free;
  end;
end;

procedure TQzMiniHtml2.LoadFromCaption;
var aMemoryStream : TMemoryStream;
begin
  Lines.clear;
  Lines.Add(Caption.Html);
  aMemoryStream := TMemoryStream.Create;
  try
  aMemoryStream.Position := 0;
  Lines.SaveToStream(aMemoryStream);
  LoadFromStream(aMemoryStream);
  finally
  aMemoryStream.Free;
  end;
end;


procedure TQzMiniHtml2.LoadFromFiles(filename : string);
var aFileStream : TFileStream;
begin
  aFileStream := TFileStream.Create(filename,fmOpenRead);
  try
  aFileStream.Position := 0;
  LoadFromStream(aFileStream);
  finally
  aFileStream.Free;
  end;
end;

function TQzMiniHtml2.Extractvariables(input : string) : tstrings;
var astrings : Tstrings;
    Working  : string;
procedure LocateNextVariables;
var i, j : integer;
    varname,varvalue : string;
begin
    Working := Trim(Working);
    i := pos('=',Working);
           varname := Copy(Working,0,i-1);
           j := pos('"',Working);
           if j <> 0 then Working := Copy(Working,j+1,length(Working)-j);
           j := pos('"',Working);

           if j = 0 then
              j := Length(Working)+1;
            varvalue:= Copy(Working,0,j-1);
            Working := Copy(Working,j+1,length(Working)-j);

           if varname <> '' then
             astrings.Values[lowercase(varname)] := lowercase(varvalue);

end;
begin
    astrings := TstringList.Create;
    Working := input;
    While (pos('=',Working) <> 0) and (Working <> '') do
       LocateNextVariables;
    if Working <> '' then
    aStrings.Values[lowercase(Trim(Working))] := lowercase('TRUE');
    Result := astrings;
end;

procedure TQzMiniHtml2.Readnexttag(text : string; var beforetag, aftertag, tagname, tagvars : string);
var i,j : integer;
    tag : string;
    tag1 : aTag;
begin
  i := pos('<',text);
  j := pos('>',text);
  if (i = 0) or (j = 0) or (j < i) then
     begin
       tag := '';
       beforetag := text;
       aftertag := '';
     end else
     begin
       tag := Copy(text,i+1,j-i-1);
       beforetag := Copy(text,0,i-1);
       aftertag := Copy(text,j+1,length(text)-j);
     end;
  i := pos(' ',tag);
  if (i <> 0) and (tag <> '') then
    begin
       tagname := copy(tag,0,i-1);
       tagvars := Copy(tag,i,length(tag)-i+1);
    end else
    begin
       tagname := Copy(tag,i,length(tag)-i+1);
       tagvars := '';
    end;
end;

procedure TQzMiniHtml2.NextLine;
begin
 Canvas.MoveTo(Left,CurrentPos.Y + LineHeight);
 LineHeight := 0;
end;

procedure TQzMiniHtml2.Update(index : integer);
var Tag : aTag;
begin
 Tag := TagList.items[index];
 //ClearCache(Left+Tag.Left,Top+Tag.Top,
 //     Left+Tag.Left+Tag.Width,Top+Tag.Top+Tag.Height);
 aVisTag(Tag).Update;
 CacheBitmap.Canvas.Font := Canvas.Font;
 CacheBitmap.Canvas.Brush := Canvas.Brush;
end;

procedure TQzMiniHtml2.Update;
var i,index, MaxHeight : integer;
    Tag : aTag;
    CurrentX, CurrentY, LineHeight : integer;
    Line : integer;
    align1 : string;
procedure CheckAlign;
var current,modifier,j : integer;
    Tag : aTag;
begin
    current := i;
    Tag := TagList.items[current];
    modifier := 0;
    align1 := '';
    while (current > 0) and (Tag.LineNumber = Line) do
      begin
       If (Tag is aVisTag) then
         begin
              Inc(modifier,aVisTag(Tag).Width+TagSeperateSize);
              if aVisTag(Tag).align <> '' then
               align1 := aVisTag(Tag).align;
         end;
       Dec(current);
       Tag := TagList.items[current];
      end;
   if align1 = '' then exit;

   if align1 = 'right' then modifier := (width - modifier - Border - Border) else
   if align1 = 'centre' then modifier := (width - modifier - Border - Border) div 2 else
                           modifier := 0;
   For j := current to i do
     begin
       Tag := TagList.items[j];
       if modifier <> 0 then
       If (Tag is aVisTag) then Inc(Tag.Left,modifier);
     end;
end;
procedure NewLine;
begin
         CurrentX := Border + CurrentState.Indent;
         CurrentY := CurrentY + LineHeight + TagSeperateSize + 5;
         LineHeight := 0;
         checkAlign;
         Inc(Line);
end;
begin
  CurrentX := Border + CurrentState.Indent;
  CurrentY := Border;
  LineHeight := 0;
  MaxHeight := 0;
  Line := 0;
  if TagList.Count = 0 then exit;
  for i := 0 to TagList.Count -1 do
    begin
      Tag := TagList.items[i];
      if not (Tag is aTDSTag) then
      begin
      Tag.Top  := CurrentY;
      Tag.Left  := CurrentX;

      Tag.Update;

      if (CurrentX + Tag.Width + Border > Width) or (Tag is aLNInVisTag) or (Tag is aHorizontalRule) then
        if (CurrentX <> Border) then
          newLine;

      if (Tag is ablockquoteSTag) then
        CurrentX := Border + INDENTSIZE;

      Tag.Left := CurrentX;
      if (Tag.Height <> 0) then
       if (Tag.Height >= LineHeight) and (Tag is aVisTag) then
        Tag.Top  := CurrentY else
        Tag.Top  := CurrentY + LineHeight - Tag.Height;

      Tag.LineNumber := Line;
      if Tag.Height + Tag.Top > MaxHeight then
          MaxHeight := Tag.Height + Tag.Top;

      Inc(CurrentX,Tag.Width+TagSeperateSize);
      if (Tag.Height > LineHeight) then
        begin
            LineHeight := Tag.Height;
            if i > 1 then
            begin
            Index := i-1;
            While (Index > 0) and
            (aTag(TagList[Index]).LineNumber = Line) do
              begin
                  aTag(TagList[Index]).Top :=
                      CurrentY + LineHeight - aTag(TagList[Index]).Height;
                  aTag(TagList[Index]).LineHeight := LineHeight;
                Dec(Index);
              end;
            end;
        end;

        if (Tag is aInVisLNTag) then
          newLine;
        Tag.LineHeight := LineHeight;
    end;
    end;
    CacheBitmap.Width := Width;
    CacheBitmap.Height := MaxHeight + Border;
end;

procedure TQzMiniHtml2.ClearCache;
begin
  CacheBitmap.Canvas.Lock;
  CacheBitmap.Canvas.Moveto(0,0);
  CacheBitmap.Canvas.Brush.Style := bsSolid;
  CacheBitmap.Canvas.Brush.Color := WebColor2TColor(TransparentColor);
  CacheBitmap.Canvas.Rectangle(0,0,CacheBitmap.Width,CacheBitmap.Height);
  CacheBitmap.Canvas.FillRect(CacheBitmap.Canvas.ClipRect);
  CacheBitmap.Canvas.UnLock;
end;
procedure TQzMiniHtml2.Clear;
begin
  Canvas.Lock;
  Canvas.Moveto(0,0);
  Canvas.Brush.Color := Color;
  Canvas.FillRect(Canvas.ClipRect);
  canvas.Brush.Style := bsSolid;
  Canvas.UnLock;
end;

procedure TQzMiniHtml2.ClearCache(Left,Top,Right,Bottom : integer);
begin
  Canvas.Lock;
  Canvas.Moveto(left,Top);
  Canvas.Brush.Color := WebColor2TColor(TransparentColor);
  canvas.Brush.Style := bsSolid;
  Canvas.FillRect(Rect(Left,Top,Right,Bottom));
  Canvas.UnLock;
end;


procedure TQzMiniHtml2.ReDraw;
var h : integer;
begin
  if not assigned(Canvas) then exit;
  Canvas.Lock;
  //Canvas.CopyMode := cmSrcInvert	;
  //Canvas.CopyMode := cmWhiteness;
  //Clear;
{  Canvas.CopyRect(
                  Rect(Left,Top,Width,Height),
                  CacheBitmap.Canvas,
                  Rect(ScrollLeft,ScrollTop,ScrollLeft+Width,ScrollTop+Height)
                  );}
  if Height > CacheBitmap.Height then
    h := CacheBitmap.Height else
    h := Height;


  Canvas.BrushCopy(
                  Rect(Left+ScrollLeft,Top,Left+ScrollLeft+CacheBitmap.Width,Top+h),
                  CacheBitmap,
                  Rect(ScrollLeft,ScrollTop,ScrollLeft+CacheBitmap.Width,ScrollTop+h),
                  WebColor2TColor(TransparentColor)//Color
                  );

  Canvas.UnLock;
end;

procedure TQzMiniHtml2.Draw(index : integer);
begin
 CacheBitmap.Canvas.Lock;
 aVisTag(TagList[index]).Draw(CacheBitmap.Canvas);
 CacheBitmap.Canvas.UnLock;
end;

procedure TQzMiniHtml2.Draw;
var CurrentPos : TPoint;
    i : integer;
    Tag : aTag;
begin
try

  CacheBitmap.Canvas.Lock;

  //Clear;
  ClearCache;

  CacheBitmap.Canvas.MoveTo(CurrentPos.X,CurrentPos.Y);
  for i := 0 to TagList.Count -1 do
    begin
      Tag := TagList.items[i];
      if assigned(Canvas) then
      begin
      CacheBitmap.Canvas.Brush := Canvas.Brush;
      CacheBitmap.Canvas.Pen := Canvas.Pen;
      end;
      Draw(i);
    end;
    finally
    CacheBitmap.Canvas.Unlock;
    end;

  Redraw;
end;

function TQzMiniHtml2.GetHeight(s : string; FontType : TFont) : integer;
begin
  CacheBitmap.Canvas.Font := Fonttype;
  Result := CacheBitmap.Canvas.TextHeight(s+'A');
end;

function TQzMiniHtml2.GetWidth(s : string; FontType : TFont) : integer;
begin
 CacheBitmap.Canvas.Font := Fonttype;
 Result := CacheBitmap.Canvas.TextWidth(s);
end;

function TQzMiniHtml2.GetHtml : string;
var i : integer;
begin
 result := '';
 for i := 0 to tagList.Count -1 do
  result := result + atag(taglist.Items[i]).GetHtml;
end;

procedure TQzMiniHtml2.UpdateSelection(StartPos,EndPos : TPoint);
var i : integer;
    tag : aTag;
procedure UpdatenDraw(too : boolean);
begin
        if Assigned(Tag) then
        if not (aVisTag(Tag).Selected = too) then
        begin
        aVisTag(Tag).Selected := too;
        if Tag is aVisTag then
           begin
            //Update(i);
            Draw(i);
           end;
        end;
end;
begin
    SelectStartFrom := -1;
    SelectEndAt := -1;
    UnselectAll;
    i := 0;
    Repeat
       tag := TagList.items[i];
       Inc(i);
    Until ((Tag is aVisTag) and (CheckSelected(Rect(StartPos.x,StartPos.y,EndPos.x,EndPos.y),Tag)) or
          (i >= TagList.Count));

    if (i < TagList.Count) and (Tag is aVisTag) and CheckSelected(Rect(StartPos.x,StartPos.y,EndPos.x,EndPos.y),Tag) then
      SelectStartFrom := TagList.IndexOf(Tag) else exit;

    i := TagList.Count -1;
    Repeat
       tag := TagList.items[i];
       Dec(i);
    Until ((Tag is aVisTag) and (CheckSelected(Rect(StartPos.x,StartPos.y,EndPos.x,EndPos.y),Tag)) or
          (i < 0));

    if (i >=0) and (Tag is aVisTag) and CheckSelected(Rect(StartPos.x,StartPos.y,EndPos.x,EndPos.y),Tag) then
      SelectEndAt := TagList.IndexOf(Tag) else exit;

    If SelectStartFrom <> SelectEndAt then
      begin
        Tag := TagList.items[SelectStartFrom];
        if (Tag is AText) then AText(Tag).Select(StartPos,EndPos,True,False);
        Tag := TagList.items[SelectEndAt];
        if (Tag is AText) then AText(Tag).Select(StartPos,EndPos,False,True);
      end else
      begin
        Tag := TagList.items[SelectStartFrom];
        if (Tag is AText) then AText(Tag).Select(StartPos,EndPos,True,True);;
      end;

    if (SelectEndAt <> -1) and (SelectStartFrom <> -1) then
    begin
      for i := SelectStartFrom to SelectEndAt do
       begin
        Tag := aTag(TagList[i]);
        UpdatenDraw(True);
       end;
   end;
end;

procedure TQzMiniHtml2.MouseMove(Sender: TObject; Shift: TShiftState; X,Y: Integer);
const minCheckTime = 150;
var TickCount : integer;
    XX, YY : integer;
begin
    TickCount := GetTickCount;
    XX  := X;
    YY  := Y;
    if ScrollLeft >= 0 then
      XX := X + ScrollLeft;
    if ScrollTop >= 0 then
      YY := Y + ScrollTop;
    if (TickCount - LastCheckTime > minCheckTime) and
    (((Abs(LastPos.X - XX) > 5) or (Abs(LastPos.Y - YY) > 5))) then
    begin
    LastPos := Point(XX,YY);
    LastCheckTime := GetTickCount;
    If Assigned(MouseKBHandler1) then
      THandler(MouseKBHandler1).MouseMove(Sender,Shift,XX,YY);
    If Assigned(MouseKBHandler2) then
      THandler(MouseKBHandler2).MouseMove(Sender,Shift,XX,YY);
    If Assigned(MouseKBHandler3) then
      THandler(MouseKBHandler3).MouseMove(Sender,Shift,XX,YY);
    end;
end;

procedure TQzMiniHtml2.MouseDown(Sender: TObject; Button: TMouseButton;
                                 Shift: TShiftState; X, Y: Integer);
var XX, YY : integer;
procedure CheckFocus;
var Tag1 : aTag;
    i : integer;
begin
  for i := 0 to tagList.Count -1 do
    begin
    Tag1 := taglist.items[i];
    if Tag1 is aVisTag then
    begin
    if aVisTag(Tag1).IsIn(Point(XX,YY)) then
      begin
      Focused := i;
      MouseOver := Tag1;
      end;
    end;
    end;
end;
begin
  XX  := X;
  YY  := Y;
  if ScrollLeft >= 0 then
      XX := X + ScrollLeft;
  if ScrollTop >= 0 then
      YY := Y + ScrollTop;
  StartPos  := Point(XX,YY);
  LastPos := StartPos;
  Selecting := true;
  if (Button = mbLeft) then
      CheckFocus;
  if TControl(Sender).Cursor = CrHandPoint then
    TControl(Sender).Cursor := CrDefault;

  If Assigned(MouseKBHandler1) then
      THandler(MouseKBHandler1).MouseDown(Sender,Button,Shift,XX,YY);
  If Assigned(MouseKBHandler2) then
      THandler(MouseKBHandler2).MouseDown(Sender,Button,Shift,XX,YY);
  If Assigned(MouseKBHandler3) then
      THandler(MouseKBHandler3).MouseDown(Sender,Button,Shift,XX,YY);

end;

procedure TQzMiniHtml2.MouseUp(Sender: TObject; Button: TMouseButton;
                               Shift: TShiftState; X, Y: Integer);
var XX, YY : integer;
begin
  XX  := X;
  YY  := Y;
  if ScrollLeft >= 0 then
      XX := X + ScrollLeft;
  if ScrollTop >= 0 then
      YY := Y + ScrollTop;
  EndPos  := Point(XX,YY);
  Selecting := false;
  If Assigned(MouseKBHandler1) then
      THandler(MouseKBHandler1).MouseUp(Sender,Button,Shift,XX,YY);
  If Assigned(MouseKBHandler2) then
      THandler(MouseKBHandler2).MouseUp(Sender,Button,Shift,XX,YY);
  If Assigned(MouseKBHandler3) then
      THandler(MouseKBHandler3).MouseUp(Sender,Button,Shift,XX,YY);
end;

procedure TQzMiniHtml2.UnSelectAll;
var i : integer;
    tag : aTag;
begin
  for i := 0 to TagList.Count -1 do
    begin
       tag := TagList.items[i];
        if aVisTag(Tag).Selected then
       begin
        aVisTag(Tag).Selected := False;
        if Tag is aText then
          aText(Tag).UnSelect;
        if Tag is aVisTag then begin {Update(i);} Draw(i); end;
        end;
    end;
  ReDraw;
end;

procedure TQzMiniHtml2.ScrollDown(Pixel : integer);
begin
  if CacheBitmap.Height <= Height then exit;
  if ScrollTop - Pixel >= 0 then Dec(ScrollTop,Pixel) else
     ScrollTop := 0;
  ReDraw;
end;

procedure TQzMiniHtml2.ScrollUp(Pixel : integer);
begin
  if CacheBitmap.Height <= Height then exit;
  If ScrollTop + Height + Pixel <= CacheBitmap.Height  then Inc(ScrollTop,Pixel) else
     ScrollTop := CacheBitmap.Height -  Height;
  ReDraw;
end;


function TQzMiniHtml2.TotalSelected : integer;
var counter, i : integer;
begin
  Counter := 0;
  for i := 0 to TagList.Count -1 do
    if aTag(TagList.items[i]).Selected then Inc(Counter);
  Result := Counter;
end;
procedure TQzMiniHtml2.Underline;
var s1, s2 : integer;
    newTag : aTag;
begin
  If (SelectStartFrom <> -1) and (SelectEndAt <> -1) then
   begin
     s2 := SplitSelected(SelectEndAt);
     s1 := SplitSelected(SelectStartFrom);
     newTag := aUETag.Create(Self);
     newTag.aHtml := self;
     newTag.variables := TStringList.Create;
     TagList.Insert(s2+1,newTag);

     newTag := aUSTag.Create(Self);
     TagList.Insert(s1,newTag);
     newTag.aHtml := self;
     newTag.variables := TStringList.Create;

     Update;
     Draw;
     ReDraw;
   end;
end;

procedure TQzMiniHtml2.Bold;
var  s1, s2 : integer;
    newTag : aTag;
begin
  If (SelectStartFrom <> -1) and (SelectEndAt <> -1) then
   begin
     s2 := SplitSelected(SelectEndAt);
     s1 := SplitSelected(SelectStartFrom);
     newTag := aBETag.Create(Self);
     newTag.aHtml := self;
     newTag.variables := TStringList.Create;
     TagList.Insert(s2+1,newTag);

     newTag := aBSTag.Create(Self);
     TagList.Insert(s1,newTag);
     newTag.aHtml := self;
     newTag.variables := TStringList.Create;

     Update;
     Draw;
     ReDraw;
   end;
end;

function TQzMiniHtml2.Bold(SelectionText : string; SelectionState : TCurrentState) : string; 
begin
  Result := SelectionText;
  if not (fsBold in SelectionState.Font.Style) then  //Bold
      begin
       Result := Replace(Result,'<b>','');
       Result := Replace(Result,'</b>','');
       Result := Format('<b>%s</b>',[Result]);
      end else
  if (Pos('<b>',Result) <> 0) and (Pos('</b>',Result) <> 0) then
      begin
       Result := Replace(Result,'<b>','');
       Result := Replace(Result,'</b>','');
       Result := Format('</b>%s<b>',[Result]);
      end else
  if Pos('</b>',Result) <> 0 then          //Unbold
      begin
       Result := Replace(Result,'</b>','');
       Result := Format('</b>%s',[Result]);
      end else
  if Pos('<b>',Result) <> 0 then
      begin
       Result := Replace(Result,'<b>','');
       Result := Format('%s<b>',[Result]);
      end;
end;

function TQzMiniHtml2.SplitSelected(splitwhich : integer) : integer;
var Tag4 : aTag;
    Tag1,Tag2,Tag3 : aText;
    k : string;
begin
    Result := splitwhich;
    if aTag(TagList.items[splitwhich]).Selected then
     begin
       Tag4 := TagList.items[splitwhich];
       if Tag4 is aText then
        with AText(Tag4) do
        if (SelStart <> 0) or (SelStop <> Length(AText(Tag4).text)) then
        if (SelStart <> -1) and (SelStop <> -1) then
          begin
            k := Copy(Text,SelStop+1,Length(Text)-SelStop);
            if k <> '' then
              begin
               Tag3 := AText.Create(Self,k);
               Tag3.Selected := false;
               Tag3.aHtml := self;
               Tag3.variables := TStringList.Create;
               TagList.Insert(splitwhich,Tag3);
              end;
            k := Copy(Text,SelStart,SelStop-SelStart+1);
            if k <> '' then
              begin
               Tag2 := AText.Create(Self,k);
               Tag2.Selected := True;
               Tag2.aHtml := self;
               Tag2.variables := TStringList.Create;
               TagList.Insert(splitwhich,Tag2);

              end;
            k := Copy(Text,0,SelStart-1);
            if k <> '' then
              begin
               Tag1 := AText.Create(Self,k);
               Tag1.Selected := false;
               Tag1.aHtml := self;
               Tag1.variables := TStringList.Create;
               TagList.Insert(splitwhich,Tag1);
              end;

            TagList.Delete(TagList.IndexOf(Tag4));
            //Tag4.Free;
            if Assigned(Tag2) then
            Result := TagList.IndexOf(Tag2);
          end;
    end;
end;

procedure TQzMiniHtml2.SetCaption(Value : TQzHtmlRec);
begin
  InputHtml := Value;
  LoadFromCaption;
end;

function TQzMiniHtml2.GetCaption : TQzHtmlRec;
begin
  Result := InputHtml;
end;


procedure THandler.MouseMove(Sender: TObject; Shift: TShiftState; X,Y: Integer);
begin end;
procedure THandler.MouseDown(Sender: TObject; Button: TMouseButton;Shift: TShiftState; X, Y: Integer);
begin end;
procedure THandler.MouseUp(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin end;
constructor THandler.Create(AOwner: TComponent; aHtml : TQzMiniHtml2);
begin
  inherited Create(AOwner);
  aMiniHtml := aHtml;
end;


procedure TNormalHandler.MouseMove(Sender: TObject; Shift: TShiftState; X,Y: Integer);
var i : integer;
    Tag1 : aTag;
begin
  MouseOver := nil;
  with aMiniHtml do
  begin
  if taglist.Count = 0 then exit;
  //if Lines.Count = 0 then exit;

  Focused := -1;
  for i := 0 to tagList.Count -1 do
    begin
    Tag1 := tagList.items[i];
    if Tag1 is aVisTag then
    begin
    if aVisTag(Tag1).IsIn(Point(X,Y)) then
      begin
      Focused := i;
      MouseOver := Tag1;
      if not aVisTag(Tag1).MouseOver then
          begin
          aVisTag(Tag1).MouseOver := True;
          if aVisTag(Tag1).TargetURL <> '' then
              Draw(i);
          end;
      end
      else {ISIN}
      if aVisTag(Tag1).MouseOver then
          begin
          aVisTag(Tag1).MouseOver := False;
          if aVisTag(Tag1).TargetURL <> '' then
              Draw(i);
          end;
         end;
    end;

    Redraw;
    If Sender is TControl then
    if MouseOver = nil then
        TControl(Sender).Cursor := crDefault else
         if aVisTag(MouseOver).TargetURL <> '' then
            TControl(Sender).Cursor := crHandPoint else
            TControl(Sender).Cursor := crDefault;
end;
end;

Procedure TNormalHandler.MouseDown(Sender: TObject; Button: TMouseButton;
                           Shift: TShiftState; X, Y: Integer);
var Tag1 : aTag;
    Handled : boolean;
begin
  with aMiniHtml do
  if (Button = mbLeft) then
  if (Focused <> -1) then
   begin
    Tag1:= tagList.items[Focused];
    if (aVisTag(Tag1).IsIn(Point(X,Y))) and
       (aVisTag(Tag1).TargetURL <> '') then
         begin
          Handled := false;
          if assigned(FLinkClicked) then
            FLinkClicked(Sender,aVisTag(Tag1).TargetURL,Handled);
          if not Handled then
          RunWWW(aVisTag(Tag1).TargetURL);
          exit;
         end;
   end;
end;
procedure TNormalHandler.MouseUp(Sender: TObject; Button: TMouseButton;
                           Shift: TShiftState; X, Y: Integer);
begin
end;


procedure TBlockHandler.MouseMove(Sender: TObject; Shift: TShiftState; X,Y: Integer);
begin
    with aMiniHtml do
    if Selecting then
    begin
    UpdateSelection(StartPos,Point(X,Y));
    ReDraw;
    end;
    If Sender is TControl then
    if MouseOver = nil then
        TControl(Sender).Cursor := crDefault else
         if aVisTag(MouseOver).TargetURL <> '' then
            TControl(Sender).Cursor := crHandPoint else
         if (MouseOver is aText) or (MouseOver is aSpace) and (aVisTag(MouseOver).MouseOver)then
            TControl(Sender).Cursor := crIBeam else
            TControl(Sender).Cursor := crDefault;
end;

Procedure TBlockHandler.MouseDown(Sender: TObject; Button: TMouseButton;
                           Shift: TShiftState; X, Y: Integer);
begin
 with aMiniHtml do
 begin
  if Lines.Count = 0 then exit;
   UnSelectAll;
   ReDraw;
 end;
end;
procedure TBlockHandler.MouseUp(Sender: TObject; Button: TMouseButton;
                           Shift: TShiftState; X, Y: Integer);
begin
  with aMiniHtml do
  begin
  if Lines.Count = 0 then exit;

  if Selecting then
  begin
  Selecting := false;
  UpdateSelection(StartPos,Point(X,Y));
  end;

  ReDraw;
  end;
end;

procedure TFormElementHandler.MouseDown(Sender: TObject; Button: TMouseButton;
                           Shift: TShiftState; X, Y: Integer);
var Tag1 : aTag;
begin
  with aMiniHtml do
  if (Button = mbLeft) then
  if (Focused <> -1) then
   begin
    Tag1:= tagList.items[Focused];
    if (aVisTag(Tag1).IsIn(Point(X,Y))) then
       if (Tag1 is aFormElement) then
         with aFormElement(Tag1) do
         begin
          if assigned(FFormElementClicked) then
            FFormElementClicked(Sender,fmName,fmMethod,fmAction,inputName,inputType,inputValue);;
          if inputType = 'checkbox' then
           begin
            aFormElement(Tag1).Checked := not aFormElement(Tag1).checked;
            aFormElement(Tag1).Draw(aMiniHtml.CacheBitmap.Canvas);
            aMiniHtml.ReDraw;
           end;
          exit;
         end else
       if (Tag1 is aUserDefined) then
         with aUserDefined(Tag1) do
         if assigned(FFormElementClicked) then
            FFormElementClicked(Sender,'','','',itemID,itemType,Variable1);
   end;

end;
procedure Register;
begin
  RegisterComponents('QZip', [TQzMiniHtml2]);
end;

end.
