unit QzHtmlLabel2;
{*********************************************************}
{*                    QzHTMLLabel2.pas                   *}
{*              Quick Zip HTML Label component           *}
{*     Copyright (c) 2003 Joseph Leung Yat Chun          *}
{*                 All rights reserved.                  *}
{*********************************************************}

interface

uses
  SysUtils, Classes, Controls, StdCtrls, QzMiniHtml2, Dialogs, Graphics;

type

  TQzHtmlLabel2 = class(TLabel)
  private
    { Private declarations }
     InputHtml : TQzHtmlRec;
     Input : string;
     NeedUpdateDyna : boolean;
     procedure SetHtml(Value : TQzHtmlRec);
     function GetHtml : TQzHtmlRec;
     procedure SetInput(Value : string);
     function GetInput : string;
     procedure SetDynamicUpdate(value : TDynamicUpdateEvent);
     function GetDynamicUpdate : TDynamicUpdateEvent;
     procedure SetLinkClicked(value : TLinkClickedEvent);
     function GetLinkClicked : TLinkClickedEvent;
     procedure SetFormElementClicked(value : TFormElementClickedEvent);
     function GetFormElementClicked : TFormElementClickedEvent;
     procedure SetUserDefinedUpdate(value : TUserDefinedUpdateEvent);
     function GetUserDefinedUpdate : TUserDefinedUpdateEvent;
     procedure SetUserDefinedDraw(value : TUserDefinedDrawEvent);
     function GetUserDefinedDraw : TUserDefinedDrawEvent;
  protected
    { Protected declarations }
  public
    { Public declarations }
    modified : boolean;
    AutoHt : boolean;
    QzMiniHtml2 : TQzMiniHtml2;
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
    procedure paint; override;
    procedure updatecaption;
    procedure OnHtmlUpdate(Sender: TObject; newHtml : string; newHKey : char);
    procedure UpdateMiniHtml;
    procedure NullDynamicUpdate(Sender: TObject;dynamicID: String; var Text: String);
  published
    { Published declarations }
    property HtmlEditor : TQzHtmlRec read getHtml write setHtml;
    property Html : String read GetInput write SetInput;
    property  OnDynamicUpdate : TDynamicUpdateEvent read GetDynamicUpdate write SetDynamicUpdate;
    property OnLinkClicked   : TLinkClickedEvent read GetLinkClicked write SetLinkClicked;
    property OnFormElementClicked : TFormElementClickedEvent read GetFormElementClicked write SetFormElementClicked;
    property OnUserDefinedUpdate : TUserDefinedUpdateEvent read GetUserDefinedUpdate write SetUserDefinedUpdate;
    property OnUserDefinedDraw : TUserDefinedDrawEvent read GetUserDefinedDraw write SetUserDefinedDraw;
    property AutoHeight : boolean read AutoHt write AutoHt;
  end;

procedure Register;

implementation

procedure TQzHtmlLabel2.UpdateMiniHtml;
begin
  QzMiniHtml2.Width := Width;
  QzMiniHtml2.Height := Height;
  QzMiniHtml2.Color := Color;
  QzMiniHtml2.Top := 0;
  QzMiniHtml2.Left := 0;
end;

procedure TQzHtmlLabel2.NullDynamicUpdate(Sender: TObject;dynamicID: String; var Text: String);
begin
  NeedUpdateDyna := true;
end;

procedure TQzHtmlLabel2.SetDynamicUpdate(value : TDynamicUpdateEvent);
begin
  QzMiniHtml2.OnDynamicUpdate := value;
end;

function TQzHtmlLabel2.GetDynamicUpdate : TDynamicUpdateEvent;
begin
  Result := QzMiniHtml2.OnDynamicUpdate;
end;

procedure TQzHtmlLabel2.SetLinkClicked(value : TLinkClickedEvent);
begin
  QzMiniHtml2.OnLinkClicked := value;
end;

function TQzHtmlLabel2.GetLinkClicked : TLinkClickedEvent;
begin
  Result := QzMiniHtml2.OnLinkClicked;
end;

procedure TQzHtmlLabel2.SetFormElementClicked(value : TFormElementClickedEvent);
begin
  QzMiniHtml2.OnFormElementClicked := value;
end;

function TQzHtmlLabel2.GetFormElementClicked : TFormElementClickedEvent;
begin
  Result := QzMiniHtml2.OnFormElementClicked;
end;

procedure TQzHtmlLabel2.SetUserDefinedUpdate(value : TUserDefinedUpdateEvent);
begin
  QzMiniHtml2.OnUserDefinedUpdate := value;
end;

function TQzHtmlLabel2.GetUserDefinedUpdate : TUserDefinedUpdateEvent;
begin
  Result := QzMiniHtml2.OnUserDefinedUpdate;
end;

procedure TQzHtmlLabel2.SetUserDefinedDraw(value : TUserDefinedDrawEvent);
begin
  QzMiniHtml2.OnUserDefinedDraw := value;
end;

function TQzHtmlLabel2.GetUserDefinedDraw : TUserDefinedDrawEvent;
begin
  Result := QzMiniHtml2.OnUserDefinedDraw;
end;

destructor TQzHtmlLabel2.Destroy;
begin
  QzMiniHtml2.free;
  Inherited Destroy;
end;

procedure TQzHtmlLabel2.OnHtmlUpdate(Sender: TObject; newHtml : string; newHKey : char);
begin
  Input := newHtml;
end;

constructor TQzHtmlLabel2.Create(AOwner:TComponent);
begin
  Inherited Create(AOwner);
  AutoSize := False;
  ParentColor := True;
  QzMiniHtml2 := TQzMiniHtml2.Create(Self);
  QzMiniHtml2.MouseKBHandler1 := TNormalHandler.Create(Self,QzMiniHtml2);
  QzMiniHtml2.MouseKBHandler2 := TFormElementHandler.Create(Self,QzMiniHtml2);
  QzMiniHtml2.Canvas := Canvas;
  QzMiniHtml2.Owner := Self;
  Modified := true;
  NeedUpdateDyna := False;
  UpdateMiniHtml;
  InputHtml := QzMiniHtml2.Caption;
  OnMouseMove := QzMiniHtml2.MouseMove;
  OnMouseDown := QzMiniHtml2.MouseDown;
  OnMouseUp := QzMiniHtml2.MouseUp;
  QzMiniHtml2.Caption.Html := Html;
  QzMiniHtml2.Caption.FHtmlUpdate := OnHtmlUpdate;
  HtmlEditor.Html := Html;
  QzMinihtml2.OnDynamicUpdate := NullDynamicUpdate;
end;

procedure TQzHtmlLabel2.updatecaption;
begin
  Invalidate;
end;

procedure TQzHtmlLabel2.paint;
begin
  UpdateMiniHtml;
  if Html <> '' then Caption := '';
  inherited Paint;

  if Html <> '' then
  if (QzMiniHtml2.CacheBitmap.Width = 0) or Modified or NeedUpdateDyna then
       begin
        NeedUpdateDyna := False;
        InputHtml.Html := Html;
        QzMiniHtml2.LoadFromCaption;
        if Modified and AutoHt then
          Height := QzMiniHtml2.CacheBitmap.Height;
        Modified := False;  
       end else
        QzMiniHtml2.ReDraw;
        
{  if AutoSize then
  begin
    Width := QzMiniHtml2.CacheBitmap.Width;
    Height := QzMiniHtml2.CacheBitmap.Height;
  end;}
end;


procedure TQzHtmlLabel2.SetHtml(Value : TQzHtmlRec);
begin
  Input := Value.Html;
  InputHtml.Html := Input;
  QzMiniHtml2.Clear;
  Modified := true;
  Invalidate;
end;

procedure TQzHtmlLabel2.SetInput(Value : string);
begin
  Input := Value;
  InputHtml.Html := Value;
  QzMiniHtml2.Clear;
  Modified := true;
  Invalidate;
end;

function TQzHtmlLabel2.GetInput : string;
begin
  result := Input;
end;


function TQzHtmlLabel2.GetHtml : TQzHtmlRec;
begin
  InputHtml.Html := Input;
  Result := InputHtml;
end;

procedure Register;
begin
  RegisterComponents('Qzip', [TQzHtmlLabel2]);
end;

end.
