unit QzHtmlHintWindow2;

interface

uses
  Types, SysUtils, Classes, Controls, QzMiniHtml2;

type
  TQzHtmlHintWindow2 = class(THintWindow)
  private
    { Private declarations }
    procedure WMNCPaint(var Message: TMessage); message WM_NCPAINT; 
    procedure WMEraseBkgnd(var Message:TWmEraseBkgnd); message WM_ERASEBKGND;

  protected
    { Protected declarations }
    procedure Paint; override;
  public
    { Public declarations }
    constructor Create(AOwner:TComponent);override;
    procedure ActivateHint(Rect: TRect; const AHint: string); override;
    function CalcHintRect(MaxWidth: Integer; const AHint: string;AData: Pointer): TRect;
  published
    { Published declarations }
  end;

procedure Register;

implementation


constructor TQzHtmlHintWindow2.Create(AOwner:
TComponent); 
begin 
inherited Create(AOwner); 
Color := C80FFFF; 
Canvas.Font.Size := 14; 
end;

procedure TQzHtmlHintWindow2.WMEraseBkgnd(var Message: TWmEraseBkgnd); 
begin 
Message.Result := 1; 
end; 



procedure TQzHtmlHintWindow2.ActivateHint(Rect: TRect; const AHint: string);
var  aQzMiniHtml2 : TQzMiniHtml2; 
begin
  aQzMiniHtml2 := TQzMiniHtml2.Create(Self);
  try
  aQzMiniHtml2.Canvas := Canvas;
  aQzMiniHtml2.Lines.Text := AHint;
  aQzMiniHtml2.LoadFromLines;
  finally
    free;
  end;
end;

procedure Register;
begin
  RegisterComponents('QZip', [TQzHtmlHintWindow2]);
end;

end.
 