unit QzHtmlEdit2;

interface

uses
  SysUtils, Classes, Controls, ExtCtrls,QzHtmlScrollBox2,Buttons,QzHtmlEditor2;

type
  TQzHtmlEdit2 = class(TPanel)
  private
    { Private declarations }
    procedure SetInput(Value : string);
    function GetInput : string;
  protected
    { Protected declarations }
  public
    Panel1 : TPanel;
    SpeedButton1 : TSpeedButton;
    QzHtmlScrollBox2 : TQzHtmlScrollBox2;
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
    procedure OnSpeedButton1Click(Sender: TObject);
    { Public declarations }
  published
    { Published declarations }
    property Html : String read GetInput write SetInput;
  end;

procedure Register;

implementation

constructor TQzHtmlEdit2.Create(AOwner : TComponent);
begin
    inherited Create(AOwner);
    Height := 25;
    Panel1 := TPanel.Create(Self);
    Panel1.Parent := Self;
    Panel1.Align := alRight;
    Panel1.AutoSize := True;
    Panel1.BevelInner := bvNone;
    Panel1.BevelOuter := bvNone;
    Panel1.Width := 26;
    SpeedButton1 := TSpeedButton.Create(Panel1);
    SpeedButton1.Align := alClient;
    SpeedButton1.Parent := Panel1;
    SpeedButton1.Flat := False;
    SpeedButton1.Caption := '...';
    SpeedButton1.OnClick := OnSpeedButton1Click;
    QzHtmlScrollBox2 := TQzHtmlScrollBox2.Create(Self);
    QzHtmlScrollBox2.Parent := Self;
    QzHtmlScrollBox2.Align := alClient;
    QzHtmlScrollBox2.AutoScroll := False;
    QzHtmlScrollBox2.VertScrollBar.Visible := false;
end;

destructor TQzHtmlEdit2.Destroy;
begin
    //SpeedButton1.Free;
    QzHtmlScrollBox2.Free;
    Panel1.Free;
    inherited Destroy;
end;

procedure TQzHtmlEdit2.OnSpeedButton1Click(Sender: TObject);
var aQzHtmlEditor : TQzHtmlEditor2;
begin
  aQzHtmlEditor := TQzHtmlEditor2.Create(nil);
  with aQzHtmlEditor do
  try
  Left := Self.Left+Self.Width;
  Top := Self.Top;
  Html := Self.Html;
  if Execute then
    Self.Html := Html;
  finally
  free;
  end;
end;

procedure TQzHtmlEdit2.SetInput(Value : string);
begin
  QzHtmlScrollBox2.Html := Value;
end;

function TQzHtmlEdit2.GetInput : string;
begin
  result := QzHtmlScrollBox2.Html;
end;

procedure Register;
begin
  RegisterComponents('QZip', [TQzHtmlEdit2]);
end;

end.
