// The Initial Developer of the Original Code is
// Copyright (C) 2003 Joseph Leung Yat Chun(lycj@yahoo.com)
// All Rights Reserved
//////////////////////////////////////////////////////////////////////
// TQz BETA Component License
// Please read Carefully.
// P	Author means the initial writer of this component.
// P	Component user means the Software developer that use a
//    TQz component to develope software.
// P	Software user means the customer of Component user.
// P	This component is in BETA Stage, bug may exists and some
//    may cause any kind of damage to the Component user and
//    Software user. The Author is not responsible to any kind
//    of loss caused. Software distributed is distributed on an
//    "AS IS" basis, WITHOUT WARRANTY OF ANY KIND, either express
//     or implied.
// P	Component user may use this component to write application,
//    including freeware,  shareware and Commercialware. In return
//    the Author request the component user to submit any changes
//    component user made to the component to the Author.
//    Please report any bugs found to Quick Zip Message Board.
// P	Component may be re-distribute as long as it is unchanged.
// P	Component user is responsibile to make sure the Software user
//    know the software use this component. Listing Component name
//    under Credits in Help page would be sufficient for this.
// P	This licence may be changed anytime, please check regularly.
//    Latest License may be found in Quick Zip Message Board.
//
//    Quick Zip Message Board - http://qzip.cjb.net
//                              http://cake.sourceforge.net
//
//////////////////////////////////////////////////////////////////////

unit QzMiniHtml;
{*********************************************************}
{*                    QzMiniHTML.pas                     *}
{*                 Quick Zip HTML support                *}
{*     Copyright (c) 2003 Joseph Leung Yat Chun          *}
{*                 All rights reserved.                  *}
{*********************************************************}
interface

uses
   Dialogs,Forms, Windows, Messages, SysUtils, Classes, Controls, Graphics,StdCtrls,ShellApi,ExtCtrls, QzLib;

const MaxLink = 20;
type
  LinkRectType = record
               loc : Trect;
               linkto : string;
               Enabled : boolean;
             end;
  FontOptionsType = record
                     Face : String;
                     Size : Integer;
                     bgColor,Color : TColor;
                    end;
  TCPageEvent = procedure ( Sender : TObject; Page : integer) of object;
  TCReqDLEvent = procedure ( Sender: TObject; Httpname: String;var Filename: string) of object;
  TQzMiniHtml = class(TComponent)
  private
    text : string;
    Colour : TColor;
    FOnPage : TCPageEvent;
    fOnReqDLEvent : TCReqDLEvent;
    procedure NextLine;
    procedure runwww(wwwpath : string);
    procedure run(programpath,Programparam : string);
    { Private declarations }
  protected
    { Protected declarations }
  public
     { Public declarations }
     Owner : TComponent;
     TotalLink : integer;
     LinkRect : array[0..MaxLink-1] of LinkRectType;
     Canvas : TCanvas;

     constructor Create(AOwner: TComponent); override;
     procedure SetCaption(caption : string);
     procedure ResetLinkRect;
     procedure processtag(var commands : tstrings; tag : string);
     function OutputFont(commands : tstrings) : TFont;
     procedure printtext(aFont: TFont;text : string;alink : boolean);
     function processFONT(command : string; Current : FontOptionsType) : FontOptionsType;
     procedure processBODY(command : string);
     procedure processIMG(command : string);
     function GetWidth(s : string) : integer;
     function GetHeight(s : string) : integer;

     procedure OnMMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
     procedure OnMDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);

     procedure update;
  published
     property Caption : string read text write setcaption;
     property Color : TColor read Colour write Colour;
     property OnCChangePage : TCPageEvent read FOnPage write FOnPage;
     property RequestDownload: TCReqDLEvent read fOnReqDLEvent write fOnReqDLEvent;
    { Published declarations }
  end;

procedure Register;

implementation
uses TextUtils;
var maxFontHeight : integer = 10;
    commands : tstrings;
constructor TQzMiniHtml.Create(AOwner:TComponent);
begin
  Inherited Create(AOwner);
  ResetLinkRect;
end;

function TextInsideQuote(text : string) : string;
var i : integer;
    k : string;
begin
    result := '';
    k := text;
    i := pos('"',k);
    if i <> 0 then
      begin
        k := Copy(k,i+1,length(k)-i);
        i := pos('"',k);
        if i <> 0 then
           result := copy(k,0,i-1);
      end;
end;

function TextInsideQuoteEx(text : string;Startfrom : integer) : string;
var i : integer;
    k : string;
begin
    result := '';
    k := Copy(text,startfrom,length(text)-startfrom);
    i := pos('"',k);
    if i <> 0 then
      begin
        k := Copy(k,i+1,length(k)-i);
        i := pos('"',k);
        if i <> 0 then
           result := copy(k,0,i-1);
      end;
end;

procedure TQzMiniHtml.processBODY(command : string);
var i : integer;
    k : string;
    pic : TImage;
    bitmap : TBitmap;
begin
    if (canvas.PenPos.X = 0) and (canvas.PenPos.Y = 0) then
    begin
    k := command;
    i := pos('bgcolor=',k);

    if i <> 0 then
        begin
         k := Copy(k,i+1,length(k));
         Canvas.Brush.Color := StringtoColor(TextInsideQuote(k));
         Canvas.FillRect(Canvas.ClipRect);
        end;

    k := command;
    i := pos('background=',k);
    if i <> 0 then
        begin
         k := Copy(k,i+1,length(k));
         pic := TImage.Create(nil);
         bitmap := tbitmap.Create;
         if pos(':',TextInsideQuote(k)) = 0 then
         k := grabprogrampath + TextInsideQuote(k) else
         k := TextInsideQuote(k);
         if fileexists(k) then
         pic.picture.LoadFromFile(k);
         bitmap.Assign(pic.Picture.Graphic);
         canvas.Brush.Bitmap := bitmap;
         canvas.FillRect(Canvas.ClipRect);
         bitmap.Free;
         pic.Free;

         canvas.Brush.Bitmap := nil;
         canvas.Brush.Style := bsVertical;
         Canvas.PenPos := Point(0,0);
        end;
    end;
end;

procedure TQzMiniHtml.processIMG(command : string);
var i : integer;
    k : string;
    pic : TImage;
    bitmap : tbitmap;
begin
    k := command;
    i := pos('src=',k);

    if i <> 0 then
        begin
         k := Copy(k,i+1,length(k));
         pic := TImage.Create(nil);
         bitmap := tbitmap.Create;
         pic.AutoSize := true;
         pic.Transparent := true;

         if pos(':',TextInsideQuote(k)) = 0 then
         k := grabprogrampath + TextInsideQuote(k) else
         k := TextInsideQuote(k);

         if fileexists(k) then
         pic.Picture.LoadFromFile(k);
         //bitmap.Canvas.Brush.Color := Canvas.Brush.Color;
         bitmap.Assign(pic.Picture.Graphic);
         //bitmap.LoadFromFile(TextInsideQuote(k));
         bitmap.Transparent := true;
         bitmap.TransparentColor := clWhite;
         //pic.Picture.Bitmap.SaveToFile('c:\test3.bmp');
         //canvas.Draw(canvas.PenPos.X,canvas.PenPos.Y,pic.Picture.Graphic);
         canvas.CopyRect(Rect(Canvas.PenPos,
            Point(Canvas.PenPos.X+pic.Width,Canvas.PenPos.Y+pic.Height)),
            bitmap.Canvas,rect(0,0,pic.Width,pic.Height));

         {canvas.BrushCopy(Rect(Canvas.PenPos,
            Point(Canvas.PenPos.X+pic.Width,Canvas.PenPos.Y+pic.Height)),
            bitmap ,rect(0,0,pic.Width,pic.Height),clWhite);}
         canvas.MoveTo(canvas.Penpos.X + pic.Width, Canvas.PenPos.Y);
        end;
end;

function TQzMiniHtml.processFONT(command : string; Current : FontOptionsType) : FontOptionsType;
var i : integer;
    k : string;
    aFontOptions : FontOptionsType;
begin
    k := command;
    aFontOptions := current;
    i := pos('face=',k);
    if i = 0 then i := pos('name=',k);
    if i <> 0 then
        begin
         k := Copy(k,i+1,length(k));
         aFontOptions.Face := TextInsideQuote(k);
        end;
    k := command;
    i := pos('size=',k);
    if i <> 0 then
        begin
         k := Copy(k,i+1,length(k));
         aFontOptions.Size := StrtoIntdef(TextInsideQuote(k),10);
        end;
        k := command;
    i := pos('color=',k);
    if i <> 0 then
        begin
         k := Copy(k,i+1,length(k));
         aFontOptions.Color := StringtoColor(TextInsideQuote(k));
        end;
    i := pos('bgcolor=',k);
    if i <> 0 then
        begin
         k := Copy(k,i+1,length(k));
         aFontOptions.bgColor := StringtoColor(TextInsideQuote(k));
        end;
   Result := aFontOptions;
end;

procedure TQzMiniHtml.NextLine;
begin
      Canvas.MoveTo(0,Canvas.PenPos.Y+Abs(Trunc(maxFontHeight)));
      maxFontHeight := GetHeight('ABCDE');
end;
procedure TQzMiniHtml.runwww(wwwpath : string);
begin
        if pos('mailto://',wwwpath) <> 0 then
        shellexecute(0,'open',pchar(
        'mailto:'+copy(wwwpath,10,length(wwwpath)-9)),'',
        '',SW_SHOWNORMAL) else
        shellexecute(0,'open',pchar(
        wwwpath),'',
        '',SW_SHOWNORMAL);
end;
procedure TQzMiniHtml.run(programpath,Programparam : string);
var k : string;
begin
        if pos('$',programpath) <> 0 then
        begin
        k := Copy(programpath,2,length(programpath)-1);
        FOnPage(nil,Strtointdef(k,0));
        end else
        if pos('//',programpath) <> 0 then runwww(programpath) else
        begin
        if pos(':',programpath) = 0 then
        k := grabprogrampath + programpath else
        k := programpath;
        shellexecute(Application.handle,'open',pchar(
        extractfilename(k)),pchar(programparam),
        pchar(extractfilepath(k)),SW_SHOWNORMAL);
        end;
end;

procedure TQzMiniHtml.OnMDown(Sender: TObject; Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var i,cX1,cX2,cY1,cY2 : integer;
begin
  if TControl(Sender).Cursor = crHandPoint then
  for i := 0 to Maxlink - 1 do
    begin
      cX1 := LinkRect[i].loc.Left;
      cY1 := LinkRect[i].loc.Top;
      cX2 := LinkRect[i].loc.Right;
      cY2 := LinkRect[i].loc.Bottom;
      if (X > cX1) and (X < cX2) and (Y > cY1) and (Y < cY2) then
          Run(LinkRect[i].linkto,'');
    end;
end;

procedure TQzMiniHtml.OnMMove(Sender: TObject; Shift: TShiftState; X, Y: Integer);
var i,cX1,cX2,cY1,cY2 : integer;
begin
  TControl(Sender).Cursor := crDefault;
  for i := 0 to Maxlink - 1 do
    begin
      cX1 := LinkRect[i].loc.Left;
      cY1 := LinkRect[i].loc.Top;
      cX2 := LinkRect[i].loc.Right;
      cY2 := LinkRect[i].loc.Bottom;
      if (X > cX1) and (X < cX2) and (Y > cY1) and (Y < cY2) then
        TControl(Sender).Cursor := crHandPoint;
    end;
end;

procedure TQzMiniHtml.ResetLinkRect;
var i : integer;
begin
  for i := 0 to MaxLink -1 do
    begin
     LinkRect[i].loc := Rect(0,0,0,0);
     LinkRect[i].linkto := '';
     LinkRect[i].Enabled := false;;
    end;
end;
procedure TQzMiniHtml.SetCaption(caption : string);
begin
  ResetLinkRect;
  text := caption;
  update;
end;


function TQzMiniHtml.OutputFont(commands : tstrings) : TFont;
var i : integer;
    k : string;
    aFont : TFont;
    aFontOptions : FontOptionsType;


begin
  aFont := TFont.Create;
  aFont.Size := 10;
  //aFont.Height := Trunc(-aFont.Size * aFont.PixelsPerInch / 72);
  aFont.Name := 'MS Sans Serif';
  aFont.Color := clBlack;

  aFont.Color := clBlack;
  for i := 0 to commands.Count -1 do
   begin
    k := lowercase(commands.Strings[i]);
    if k = 'b' then
      aFont.Style := aFont.Style + [fsBold] else
    if k = 'i' then
      aFont.Style := aFont.Style + [fsItalic] else
    if k = 's' then
      aFont.Style := aFont.Style + [fsStrikeOut] else
    if k = 'u' then
      aFont.Style := aFont.Style + [fsUnderLine] else
    if k = 'hi' then
      begin
      Canvas.Brush.Color := aFont.Color;
      aFont.Color := Colour;
      end else
    if k = 'p' then
      NextLine
    else
    if pos('a href=',k) <> 0 then
      begin
         k := TextInsideQuote(k);
         if k <> '' then
           begin
           aFont.Style := aFont.Style + [fsUnderLine];
           aFont.Color := clBlue;
           end;
      end else
    if pos('body',k) <> 0 then
      begin
         processBODY(k);
         commands.Strings[i] := '';
      end else
    if pos('img',k) <> 0 then
      begin
         processIMG(k);
         commands.Strings[i] := '';
      end else
    if pos('font',k) <> 0 then
      begin
         aFontOptions.Face := aFont.Name;
         aFontOptions.Size := aFont.Size;
         aFontOptions.bgColor := canvas.Brush.Color;
         aFontOptions.Color := aFont.Color;
         aFontOptions := ProcessFont(k,aFontOptions);
         aFont.Name := aFontOptions.Face;
         aFont.Size := aFontOptions.Size;
         canvas.Brush.Color := aFontOptions.bgColor;
         aFont.Color := aFontOptions.Color;
      end;

   end;
  if commands.IndexOf('p') <> -1 then
     Commands.Delete(commands.IndexOf('p'));

  if maxFontHeight <  GetHeight('ABCDE') then
             maxFontHeight := GetHeight('ABCDE');
  Result := aFont;
end;

procedure TQzMiniHtml.processtag(var commands : tstrings; tag : string);
var i : integer;
function findtag(tag : string) : integer;
var j : integer;
begin
 result := -1; 
 if tag = '/a' then
   begin
     for j := 0 to commands.Count -1 do
       if pos('a href',commands.strings[j]) <> 0 then
         result := j;
   end
   else
 if tag = '/font' then
   begin
     for j := 0 to commands.Count -1 do
       if pos('font',commands.strings[j]) <> 0 then
         result := j;
   end
   else
   if tag[1] = '/' then
   result := commands.IndexOf(Copy(tag,2,length(tag)-1))
   else
   result := commands.IndexOf(Copy(tag,1,length(tag)));
end;
begin
  i := -1;
  if length(tag) > 0 then
    if tag[1] = '/' then
      begin
      if length(tag) > 1 then
        i := findtag(tag);
      if i <> -1 then
        commands.Delete(i);
      end else
      begin
        i := Findtag(tag);
        if i = -1 then
        commands.Add(tag);
      end;
  Canvas.Font := OutputFont(commands);
end;

procedure Readnexttag(text : string; var beforetag, aftertag, tag : string);
var i,j : integer;
begin
  i := pos('<',text);
  j := pos('>',text);
  if (i = 0) or (j = 0) then
     begin
       tag := '';
       beforetag := text;
       aftertag := '';
     end else
     begin
       tag := Copy(text,i+1,j-i-1);
       beforetag := Copy(text,0,i-1);
       aftertag := Copy(text,j+1,length(text)-j);
     end;
end;

procedure TQzMiniHtml.Printtext(aFont: TFont;text : string;alink : boolean);
var k,print  : string;
    i : integer;
    CurXY : TPoint;
    //Style:TBrushStyle;
begin
    k := text;
    while k <> '' do
    begin

    if (fsBold in Canvas.Font.Style) or (fsItalic in Canvas.Font.Style) then
    if Canvas.PenPos.X <> 0 then
    Canvas.MoveTo(Canvas.PenPos.X,Canvas.PenPos.Y);

    Canvas.Font := aFont;

    i := pos(' ',k);
    if i = 0 then
    begin
    print := k;
    k := '';
    end else
    begin
    print := copy(k,0,i);// + ' ';
    k := copy(k,i+1,length(k)-i);
    end;

    //if aFont.Size < maxFontHeight then
    //   Canvas.MoveTo(Canvas.PenPos.X,Canvas.PenPos.Y+(maxFontHeight-aFont.size));

    CurXY := Canvas.PenPos;

    if (Canvas.PenPos.X + GetWidth(print) > TControl(Owner).Width - 40) and (Canvas.PenPos.X <> 0) and not alink then
       NextLine;
    Canvas.TextOut(Canvas.PenPos.X,Canvas.PenPos.Y,print);
    end;
end;

procedure TQzMiniHtml.update;
var
    atag,beforetag,aftertag : string;
    k : string;
    CurXY,CurXY2 : TPoint;
    //Styles : longint;
begin
  //Styles := GetWindowLong(TWinControl(Self.Owner).Handle, GWL_STYLE);
  //Styles := Styles or WS_EX_TRANSPARENT;
  //SetWindowLong (TWinControl(Self.Owner).Handle, GWL_STYLE, Styles);
  canvas.Brush.Style := bsSolid;
  ResetLinkRect;
  atag := '';
  k := caption;
  if not Assigned(Canvas) then exit;
  Canvas.Lock;
  Canvas.Moveto(0,0);
  Canvas.Brush.Color := Colour;
  Canvas.FillRect(Canvas.ClipRect);
  commands := tstringList.Create;
  TotalLink := 0;
  while k <> '' do
     begin
       Readnexttag(k,beforetag,aftertag,atag);
       printtext(OutputFont(commands),beforetag,false);
       processtag(commands,atag);

       if pos('a href',atag) <> 0 then
         begin
           k := aftertag;
           Inc(TotalLink);
           LinkRect[TotalLink-1].linkto := TextInsideQuote(atag);
           Readnexttag(k,beforetag,aftertag,atag);

           CurXY := Canvas.PenPos;
           printtext(OutputFont(commands),beforetag,true);

           CurXY2 := Point(Canvas.PenPos.X,Canvas.PenPos.Y+Abs(OutputFont(commands).Height));
           LinkRect[TotalLink-1].loc := Rect(CurXY,CurXY2);

           processtag(commands,atag);
         end;

       k := aftertag;
     end;
  commands.Free;
  Canvas.Unlock;

end;

function TQzMiniHtml.GetWidth(s : string) : integer;
begin
  Result := Canvas.TextWidth(s) + GetTextCAdjust(Canvas, s) +
            GetTextAAdjust(Canvas, s);
end;

function TQzMiniHtml.GetHeight(s : string) : integer;
begin
 Result := Canvas.TextHeight(s);
end;

procedure Register;
begin
  RegisterComponents('QZip', [TQzMiniHtml]);
end;

end.
 