unit QzHtmlLabel2;
{*********************************************************}
{*                    QzHTMLLabel2.pas                   *}
{*              Quick Zip HTML Label component           *}
{*     Copyright (c) 2003 Joseph Leung Yat Chun          *}
{*                 All rights reserved.                  *}
{*********************************************************}

interface

uses
  SysUtils, Classes, Controls, StdCtrls, QzMiniHtml2, Dialogs, Graphics;

type

  TQzHtmlLabel2 = class(TLabel)
  private
    { Private declarations }
     InputHtml : TQzHtmlRec;
     Input : string;
     procedure SetCaption(Value : TQzHtmlRec);
     function GetCaption : TQzHtmlRec;
     procedure SetInput(Value : string);
     function GetInput : string;
  protected
    { Protected declarations }
  public
    { Public declarations }
    QzMiniHtml2 : TQzMiniHtml2;
    constructor Create(AOwner : TComponent); override;
    destructor Destroy; override;
    procedure paint; override;
    procedure updatecaption;
    procedure OnHtmlUpdate(Sender: TObject; newHtml : string);
  published
    { Published declarations }
    property Caption : TQzHtmlRec read getCaption write setcaption;
    property Html : String read GetInput write SetInput;
  end;

procedure Register;

implementation

destructor TQzHtmlLabel2.Destroy;
begin
  QzMiniHtml2.free;
  Inherited Destroy;
end;

procedure TQzHtmlLabel2.OnHtmlUpdate(Sender: TObject; newHtml : string);
begin
  Input := newHtml;
end;

constructor TQzHtmlLabel2.Create(AOwner:TComponent);
begin
  Inherited Create(AOwner);
  AutoSize := False;
  ParentColor := True;
  QzMiniHtml2 := TQzMiniHtml2.Create(Self);
  QzMiniHtml2.MouseKBHandler1 := TNormalHandler.Create(Self,QzMiniHtml2);
  QzMiniHtml2.Canvas := Canvas;
  QzMiniHtml2.Owner := Self;
  QzMiniHtml2.Color := Color;
  InputHtml := QzMiniHtml2.Caption;
  OnMouseMove := QzMiniHtml2.MouseMove;
  OnMouseDown := QzMiniHtml2.MouseDown;
  OnMouseUp := QzMiniHtml2.MouseUp;
  QzMiniHtml2.Caption.Html := Html;
  QzMiniHtml2.Caption.FHtmlUpdate := OnHtmlUpdate;
  Caption.Html := Html;
end;

procedure TQzHtmlLabel2.updatecaption;
begin

  QzMiniHtml2.Width := Width;
  QzMiniHtml2.Height := Height;
  QzMiniHtml2.Top := 0;
  QzMiniHtml2.Left := 0;

  QzMiniHtml2.LoadFromCaption;
end;

procedure TQzHtmlLabel2.paint;
begin
  inherited Paint;
  QzMiniHtml2.Width := Width;
  QzMiniHtml2.Height := Height;
  QzMiniHtml2.Top := 0;
  QzMiniHtml2.Left := 0;

  if Html <> '' then
    begin
//     InputHtml.Html := Html;
     QzMiniHtml2.LoadFromCaption;
    end;
end;


procedure TQzHtmlLabel2.SetCaption(Value : TQzHtmlRec);
begin
  Html := Value.Html;
  InputHtml.Html := Html;
  QzMiniHtml2.LoadFromCaption;
end;

procedure TQzHtmlLabel2.SetInput(Value : string);
begin
  input := Value;
  InputHtml.Html := input;
  QzMiniHtml2.LoadFromCaption;
end;

function TQzHtmlLabel2.GetInput : string;
begin
  result := InputHtml.Html;
end;


function TQzHtmlLabel2.GetCaption : TQzHtmlRec;
begin
  Result := InputHtml;
end;

procedure Register;
begin
  RegisterComponents('Qzip', [TQzHtmlLabel2]);
end;

end.
