unit QzHtmlEditor;
{*********************************************************}
{*                    QzHTMLEditor.pas                   *}
{*                  Quick Zip HTML Editor                *}
{*     Copyright (c) 2003 Joseph Leung Yat Chun          *}
{*                 All rights reserved.                  *}
{*********************************************************}

interface

uses
  DesignIntf, DesignEditors,
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, ToolWin, ExtCtrls, QzMiniHtml2, ImgList;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    ToolBar1: TToolBar;
    FontName: TComboBox;
    FontSize: TComboBox;
    Bold: TToolButton;
    Italic: TToolButton;
    Underline: TToolButton;
    QzMiniHtml21: TQzMiniHtml2;
    Panel1: TPanel;
    Image1: TImage;
    Panel2: TPanel;
    Button1: TButton;
    Button2: TButton;
    ToolbarImages: TImageList;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    ColorDialog1: TColorDialog;
    ComboBox1: TComboBox;
    procedure FormShow(Sender: TObject);
    procedure Memo1Change(Sender: TObject);
    procedure BoldClick(Sender: TObject);
    procedure ItalicClick(Sender: TObject);
    procedure UnderlineClick(Sender: TObject);
    procedure FontNameChange(Sender: TObject);
    procedure Memo1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Memo1KeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FontSizeChange(Sender: TObject);
    procedure ToolButton5Click(Sender: TObject);
    procedure ToolButton6Click(Sender: TObject);
    procedure ComboBox1Change(Sender: TObject);
    procedure Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
  private
    { Private declarations }
    procedure GetFontNames;
  public
    { Public declarations }
  end;


TQzHtmlProperty=class(TStringProperty{TPropertyEditor})
  public
    function GetAttributes: TPropertyAttributes; override;
    procedure SetValue(const Value: string); override;
    function GetValue: string; override;
    procedure Edit; override;
  end;

procedure Register;  
implementation
var showingtext : string;
    //RealDesigner: IDesigner;

{$R *.dfm}


function TQzHtmlProperty.GetAttributes:TPropertyAttributes;
begin
  Result:=[paDialog,paReadOnly,paMultiSelect];
end;

procedure TQzHtmlProperty.SetValue(const Value: string);
begin

end;

function TQzHtmlProperty.GetValue: string;
begin
  FmtStr(Result, '(%s)', [GetPropType^.Name]);
end;

procedure TQzHtmlProperty.Edit;
var
  Form1: TForm1;
  P:TPoint;
  Count : integer;
begin
Form1:=TForm1.Create(nil);
try
  with Form1 do
    begin
    GetCursorPos(P);
    Left:=P.X;
    Top:=P.Y-50;
    Showingtext := TQzHtmlRec(GetOrdValue).Html;
    ShowModal;
    if ModalResult=mrOk
    then
      begin
      for Count:=0 to PropCount-1 do
        begin
        TQzHtmlRec(GetOrdValueAt(Count)).SetHtml(Memo1.Lines.Text);
        end;
      end;
    end;
finally
  Form1.Free;
end;
end;


procedure TForm1.FormShow(Sender: TObject);
begin
  QzMiniHtml21.Canvas := Image1.Canvas;
  QzMiniHtml21.height := Image1.Height;
  QzMiniHtml21.width := Image1.Width;
  GetFontNames;
  Memo1.Text := Showingtext;
  QzMiniHtml21.MouseKBHandler1 := TNormalHandler.Create(Self,QzMiniHtml21);
end;

function EnumFontsProc(var LogFont: TLogFont; var TextMetric: TTextMetric;
  FontType: Integer; Data: Pointer): Integer; stdcall;
begin
  TStrings(Data).Add(LogFont.lfFaceName);
  Result := 1;
end;

procedure TForm1.GetFontNames;
var
  DC: HDC;
begin
  DC := GetDC(0);
  EnumFonts(DC, nil, @EnumFontsProc, Pointer(FontName.Items));
  ReleaseDC(0, DC);
  FontName.Sorted := True;
end;

procedure TForm1.Memo1Change(Sender: TObject);
begin
  QzMiniHtml21.Lines.Clear;
  QzMiniHtml21.Lines.AddStrings(Memo1.Lines);
  QzMiniHtml21.LoadFromLines;
end;

procedure TForm1.BoldClick(Sender: TObject);
begin
  If Memo1.SelLength = 0 then exit;
  Memo1.SelText :=  '<b>' + Memo1.SelText + '</b>'
end;

procedure TForm1.ItalicClick(Sender: TObject);
begin
  If Memo1.SelLength = 0 then exit;
  Memo1.SelText :=  '<i>' + Memo1.SelText + '</i>'
end;

procedure TForm1.UnderlineClick(Sender: TObject);
begin
  If Memo1.SelLength = 0 then exit;
  Memo1.SelText :=  '<u>' + Memo1.SelText + '</u>'
end;

procedure TForm1.FontNameChange(Sender: TObject);
begin
  if (FontName.Text = '') or (FontName.Text = 'Fonts') then exit;
  If Memo1.SelLength = 0 then exit;
  Memo1.SelText :=  Format('<font name="%s">',[FontName.Text]) + Memo1.SelText + '</font>'
end;

procedure TForm1.Memo1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  FontName.Text := '';
  FontSize.Text := '';
end;

procedure TForm1.Memo1KeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  FontName.Text := '';
  FontSize.Text := '';
  Case Key of
  vk_Return : if Shift = [ssShift] then Memo1.SelText := '<br>';
  Ord(',')  : if Shift = [ssShift] then Memo1.SelText := '&lt;';
  Ord('.')  : if Shift = [ssShift] then Memo1.SelText := '&gt;';
  end;

end;

procedure TForm1.FontSizeChange(Sender: TObject);
begin
  if (FontSize.Text = '') or (FontSize.Text = 'Size') then exit;
  If Memo1.SelLength = 0 then exit;
  Memo1.SelText :=  Format('<font size="%s">',[FontSize.Text]) + Memo1.SelText + '</font>'
end;

procedure TForm1.ToolButton5Click(Sender: TObject);
begin
  If Memo1.SelLength = 0 then
  Memo1.SelText :=  '<ul><li>First Bullet</li><li>Second Bullet</li></ul>' else
  Memo1.SelText :=  '<ul><li>' + Memo1.SelText + '</li><li>Another Bullet</li></ul>'
end;

procedure TForm1.ToolButton6Click(Sender: TObject);
begin
 If Memo1.SelLength <> 0 then
 if ColorDialog1.Execute then
 Memo1.SelText :=  Format('<font color="%s">',[Tcolor2Webcolor(ColorDialog1.Color)])
                   + Memo1.SelText + '</font>';
end;

procedure Register;
begin
  RegisterPropertyEditor(TypeInfo(TQzHtmlRec),nil,'',TQzHtmlProperty);
end;

procedure TForm1.ComboBox1Change(Sender: TObject);
begin
  Case Combobox1.ItemIndex of
  0 : Memo1.SelText := '&lt;';
  1 : Memo1.SelText := '&gt;';
  2 : Memo1.SelText := '&amp;';
  3 : Memo1.SelText := '&quot;';
  end;
end;

procedure TForm1.Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
begin
  QzMiniHtml21.MouseMove(Sender,Shift,X,Y);
end;

end.
