library OSVDDLL;
{

 Operating System Version Detector Dynamic Link Library
 1.2.0.0.
 Copyright Ville Alasaari 2003
 valasaari@hotmail.com

}

uses
 Windows, SysUtils;

{$E dll}
{$R *.res}

var Major, Minor, Build: Integer;
    CSDVersion: PChar;

{ Define types for OSVersionInfo }

{
*************************************
From MS Win32 Programmer's Reference:
*************************************

The OSVERSIONINFO data structure contains operating system version
information. The information includes major and minor version numbers,
a build number, a platform identifier, and descriptive text about the
operating system. This structure is used with the GetVersionEx function.

typedef struct _OSVERSIONINFO

    DWORD dwOSVersionInfoSize;
    DWORD dwMajorVersion;
    DWORD dwMinorVersion;
    DWORD dwBuildNumber;
    DWORD dwPlatformId;
    TCHAR szCSDVersion[ 128 ];

 OSVERSIONINFO;

Members

dwOSVersionInfoSize

Specifies the size, in bytes, of this data structure.
Set this member to sizeof(OSVERSIONINFO) before calling the GetVersionEx function.

dwMajorVersion

Identifies the major version number of the operating system. For example,
for Windows NT version 3.51, the major version number is 3;
and for Windows NT version 4.0, the major version number is 4.

dwMinorVersion

Identifies the minor version number of the operating system. For example,
for Windows NT version 3.51, the minor version number is 51;
and for Windows NT version 4.0, the minor version number is 0.

dwBuildNumber

Windows NT: Identifies the build number of the operating system.
Windows 95: Identifies the build number of the operating system
in the low-order word. The high-order word contains the major and
minor version numbers.
((-- Use operator: and $FFFF
     do get valid build version -- VA))

dwPlatformId

Identifies the operating system platform.
This member can be one of the following values:

Value	Platform
VER_PLATFORM_WIN32s	        Win32s on Windows 3.1.
VER_PLATFORM_WIN32_WINDOWS	Win32 on Windows 95.
VER_PLATFORM_WIN32_NT	        Win32 on Windows NT.

numeric values:

VER_PLATFORM_WIN32s := 0;
VER_PLATFORM_WIN32_WINDOWS := 1;
VER_PLATFORM_WIN32_NT := 2;

szCSDVersion

Windows NT: Contains a null-terminated string, such as
 "Service Pack 3", that indicates
 Service Pack 3 is installed on the system.
 If no Service Pack has been installed, the string is empty.
Windows 95: Contains a null-terminated string that provides arbitrary
            additional information about the operating system.
           ((-- such as: 'A', 'B', 'C' in Windows 95 -- VA))
}

type
  POSVersionInfoA = ^TOSVersionInfoA;
  POSVersionInfoW = ^TOSVersionInfoW;
  POSVersionInfo = POSVersionInfoA;

  _OSVERSIONINFOA = record // Ansi
    dwOSVersionInfoSize: DWORD;
    dwMajorVersion: DWORD;
    dwMinorVersion: DWORD;
    dwBuildNumber: DWORD;
    dwPlatformId: DWORD;
    szCSDVersion: array[0..127] of AnsiChar;
  end;

  _OSVERSIONINFOW = record // Wide
    dwOSVersionInfoSize: DWORD;
    dwMajorVersion: DWORD;
    dwMinorVersion: DWORD;
    dwBuildNumber: DWORD;
    dwPlatformId: DWORD;
    szCSDVersion: array[0..127] of WideChar;
  end;

  _OSVERSIONINFO = _OSVERSIONINFOA; // Ansi
  TOSVersionInfoA = _OSVERSIONINFOA; // Ansi
  TOSVersionInfoW = _OSVERSIONINFOW; // Wide
  TOSVersionInfo = TOSVersionInfoA; // Ansi
  OSVERSIONINFOA = _OSVERSIONINFOA; // Ansi
  OSVERSIONINFOW = _OSVERSIONINFOW; // Wide
  OSVERSIONINFO = OSVERSIONINFOA; // Ansi

const
  VER_PLATFORM_WIN32s = 0;
  VER_PLATFORM_WIN32_WINDOWS = 1;
  VER_PLATFORM_WIN32_NT = 2;
  { This is not tested }
  VER_PLATFORM_WIN32_CE = 3;

{
*************************************
From MS Win32 Programmer's Reference:
*************************************

The GetVersionEx function obtains extended information about the version of
the operating system that is currently running.

BOOL GetVersionEx(
    LPOSVERSIONINFO lpVersionInformation 	// pointer to version information structure
   );

Parameters

lpVersionInformation

Pointer to an OSVERSIONINFO data structure that the function fills with
operating system version information. Before calling the GetVersionEx
function, set the dwOSVersionInfoSize member of the OSVERSIONINFO
data structure to sizeof(OSVERSIONINFO).

Return Values

If the function succeeds, the return value is nonzero.
If the function fails, the return value is zero.
To get extended error information, call GetLastError.
The function fails if you specify an invalid value for the
dwOSVersionInfoSize member of the OSVERSIONINFO structure.

Remarks

The GetVersionEx function supersedes the GetVersion function and is the
preferred method for obtaining operating system version number information.
New applications should use the GetVersionEx function rather than the
GetVersion function.

}

// import it from Kernel32.dll
function GetVersionEx(lpVersionInformation: Pointer): BOOL; stdcall; external 'Kernel32' name 'GetVersionExA';

// this is helper procedure. do not use this.
procedure __GetWindowsVersion(var Major: Integer; var Minor: Integer; var Build: Integer; var CSDVersion: PChar);
var
 lpOS, lpOS2: POsVersionInfo;
begin
 try
  GetMem(lpOS, SizeOf(TOsVersionInfo));
  lpOS^.dwOSVersionInfoSize := SizeOf(TOsVersionInfo);
  while GetVersionEx(lpOS) = False do
   begin
    GetMem(lpOS2, lpOS^.dwOSVersionInfoSize + 1);
    lpOS2^.dwOSVersionInfoSize := lpOS^.dwOSVersionInfoSize + 1;
    FreeMem(lpOS, lpOS^.dwOSVersionInfoSize);
    lpOS := lpOS2;
   end;
  Major := Integer(lpOs^.dwMajorVersion);
  Minor := Integer(lpOs^.dwMinorVersion);
  Build := Integer(lpOs^.dwBuildNumber);
  CSDVersion := (lpOs^.szCSDVersion);
  FreeMem(lpOs, lpOs^.dwOSVersionInfoSize);
 except on E: Exception do
  begin
   raise E.Create(SysErrorMessage(GetLastError));
  end;
 end;
end;

// --- Exports from this Dll --- //
function GetWindowsPlatformID: Integer; stdcall;
begin
 try
  Result := Integer(SysUtils.Win32Platform);
 except on E: Exception do
 begin
  E.Create(SysErrorMessage(GetLastError));
 end;
end;
end;

function GetWindowsMajorVersion: Integer; stdcall;
begin
 try
  Result := Integer(Major);
 except on E: Exception do
 begin
  E.Create(SysErrorMessage(GetLastError));
 end;
end;
end;

function GetWindowsMinorVersion: Integer; stdcall;
begin
 try
  Result := Integer(Minor);
 except on E: Exception do
 begin
  E.Create(SysErrorMessage(GetLastError));
 end;
end;
end;

function GetWindowsBuildVersion: Integer; stdcall;
begin
 try
  Result := Integer(Build and $FFFF); // must use $FFFF otherwise you get invalid results
 except on E: Exception do
 begin
  E.Create(SysErrorMessage(GetLastError));
 end;
end;
end;

function GetWindowsCSDVersion: PChar; stdcall;
begin
 try
  Result := PChar(Trim(CSDVersion));
 except on E: Exception do
 begin
  E.Create(SysErrorMessage(GetLastError));
 end;
end;
end;

function GetWindowsFullName: PChar; stdcall;
begin
 Result := PChar('');
 try
 if GetWindowsPlatformID = 0 then
  begin
   if (GetWindowsMajorVersion = 1) then
    Result := 'Microsoft Windows 1' else
   if (GetWindowsMajorVersion = 2) then
    Result := 'Microsoft Windows 2' else
   if (GetWindowsMajorVersion = 3) then
    Result := 'Microsoft Windows 3' else
   Result := PChar(Format('Microsoft Windows 32s %d.%d.%d', [GetWindowsMajorVersion, GetWindowsMinorVersion, GetWindowsBuildVersion]));
  end
 else
 if GetWindowsPlatformID = 1 then
  begin
   if (GetWindowsMajorVersion = 4) and (GetWindowsMinorVersion <= 10) and (GetWindowsBuildVersion = 950) and (GetWindowsBuildVersion <= 1080) then
    Result := PChar('Microsoft Windows 95') else
   if (GetWindowsMajorVersion = 4) and (GetWindowsMinorVersion = 10) and (GetWindowsBuildVersion >= 1998) and (GetWindowsBuildVersion < 2183) then
    Result := PChar('Microsoft Windows 98') else
   if (GetWindowsMajorVersion = 4) and (GetWindowsMinorVersion = 10) and (GetWindowsBuildVersion >= 2183) then
    Result := PChar('Microsoft Windows Second Edition') else
   if (GetWindowsMajorVersion = 4) and (GetWindowsMinorVersion = 90) and (GetWindowsBuildVersion = 3000) then
    Result := PChar('Microsoft Windows Millennium Edition') else
     Result := PChar(Format('Microsoft Windows 32bit %d.%d.%d', [GetWindowsMajorVersion, GetWindowsMinorVersion, GetWindowsBuildVersion]));
  end
 else
 if GetWindowsPlatformID = 2 then
  begin
   if (GetWindowsMajorVersion < 5) then
    Result := PChar(Format('Microsoft Windows NT %d.%d', [GetWindowsMajorVersion, GetWindowsMinorVersion])) else
   if (GetWindowsMajorVersion = 5) and (GetWindowsMinorVersion = 0) then
    Result := PChar('Microsoft Windows 2000') else
   if (GetWindowsMajorVersion = 5) and (GetWindowsMinorVersion = 1) then
    Result := PChar('Microsoft Windows XP') else
   // not sure.. This Windows is not even released yet!
   // (08.03.2003)
   // => http://www.microsoft.com/windowsserver2003
   if (GetWindowsMajorVersion = 5) and (GetWindowsMinorVersion = 2) then
    Result := PChar('Microsoft Windows Server 2003') else
     Result := PChar(Format('Microsoft Windows NT %d.%d.%d', [GetWindowsMajorVersion, GetWindowsMinorVersion, GetWindowsBuildVersion]));
  end
 else
 if GetWindowsPlatformID = 3 then
  begin
   Result := PChar(Format('Microsoft Windows CE %d.%d.%d', [GetWindowsMajorVersion, GetWindowsMinorVersion, GetWindowsBuildVersion]));
  end
 else
 begin
  Result := PChar('Unknown Operating System');
 end;
 except on E: Exception do
 begin
  E.Create(SysErrorMessage(GetLastError));
 end;
end;
end;

function GetWindowsUptime: PChar; stdcall;
const
  ticksperday: Integer    = 1000 * 60 * 60 * 24;
  ticksperhour: Integer   = 1000 * 60 * 60;
  ticksperminute: Integer = 1000 * 60;
  tickspersecond: Integer = 1000;
var
  t:          Longword;
  d, h, m, s: Integer;
begin
 try
  t := GetTickCount;
  d := t div ticksperday;
  Dec(t, d * ticksperday);
  h := t div ticksperhour;
  Dec(t, h * ticksperhour);
  m := t div ticksperminute;
  Dec(t, m * ticksperminute);
  s := t div tickspersecond;
  Result := PChar(IntToStr(d) + ' days ' +
            IntToStr(h) + ' hours ' + IntToStr(m) +
            ' minutes ' + IntToStr(s) + ' seconds.');
 except on E: Exception do
 begin
  E.Create(SysErrorMessage(GetLastError));
 end;
end;
end;

function GetWindowsUptime_Helper(fromzerotofour: Integer): Integer;
const
  ticksperday: Integer    = 1000 * 60 * 60 * 24;
  ticksperhour: Integer   = 1000 * 60 * 60;
  ticksperminute: Integer = 1000 * 60;
  tickspersecond: Integer = 1000;
var
  t:          Longword;
  d, h, m, s: Integer;
begin
 try
  t := GetTickCount;
  d := t div ticksperday;
  Dec(t, d * ticksperday);
  h := t div ticksperhour;
  Dec(t, h * ticksperhour);
  m := t div ticksperminute;
  Dec(t, m * ticksperminute);
  s := t div tickspersecond;
  case fromzerotofour of
   0: Result := d;
   1: Result := h;
   2: Result := m;
   3: Result := s;
   4: Result := t;
   else
    Result := t;
  end;
 except on E: Exception do
 begin
  E.Create(SysErrorMessage(GetLastError));
 end;
end;
end;

function GetWindowsUptimeInDays: Integer; stdcall;
begin
 Result := GetWindowsUptime_Helper(0);
end;

function GetWindowsUptimeInHours: Integer; stdcall;
begin
 Result := GetWindowsUptime_Helper(1);
end;

function GetWindowsUptimeInMinutes: Integer; stdcall;
begin
 Result := GetWindowsUptime_Helper(2);
end;

function GetWindowsUptimeInSeconds: Integer; stdcall;
begin
 Result := GetWindowsUptime_Helper(3);
end;

procedure LibraryProc(Reason: Integer);
begin
 try
  __GetWindowsVersion(Major, Minor, Build, CSDVersion);
 except on E: Exception do
 begin
  E.Create(SysErrorMessage(GetLastError));
 end;
end;
end;

exports
 GetWindowsPlatformID index 1,
 GetWindowsMajorVersion index 2,
 GetWindowsMinorVersion index 3,
 GetWindowsBuildVersion index 4,
 GetWindowsCSDVersion index 5,
 GetWindowsFullName index 6,
 GetWindowsUptime index 7,
 GetWindowsUptimeInDays index 8,
 GetWindowsUptimeInHours index 9,
 GetWindowsUptimeInMinutes index 10,
 GetWindowsUptimeInSeconds index 11;

begin
 __GetWindowsVersion(Major, Minor, Build, CSDVersion);
 DllProc := @LibraryProc;
 __GetWindowsVersion(Major, Minor, Build, CSDVersion);
end.
