unit KAFormImageReg;
{$I KACD.pas}
interface
Uses Classes {$IFNDEF D6UP}, DsgnIntf{$ENDIF}
             {$IFDEF D6UP},  DesignIntf, DesignWindows,  DesignEditors{$ENDIF};

Type
TDefaultTableNameEditor = class(TStringProperty)
    Public
      function  GetValue: string; override;
      Procedure Edit;override;
      Function  GetAttributes: TPropertyAttributes; override;
    End;


procedure Register;


implementation
Uses Forms, Dialogs, TypInfo, SysUtils, KAFormImage, KAFormImageEditor;

{ TDefaultTableNameEditor }
procedure TDefaultTableNameEditor.Edit;
Var
 FI : TKAFormImage;
begin
  inherited Edit;
  if (GetComponent(0) is TKAFormImage) Then
     Begin
       FI := TKAFormImage(GetComponent(0));
       Application.CreateForm(TColorEditForm,ColorEditForm);
       FI.Picture := FI.Picture; 
       if ColorEditForm.Execute(FI) Then
          Begin
            FI.ColorArray.Assign(FI.ColorArray);
            Modified;
          End;
       ColorEditForm.Free;
     End;
end;

function TDefaultTableNameEditor.GetAttributes: TPropertyAttributes;
begin
 Result := Inherited GetAttributes + [paDialog];
end;

function TDefaultTableNameEditor.GetValue: string;
begin
 Result := '(Color Editor)';
end;

Procedure Register;
Begin
 RegisterPropertyEditor(TypeInfo(TList), TKAFormImage, 'ColorArray', TDefaultTableNameEditor);
End;


end.

