unit KAFormImageEditor;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Buttons, KAFormImage, ComCtrls;

type
  TColorEditForm = class(TForm)
    ScrollBox1: TScrollBox;
    Image1: TImage;
    Button1: TButton;
    Button2: TButton;
    Panel100: TPanel;
    Panel200: TPanel;
    Label2: TLabel;
    Button3: TButton;
    Panel0: TPanel;
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    Panel4: TPanel;
    Panel5: TPanel;
    Panel6: TPanel;
    Panel7: TPanel;
    Panel8: TPanel;
    Panel9: TPanel;
    Panel10: TPanel;
    Panel11: TPanel;
    Panel12: TPanel;
    Panel13: TPanel;
    Panel14: TPanel;
    Panel15: TPanel;
    Panel16: TPanel;
    Panel17: TPanel;
    Panel18: TPanel;
    Panel19: TPanel;
    Panel20: TPanel;
    Panel21: TPanel;
    Panel22: TPanel;
    Panel23: TPanel;
    Panel24: TPanel;
    Panel25: TPanel;
    Panel26: TPanel;
    Panel27: TPanel;
    Panel28: TPanel;
    Panel29: TPanel;
    Panel30: TPanel;
    Panel31: TPanel;
    Panel32: TPanel;
    Panel33: TPanel;
    Panel34: TPanel;
    Panel35: TPanel;
    Image2: TImage;
    ColorDialog1: TColorDialog;
    TrackBar1: TTrackBar;
    CheckBox1: TCheckBox;
    Panel36: TPanel;
    Panel37: TPanel;
    Panel38: TPanel;
    Panel39: TPanel;
    Panel40: TPanel;
    Panel41: TPanel;
    Panel42: TPanel;
    Panel43: TPanel;
    Panel44: TPanel;
    Panel45: TPanel;
    Panel46: TPanel;
    Panel47: TPanel;
    Panel48: TPanel;
    Panel49: TPanel;
    Panel50: TPanel;
    Panel51: TPanel;
    Panel52: TPanel;
    Panel53: TPanel;
    Panel54: TPanel;
    Panel55: TPanel;
    Panel56: TPanel;
    Panel57: TPanel;
    Panel58: TPanel;
    Panel59: TPanel;
    Panel60: TPanel;
    Panel61: TPanel;
    Panel62: TPanel;
    Panel63: TPanel;
    Panel64: TPanel;
    Panel65: TPanel;
    Panel66: TPanel;
    Panel67: TPanel;
    Panel68: TPanel;
    Panel69: TPanel;
    Panel70: TPanel;
    Panel71: TPanel;
    Panel72: TPanel;
    Panel73: TPanel;
    Panel74: TPanel;
    Panel75: TPanel;
    Panel76: TPanel;
    Panel77: TPanel;
    Panel78: TPanel;
    Panel79: TPanel;
    Panel80: TPanel;
    Panel81: TPanel;
    Panel82: TPanel;
    Panel83: TPanel;
    Panel84: TPanel;
    Panel85: TPanel;
    Panel86: TPanel;
    Panel87: TPanel;
    Panel88: TPanel;
    Panel89: TPanel;
    Panel90: TPanel;
    Panel91: TPanel;
    Panel92: TPanel;
    Panel93: TPanel;
    Panel94: TPanel;
    Panel95: TPanel;
    Edit1: TEdit;
    Button4: TButton;
    Label1: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormKeyUp(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure Image1MouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure Image1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Image1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure Button1Click(Sender: TObject);
    procedure Panel100DblClick(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure TrackBar1Change(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);

  private
    { Private declarations }
    CCanvas  : TControlCanvas;
    Scale    : Integer;
    OW       : Integer;
    OH       : Integer;
    LX       : Integer;
    LY       : Integer;
    LastDown : TPoint;
    Panels   : Array[0..95] of TPanel;
    NumColors: Integer;

    Procedure ZoomIn(X,Y:Integer);
    Procedure ZoomOut(X,Y:Integer);
    Function  IsInvisible(Clr:TColor):Boolean;
    Procedure Refill;
  public
    { Public declarations }
    Function Execute(Var FI : TKAFormImage):Boolean;
  end;

var
  ColorEditForm: TColorEditForm;

implementation
{$R *.dfm}
{$R KAFIRC.RES}
{ TColorEditForm }
Const
 crPipeta_P = 1;
 crPipeta_M = 2;
 crLupa_P   = 3;
 crLupa_M   = 4;
 crHand     = 5;

function TColorEditForm.Execute(var FI: TKAFormImage): Boolean;
Var
 X : Integer;
begin
 Result                     := False;
 Panels[0]  := Panel0;
 Panels[1]  := Panel1;
 Panels[2]  := Panel2;
 Panels[3]  := Panel3;
 Panels[4]  := Panel4;
 Panels[5]  := Panel5;
 Panels[6]  := Panel6;
 Panels[7]  := Panel7;
 Panels[8]  := Panel8;
 Panels[9]  := Panel9;
 Panels[10] := Panel10;
 Panels[11] := Panel11;
 Panels[12] := Panel12;
 Panels[13] := Panel13;
 Panels[14] := Panel14;
 Panels[15] := Panel15;
 Panels[16] := Panel16;
 Panels[17] := Panel17;
 Panels[18] := Panel18;
 Panels[19] := Panel19;
 Panels[20] := Panel20;
 Panels[21] := Panel21;
 Panels[22] := Panel22;
 Panels[23] := Panel23;
 Panels[24] := Panel24;
 Panels[25] := Panel25;
 Panels[26] := Panel26;
 Panels[27] := Panel27;
 Panels[28] := Panel28;
 Panels[29] := Panel29;
 Panels[30] := Panel30;
 Panels[31] := Panel31;
 Panels[32] := Panel32;
 Panels[33] := Panel33;
 Panels[34] := Panel34;
 Panels[35] := Panel35;
 Panels[36] := Panel36;
 Panels[37] := Panel37;
 Panels[38] := Panel38;
 Panels[39] := Panel39;
 Panels[40] := Panel40;
 Panels[41] := Panel41;
 Panels[42] := Panel42;
 Panels[43] := Panel43;
 Panels[44] := Panel44;
 Panels[45] := Panel45;
 Panels[46] := Panel46;
 Panels[47] := Panel47;
 Panels[48] := Panel48;
 Panels[49] := Panel49;
 Panels[50] := Panel50;
 Panels[51] := Panel51;
 Panels[52] := Panel52;
 Panels[53] := Panel53;
 Panels[54] := Panel54;
 Panels[55] := Panel55;
 Panels[56] := Panel56;
 Panels[57] := Panel57;
 Panels[58] := Panel58;
 Panels[59] := Panel59;
 Panels[60] := Panel60;
 Panels[61] := Panel61;
 Panels[62] := Panel62;
 Panels[63] := Panel63;
 Panels[64] := Panel64;
 Panels[65] := Panel65;
 Panels[66] := Panel66;
 Panels[67] := Panel67;
 Panels[68] := Panel68;
 Panels[69] := Panel69;
 Panels[70] := Panel70;
 Panels[71] := Panel71;
 Panels[72] := Panel72;
 Panels[73] := Panel73;
 Panels[74] := Panel74;
 Panels[75] := Panel75;
 Panels[76] := Panel76;
 Panels[77] := Panel77;
 Panels[78] := Panel78;
 Panels[79] := Panel79;
 Panels[80] := Panel80;
 Panels[81] := Panel81;
 Panels[82] := Panel82;
 Panels[83] := Panel83;
 Panels[84] := Panel84;
 Panels[85] := Panel85;
 Panels[86] := Panel86;
 Panels[87] := Panel87;
 Panels[88] := Panel88;
 Panels[89] := Panel89;
 Panels[90] := Panel90;
 Panels[91] := Panel91;
 Panels[92] := Panel92;
 Panels[93] := Panel93;
 Panels[94] := Panel94;
 Panels[95] := Panel95;
 Screen.Cursors[crPipeta_P] := LoadCursor(HInstance, 'PIPETAP');
 Screen.Cursors[crPipeta_M] := LoadCursor(HInstance, 'PIPETAM');
 Screen.Cursors[crLupa_P]   := LoadCursor(HInstance, 'LUPAP');
 Screen.Cursors[crLupa_M]   := LoadCursor(HInstance, 'LUPAM');
 Screen.Cursors[crHand]     := LoadCursor(HInstance, 'HAND');
 Image1.Cursor              := crPipeta_P;
 Image1.AutoSize            := True;

 Image1.Picture.Bitmap.PixelFormat := pf24bit;
 Image2.Picture.Bitmap.PixelFormat := pf24bit;
 Image1.Picture.Bitmap.Assign(FI.BmpRepresentation);
 Image2.Picture.Bitmap.Assign(FI.BmpRepresentation);
 Image1.AutoSize            := False;
 OW                         := Image1.Width;
 OH                         := Image1.Height;
 TrackBar1.Position         := FI.ColorSimilarity;
 CheckBox1.Checked          := NOT (FI.ColorMatching=ExactColorArray);
 Edit1.Text                 := IntToStr(TrackBar1.Position);
 TrackBar1.Enabled          := CheckBox1.Checked;
 Button4.Enabled            := CheckBox1.Checked;
 For X := 0 To FI.ColorArray.Count-1 do
     Panels[X].Color := TColor(FI.ColorArray.Items[X]);
 NumColors                  := FI.ColorArray.Count;
 CCanvas                    := TControlCanvas.Create;
 Try
  CCanvas.Control                := Image1;
  ScrollBox1.HorzScrollBar.Range := Image1.Width;
  ScrollBox1.VertScrollBar.Range := Image1.Height;
  Scale := 1;
  if NumColors > 0 Then ReFill;
  ShowModal;
  if ModalResult=mrOK Then
     Begin
       if NumColors < 2 Then
          Begin
            FI.ColorArray.Clear;
            if CheckBox1.Checked Then
               FI.ColorMatching := Similar
            Else
               FI.ColorMatching := Exact;
            if NumColors=1 Then FI.Color := Panels[0].Color;
          End
       Else
          Begin
            FI.ColorArray.Clear;
            if CheckBox1.Checked Then
               FI.ColorMatching := SimilarColorArray
            Else
               FI.ColorMatching := ExactColorArray;
            For X := 0 To NumColors-1 do
              Begin
                FI.ColorArray.Add(Pointer(Panels[X].Color));
              End;
           End;
       FI.ColorSimilarity  := StrToInt(Edit1.Text);
     End;
 Finally
  CCanvas.Free;
 End;
end;

procedure TColorEditForm.ZoomIn(X, Y: Integer);
Var
  VS : Real;
  HS : Real;
begin
 HS := X/Scale;
 VS := Y/Scale;
 Inc(Scale);
 ScrollBox1.HorzScrollBar.Position := 0;
 ScrollBox1.VertScrollBar.Position := 0;
 Image1.Width  := OW*Scale;
 Image1.Height := OH*Scale;
 ScrollBox1.HorzScrollBar.Range := Image1.Width;
 ScrollBox1.VertScrollBar.Range := Image1.Height;
 ScrollBox1.HorzScrollBar.Position := (Round(HS)*Scale)-(ScrollBox1.ClientWidth Div 2);
 ScrollBox1.VertScrollBar.Position := (Round(VS)*Scale)-(ScrollBox1.ClientHeight Div 2);
end;

procedure TColorEditForm.ZoomOut(X, Y: Integer);
Var
  VS : Real;
  HS : Real;
begin
 if (Scale) > 1 Then
    Begin
      HS := X/Scale;
      VS := Y/Scale;
      Dec(Scale);
      ScrollBox1.HorzScrollBar.Position := 0;
      ScrollBox1.VertScrollBar.Position := 0;
      Image1.Width  := OW*Scale;
      Image1.Height := OH*Scale;
      ScrollBox1.HorzScrollBar.Range := Image1.Width;
      ScrollBox1.VertScrollBar.Range := Image1.Height;
      ScrollBox1.HorzScrollBar.Position := (Round(HS)*Scale)-(ScrollBox1.ClientWidth Div 2);
      ScrollBox1.VertScrollBar.Position := (Round(VS)*Scale)-(ScrollBox1.ClientHeight Div 2);
    End;
end;

procedure TColorEditForm.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
Var
  PT     : TPoint;
begin
 if (ssShift in Shift) Then
    Begin
      if Image1.Cursor <> crLupa_P Then Image1.Cursor := crLupa_P;
      GetCursorPos(PT);
      SetCursorPos(PT.X, PT.Y);
    End;
 if (ssCtrl in Shift) Then
    Begin
      if Image1.Cursor <> crLupa_M Then Image1.Cursor := crLupa_M;
      GetCursorPos(PT);
      SetCursorPos(PT.X, PT.Y);
    End;
 if (ssAlt in Shift) Then
    Begin
      if Image1.Cursor <> crHand Then Image1.Cursor := crHand;
      GetCursorPos(PT);
      SetCursorPos(PT.X, PT.Y);
    End;
end;

procedure TColorEditForm.FormKeyUp(Sender: TObject; var Key: Word;
  Shift: TShiftState);
Var
  PT     : TPoint;
begin
  Image1.Cursor := crPipeta_P;
  GetCursorPos(PT);
  SetCursorPos(PT.X, PT.Y);
end;

procedure TColorEditForm.Image1MouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
Var
  PT    : TPoint;
begin
  LX := X;
  LY := Y;
  //**************************************************************** Drag System
  if  (ssLeft in Shift)
  And (LastDown.X >= 0)
  And (Image1.Cursor = crHand) Then
      Begin
       GetCursorPos(PT);
       Scrollbox1.VertScrollBar.Position :=
       Scrollbox1.VertScrollBar.Position + LastDown.Y - PT.Y;
       Scrollbox1.HorzScrollBar.Position :=
       Scrollbox1.HorzScrollBar.Position + LastDown.X - PT.X;
       LastDown := PT;
      End
  Else
  //********************************************************** Color Info System
  If (Image1.Cursor = crPipeta_P) Then
      Begin
        Panel200.Color :=  CCanvas.Pixels[X,Y];
        Panel200.Caption :=  '$'+IntToHex(Panel200.Color,6);
      End;
end;

function TColorEditForm.IsInvisible(Clr: TColor): Boolean;
Var
 X      : Integer;
 IPixR  : Byte;
 IPixG  : Byte;
 IPixB  : Byte;

 CPixR  : Byte;
 CPixG  : Byte;
 CPixB  : Byte;
 Color  : TColor;
 Sim    : Integer;
begin
 Result := False;
 if Clr = Panel100.Color Then Exit;
 Result := True;
 if CheckBox1.Checked Then
    Begin
      IPixR       := GetRValue(Clr);
      IPixG       := GetGValue(Clr);
      IPixB       := GetBValue(Clr);
      Sim         := StrToInt(Edit1.Text);
      For X := 0 To NumColors-1 do
          Begin
            Color := Panels[X].Color;
            CPixR  := GetRValue(Color);
            CPixG  := GetGValue(Color);
            CPixB  := GetBValue(Color);
            Result :=     (Abs(CPixR-IPixR) <= Sim)
                      And (Abs(CPixG-IPixG) <= Sim)
                      And (Abs(CPixB-IPixB) <= Sim);
            if Result Then Exit;
          End;
    End
 Else
    Begin
      For X := 0 To NumColors-1 do
        Begin
          if Panels[X].Color=Clr Then Exit;
        End;
    End;
 Result := False;
end;

procedure TColorEditForm.Refill;
Var
 X,Y : Integer;
 Clr : TColorRef;
begin
 For Y := 0 To Image2.Picture.Height-1 do
     Begin
       For X := 0 To Image2.Picture.Width-1 do
           Begin
             Clr := Image2.Canvas.Pixels[X,Y];
             if IsInvisible(Clr) Then Image1.Canvas.Pixels[X,Y] := Panel100.Color;
           End;
      End;
end;

procedure TColorEditForm.Image1Click(Sender: TObject);
Var
 X : Integer;
begin
 if (Image1.Cursor=crLupa_P) Then ZoomIn(LX,LY)
 Else
 if (Image1.Cursor=crLupa_M) Then ZoomOut(LX,LY)
 Else
 If (Image1.Cursor = crPipeta_P) Then
    Begin
     if NumColors < 95 Then
        Begin
          For X := 0 To NumColors-1 do
            Begin
              if Panels[X].Color=Panel200.Color Then Exit;
            End;
          Panels[NumColors].Color := Panel200.Color;
          Inc(NumColors);
          Refill;
        End;
    End;
end;

procedure TColorEditForm.Button2Click(Sender: TObject);
begin
//
end;

procedure TColorEditForm.Image1MouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  GetCursorPos(LastDown);
end;

procedure TColorEditForm.Button1Click(Sender: TObject);
Var
 X : Integer;
begin
 For X := 0 To NumColors-1 do Panels[X].Color := clBtnFace;
 NumColors := 0;
 Image1.Picture.Assign(Image2.Picture);
end;

procedure TColorEditForm.Panel100DblClick(Sender: TObject);
begin
 ColorDialog1.Color := Panel100.Color;
 if ColorDialog1.Execute Then
    Begin
      Panel100.Color := ColorDialog1.Color;
      Refill;
    End;
end;

procedure TColorEditForm.CheckBox1Click(Sender: TObject);
begin
 TrackBar1.Enabled := CheckBox1.Checked;
 Button4.Enabled   := CheckBox1.Checked;
 Image1.Picture.Assign(Image2.Picture);
 Refill;
end;

procedure TColorEditForm.TrackBar1Change(Sender: TObject);
begin
  Edit1.Text := IntToStr(TrackBar1.Position);
end;

procedure TColorEditForm.Button4Click(Sender: TObject);
begin
 Image1.Picture.Assign(Image2.Picture);
 Refill;
end;

procedure TColorEditForm.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if Key=#26 Then
     Begin
       Key := #0;
       if NumColors > 0 Then
          Begin
            Image1.Picture.Assign(Image2.Picture);
            Dec(NumColors);
            Panels[NumColors].Color := clBtnFace;
            Refill;
          End;
     End;
end;

end.
