unit FloatPanel;

interface

uses
  Windows, Messages, SysUtils, Classes, Forms, Controls, ExtCtrls, Graphics, Dialogs;

type
  TFloatPanel = class(TPanel)
  private
    { Private declarations }
    F_OnClose    : TNotifyEvent;
    F_OnMove     : TNotifyEvent;
    F_OnSize     : TNotifyEvent;
    F_Rolled     : Boolean;
    F_Height     : Integer;
    F_Sizeable   : Boolean;
    F_CanRoll    : Boolean;
  protected
    { Protected declarations }
    procedure F_Set_Rolled(Value : Boolean);
    Procedure F_Set_Sizeable(Value:Boolean);
    procedure CreateParams(var Params: TCreateParams); override;
    procedure CreateWnd; override;
    procedure Paint; override;
    procedure DblClick; override;
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); Override;
    procedure WMNCLBUTTONDBLCLKHandler(var Message: TMessage); message WM_NCLBUTTONDBLCLK;
    procedure WMCLOSEHandler(var Message: TMessage); message WM_CLOSE;
    procedure WMMOVEHandler(var Message: TMessage); message WM_MOVE;
    procedure WMSIZEHandler(var Message: TMessage); message WM_SIZE;
    procedure Loaded; override;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor  Destroy;override;
    procedure   RollUp;
    procedure   RollDown;
  published
    { Published declarations }
    property CanRoll  : Boolean      Read F_CanRoll   Write F_CanRoll;
    property Rolled   : Boolean      Read F_Rolled    Write F_Set_Rolled;
    property Sizeable : Boolean      Read F_Sizeable  Write F_Set_Sizeable;
    property OnClose  : TNotifyEvent Read F_OnClose   Write F_OnClose;
    property OnMove   : TNotifyEvent Read F_OnMove    Write F_OnMove;
    property OnSize   : TNotifyEvent Read F_OnMove    Write F_OnSize;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('KA', [TFloatPanel]);
end;

{ TFloatPanel }

constructor TFloatPanel.Create(AOwner: TComponent);
begin
  inherited;
  ControlStyle := ControlStyle + [csAcceptsControls, csOpaque];
  F_OnClose    := Nil;
  F_OnMove     := Nil;
  F_OnSize     := Nil;
  Height       := Width;
  BorderStyle  := bsNone;
  BevelInner   := bvNone;
  BevelOuter   := bvLowered;
  F_Rolled     := False;
  F_Sizeable   := True;
  F_CanRoll    := True;
  F_Height     := Height;
  TabStop      := True;
end;

procedure TFloatPanel.CreateParams(var Params: TCreateParams);
begin
  inherited;
  Params.Style   := Params.Style   Or WS_SYSMENU OR WS_SIZEBOX;
  Params.ExStyle := Params.ExStyle Or WS_EX_TOOLWINDOW;
end;


procedure TFloatPanel.Paint;
const
  Alignments: array[TAlignment] of Longint = (DT_LEFT, DT_RIGHT, DT_CENTER);
var
  Rect: TRect;
  TopColor, BottomColor: TColor;

  procedure AdjustColors(Bevel: TPanelBevel);
  begin
    TopColor := clBtnHighlight;
    if Bevel = bvLowered then TopColor := clBtnShadow;
    BottomColor := clBtnShadow;
    if Bevel = bvLowered then BottomColor := clBtnHighlight;
  end;

begin
  Rect := GetClientRect;
  if BevelOuter <> bvNone then
  begin
    AdjustColors(BevelOuter);
    Frame3D(Canvas, Rect, TopColor, BottomColor, BevelWidth);
  end;
  Frame3D(Canvas, Rect, Color, Color, BorderWidth);
  if BevelInner <> bvNone then
  begin
    AdjustColors(BevelInner);
    Frame3D(Canvas, Rect, TopColor, BottomColor, BevelWidth);
  end;
  with Canvas do
  begin
    Brush.Color := Color;
    FillRect(Rect);
  end;
end;

procedure TFloatPanel.CreateWnd;
begin
  inherited;
  CallWindowProc(DefWndProc, Handle, WM_SETFOCUS, 0, 0);
end;

destructor TFloatPanel.Destroy;
begin

  inherited;
end;


Procedure TFloatPanel.F_Set_Sizeable(Value:Boolean);
Var
 Style : LongInt;
Begin
 if F_Sizeable = Value Then Exit;
 F_Sizeable := Value;
 Style := GetWindowLong(Handle,GWL_STYLE);
 if F_Sizeable Then
    Style := Style + WS_SIZEBOX
 Else
    Style := Style - WS_SIZEBOX;
 SetWindowLong(Handle,GWL_STYLE,Style);
End;

procedure TFloatPanel.F_Set_Rolled(Value: Boolean);
begin
 //*************************** READ ONLY
end;

procedure TFloatPanel.RollDown;
begin
 if Not F_CanRoll Then Exit;
 Height := F_Height;
 F_Rolled := False;
end;

procedure TFloatPanel.RollUp;
begin
 if Not F_CanRoll Then Exit;
 F_Height  := Height;
 Height    := GetSystemMetrics(SM_CYCAPTION);
 if NOT F_Sizeable Then Height := Height+GetSystemMetrics(SM_CYFIXEDFRAME);
 F_Rolled  := True;
end;

procedure TFloatPanel.WMNCLBUTTONDBLCLKHandler(var Message: TMessage);
begin
 if Message.WParam=HTCAPTION Then
    if F_Rolled Then RollDown Else RollUp;
end;

procedure TFloatPanel.WMCLOSEHandler(var Message: TMessage);
begin
 if Assigned(F_OnClose) Then F_OnClose(Self);
end;

procedure TFloatPanel.WMMOVEHandler(var Message: TMessage);
begin
 Inherited;
 if Assigned(F_OnMove) Then F_OnMove(Self);
end;

procedure TFloatPanel.WMSIZEHandler(var Message: TMessage);
begin
 Inherited;
 if Assigned(F_OnSize) Then F_OnSize(Self);
end;

procedure TFloatPanel.Loaded;
begin
  inherited Loaded;
end;

procedure TFloatPanel.DblClick;
Begin
  if F_Rolled Then RollDown Else RollUp;
End;

procedure TFloatPanel.MouseDown(Button: TMouseButton; Shift: TShiftState;
  X, Y: Integer);
begin
  inherited MouseDown(Button, Shift, X,Y);
  ReleaseCapture;
  Perform(WM_SysCommand,$F012,0);
end;
end.
