unit FloatCheckListBox;

interface

uses
  Windows, Messages, SysUtils, Classes, Controls, StdCtrls, CheckLst;

type
  TFloatCheckListBox = class(TCheckListBox)
  private
    { Private declarations }
    F_Rolled   : Boolean;
    F_Height   : Integer;
    F_OnClose  : TNotifyEvent;
    F_OnMove   : TNotifyEvent;
    F_OnSize   : TNotifyEvent;
    F_Sizeable : Boolean;
    F_CanRoll  : Boolean;
  protected
    { Protected declarations }
    procedure F_Set_Rolled(Value : Boolean);
    Procedure F_Set_Sizeable(Value:Boolean);
    procedure CreateParams(var Params: TCreateParams); override;
    procedure CreateWnd; override;
    procedure WMNCLBUTTONDBLCLKHandler(var Message: TMessage); message WM_NCLBUTTONDBLCLK;
    procedure WMCLOSEHandler(var Message: TMessage); message WM_CLOSE;
    procedure WMMOVEHandler(var Message: TMessage); message WM_MOVE;
    procedure WMSIZEHandler(var Message: TMessage); message WM_SIZE;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor  Destroy;override;
    procedure   RollUp;
    procedure   RollDown;
  published
    { Published declarations }
    property Caption;
    property CanRoll  : Boolean      Read F_CanRoll   Write F_CanRoll;
    property Rolled   : Boolean      Read F_Rolled    Write F_Set_Rolled;
    property Sizeable : Boolean      Read F_Sizeable  Write F_Set_Sizeable;
    property OnClose  : TNotifyEvent Read F_OnClose   Write F_OnClose;
    property OnMove   : TNotifyEvent Read F_OnMove    Write F_OnMove;
    property OnSize   : TNotifyEvent Read F_OnMove    Write F_OnSize;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('KA', [TFloatCheckListBox]);
end;

{ TFloatCheckListBox }

constructor TFloatCheckListBox.Create(AOwner: TComponent);
begin
  inherited;
  F_OnClose    := Nil;
  F_OnMove     := Nil;
  F_OnSize     := Nil;
  F_Rolled     := False;
  F_Height     := Height;
  F_Sizeable   := True;
  F_CanRoll    := True;
  ControlStyle := ControlStyle + [csAcceptsControls, csOpaque];
end;

procedure TFloatCheckListBox.CreateParams(var Params: TCreateParams);
begin
  inherited;
  Params.Style   := Params.Style   Or WS_SYSMENU  OR WS_CAPTION Or WS_SIZEBOX;
  Params.ExStyle := Params.ExStyle Or WS_EX_TOOLWINDOW;
end;

procedure TFloatCheckListBox.CreateWnd;
begin
  inherited;
  CallWindowProc(DefWndProc, Handle, WM_SETFOCUS, 0, 0);
end;

destructor TFloatCheckListBox.Destroy;
begin

  inherited;
end;

Procedure TFloatCheckListBox.F_Set_Sizeable(Value:Boolean);
Var
 Style : LongInt;
Begin
 if F_Sizeable = Value Then Exit;
 F_Sizeable := Value;
 Style := GetWindowLong(Handle,GWL_STYLE);
 if F_Sizeable Then
    Style := Style + WS_SIZEBOX
 Else
    Style := Style - WS_SIZEBOX;
 SetWindowLong(Handle,GWL_STYLE,Style);
End;

procedure TFloatCheckListBox.F_Set_Rolled(Value: Boolean);
begin
 //*************************** READ ONLY
end;

procedure TFloatCheckListBox.RollDown;
begin
 if Not F_CanRoll Then Exit;
 Height := F_Height;
 F_Rolled := False;
end;

procedure TFloatCheckListBox.RollUp;
begin
 if Not F_CanRoll Then Exit;
 F_Height  := Height;
 Height    := GetSystemMetrics(SM_CYCAPTION);
 if NOT F_Sizeable Then Height := Height+GetSystemMetrics(SM_CYFIXEDFRAME);
 F_Rolled  := True;
end;

procedure TFloatCheckListBox.WMNCLBUTTONDBLCLKHandler(var Message: TMessage);
begin
  if Message.WParam=HTCAPTION Then
     if F_Rolled Then RollDown Else RollUp;
end;

procedure TFloatCheckListBox.WMCLOSEHandler(var Message: TMessage);
begin  
 if Assigned(F_OnClose) Then F_OnClose(Self);
end;

procedure TFloatCheckListBox.WMMOVEHandler(var Message: TMessage);
begin
 Inherited;
 if Assigned(F_OnMove) Then F_OnMove(Self);
end;

procedure TFloatCheckListBox.WMSIZEHandler(var Message: TMessage);
begin
 Inherited;
 if Assigned(F_OnSize) Then F_OnSize(Self);
end;

end.
