unit FloatCaptionPanel;

interface

uses
  Windows, Messages, SysUtils, Classes, Forms, Controls, ExtCtrls, Graphics, Dialogs;

type
  TFloatCaptionPanel = class(TPanel)
  private
    { Private declarations }
    F_OnClose    : TNotifyEvent;
    F_OnMove     : TNotifyEvent;
    F_OnSize     : TNotifyEvent;
    F_Rolled     : Boolean;
    F_Height     : Integer;
    F_Sizeable   : Boolean;
    F_CanRoll    : Boolean;
  protected
    { Protected declarations }
    procedure F_Set_Rolled(Value : Boolean);
    Procedure F_Set_Sizeable(Value:Boolean);
    procedure CreateParams(var Params: TCreateParams); override;
    procedure CreateWnd; override;
    procedure Paint; override;
    procedure MouseDown(Button: TMouseButton; Shift: TShiftState; X, Y: Integer); Override;
    procedure WMNCLBUTTONDBLCLKHandler(var Message: TMessage); message WM_NCLBUTTONDBLCLK;
    procedure WMCLOSEHandler(var Message: TMessage); message WM_CLOSE;
    procedure WMMOVEHandler(var Message: TMessage); message WM_MOVE;
    procedure WMSIZEHandler(var Message: TMessage); message WM_SIZE;
    {
    procedure WMNCCalcSizeHandler(var Message: TWMNCCalcSize); message WM_NCCALCSIZE;
    procedure WMNCPaint(var Message: TMessage); message WM_NCPAINT;
    procedure WMNCHitTest(var Message: TWMNCHitTest); message WM_NCHITTEST;
    }
    procedure Loaded; override;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    destructor  Destroy;override;
    procedure   RollUp;
    procedure   RollDown;
  published
    { Published declarations }
    property CanRoll  : Boolean      Read F_CanRoll   Write F_CanRoll;
    property Rolled   : Boolean      Read F_Rolled    Write F_Set_Rolled;
    property Sizeable : Boolean      Read F_Sizeable  Write F_Set_Sizeable;
    property OnClose  : TNotifyEvent Read F_OnClose   Write F_OnClose;
    property OnMove   : TNotifyEvent Read F_OnMove    Write F_OnMove;
    property OnSize   : TNotifyEvent Read F_OnMove    Write F_OnSize;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('KA', [TFloatCaptionPanel]);
end;

{ TFloatCaptionPanel }

constructor TFloatCaptionPanel.Create(AOwner: TComponent);
begin
  inherited;
  ControlStyle := ControlStyle + [csAcceptsControls, csOpaque];
  F_OnClose    := Nil;
  F_OnMove     := Nil;
  F_OnSize     := Nil;
  Height       := Width;
  BorderStyle  := bsNone;
  BevelInner   := bvNone;
  BevelOuter   := bvLowered;
  F_Rolled     := False;
  F_Sizeable   := True;
  F_CanRoll    := True;
  F_Height     := Height;
  TabStop      := True;
end;

procedure TFloatCaptionPanel.CreateParams(var Params: TCreateParams);
begin
  inherited;
  Params.Style   := Params.Style   Or WS_SYSMENU OR WS_SIZEBOX OR WS_CAPTION;
  Params.ExStyle := Params.ExStyle Or WS_EX_TOOLWINDOW;
end;


procedure TFloatCaptionPanel.Paint;
const
  Alignments: array[TAlignment] of Longint = (DT_LEFT, DT_RIGHT, DT_CENTER);
var
  Rect: TRect;
  TopColor, BottomColor: TColor;

  procedure AdjustColors(Bevel: TPanelBevel);
  begin
    TopColor := clBtnHighlight;
    if Bevel = bvLowered then TopColor := clBtnShadow;
    BottomColor := clBtnShadow;
    if Bevel = bvLowered then BottomColor := clBtnHighlight;
  end;

begin
  Rect := GetClientRect;
  if BevelOuter <> bvNone then
  begin
    AdjustColors(BevelOuter);
    Frame3D(Canvas, Rect, TopColor, BottomColor, BevelWidth);
  end;
  Frame3D(Canvas, Rect, Color, Color, BorderWidth);
  if BevelInner <> bvNone then
  begin
    AdjustColors(BevelInner);
    Frame3D(Canvas, Rect, TopColor, BottomColor, BevelWidth);
  end;
  with Canvas do
  begin
    Brush.Color := Color;
    FillRect(Rect);
  end;
end;

procedure TFloatCaptionPanel.CreateWnd;
begin
  inherited;
  CallWindowProc(DefWndProc, Handle, WM_SETFOCUS, 0, 0);
end;

destructor TFloatCaptionPanel.Destroy;
begin

  inherited;
end;


Procedure TFloatCaptionPanel.F_Set_Sizeable(Value:Boolean);
Var
 Style : LongInt;
Begin
 if F_Sizeable = Value Then Exit;
 F_Sizeable := Value;
 Style := GetWindowLong(Handle,GWL_STYLE);
 if F_Sizeable Then
    Style := Style + WS_SIZEBOX
 Else
    Style := Style - WS_SIZEBOX;
 SetWindowLong(Handle,GWL_STYLE,Style);
End;

procedure TFloatCaptionPanel.F_Set_Rolled(Value: Boolean);
begin
 //*************************** READ ONLY
end;

procedure TFloatCaptionPanel.RollDown;
begin
 if Not F_CanRoll Then Exit;
 Height := F_Height;
 F_Rolled := False;
end;

procedure TFloatCaptionPanel.RollUp;
begin
 if Not F_CanRoll Then Exit;
 F_Height  := Height;
 Height    := GetSystemMetrics(SM_CYCAPTION);
 if NOT F_Sizeable Then Height := Height+GetSystemMetrics(SM_CYFIXEDFRAME);
 F_Rolled  := True;
end;

procedure TFloatCaptionPanel.WMNCLBUTTONDBLCLKHandler(var Message: TMessage);
begin
 if Message.WParam=HTCAPTION Then
    if F_Rolled Then RollDown Else RollUp;
end;

procedure TFloatCaptionPanel.WMCLOSEHandler(var Message: TMessage);
begin
 if Assigned(F_OnClose) Then F_OnClose(Self);
end;

procedure TFloatCaptionPanel.WMMOVEHandler(var Message: TMessage);
begin
 Inherited;
 if Assigned(F_OnMove) Then F_OnMove(Self);
end;

procedure TFloatCaptionPanel.WMSIZEHandler(var Message: TMessage);
begin
 Inherited;
 if Assigned(F_OnSize) Then F_OnSize(Self);
end;

procedure TFloatCaptionPanel.Loaded;
begin
  inherited Loaded;
end;

procedure TFloatCaptionPanel.MouseDown(Button: TMouseButton; Shift: TShiftState;
  X, Y: Integer);
begin
  inherited MouseDown(Button, Shift, X,Y);
end;

{
procedure TFloatCaptionPanel.WMNCCalcSizeHandler(var Message: TWMNCCalcSize);
begin
  Inc(Message.CalcSize_Params^.rgrc[0].Top,GetSystemMetrics(SM_CYCAPTION)-1);
  Inherited;
end;

procedure TFloatCaptionPanel.WMNCPaint(var Message: TMessage);
Var
  DC  : HDC;
  RC  : TRect;
  ES  : Integer;
begin
  DC := GetWindowDC(Handle);
  Try
   Windows.GetClientRect(Handle, RC);
   ES := 0;
   if BevelInner <> bvNone then Inc(ES, BevelWidth);
   if BevelOuter <> bvNone then Inc(ES, BevelWidth);
   RC.Left  := RC.Left+ES+2*GetSystemMetrics(SM_CXBORDER);
   RC.Right := RC.Right+ES+2*GetSystemMetrics(SM_CXBORDER);
   if BorderStyle=bsSingle Then
      Begin
        RC.Right  := RC.Right+2*GetSystemMetrics(SM_CXBORDER);
      End;
   RC.Top   := RC.Top+ES;
   RC.Bottom := RC.Top+GetSystemMetrics(SM_CYCAPTION)+ES+4;
   Windows.FillRect(DC, RC, Brush.Handle);
  Finally
   ReleaseDC(Handle, DC);
  End;
  Inherited;
end;

procedure TFloatCaptionPanel.WMNCHitTest(var Message: TWMNCHitTest);
 Var
  RW : TRect;
begin
  Windows.GetWindowRect(Handle, RW);
  if Message.YPos < RW.Top+GetSystemMetrics(SM_CYCAPTION)-1 Then
     Message.Result := HTCAPTION
  Else
     Inherited;
end;
}

end.
