unit Find;

interface

uses Windows, SysUtils, Classes, Graphics, Forms, Controls, StdCtrls,
     Buttons,Dialogs,ComCtrls,ExtCtrls;

type
  TFFind = class(TForm)
    LField: TLabel;
    OKBtn: TButton;
    CancelBtn: TButton;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    Fw: TRadioButton;
    Bw: TRadioButton;
    CaseBox: TCheckBox;
    WholeBox: TCheckBox;
    Data: TComboBox;
    Origin: TRadioGroup;
    Scope: TRadioGroup;
    procedure OKBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure FormActivate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FFind: TFFind;

implementation

uses Demo,JADbfGrid;

{$R *.DFM}

procedure TFFind.OKBtnClick(Sender: TObject);
var Gasit,i:Integer;
    Find_:Boolean;
    Mode_:TLocateMode;
    Way_:TLocateDirection;
    Scp:TLocateScope;
    Org:TLocateStart;
begin
  if Length(Trim(Data.Text))=0 then begin
     MessageDlg('The search string cannot be blank',mtError,[mbOk],0);
     Exit;
     end;
  Hide;
  Find_:=False;
  for i:=0 to Data.Items.Count-1 do begin
      if Trim(Data.Items.Strings[i])=Trim(Data.Text) then
         Find_:=True;
      end;
  if not Find_ then
     Data.Items.Append(Data.Text);
  Mode_:=janone;
  Way_:=jaforward;
  if CaseBox.Checked then
     Mode_:=jacasesensitive;
  if WholeBox.Checked then
     Mode_:=jawholekey;
  if CaseBox.Checked and WholeBox.Checked then
     Mode_:=jaboth;
  if Fw.Checked then Way_:=jaforward;
  if Bw.Checked then Way_:=jabackward;
  if Scope.ItemIndex=0 then
     Scp:=jaglobal
  else
     Scp:=jafield;
  if Origin.ItemIndex=0 then
     org:=jafromrecord
  else
     org:=jawholerecords;
  Gasit:=Form1.JADbfGrid1.DataSet.Locate(Form1.JADbfGrid1.Cells[Form1.JADbfGrid1.Col,0],Data.Text,Mode_,Way_,Scp,Org);
  if Gasit>0 then begin
     Form1.JADbfGrid1.Row:=Gasit;
     Form1.JADbfGrid2.Row:=Gasit;
//     Row_:=Form1.JADbfGrid1.Row;
//     for i:=1 to Form1.JADbfGrid1.DataSet.ColCount do begin
//         if AnsiPos(UpperCase(Trim(Data.Text)),
//                    UpperCase(MainForm.DataSet.Cells[i,Row_]))<>0 then begin
//            MainForm.DataSet.Col:=i;
//            Break;
//            end;
//         end;
     end
  else MessageDlg('Search string "'+Data.Text+'" not found',mtInformation,[mbOk],0);
  Close;
end;

procedure TFFind.CancelBtnClick(Sender: TObject);
begin
  Close;
end;

procedure TFFind.FormActivate(Sender: TObject);
begin
  Data.SetFocus;
end;

end.

