unit Demo;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Grids, JADbfGrid, StdCtrls, ExtCtrls, ComCtrls, ExtDlgs;

type
  TForm1 = class(TForm)
    JADbfGrid2: TJADbfGrid;
    Memo1: TMemo;
    JADbfGrid1: TJADbfGrid;
    Button1: TButton;
    Panel1: TPanel;
    Image1: TImage;
    Button2: TButton;
    Button3: TButton;
    Button4: TButton;
    Button5: TButton;
    StatusBar1: TStatusBar;
    Button6: TButton;
    Button7: TButton;
    Button8: TButton;
    Button9: TButton;
    OpenPictureDialog1: TOpenPictureDialog;
    OpenDialog1: TOpenDialog;
    SavePictureDialog1: TSavePictureDialog;
    SaveDialog1: TSaveDialog;
    Button10: TButton;
    procedure JADbfGrid2ChangeRecord(Sender: TObject; ACol, ARow: Integer);
    procedure JADbfGrid1ChangeRecord(Sender: TObject; ACol, ARow: Integer);
    procedure JADbfGrid1Delete(Sender: TObject);
    procedure JADbfGrid2Delete(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button4Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
    procedure Button7Click(Sender: TObject);
    procedure Button8Click(Sender: TObject);
    procedure Button9Click(Sender: TObject);
    procedure Button10Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

uses Find;

{$R *.dfm}

procedure TForm1.JADbfGrid2ChangeRecord(Sender: TObject; ACol,
  ARow: Integer);
begin
  JADbfGrid2.Dataset.ReadMemo('graphic');
  Image1.Picture.Assign(JADbfgrid2.Dataset.DataMemo.MemoImage);
  JADbfGrid2.Dataset.ReadMemo('notes');
  Memo1.Lines.Assign(JADbfGrid2.Dataset.DataMemo.MemoLine);
  JADbfGrid1.Row:=ARow;
  JADbfGrid1.Refresh;
  Statusbar1.Panels.Items[0].Text:='Record #'+IntToStr(JADbfGrid2.Row);
end;

procedure TForm1.JADbfGrid1ChangeRecord(Sender: TObject; ACol,
  ARow: Integer);
begin
  JADbfGrid1.Dataset.ReadMemo('graphic');
  Image1.Picture.Assign(JADbfgrid1.Dataset.DataMemo.MemoImage);
  JADbfGrid1.Dataset.ReadMemo('notes');
  Memo1.Lines.Assign(JADbfGrid1.Dataset.DataMemo.MemoLine);
  JADbfGrid2.Refresh;
  JADbfGrid2.Row:=ARow;
  Statusbar1.Panels.Items[0].Text:='Record #'+IntToStr(JADbfGrid1.Row);
end;

procedure TForm1.JADbfGrid1Delete(Sender: TObject);
begin
  JADbfGrid1.Refresh;
end;

procedure TForm1.JADbfGrid2Delete(Sender: TObject);
begin
  JADbfGrid2.Refresh;
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  FFind.ShowModal;
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  JADbfGrid1.Append;
  JADbfGrid2.Refresh;
end;

procedure TForm1.Button3Click(Sender: TObject);
begin
  JADbfGrid1.Delete;
  JADbfGrid2.Refresh;
end;

procedure TForm1.Button4Click(Sender: TObject);
begin
  JADbfGrid1.Insert;
  JADbfGrid2.Refresh;
end;

procedure TForm1.Button5Click(Sender: TObject);
begin
  JADbfGrid1.Pack;
  JADbfGrid2.Refresh;
end;

procedure TForm1.Button6Click(Sender: TObject);
begin
  if OpenPictureDialog1.Execute then begin
     JADbfGrid1.Dataset.SaveMemo(OpenPictureDialog1.FileName,'graphic');
     JADbfGrid2.Dataset.DataMemo.Open:=True;
     JADbfGrid1.Dataset.ReadMemo('graphic');
     Image1.Picture.Assign(JADbfgrid1.Dataset.DataMemo.MemoImage);
     end;
end;

procedure TForm1.Button7Click(Sender: TObject);
begin
  if OpenDialog1.Execute then begin
     JADbfGrid1.Dataset.SaveMemo(OpenDialog1.FileName,'notes');
     JADbfGrid2.Dataset.DataMemo.Open:=True;
     JADbfGrid1.Dataset.ReadMemo('notes');
     Memo1.Lines.Assign(JADbfGrid1.Dataset.DataMemo.MemoLine);
     end;
end;

procedure TForm1.Button8Click(Sender: TObject);
begin
  SavePictureDialog1.FileName:='';
  JADbfGrid1.Dataset.ReadMemo('graphic');
  if JADbfGrid1.Dataset.DataMemo.ImageType='BMP Image' then begin
     SavePictureDialog1.Filter:='(*.bmp)|*.bmp|Bitmaps (*.bmp)|*.bmp';
     SavePictureDialog1.DefaultExt:='bmp';
     end
  else begin
     SavePictureDialog1.Filter:='(*.jpg;*.jpeg)|*.jpg;*.jpeg|JPEG Image File (*.jpg)|*.jpg|JPEG Image File (*.jpeg)|*.jpeg';
     SavePictureDialog1.DefaultExt:='jpg'
     end;
  if SavePictureDialog1.Execute then
     JADbfGrid1.Dataset.DataMemo.MemoImage.SaveToFile(SavePictureDialog1.FileName);
end;

procedure TForm1.Button9Click(Sender: TObject);
begin
  JADbfGrid1.Dataset.ReadMemo('notes');
  SaveDialog1.DefaultExt:='txt';  
  if SaveDialog1.Execute then
     JADbfGrid1.Dataset.DataMemo.MemoLine.SaveToFile(SaveDialog1.FileName);
end;

procedure TForm1.Button10Click(Sender: TObject);
begin
  JADbfGrid1.Active:=False;
  JADbfGrid2.Active:=False;  
  Close;
end;

end.
