unit HHComp;
{This is freeware Delphi 6 unit which allow to use HTMLHelp instead of usual Windows Help
 intercepting onkeydown event. Using this component you can still use HelpContext properties
 of the components but THHComp sends help requests directly to the HTMLHelp API.
 Component should be placed on every form which uses HTMLHelp system.
 Version 2.0
 Copyright (c) 2001 Ainars Skangals 
 http://balder.prohosting.com/ainars/Delphi.shtml
 This component is provided "as is" without warranty of any kind,
 either expressed or implied.
}
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  THHComp = class(TComponent)
  private
    { Private declarations }
    FHelp,
    FHelp1:String;
    fOnOldKeyDown:TKeyEvent;
  protected
    { Protected declarations }
    procedure Loaded; override;
  public
    { Public declarations }
    Function ShowContents:Integer;
    Function ShowIndex:Integer;
    Procedure ShowHelp(Sender: TObject; var Key: Word; Shift: TShiftState);
//    Function ShowHelp(Command: Word; Data: Longint; var CallHelp: Boolean): Boolean;
    Destructor Destroy; override;
  published
    { Published declarations }
    Property HelpFile:String read FHelp write FHelp;
  end;

procedure Register;

implementation
const
  HH_DISPLAY_TOPIC  = $0000;
  HH_DISPLAY_TOC    = $0001;
  HH_DISPLAY_INDEX  = $0002;
  HH_HELP_CONTEXT   = $000F;
  HH_CLOSE_ALL      = $0012;

function HHelp(hwndCaller : HWND; pszFile: PChar; uCommand : Integer;
            dwData : DWORD) : HWND; stdcall; external 'hhctrl.ocx' name 'HtmlHelpA';

function THHComp.ShowContents:Integer;
begin
   Result:=HHelp(Application.Handle,PChar(FHelp1),HH_DISPLAY_TOC,0);
end;

function THHComp.ShowIndex:Integer;
begin
   Result:=HHelp(Application.Handle,PChar(FHelp),HH_DISPLAY_INDEX,0);
end;

Procedure THHComp.ShowHelp(Sender: TObject; var Key: Word; Shift: TShiftState);
var data:longint;
    Control:TControl;
begin
data:=0; Control:=nil;
if (Shift=[])and(Key=VK_F1) then begin
 if (Owner as TForm).Activecontrol.HelpContext<>0 then data:=(Owner as TForm).Activecontrol.HelpContext;
 if data=0 then
  if (Owner as TForm).Activecontrol.Owner is TControl then begin
    Control:=((Owner as TForm).Activecontrol.Owner as TControl);
    if Control.HelpContext<>0 then data:=Control.HelpContext;
    end;
 if (data=0) and ((Owner as TForm).HelpContext<>0) then data:=(Owner as TForm).HelpContext; 
 if FHelp<>'' then
   HHelp(Application.Handle,PChar(FHelp1),HH_HELP_CONTEXT,Data);
 //  CallHelp:=False;
 Key:=0;  
 end;
 if assigned(fOnOldKeyDown) then fOnOldKeyDown(sender,key,shift)
end;

procedure THHComp.Loaded;
begin
Inherited;
// Here the help system is switched to HTMLHelp
//HelpSystem:=
 if assigned((Owner as TForm).onkeydown) then fOnOldKeyDown:=(Owner as TForm).onkeydown;
 (Owner as TForm).OnKeyDown:=ShowHelp;
 (Owner as TForm).KeyPreview:=true;
 FHelp1:=ExtractFilePath(Application.exename)+FHelp;
end;

destructor THHComp.Destroy;
begin
 // Automatically close help window if any
 HHelp(0,PChar(FHelp1),HH_CLOSE_ALL,0);
 inherited;
end;

procedure Register;
begin
  RegisterComponents('Install', [THHComp]);
end;

end.
