unit MiniGL;

{ Tiny OpenGL implementation for Windows & Linux

 Copyright (C) 2001 Paul TOTH <tothpaul@free.fr>
 http://tothpaul.free.fr

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
}
{************************************************************
 Neccesery additions from gl.h,glu.h by Artur Ba 2002
************************************************************}


interface
{$define pure} { use GLU or pure pascal code }

{$ifdef win32}
const
 OpenGL='OpenGL32.DLL';
 GLU='GLU32.DLL';
 GLUT='GLUT32.DLL';
{$else}
uses
 Xlib;
const
 OpenGL='libGL.so'; // please make link to valid LIBName/Version
 GLU='libGLU.so';
 GLUT='libglut.so';
{$endif}
Type
  GLenum     = Cardinal;
  GLboolean  = Byte;
  GLbitfield = Integer;
  GLbyte     = ShortInt;
  GLshort    = SmallInt;
  GLint      = Integer;
  GLubyte    = Byte;
  GLushort   = Word;
  GLuint     = Cardinal;
  GLsizei    = Integer;
  GLfloat    = Single;
  GLclampf   = Single;
  GLdouble   = double;
  GLclampd   = double;

  TGLenum    = GLenum;
  TGLboolean = GLboolean;
  TGLbitfiel = GLbitfield;
  TGLbyte    = GLbyte;
  TGLshort   = GLshort;
  TGLint     = GLint;
  TGLubyte   = GLubyte;
  TGLushort  = GLushort;
  TGLuint    = GLuint;
  TGLsizei   = GLsizei;
  TGLfloat   = GLfloat;
  TGLclampf  = GLclampf;
  TGLdouble  = GLdouble;
  TGLclampd  = GLclampd;

  PGLenum    = ^GLenum;
  PGLboolean = ^GLboolean;
  PGLbitfiel = ^GLbitfield;
  PGLbyte    = ^GLbyte;
  PGLshort   = ^GLshort;
  PGLint     = ^GLint;
  PGLubyte   = ^GLubyte;
  PGLushort  = ^GLushort;
  PGLuint    = ^GLuint;
  PGLsizei   = ^GLsizei;
  PGLfloat   = ^GLfloat;
  PGLclampf  = ^GLclampf;
  PGLdouble  = ^GLdouble;
  PGLclampd  = ^GLclampd;
  PGLVoid    = Pointer;
  PVoid      = Pointer;

Const

{ StringName }
  GL_VENDOR                         =  $1F00;
  {$EXTERNALSYM GL_VENDOR}
  GL_RENDERER                       =  $1F01;
  {$EXTERNALSYM GL_RENDERER}
  GL_VERSION                        =  $1F02;
  {$EXTERNALSYM GL_VERSION}
  GL_EXTENSIONS                     =  $1F03;
  {$EXTERNALSYM GL_EXTENSIONS}
//* Render Mode */
    GL_FEEDBACK	            =$1C01;
    GL_RENDER				=$1C00;
    GL_SELECT				=$1C02;



{$ifdef linux}
type
   GLXContext = integer;

   function glXQueryExtension(dpy:PDisplay;var err,event:integer):boolean; cdecl external OpenGL;
function glXQueryVersion (dpy : PDisplay; var major,minor : integer):boolean; cdecl external OpenGL;

function glXChooseVisual(dpy: PDisplay; screen: Integer;out attribList:array of integer):PXVisualInfo; cdecl external OpenGL;
function glXCreateContext(dpy: PDisplay; vis: PXVisualInfo; shareList:integer; direct: Boolean):integer; cdecl external OpenGL;
Function glXIsDirect (dpy : PDisplay; ctx : GLXContext) : boolean; cdecl external OpenGL;
Procedure glXDestroyContext (dpy : PDisplay; ctx : GLXContext); cdecl external OpenGL;

// Tokens for glXChooseVisual and glXGetConfig:
const
  GLX_USE_GL                            = 1;
  GLX_BUFFER_SIZE                       = 2;
  GLX_LEVEL                             = 3;
  GLX_RGBA                              = 4;
  GLX_DOUBLEBUFFER                      = 5;
  GLX_STEREO                            = 6;
  GLX_AUX_BUFFERS                       = 7;
  GLX_RED_SIZE                          = 8;
  GLX_GREEN_SIZE                        = 9;
  GLX_BLUE_SIZE                         = 10;
  GLX_ALPHA_SIZE                        = 11;
  GLX_DEPTH_SIZE                        = 12;
  GLX_STENCIL_SIZE                      = 13;
  GLX_ACCUM_RED_SIZE                    = 14;
  GLX_ACCUM_GREEN_SIZE                  = 15;
  GLX_ACCUM_BLUE_SIZE                   = 16;
  GLX_ACCUM_ALPHA_SIZE                  = 17;
procedure glXWaitGL; cdecl external OpenGL;
procedure glXWaitX; cdecl external OpenGL;
//Procedure glXUseXFont (Font font, int first, int count, int listBase);
procedure glXMakeCurrent(dpy:PDisplay; glwin:TWindow; cx:integer); cdecl external OpenGL;
procedure glXSwapBuffers(dpy:PDisplay; glwin:TWindow); cdecl external OpenGL;
{$endif}


Function glGetString( name : GLenum ) : PGLubyte;{$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
Function glGetError : GLenum;{$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;

procedure glClear(m:integer);{$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
const // attribute bits
  GL_CURRENT_BIT                             = $00000001;
  GL_POINT_BIT                               = $00000002;
  GL_LINE_BIT                                = $00000004;
  GL_POLYGON_BIT                             = $00000008;
  GL_POLYGON_STIPPLE_BIT                     = $00000010;
  GL_PIXEL_MODE_BIT                          = $00000020;
  GL_LIGHTING_BIT                            = $00000040;
  GL_FOG_BIT                                 = $00000080;
  GL_DEPTH_BUFFER_BIT                        = $00000100;
  GL_ACCUM_BUFFER_BIT                        = $00000200;
  GL_STENCIL_BUFFER_BIT                      = $00000400;
  GL_VIEWPORT_BIT                            = $00000800;
  GL_TRANSFORM_BIT                           = $00001000;
  GL_ENABLE_BIT                              = $00002000;
  GL_COLOR_BUFFER_BIT                        = $00004000;
  GL_HINT_BIT                                = $00008000;
  GL_EVAL_BIT                                = $00010000;
  GL_LIST_BIT                                = $00020000;
  GL_TEXTURE_BIT                             = $00040000;
  GL_SCISSOR_BIT                             = $00080000;
  GL_ALL_ATTRIB_BITS                         = $000FFFFF;
procedure glClearIndex(c:single); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
procedure glClearDepth(d:double); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
procedure glClearColor(red, green, blue, alpha: GLclampf); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;


procedure glEnable(c:integer); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
const
 GL_DEPTH_TEST = $0B71;

procedure glDisable(c:integer); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
const
{ Boolean values}
 GL_FALSE				= $0;
 GL_TRUE				= $1;

{ Data types }
 GL_BYTE				= $1400;
 GL_UNSIGNED_BYTE		= $1401;
 GL_SHORT				= $1402;
 GL_UNSIGNED_SHORT		= $1403;
 GL_INT					= $1404;
 GL_UNSIGNED_INT		= $1405;
 GL_FLOAT				= $1406;
 GL_DOUBLE				= $140A;
 GL_2_BYTES				= $1407;
 GL_3_BYTES				= $1408;
 GL_4_BYTES				= $1409;

// Buffers, Pixel Drawing/Reading
  GL_NONE                               = 0;
  GL_LEFT                               = $0406;
  GL_RIGHT                              = $0407;
  //GL_FRONT                            = $0404;
  //GL_BACK                             = $0405;
  //GL_FRONT_AND_BACK                   = $0408;
  GL_FRONT_LEFT                         = $0400;
  GL_FRONT_RIGHT                        = $0401;
  GL_BACK_LEFT                          = $0402;
  GL_BACK_RIGHT                         = $0403;
  GL_AUX0                               = $0409;
  GL_AUX1                               = $040A;
  GL_AUX2                               = $040B;
  GL_AUX3                               = $040C;
  GL_COLOR_INDEX                        = $1900;
  GL_RED                                = $1903;
  GL_GREEN                              = $1904;
  GL_BLUE                               = $1905;
  GL_ALPHA                              = $1906;
  GL_LUMINANCE                          = $1909;
  GL_LUMINANCE_ALPHA                    = $190A;
  GL_ALPHA_BITS                         = $0D55;
  GL_RED_BITS                           = $0D52;
  GL_GREEN_BITS                         = $0D53;
  GL_BLUE_BITS                          = $0D54;
  GL_INDEX_BITS                         = $0D51;
  GL_SUBPIXEL_BITS                      = $0D50;
  GL_AUX_BUFFERS                        = $0C00;
  GL_READ_BUFFER                        = $0C02;
  GL_DRAW_BUFFER                        = $0C01;
  GL_DOUBLEBUFFER                       = $0C32;
  GL_STEREO                             = $0C33;
  GL_BITMAP                             = $1A00;
  GL_COLOR                              = $1800;
  GL_DEPTH                              = $1801;
  GL_STENCIL                            = $1802;
  GL_DITHER                             = $0BD0;
  GL_RGB                                = $1907;
  GL_RGBA                               = $1908;

procedure glCullFace(c:integer); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
const // Polygons
  GL_POINT                              = $1B00;
  GL_LINE                               = $1B01;
  GL_FILL                               = $1B02;
  GL_CCW                                = $0901;
  GL_CW                                 = $0900;
  GL_FRONT                              = $0404;
  GL_BACK                               = $0405;
  GL_CULL_FACE                          = $0B44;
  GL_CULL_FACE_MODE                     = $0B45;
  GL_POLYGON_SMOOTH                     = $0B41;
  GL_POLYGON_STIPPLE                    = $0B42;
  GL_FRONT_FACE                         = $0B46;
  GL_POLYGON_MODE                       = $0B40;
  GL_POLYGON_OFFSET_FACTOR              = $8038;
  GL_POLYGON_OFFSET_UNITS               = $2A00;
  GL_POLYGON_OFFSET_POINT               = $2A01;
  GL_POLYGON_OFFSET_LINE                = $2A02;
  GL_POLYGON_OFFSET_FILL                = $8037;
procedure glShadeModel(s:integer); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
const // Lighting
  GL_LIGHTING                           = $0B50;
  GL_LIGHT0                             = $4000;
  GL_LIGHT1                             = $4001;
  GL_LIGHT2                             = $4002;
  GL_LIGHT3                             = $4003;
  GL_LIGHT4                             = $4004;
  GL_LIGHT5                             = $4005;
  GL_LIGHT6                             = $4006;
  GL_LIGHT7                             = $4007;
  GL_SPOT_EXPONENT                      = $1205;
  GL_SPOT_CUTOFF                        = $1206;
  GL_CONSTANT_ATTENUATION               = $1207;
  GL_LINEAR_ATTENUATION                 = $1208;
  GL_QUADRATIC_ATTENUATION              = $1209;
  GL_AMBIENT                            = $1200;
  GL_DIFFUSE                            = $1201;
  GL_SPECULAR                           = $1202;
  GL_SHININESS                          = $1601;
  GL_EMISSION                           = $1600;
  GL_POSITION                           = $1203;
  GL_SPOT_DIRECTION                     = $1204;
  GL_AMBIENT_AND_DIFFUSE                = $1602;
  GL_COLOR_INDEXES                      = $1603;
  GL_LIGHT_MODEL_TWO_SIDE               = $0B52;
  GL_LIGHT_MODEL_LOCAL_VIEWER           = $0B51;
  GL_LIGHT_MODEL_AMBIENT                = $0B53;
  GL_FRONT_AND_BACK                     = $0408;
  GL_SHADE_MODEL                        = $0B54;
  GL_FLAT                               = $1D00;
  GL_SMOOTH                             = $1D01;
  GL_COLOR_MATERIAL                     = $0B57;
  GL_COLOR_MATERIAL_FACE                = $0B55;
  GL_COLOR_MATERIAL_PARAMETER           = $0B56;
  GL_NORMALIZE                          = $0BA1;
{ Vertex Arrays }
GL_VERTEX_ARRAY				    = $8074;
GL_NORMAL_ARRAY				    = $8075;
GL_COLOR_ARRAY				    = $8076;
GL_INDEX_ARRAY				    = $8077;
GL_TEXTURE_COORD_ARRAY			= $8078;
GL_EDGE_FLAG_ARRAY			    = $8079;
GL_VERTEX_ARRAY_SIZE			= $807A;
GL_VERTEX_ARRAY_TYPE			= $807B;
GL_VERTEX_ARRAY_STRIDE			= $807C;
GL_NORMAL_ARRAY_TYPE			= $807E;
GL_NORMAL_ARRAY_STRIDE			= $807F;
GL_COLOR_ARRAY_SIZE			    = $8081;
GL_COLOR_ARRAY_TYPE			    = $8082;
GL_COLOR_ARRAY_STRIDE			= $8083;
GL_INDEX_ARRAY_TYPE			    = $8085;
GL_INDEX_ARRAY_STRIDE			= $8086;
GL_TEXTURE_COORD_ARRAY_SIZE		= $8088;
GL_TEXTURE_COORD_ARRAY_TYPE		= $8089;
GL_TEXTURE_COORD_ARRAY_STRIDE	= $808A;
GL_EDGE_FLAG_ARRAY_STRIDE		= $808C;
GL_VERTEX_ARRAY_POINTER			= $808E;
GL_NORMAL_ARRAY_POINTER			= $808F;
GL_COLOR_ARRAY_POINTER			= $8090;
GL_INDEX_ARRAY_POINTER			= $8091;
GL_TEXTURE_COORD_ARRAY_POINTER	= $8092;
GL_EDGE_FLAG_ARRAY_POINTER		= $8093;
GL_V2F					        = $2A20;
GL_V3F					        = $2A21;
GL_C4UB_V2F				        = $2A22;
GL_C4UB_V3F				        = $2A23;
GL_C3F_V3F				        = $2A24;
GL_N3F_V3F				        = $2A25;
GL_C4F_N3F_V3F				    = $2A26;
GL_T2F_V3F				        = $2A27;
GL_T4F_V4F				        = $2A28;
GL_T2F_C4UB_V3F				    = $2A29;
GL_T2F_C3F_V3F				    = $2A2A;
GL_T2F_N3F_V3F				    = $2A2B;
GL_T2F_C4F_N3F_V3F			    = $2A2C;
GL_T4F_C4F_N3F_V4F			    = $2A2D;

procedure glMatrixMode(m:integer); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
const // matrix modes
 GL_MATRIX_MODE = $0BA0;
 GL_MODELVIEW   = $1700;
 GL_PROJECTION  = $1701;
 GL_TEXTURE     = $1702;


{ display lists}
const
  GL_LIST_MODE                               = $0B30;
  GL_LIST_BASE                               = $0B32;
  GL_LIST_INDEX                              = $0B33;
  GL_COMPILE                                 = $1300;
  GL_COMPILE_AND_EXECUTE                     = $1301;

Function glIsList(list : GLuint) : GLboolean;{$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
Procedure glDeleteLists(list :GLuint;range: GLsizei);{$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
function glGenLists(range :  GLsizei) : GLuint; {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
Procedure glNewList( list :GLuint;mode : GLenum);{$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
Procedure glEndList; {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
Procedure glIndexi(i:integer); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
Procedure glCallList(list :  GLuint);{$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
Procedure glCallLists(n :GLsizei;_type: GLenum;const lists:PGLvoid);{$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
Procedure glListBase(base : GLuint);{$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;

procedure glPushMatrix; {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
procedure glRotatef(angle,x,y,z:single); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
procedure glRotated(angle,x,y,z:double); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
procedure glTranslatef(x,y,z:single); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
procedure glTranslated(x,y,z:double); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
procedure glScalef(x,y,z:single); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
procedure glOrtho(left, right, bottom, top, near_val, far_val: Double); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
procedure glPopMatrix; {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
procedure glBegin(mode:integer); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;


const // Primitives
  GL_LINES                              = $0001;
  GL_POINTS                             = $0000;
  GL_LINE_STRIP                         = $0003;
  GL_LINE_LOOP                          = $0002;
  GL_TRIANGLES                          = $0004;
  GL_TRIANGLE_STRIP                     = $0005;
  GL_TRIANGLE_FAN                       = $0006;
  GL_QUADS                              = $0007;
  GL_QUAD_STRIP                         = $0008;
  GL_POLYGON                            = $0009;
  GL_EDGE_FLAG                          = $0B43;

procedure glVertex2d(x:GLdouble ; y:GLdouble ); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
procedure glVertex2f(x:GLfloat; y:GLfloat ); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
procedure glVertex2i(x:GLint; y:GLint ); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
procedure glVertex2s(x:GLshort; y:GLshort ); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;

procedure glVertex3d( x,y,z: GLdouble ); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
procedure glVertex3f( x,y,z: GLfloat ); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
procedure glVertex3i( x,y,z: GLint ); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
procedure glVertex3s( x,y,z: GLshort ); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;

procedure glVertex4d( x,y,z,w : GLdouble  ); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
procedure glVertex4f( x,y,z,w : GLfloat ); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
procedure glVertex4i( x,y,z,w : GLint ); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
procedure glVertex4s( x,y,z,w : GLshort ); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;

procedure glVertex2dv( const v : PGLdouble ); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
procedure glVertex2fv( const v : PGLfloat ); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
procedure glVertex2iv( const v : PGLint ); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
procedure glVertex2sv( const v : PGLshort ); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;

procedure glVertex3dv( const v : PGLdouble ); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
procedure glVertex3fv( const v : PGLfloat ); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
procedure glVertex3iv( const v : PGLint ); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
procedure glVertex3sv( const v : PGLshort); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;

procedure glVertex4dv( const v : PGLdouble ); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
procedure glVertex4fv( const v : PGLfloat ); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
procedure glVertex4iv( const v : PGLint); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
procedure glVertex4sv( const v : PGLshort); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;


procedure glColor3f(r,g,b:single); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
procedure glNormal3f(x,y,z:single); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
procedure glTexCoord2f(u,v:single); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
procedure glEnd; {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;

procedure glViewport(left,top,width,height:integer); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
procedure glLoadIdentity; {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;

procedure glFlush; {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;

procedure glFrustum(xmin,xmax,ymin,ymax,zNear,zFar:double); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
procedure glDepthRange(zNear, zFar: GLclampd); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
Procedure glGetBooleanv(pname : GLenum; params : pboolean ); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
Procedure glGetDoublev(pname : GLenum; params : PGLdouble ); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
Procedure glGetFloatv(pname: GLenum; params  : PGLfloat ); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
Procedure glGetIntegerv(pname: GLenum; params : PGLint); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
Function glRenderMode( mode : GLenum ) : glint; {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;

Const
//* Gets */
GL_ATTRIB_STACK_DEPTH			=   $0BB0;
GL_CLIENT_ATTRIB_STACK_DEPTH	=   $0BB1;
GL_COLOR_CLEAR_VALUE			=   $0C22;
GL_COLOR_WRITEMASK			    =   $0C23;
GL_CURRENT_INDEX			    =   $0B01;
GL_CURRENT_COLOR			    =   $0B00;
GL_CURRENT_NORMAL			    =   $0B02;
GL_CURRENT_RASTER_COLOR			=   $0B04;
GL_CURRENT_RASTER_DISTANCE		=   $0B09;
GL_CURRENT_RASTER_INDEX			=   $0B05;
GL_CURRENT_RASTER_POSITION		=   $0B07;
GL_CURRENT_RASTER_TEXTURE_COORDS=	$0B06;
GL_CURRENT_RASTER_POSITION_VALID=	$0B08;
GL_CURRENT_TEXTURE_COORDS		=   $0B03;
GL_INDEX_CLEAR_VALUE			=   $0C20;
GL_INDEX_MODE				    =   $0C30;
GL_INDEX_WRITEMASK			    =   $0C21;
GL_MODELVIEW_MATRIX			    =   $0BA6;
GL_MODELVIEW_STACK_DEPTH		=   $0BA3;
GL_NAME_STACK_DEPTH			    =   $0D70;
GL_PROJECTION_MATRIX			=   $0BA7;
GL_PROJECTION_STACK_DEPTH		=   $0BA4;
GL_RENDER_MODE				    =   $0C40;
GL_RGBA_MODE				    =   $0C31;
GL_TEXTURE_MATRIX			    =   $0BA8;
GL_TEXTURE_STACK_DEPTH			=   $0BA5;
GL_VIEWPORT				        =   $0BA2;

// Selection and Feedback

Procedure glFeedbackBuffer(size : GLsizei; _type : GLenum; buffer : PGLfloat ); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
Procedure glPassThrough(token : GLfloat); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
Procedure glSelectBuffer(size : GLsizei; buffer : PGLuint ); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
Procedure glInitNames(); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
Procedure glLoadName(name : GLuint); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
Procedure glPushName(name :  GLuint); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
Procedure glPopName(); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;

{30. GL_EXT_vertex_array}
Const
GL_VERTEX_ARRAY_EXT			        =   $8074;
GL_NORMAL_ARRAY_EXT			        =   $8075;
GL_COLOR_ARRAY_EXT			        =   $8076;
GL_INDEX_ARRAY_EXT			        =   $8077;
GL_TEXTURE_COORD_ARRAY_EXT		    =   $8078;
GL_EDGE_FLAG_ARRAY_EXT			    =   $8079;
GL_VERTEX_ARRAY_SIZE_EXT		    =   $807A;
GL_VERTEX_ARRAY_TYPE_EXT		    =   $807B;
GL_VERTEX_ARRAY_STRIDE_EXT		    =   $807C;
GL_VERTEX_ARRAY_COUNT_EXT		    =   $807D;
GL_NORMAL_ARRAY_TYPE_EXT		    =   $807E;
GL_NORMAL_ARRAY_STRIDE_EXT		    =   $807F;
GL_NORMAL_ARRAY_COUNT_EXT		    =   $8080;
GL_COLOR_ARRAY_SIZE_EXT			    =   $8081;
GL_COLOR_ARRAY_TYPE_EXT			    =   $8082;
GL_COLOR_ARRAY_STRIDE_EXT		    =   $8083;
GL_COLOR_ARRAY_COUNT_EXT		    =   $8084;
GL_INDEX_ARRAY_TYPE_EXT			    =   $8085;
GL_INDEX_ARRAY_STRIDE_EXT		    =   $8086;
GL_INDEX_ARRAY_COUNT_EXT		    =   $8087;
GL_TEXTURE_COORD_ARRAY_SIZE_EXT		=   $8088;
GL_TEXTURE_COORD_ARRAY_TYPE_EXT		=   $8089;
GL_TEXTURE_COORD_ARRAY_STRIDE_EXT	=   $808A;
GL_TEXTURE_COORD_ARRAY_COUNT_EXT	=   $808B;
GL_EDGE_FLAG_ARRAY_STRIDE_EXT		=   $808C;
GL_EDGE_FLAG_ARRAY_COUNT_EXT		=   $808D;
GL_VERTEX_ARRAY_POINTER_EXT		    =   $808E;
GL_NORMAL_ARRAY_POINTER_EXT		    =   $808F;
GL_COLOR_ARRAY_POINTER_EXT		    =   $8090;
GL_INDEX_ARRAY_POINTER_EXT		    =   $8091;
GL_TEXTURE_COORD_ARRAY_POINTER_EXT	=   $8092;
GL_EDGE_FLAG_ARRAY_POINTER_EXT		=   $8093;

 Procedure glVertexPointerEXT( size:GLint; _type:GLenum; stride,count:GLsizei; const ptr:PGLvoid );  {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
 Procedure glNormalPointerEXT( _type:GLenum; stride:GLsizei; count:GLsizei; const ptr:PGLvoid );  {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
 Procedure glColorPointerEXT( size:GLint; _type:GLenum; stride:GLsizei; count:GLsizei; const ptr:PGLvoid );  {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
 Procedure glIndexPointerEXT( _type:GLenum; stride:GLsizei; count:GLsizei; const ptr:PGLvoid );  {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
 Procedure glTexCoordPointerEXT( size:GLint; _type:GLenum; stride:GLsizei; count:GLsizei; const ptr:PGLvoid );  {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
 Procedure glEdgeFlagPointerEXT( stride :GLsizei; count:GLsizei; const ptr:PGLboolean );  {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
 Procedure glGetPointervEXT(pname:GLenum ; params : pointer);  {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
 Procedure glArrayElementEXT( i:GLint );  {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
 Procedure glDrawArraysEXT(mode: GLenum;first: GLint;count: GLsizei);  {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;


{1.1} Procedure glEnableClientState(cap : GLenum);  {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
{1.1} Procedure glDisableClientState(cap : GLenum ); {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
{Vertex Arrays  (1.1) }
{1.1} Procedure glVertexPointer( size : GLint; _type :GLenum; stride: GLsizei; const ptr : PGLvoid );  {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
{1.1} Procedure glNormalPointer(_type: GLenum;stride: GLsizei;const ptr :PGLvoid  );  {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
{1.1} Procedure glColorPointer(size: GLint;_type: GLenum;stride:GLsizei; const ptr:PGLvoid );  {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
{1.1} Procedure glIndexPointer(_type: GLenum;stride: GLsizei;const ptr: PGLvoid );  {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
{1.1} Procedure glTexCoordPointer(size: GLint ;_type: GLenum;stride:GLsizei; const ptr:PGLvoid );  {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
{1.1} Procedure glEdgeFlagPointer(stride: GLsizei; const ptr:PGLvoid );  {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
{1.1} Procedure glGetPointerv(pname : GLenum; params:pointer );  {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
{1.1} Procedure glArrayElement(i: GLint);  {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
{1.1} Procedure glDrawArrays(mode: GLenum;first: GLint;count: GLsizei );  {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
{1.1} Procedure glDrawElements(mode: GLenum ;count: GLsizei;_type: GLenum; const indices : PGLvoid );  {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;
{1.1} Procedure glInterleavedArrays(format: GLenum;stride: GLsizei;const pptr: PGLvoid );  {$ifdef win32}stdcall{$else}cdecl{$endif} external OpenGL;













//---GLU---
procedure gluPerspective(fovy, aspect, zNear, zFar: double);
{$ifndef pure}
 {$ifdef win32}stdcall{$else}cdecl{$endif} external GLU;
{$endif}
function gluNewQuadric:integer;
{$ifndef pure}
 {$ifdef win32}stdcall{$else}cdecl{$endif} external GLU;
{$endif}
procedure gluDeleteQuadric(quadric:integer);
{$ifndef pure}
 {$ifdef win32}stdcall{$else}cdecl{$endif} external GLU;
{$endif}
procedure gluQuadricDrawStyle(quadric,style:integer);
{$ifndef pure}
 {$ifdef win32}stdcall{$else}cdecl{$endif} external GLU;
{$endif}
const  // QuadricDrawStyle
  GLU_POINT                                  = 100010;
  GLU_LINE                                   = 100011;
  GLU_FILL                                   = 100012;
  GLU_SILHOUETTE                             = 100013;
procedure gluQuadricNormals(quadric,normals:integer);
{$ifndef pure}
 {$ifdef win32}stdcall{$else}cdecl{$endif} external GLU;
{$endif}
const  // QuadricNormal
  GLU_SMOOTH                                 = 100000;
  GLU_FLAT                                   = 100001;
  GLU_NONE                                   = 100002;
procedure gluSphere(quad:integer; radius:double; slices, stacks:integer);
{$ifndef pure}
 {$ifdef win32}stdcall{$else}cdecl{$endif} external GLU;
{$endif}
procedure gluCylinder(quad:integer; baseRadius,topRadius,height:double; slices, stacks:integer);
{$ifndef pure}
 {$ifdef win32}stdcall{$else}cdecl{$endif} external GLU;
{$endif}
type
    viewport_array = array[0..3] of GLint;


procedure gluPickMatrix (x: GLdouble; y: GLdouble; width: GLdouble; height: GLdouble; const viewport: viewport_array); {$ifdef win32}stdcall{$else}cdecl{$endif} external GLU;














//---GLUT---
procedure glutInit(Var Count:integer;Var Parms:PChar);{$ifdef win32}stdcall{$else}cdecl{$endif} external GLUT;
procedure glutInitWindowPosition(x,y:integer);{$ifdef win32}stdcall{$else}cdecl{$endif} external GLUT;
procedure glutInitWindowSize(Width,Height:integer);{$ifdef win32}stdcall{$else}cdecl{$endif} external GLUT;
procedure glutInitDisplayMode(Mode:integer);{$ifdef win32}stdcall{$else}cdecl{$endif} external GLUT;
const  // Display mode bit masks
  GLUT_RGB                      = 0;
  GLUT_RGBA                     = GLUT_RGB;
  GLUT_INDEX                    = 1;
  GLUT_SINGLE                   = 0;
  GLUT_DOUBLE                   = 2;
  GLUT_ACCUM                    = 4;
  GLUT_ALPHA                    = 8;
  GLUT_DEPTH                    = 16;
  GLUT_STENCIL                  = 32;
  GLUT_MULTISAMPLE              = 128;
  GLUT_STEREO                   = 256;
  GLUT_LUMINANCE                = 512;
procedure glutCreateWindow(Name:Pchar); {$ifdef win32}stdcall{$else}cdecl{$endif} external GLUT;

const // Visibility state
  GLUT_NOT_VISIBLE              = 0;
  GLUT_VISIBLE                  = 1;
type
 glutFunc=procedure; {$ifdef win33}stdcall{$else}cdecl{$endif};
procedure glutIdleFunc(f:glutFunc);{$ifdef win32}stdcall{$else}cdecl{$endif} external GLUT;
procedure glutDisplayFunc(f:glutFunc);{$ifdef win32}stdcall{$else}cdecl{$endif} external GLUT;
procedure glutReshapeFunc(f:glutFunc);{$ifdef win32}stdcall{$else}cdecl{$endif} external GLUT;
procedure glutVisibilityFunc(f:glutFunc);{$ifdef win32}stdcall{$else}cdecl{$endif} external GLUT;
procedure glutKeyboardFunc(f:glutFunc);{$ifdef win32}stdcall{$else}cdecl{$endif} external GLUT;
procedure glutSetColor(Index,R,G,B:single);{$ifdef win32}stdcall{$else}cdecl{$endif} external GLUT;
procedure glutSwapBuffers; {$ifdef win32}stdcall{$else}cdecl{$endif} external GLUT;
procedure glutPostRedisplay; {$ifdef win32}stdcall{$else}cdecl{$endif} external GLUT;
procedure glutMainLoop; {$ifdef win32}stdcall{$else}cdecl{$endif} external GLUT;














implementation

{$ifdef pure}

uses Math;

procedure gluPerspective(fovy, aspect, zNear, zFar: double);
 var
  xmin,xmax,ymin,ymax:double;
 begin
  ymax:=zNear*tan(fovy*PI/360);
  ymin:=-ymax;
  xmin:=ymin*aspect;
  xmax:=ymax*aspect;
  glFrustum(xmin,xmax,ymin,ymax,zNear,zFar);
 end;

(***************************************
truct GLUquadric {
GLenumDrawStyle;/* GLU_FILL, LINE, SILHOUETTE, or POINT */
GLenum Orientation;/* GLU_INSIDE or GLU_OUTSIDE */
GLboolean TextureFlag;/* Generate texture coords? */
GLenum Normals;/* GLU_NONE, GLU_FLAT, or GLU_SMOOTH */
void (GLCALLBACK *ErrorFunc)(GLenum err);/* Error handler callback function */
};
****************************************)
Type
 TQuadric=class
  Style  :integer;
  Normals:integer;
  Texture:boolean;
  Constructor Create(AStyle,ANormals:integer);
 end;

// Call glNormal3f after scaling normal to unit length.
procedure normal3f(x,y,z:single);
 var
  mag:double;
 begin
  mag := sqrt( x*x + y*y + z*z );
  if (mag>0.00001) then begin
   x:=x/mag;
   y:=y/mag;
   z:=z/mag;
  end;
  glNormal3f( x, y, z );
 end;
 
Constructor TQuadric.Create(AStyle,ANormals:integer);
 begin
  Style:=AStyle;
  Normals:=ANormals;
  Texture:=False;
 end;

function gluNewQuadric:integer;
 begin
  TQuadric(Result):=TQuadric.Create(GLU_FILL,GLU_SMOOTH);
 end;

procedure gluDeleteQuadric(quadric:integer);
 begin
  TQuadric(quadric).Free;
 end;

procedure gluQuadricDrawStyle(quadric,style:integer);
 begin
  TQuadric(quadric).Style:=style;
 end;

procedure gluQuadricNormals(quadric,normals:integer);
 begin
  TQuadric(quadric).Normals:=normals;
 end;

procedure gluSphere(quad:integer; radius:double; slices, stacks:integer);
 var
  rho,drho,theta,dtheta:single;
  x,y,z:single;
  s,t,ds,dt:single;
  i,j,imin,imax:integer;
  normals:boolean;
  nsign:single;
 begin
  normals:=TQuadric(quad).Normals<>GLU_NONE;
  nsign := 1.0; // GLU_OUTSIDE...
  drho := PI / stacks;
  dtheta := 2.0 * PI / slices;

  //* texturing: s goes from 0.0/0.25/0.5/0.75/1.0 at +y/+x/-y/-x/+y axis */
  //* t goes from -1.0/+1.0 at z = -radius/+radius (linear along longitudes) */
  //* cannot use triangle fan on texturing (s coord. at top/bottom tip varies) */

  if TQuadric(quad).Style=GLU_FILL then begin
   if not TQuadric(quad).Texture then begin
    //* draw +Z end as a triangle fan */
    glBegin( GL_TRIANGLE_FAN );
    glNormal3f( 0.0, 0.0, 1.0 );
    //--if TQuadric(quad).Texture then glTexCoord2f(0.5,1.0);
    glVertex3f( 0.0, 0.0, nsign * radius );
    for j:=0 to slices do begin
     if j=slices then theta := 0.0 else theta:= j * dtheta;
     x := -sin(theta) * sin(drho);
     y :=  cos(theta) * sin(drho);
     z := nsign * cos(drho);
     if (normals) then glNormal3f( x*nsign, y*nsign, z*nsign );
     glVertex3f( x*radius, y*radius, z*radius );
    end;
    glEnd();
   end; // not texture
   ds := 1.0 / slices;
   dt := 1.0 / stacks;
   t := 1.0;  //* because loop now runs from 0 */
   if TQuadric(quad).Texture then begin
    imin := 0;
    imax := stacks;
   end else begin
    imin := 1;
    imax := stacks-1;
   end;
   //* draw intermediate stacks as quad strips */
   for i:=imin to imax-1 do begin
    rho := i * drho;
    glBegin( GL_QUAD_STRIP );
    s := 0.0;
    for j:=0 to slices do begin
     if j=slices then theta:=0.0 else theta:=j*dtheta;
     x := -sin(theta) * sin(rho);
     y := cos(theta) * sin(rho);
     z := nsign * cos(rho);
     if (normals) then glNormal3f( x*nsign, y*nsign, z*nsign );
     if TQuadric(quad).Texture then glTexCoord2f(s,t);
     glVertex3f( x*radius, y*radius, z*radius );
     x := -sin(theta) * sin(rho+drho);
     y :=  cos(theta) * sin(rho+drho);
     z := nsign * cos(rho+drho);
     if (normals) then glNormal3f( x*nsign, y*nsign, z*nsign );
     if TQuadric(quad).Texture then glTexCoord2f(s,t-dt);
     s :=s + ds;
     glVertex3f( x*radius, y*radius, z*radius );
    end;
    glEnd();
    t := t- dt;
   end;

   if not TQuadric(quad).Texture then begin
  //* draw -Z end as a triangle fan */
    glBegin( GL_TRIANGLE_FAN );
    glNormal3f( 0.0, 0.0, -1.0 );
   //--TXTR_COORD(0.5,0.0);
    glVertex3f( 0.0, 0.0, -radius*nsign );
    rho := PI - drho;
    s := 1.0;
    t := dt;
    for j:=slices downto 0 do begin
     if j=slices then theta := 0.0 else theta := j * dtheta;
     x := -sin(theta) * sin(rho);
     y :=  cos(theta) * sin(rho);
     z := nsign * cos(rho);
     if (normals) then glNormal3f( x*nsign, y*nsign, z*nsign );
    //-TXTR_COORD(s,t);
     s := s- ds;
     glVertex3f( x*radius, y*radius, z*radius );
    end;
    glEnd();
   end;
  // GLU_FILL
  end else
  if (TQuadric(quad).Style=GLU_LINE) or (TQuadric(quad).style=GLU_SILHOUETTE) then begin
   //* draw stack lines */
   for i:=1 to stacks-1  do begin //* stack line at i==stacks-1 was missing here */
    rho := i * drho;
    glBegin( GL_LINE_LOOP );
    for j:=0 to slices-1 do begin
     theta := j * dtheta;
     x := cos(theta) * sin(rho);
     y := sin(theta) * sin(rho);
     z := cos(rho);
     if (normals) then glNormal3f( x*nsign, y*nsign, z*nsign );
     glVertex3f( x*radius, y*radius, z*radius );
    end;
    glEnd();
   end;
   //* draw slice lines */
   for j:=0 to slices-1 do begin
    theta := j * dtheta;
    glBegin( GL_LINE_STRIP );
    for i:=0 to stacks do begin
     rho := i * drho;
     x := cos(theta) * sin(rho);
     y := sin(theta) * sin(rho);
     z := cos(rho);
     if (normals) then glNormal3f( x*nsign, y*nsign, z*nsign );
     glVertex3f( x*radius, y*radius, z*radius );
    end;
    glEnd();
   end
  // GLU_LINE or GLU_SILHOUETTE
  end else
  if TQuadric(quad).Style=GLU_POINT then begin
   //* top and bottom-most points */
   glBegin( GL_POINTS );
   if (normals) then glNormal3f( 0.0, 0.0, nsign );
   glVertex3d( 0.0, 0.0, radius );
   if (normals) then glNormal3f( 0.0, 0.0, -nsign );
   glVertex3d( 0.0, 0.0, -radius );
   //* loop over stacks */
   for i:=1 to stacks-2 do begin
    rho := i * drho;
    for j:=0 to slices-1 do begin
     theta := j * dtheta;
     x := cos(theta) * sin(rho);
     y := sin(theta) * sin(rho);
     z := cos(rho);
     if (normals) then glNormal3f( x*nsign, y*nsign, z*nsign );
     glVertex3f( x*radius, y*radius, z*radius );
    end;
   end;
   glEnd();
  end;
 end;

procedure gluCylinder(quad:integer; baseRadius,topRadius,height:double; slices, stacks:integer);
 var
  da,r,dr,dz:double;
  x,y,z,nz,nsign:single;
  i,j:integer;
  ds,dt,t,s:single;
 begin
  nsign:=1.0; // GLU_OUTSIDE
  da := 2.0*PI / slices;
  dr := (topRadius-baseRadius) / stacks;
  dz := height / stacks;
  nz := (baseRadius-topRadius) / height;  //* Z component of normal vectors */
  if TQuadric(quad).Style=GLU_POINT then begin
   glBegin( GL_POINTS );
   for i:=0 to slices-1 do begin
    x := cos(i*da);
    y := sin(i*da);
    normal3f( x*nsign, y*nsign, nz*nsign );
    z := 0.0;
    r := baseRadius;
    for j:=0 to stacks do begin
     glVertex3f( x*r, y*r, z );
     z := z+ dz;
     r := r+ dr;
    end;
   end;
   glEnd();
  // GLU_POINT
  end else
  if (TQuadric(quad).Style=GLU_LINE) or (TQuadric(quad).Style=GLU_SILHOUETTE) then begin
   //* Draw rings */
   if TQuadric(quad).Style=GLU_LINE then begin
    z := 0.0;
    r := baseRadius;
    for j:=0 to stacks do begin
     glBegin( GL_LINE_LOOP );
     for i:=0 to slices-1 do begin
      x := cos(i*da);
      y := sin(i*da);
      normal3f( x*nsign, y*nsign, nz*nsign );
      glVertex3f( x*r, y*r, z );
     end;
     glEnd();
     z :=z + dz;
     r :=r + dr;
    end;
   end else
   //* draw one ring at each end */
   if (baseRadius<>0.0) then begin
    glBegin( GL_LINE_LOOP );
    for i:=0 to slices-1 do begin
     x := cos(i*da);
     y := sin(i*da);
     normal3f( x*nsign, y*nsign, nz*nsign );
     glVertex3f( x*baseRadius, y*baseRadius, 0.0 );
    end;
    glEnd();
    glBegin( GL_LINE_LOOP );
    for i:=0 to slices-1 do begin
     x := cos(i*da);
     y := sin(i*da);
     normal3f( x*nsign, y*nsign, nz*nsign );
     glVertex3f( x*topRadius, y*topRadius, height );
    end;
    glEnd();
   end;
  //* draw length lines */
   glBegin( GL_LINES );
   for i:=0 to slices-1 do begin
    x := cos(i*da);
    y := sin(i*da);
    normal3f( x*nsign, y*nsign, nz*nsign );
    glVertex3f( x*baseRadius, y*baseRadius, 0.0 );
    glVertex3f( x*topRadius, y*topRadius, height );
   end;
   glEnd();
  // GLU_LINE or GLU_SILHOUETTE
  end else
  if TQuadric(quad).Style=GLU_FILL then begin
   ds := 1.0 / slices;
   dt := 1.0 / stacks;
   t := 0.0;
   z := 0.0;
   r := baseRadius;
   for j:=0 to stacks-1 do begin
    s := 0.0;
    glBegin( GL_QUAD_STRIP );
    for i:=0 to slices do begin
     if (i = slices) then begin
      x := sin(0.0);
      y := cos(0.0);
     end else begin
      x := sin(i * da);
      y := cos(i * da);
     end;
     if (nsign=1.0) then begin
      normal3f( x*nsign, y*nsign, nz*nsign );
      if TQuadric(quad).Texture then glTexCoord2f(s,t);
      glVertex3f( x * r, y * r, z );
      normal3f( x*nsign, y*nsign, nz*nsign );
      if TQuadric(quad).Texture then glTexCoord2f(s,t+dt);
      glVertex3f( x * (r + dr), y * (r + dr), z + dz);
     end else begin
      normal3f( x*nsign, y*nsign, nz*nsign );
      if TQuadric(quad).Texture then glTexCoord2f(s,t);
      glVertex3f( x * r, y * r, z );
      normal3f( x*nsign, y*nsign, nz*nsign );
      if TQuadric(quad).Texture then glTexCoord2f(s,t+dt);
      glVertex3f( x * (r + dr), y * (r + dr), z + dz);
     end;
     s := s+ ds;
    end; //* for slices */
    glEnd();
    r:=r+dr;
    t:=t+dt;
    z:=z+dz;
   end; //* for stacks */
  end;
 end;
{$endif}
end.
