unit rdlg;

{
  rdlg
  ====
  Date: Sep 2002
  Author: Rosi (http://sweb.cz/rosisoft)

  Description:
  rdlg is set of dialog functions

  Note:
  Full functional demo
{}

interface

{$DEFINE UseFormatLabel}

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, StdCtrls, Buttons, Variants
  {$IFDEF UseFormatLabel},FormatLabel{$ENDIF}
  ;

type
  TDialogType = (dtNone, dtI, dtQ, dtW, dtE);
  TButtonsType = (btO, btOS, btAN, btANS);

  function DlgI(const InfoText: string): integer;
  function DlgQ(const InfoText: string): integer;
  function DlgW(const InfoText: string): integer;
  function DlgE(const InfoText: string): integer;

  function DlgI2(const BoldText, NormalText: string): integer;
  function DlgQ2(const BoldText, NormalText: string): integer;
  function DlgW2(const BoldText, NormalText: string): integer;
  function DlgE2(const BoldText, NormalText: string): integer;

  function ShowDlg(const DialogType: TDialogType;
                   const ButtonsType: TButtonsType;
                   const Params: array of Variant): integer;
  {Params: array of strings to display, helpcontext
    if string begining: ^C - this string will be used as caption of window
                        ^B - this string will be displayed bold
                        ^I - -"- italic
                        ^U - -"- underline
                        ^L - -"- large font
                        ^X - -"- extra large font
  }

  function InputStr(const Capt, Info: string; var Input: string): boolean;
  function InputInt(const Capt, Info: string; var Input: integer): boolean;
  function InputPassword(const Info: string; var Psw: string): boolean;

  function ShowInput(const Capt, Info: string; var Input: string;
                     const Width: integer; const MaskChar: Char): boolean;

  procedure ShowInfo(const InfoText: string; const Form: TForm);

  procedure ShowErr(const Info: string; E: Exception; EndProgram: boolean);

implementation

//include resource file
{$R rdlg.res}

uses rstring, rtool;

const
  gap = 10;
  bmpResI : array[1..4] of string = ('bmpI','bmpQ','bmpW','bmpE');
  bmpResG : array[1..9] of string =
    ('bmpOK','','bmpOK','bmpCancel','bmpOK','bmpNo','bmpOK','bmpNo','bmpCancel');
  strCapRes : array[0..4] of string=
              ('',sInformation,sQuestion,sWarning,sError);
  strButRes : array[1..12] of string = (sBtOk,'','',
                                        sBtOk,sBtCancel,'',
                                        sBtYes,sBtNo,'',
                                        sBtYes,sBtNo,sBtCancel);

var InfoForm: TForm;

function DlgI(const InfoText: string): integer;
begin
  Result:=ShowDlg(dtI,btO,[InfoText]);
end;

function DlgQ(const InfoText: string): integer;
begin
  Result:=ShowDlg(dtQ,btAN,[InfoText]);
end;

function DlgW(const InfoText: string): integer;
begin
  Result:=ShowDlg(dtW,btO,[InfoText]);
end;

function DlgE(const InfoText: string): integer;
begin
  Result:=ShowDlg(dtE,btO,[InfoText]);
end;

function DlgI2(const BoldText, NormalText: string): integer;
begin
  Result:=ShowDlg(dtI,btO,['^B'+BoldText, NormalText]);
end;

function DlgQ2(const BoldText, NormalText: string): integer;
begin
  Result:=ShowDlg(dtQ,btAN,['^B'+BoldText, NormalText]);
end;

function DlgW2(const BoldText, NormalText: string): integer;
begin
  Result:=ShowDlg(dtW,btO,['^B'+BoldText, NormalText]);
end;

function DlgE2(const BoldText, NormalText: string): integer;
begin
  Result:=ShowDlg(dtE,btO,['^B'+BoldText, NormalText]);
end;

function ShowDlg(const DialogType: TDialogType;
                 const ButtonsType: TButtonsType;
                 const Params: array of Variant): integer;
var F: TForm;
    I: TImage;
    B: array[1..3] of TBitBtn;
    a, aBut, aLeft, aTop: integer;
    s: string;
    oldCursor: TCursor;
begin
  //inicialization
  aLeft:=gap;
  aTop:=gap;

  //Form
  F:=TForm.Create(Application);
  F.Position:=poScreenCenter;
  F.ClientWidth:=400;
  F.ClientHeight:=600;
  F.BorderStyle:=bsDialog;
  F.Caption:=strCapRes[ord(DialogType)];

  //Image
  if DialogType<>dtNone then
  begin
    I:=TImage.Create(F);
    I.Parent:=F;
    I.Picture.Bitmap.LoadFromResourceName(HInstance,bmpResI[ord(DialogType)]);
    I.AutoSize:=true;
    I.Transparent:=true;
    I.Left:=aLeft;
    Inc(aLeft,I.Width+gap);
    I.Top:=aTop;
    Inc(aTop,8);
  end;

  //Labels
  for a:=0 to High(Params) do
    case VarType(Params[a]) of
     varString:begin
                s:=Params[a]+'   ';
                //caption?
                if copy(s,1,2)='^C' then F.Caption:=Trim(copy(s,3,Length(s)))
                else
                 {$IFDEF UseFormatLabel}
                  with TFormatLabel.Create(F) do
                 {$ELSE}
                  with TLabel.Create(F) do
                 {$ENDIF}
                  begin
                    Parent:=F;
                    WordWrap:=true;
                    Left:=aLeft;
                    Top:=aTop;
                    if s[1]='^' then
                    begin
                      case s[2] of
                        'B': Font.Style:=[fsBold];
                        'I': Font.Style:=[fsItalic];
                        'U': Font.Style:=[fsUnderline];
                        'L': Font.Size:=Font.Size+2;
                        'X': Font.Size:=Font.Size+4;
                      end;
                      s:=copy(s,3,Length(s));
                    end;
                    Width:=F.ClientWidth-Left-gap;
                    Caption:=Trim(s);
                    Inc(aTop,Height+gap);
                    //check width
                    if Width>F.ClientWidth-Left-gap then
                      F.ClientWidth:=Left+gap+Width;
                  end;
                end;
     varInteger: F.HelpContext:=Params[a];
    end;

  //Buttons
  aTop:=aTop+gap;
  if aTop<50 then aTop:=50;
  case ButtonsType of
    btO: aBut:=1;
    btOS, btAN: aBut:=2;
    btANS: aBut:=3;
    else aBut:=1;
  end;
  for a:=1 to aBut do
  begin
    B[a]:=TBitBtn.Create(F);
    B[a].Parent:=F;
    B[a].Glyph.LoadFromResourceName
      (HInstance,bmpResG[ord(ButtonsType)*2+a]);
    B[a].Caption:=strButRes[a+ord(ButtonsType)*3];
    B[a].Width:=80;
    B[a].Top:=aTop;
    B[a].Left:=((F.ClientWidth-(2*gap)-aBut*B[a].Width) div (aBut+1))*a
               + gap+B[a].Width*(a-1);
  end;
  Inc(aTop,B[aBut].Height+gap);
  case ButtonsType of
    btO: begin
           B[1].Cancel:=true;
           B[1].Default:=true;
           B[1].ModalResult:=mrOK;
         end;
    btOS:begin
           B[1].Default:=true;
           B[1].ModalResult:=mrOK;
           B[2].Cancel:=true;
           B[2].ModalResult:=mrCancel;
         end;
    btAN:begin
           B[1].ModalResult:=mrYes;
           B[2].ModalResult:=mrNo;
           F.BorderIcons:=[];
         end;
    btANS:begin
           B[1].ModalResult:=mrYes;
           B[2].ModalResult:=mrNo;
           B[3].Cancel:=true;
           B[3].ModalResult:=mrCancel;
          end;
  end;

  F.ClientHeight:=aTop;
  oldCursor:=NCursor;
  Result:=F.ShowModal;
  ChCursor(oldCursor);
  F.Free;
end;

function InputStr(const Capt, Info: string; var Input: string): boolean;
begin
  Result:=ShowInput(Capt,Info,Input,350,#0);
end;

function InputInt(const Capt, Info: string; var Input: integer): boolean;
var s: string;
begin
  repeat
    s:=IntToStr(Input);
    Result:=ShowInput(Capt,Info,s,188,#0);
    if Result then
    try
      Input:=StrToInt(s);
    except
      DlgE2(sInputErr,sFormatNumberErr);
      s:='e';
    end;
  until s<>'e';
end;

function InputPassword(const Info: string; var Psw: string): boolean;
begin
  Result:=ShowInput(sInput,Info,Psw,188,'*');
end;

function ShowInput(const Capt, Info: string; var Input: string;
                   const Width: integer; const MaskChar: Char): boolean;
var F: TForm;
    L: TLabel;
    E: TEdit;
    B1,B2: TBitBtn;
    aLeft, aTop: integer;
    oldCursor: TCursor;
begin
  //inicialization
  aLeft:=gap;
  aTop:=gap;

  //Form
  F:=TForm.Create(Application);
  F.Position:=poScreenCenter;
  F.ClientWidth:=Width;
  F.ClientHeight:=600;
  F.BorderStyle:=bsDialog;
  F.Caption:=Capt;

  //Label
 {$IFDEF UseFormatLabel}
  L:=TFormatLabel.Create(F);
 {$ELSE}
  L:=TLabel.Create(F);
 {$ENDIF}
  L.Parent:=F;
  L.WordWrap:=true;
  L.Left:=aLeft;
  L.Top:=aTop;
  L.Width:=F.ClientWidth-L.Left-gap;
  L.Caption:=Info;
  Inc(aTop,L.Height+gap);
  //check width
  if L.Width>F.ClientWidth-L.Left-gap then
    F.ClientWidth:=L.Left+gap+L.Width;

  //Edit
  E:=TEdit.Create(F);
  E.Parent:=F;
  E.Left:=aLeft;
  E.Width:=F.ClientWidth-E.Left-gap;
  E.Top:=aTop;
  Inc(aTop,E.Height+gap);
  E.PasswordChar:=MaskChar;
  E.Text:=Input;
  E.SelectAll;

  //Buttons
  B1:=TBitBtn.Create(F);
  B1.Parent:=F;
  B1.Top:=aTop;
  B1.Left:=aLeft;
  B1.Caption:=sBtOk;
  B1.Glyph.LoadFromResourceName(HInstance,bmpResG[1]);
  B1.Default:=true;
  B1.ModalResult:=mrOK;
  B2:=TBitBtn.Create(F);
  B2.Parent:=F;
  B2.Top:=aTop;
  B2.Left:=B1.Left+B1.Width+2*gap;
  B2.Caption:=sBtCancel;
  B2.Glyph.LoadFromResourceName(HInstance,bmpResG[4]);
  B2.Cancel:=true;
  B2.ModalResult:=mrCancel;
  Inc(aTop,B1.Height+gap);

  F.ClientHeight:=aTop;
  oldCursor:=NCursor;
  Result:=F.ShowModal=mrOK;
  ChCursor(oldCursor);
  if Result then Input:=E.Text;
  F.Free;
end;

procedure ShowInfo(const InfoText: string; const Form: TForm);
begin
  //Hide?
  if (InfoText='') then
  begin
    NCursor;
    if InfoForm=nil then Exit;
    InfoForm.Hide;
    InfoForm.Free;
    InfoForm:=nil;
    Exit;
  end;
  //Show
  if InfoForm=nil then
  begin
    //Form
    InfoForm:=TForm.Create(Application);
    InfoForm.BorderIcons:=[];
    InfoForm.BorderStyle:=bsNone;
    InfoForm.Caption:='';
    InfoForm.Height:=50;
    InfoForm.Width:=250;
    if Form=nil then InfoForm.Position:=poScreenCenter
    else
    begin
      InfoForm.Left:=Form.Left + (Form.Width - InfoForm.Width) div 2;
      InfoForm.Top:=Form.Top + (Form.Height - InfoForm.Height) div 2;
    end;
    with TPanel.Create(InfoForm) do
    begin
      Parent:=InfoForm;
      Align:=alClient;
      BevelWidth:=2;
    end;
  end;
  (InfoForm.Controls[0] as TPanel).Caption:=InfoText;
  WCursor;
  InfoForm.Show;
  InfoForm.Update;
end;

// display error message
procedure ShowErr(const Info: string; E: Exception; EndProgram: boolean);
begin
  ShowInfo('',nil);
  if Application.Terminated then Exit;
  MessageBeep(MB_ICONEXCLAMATION);
  if Info<>'' then DlgE2(Info,sErrorDescription+#13+E.Message)
              else DlgE(sErrorDescription+#13+E.Message);
  if EndProgram then Application.Terminate;
end;

initialization
  InfoForm:=nil;

end.
