unit URLLabel;

{
  URL Label
  =========
  Date: May 2003
  Author: Rosi (http://sweb.cz/rosisoft)

  Description:
  URLLabel is enhanced TLabel component which provides functionality
  for launching of any URL target, ie.:
  mailto:name@email.com
  http://www.company.com
  file:C:\text.txt

  Note:
  Full functional demo
{}

interface

uses
  Windows, Messages, SysUtils, Classes, Controls, Graphics, StdCtrls,
  Forms, ShellApi;

type
  TURLLabel = class(TLabel)
  private
    { Private declarations }
    oldColor: TColor;
    FURLCommand: string;
    procedure CMMouseEnter(var AMsg: TMessage); message CM_MOUSEENTER;
    procedure CMMouseLeave(var AMsg: TMessage); message CM_MOUSELEAVE;
  protected
    { Protected declarations }
    procedure Loaded; override;
    procedure Click; override;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); override;
    procedure SetURLCommand(Cmd: string);
  published
    { Published declarations }
    property URLCommand: string
      read FURLCommand write FURLCommand;
  end;

procedure Register;

implementation

{$R *.res}

procedure Register;
begin
  RegisterComponents('Rosi', [TURLLabel]);
end;

constructor TURLLabel.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  Font.Color:=clHighLight;
  Font.Style:=[fsUnderline];
  Cursor:=crHandPoint;
end;

procedure TURLLabel.Loaded;
begin
  oldColor:=Font.Color;
  if not (csDesigning in ComponentState) and (Hint='') then Hint:=FURLCommand;
end;

procedure TURLLabel.CMMouseEnter(var AMsg: TMessage);
begin
  Font.Color:=clHotLight;
end;

procedure TURLLabel.CMMouseLeave(var AMsg: TMessage);
begin
  Font.Color:=oldColor;
end;

procedure TURLLabel.Click;
begin
  inherited;
  if FURLCommand<>'' then
    ShellExecute(Application.Handle,'open',PChar(FURLCommand),nil,nil,SW_NORMAL);
end;

procedure TURLLabel.SetURLCommand(Cmd: string);
begin
  if Hint=FURLCommand then Hint:=Cmd;
  FURLCommand:=Cmd;
end;

end.
