unit easy_outlook;

interface

uses Classes, Outlook2000;

{ Mgliche Werte fr GoFolder:
 olFolderDeletedItems = $00000003;
  olFolderOutbox = $00000004;
  olFolderSentMail = $00000005;
  olFolderInbox = $00000006;
  olFolderCalendar = $00000009;
  olFolderContacts = $0000000A;
  olFolderJournal = $0000000B;
  olFolderNotes = $0000000C;
  olFolderTasks = $0000000D;
  olFolderDrafts = $00000010;
}

  type
   TeasyMail = class
   private
    FRecipient : String;
    FSubject,
    FBody,
    FHTMLBody : String;
   public
     constructor Create;
   published
     property Recipient : String read FRecipient write FRecipient;  {Empfnger}
     property Subject : String read FSubject write FSubject; {Betreff}
     property Body : String read FBody write FBody; {Mail-Text}
     property HtmlBody : string read FHTMLBody write FHTMLBody;
   end;

   TFolderItemEvent = procedure ( Adresse, Body : String; attachments : TStringList; revicedon, sendon : TDateTime ) of object;

   TeasyOutlookMail = class(TPersistent)
   private
    FOutlook : TOutlookApplication;
    NmSpace: NameSpace;
    Folder: MAPIFolder;
    FMail : TeasyMail;
    Ferc : boolean;
    FOnFolderItem : TFolderItemEvent;
   public
     constructor Create;
     procedure Open;
     procedure Close;
     procedure SendItem;
     procedure GoFolder( fld : OlDefaultFolders );
   published
     property MsOutlook : TOutlookApplication read FOutlook write FOutlook;
     property Mail : TeasyMail read FMail write FMail;
     property EachRecipient : Boolean read Ferc write Ferc;
     property OnFolderItem : TFolderItemEvent read  FOnFolderItem write FOnFolderItem;
   end;

implementation

uses Forms, OleCtrls, dialogs, sysutils;

constructor TeasyMail.Create;
begin
    FRecipient := '';
    FSubject := '';
    FBody := '';
    FHTMLBody := '';
end;

constructor TeasyOutlookMail.Create;
begin
 Fmail := teasymail.create;
end;

procedure TeasyOutlookMail.Close;
begin
  NmSpace.Logoff;
  MsOutlook.Quit;
  MsOutlook.Disconnect;
end;

procedure TeasyOutlookMail.Open;
begin
  MsOutlook := TOutlookApplication.Create( Application );
  MsOutlook.Connect;
  NmSpace := MsOutlook.GetNamespace('MAPI');
  NmSpace.Logon('', '', False, False);
//  Folder := NmSpace.GetDefaultFolder(olFolderInbox);
//  Folder.Display;
end;

procedure TeasyOutlookMail.SendItem;
var
  MI: MailItem;
  a : olevariant;
begin
  MI := MsOutlook.CreateItem(olMailItem) as MailItem;
  MI.Recipients.Add(Mail.Recipient);
  MI.Subject := Mail.Subject;
  MI.Body := Mail.Body;
  mi.HTMLBody := mail.HtmlBody;
  a := true;
  MI.Display(a);
end;

procedure TeasyOutlookMail.GoFolder( fld : OlDefaultFolders );      //olFolderOutbox
var
    b : MAPIFolder;
    i,a : Integer;
    c : mailitem;
    d   : Recipient;
    at  : Attachment;
    tmp : tstringlist;
begin
  b := NmSpace.GetDefaultFolder(fld);
  for i:=1 to b.Items.Count do
  begin
    c := b.Items.Item(i) as _MailItem;

    // Attachments abrufen
    if c.Attachments.Count>0 then
    begin
      tmp := tstringlist.create;
      for a:=1 to c.Attachments.Count do
      begin
        at := c.Attachments.Item(1);
        tmp.Add( at.FileName );
      end;
    end else tmp := nil;

    // Empfnger Adressen abrufen; fr jeden Empfnger FolderItemEvent aufrufen;
    // select recipients; for each recipient fire FolderItemEvent
    if c.Recipients.Count>0 then
    begin
      for a:=1 to c.Recipients.Count do
      begin
        d := c.Recipients.Item(1) as Recipient;
        If Assigned(FOnFolderItem) then OnFolderItem( d.Address, c.Body, tmp, c.ReceivedTime, c.SentOn );
      end;
    end else If Assigned(FOnFolderItem) then OnFolderItem( '', c.Body, tmp, c.ReceivedTime, c.SentOn );
  end;
end;




end.
