{  ICS WSocket extension supporting WinSock interface to XPSP1 Bluetooth
   Based on WIrCOMMSocket by Primoz Gabrijelcic

   Author           : Warren Chin
   Creation date    : 2002-07-09
   Last modification: 2002-07-09
   Version          : 0.1
   Limitations      : Supports only basic MS-BT (XP SP1 beta) Operation
}

unit WBluetoothSocket;

interface

uses
  Windows,
  WinSock,
  WSocket,
  Classes;

const

  // Partially imports from ws2bth.h
  NS_BTH: Integer = 16;
  AF_BTH: Integer = 32;
  BTHPROTO_RFCOMM: Integer = $0003;
  SerialPortServiceClass_UUID: TGUID = '{00001101-0000-1000-8000-00805F9B34FB}';

type

  PSockAddrBth = ^TSockAddrBth;
  _SOCKADDR_BTH = packed record
    addressFamily: U_SHORT;
    btAddr: Int64;
    serviceClassId: TGUID;
    port: ULONG;
  end;
  TSockAddrBth = _SOCKADDR_BTH;

  TWBluetoothSocket = class(TCustomSyncWSocket)
  protected
    procedure AssignDefaultValue; override;
    function  InitializeSocket: boolean; virtual;
  public
    procedure Connect; override;
    property Handle;
    property HSocket;
    property BufSize;
    property Text;
    property AllSent;
    property OnDisplay;
  published
    property Addr;
    property Port;
    property State;
    property ReadCount;
    property RcvdCount;
    property LastError;
    property MultiThreaded;
    property ComponentOptions;
    property OnDataAvailable;
    property OnDataSent;
    property OnSendData;
    property OnSessionClosed;
    property OnSessionAvailable;
    property OnSessionConnected;
    property OnChangeState;
    property OnLineTooLong;
    property OnError;
    property OnBgException;
    property FlushTimeout;
    property SendFlags;
    property LingerOnOff;
    property LingerTimeout;
  end;

  procedure Register;

implementation

uses
  SysUtils;

procedure Register;
begin
  RegisterComponents('FPiette', [TWBluetoothSocket]);
end;

procedure TWBluetoothSocket.AssignDefaultValue;
begin
  inherited AssignDefaultValue;
  FAddrFormat := AF_BTH;
  FProto := BTHPROTO_RFCOMM;
  FPortStr := '0';
end;

procedure TWBluetoothSocket.Connect;
var
  iStatus : integer;
  sin : TSockAddrBth;
begin
  if (FHSocket <> INVALID_SOCKET) and (FState <> wsClosed) then begin
    RaiseException('Connect: Socket already in use');
    Exit;
  end;

  if not InitializeSocket then Exit;

  sin.addressFamily := AF_BTH;
  sin.btAddr := StrToInt64('$' + GetAddr);
  sin.serviceClassId := SerialPortServiceClass_UUID;
  sin.port := StrToInt(GetRemotePort);

  iStatus := WSocket_connect(FHSocket, TSockAddr((@sin)^), sizeof(sin));
  if iStatus = 0 then
    ChangeState(wsConnected)
  else begin
    iStatus := WSocket_WSAGetLastError;
    if iStatus = WSAEWOULDBLOCK then
      ChangeState(wsConnecting)
    else begin
      SocketError('Connect');
      Exit;
    end;
  end;
end;

function TWBluetoothSocket.InitializeSocket: boolean;
var
  iStatus: integer;
begin
  Result := false;
  FProtoResolved := true;

  DeleteBufferedData;
  FHSocket := WSocket_socket(FAddrFormat, FType, FProto);

  if FHSocket = INVALID_SOCKET then begin
    SocketError('Connect (socket)');
    Exit;
  end;

  ChangeState(wsOpened);

  SetLingerOption;

  FSelectEvent := FD_READ or FD_WRITE or FD_CLOSE or FD_ACCEPT or FD_CONNECT;

  iStatus := WSocket_WSAASyncSelect(FHSocket, Handle, WM_ASYNCSELECT, FSelectEvent);
  if iStatus <> 0 then begin
    SocketError('WSAAsyncSelect');
    Exit;
  end;
  Result := true;
end;

end.


