unit Translation ;

// this unit holds the messages, translated or in English
// (c) 2002 Frederic DA VITORIA

interface
  uses Windows, SysUtils, IniFiles ;

  type
    TEXT_MESSAGES = (
      msg_DIRECTORY,
      msg_DIRECTORY_HINT,
      msg_BROWSE,
      msg_HEXADECIMAL_MODE,
      msg_UNIT_HINT,
      msg_EXECUTE,
      msg_EXECUTE_HINT,
      msg_SAVE,
      msg_SAVE_HINT,
      msg_FILES,
      msg_FILES_HINT,
      msg_FILE_DATE,
      msg_CALCULATED_SIZE,
      msg_CALCULATED_SIZE_HINT,
      msg_REAL_SIZE,
      msg_REAL_SIZE_HINT,
      msg_SIZE_DIFFERENCE,
      msg_SIZE_DIFFERENCE_HINT,
      msg_ID3V1,
      msg_ID3V1_HINT,
      msg_LAST_FRAME,
      msg_LAST_FRAME_HINT,
      msg_SYNCHRO_ERRORS,
      msg_SYNCHRO_ERRORS_LIST,
      msg_SYNCHRO_ERRORS_LIST_HINT,
      msg_LAST_OK_FRAME_FOUND,
      msg_LAST_OK_FRAME_FOUND_HINT,
      msg_NEXT_EXPECTED_FRAME,
      msg_NEXT_EXPECTED_FRAME_HINT,
      msg_NEXT_FRAME_FOUND,
      msg_NEXT_FRAME_FOUND_HINT,
      msg_SYNCHRO_DIFFERENCE,
      msg_SYNCHRO_DIFFERENCE_HINT,
      msg_ABOUT,
      msg_CLOSE,
      msg_CLOSE_HINT,
      msg_ENDS_WITH_ID3V1,
      msg_LAST_FRAME_TRUNCATED,
      msg_LAST_FRAME_INVALID,
      msg_ABORTED,
      msg_FINISHED,
      msg_SORT,
      msg_SORT_HINT,
      msg_NAME,
      msg_DIRECTORY_SORT,
      msg_ABOUT_TITLE,
      msg_BRAVA_TAG,
      msg_BRAVA_TAG_FOUND,
      msg_DIRECTORY_NOT_FOUND,
      msg_UNIT,
      msg_DECIMAL_MODE,
      msg_TIME_MODE
      ) ;

  const
    {$WRITEABLECONST ON}
    MSGS : array [Low (TEXT_MESSAGES)..High (TEXT_MESSAGES)] of string = (
    // default english messages
      '&Directory',
      'Directory where the mp3 files are',
      '&Browse...',
      '&Hexadecimal',
      'If checked, all positions will be displayed in hexadecimal',
      '&Execute',
      'Tests the files in the specified directory',
      '&Save',
      'Saves the test results in a file',
      '&Files',
      'Choose the file whose test results will appear in the box to the right, double-click to load in your mp3 player',
      'File date',
      'Calculated size',
      'Size the file should have if it was correct',
      'Real size',
      'Size the file has (minus 128 bytes for the Id3v1 tag if present)',
      'Difference',
      'Difference between the Calculated size and the Real size',
      'Id3v1 tag',
      'There is an Id3v1 tag at the end of the file',
      'Last frame',
      'Error found when analyzing the last frame',
      'Synchronization errors',
      'Synchronization errors list',
      'Choose the position of the synchronization error whose details will appear in the box to the right',
      'Last ok frame found',
      'Position where the last correct frame was found',
      'Next expected frame',
      'Position where the next correct frame was expected',
      'Next frame found',
      'Position where the next correct frame was found',
      'Difference',
      'Difference between the expected position and the found position. Usually, they sound like "drop-outs"',
      'About...',
      'Close',
      'Quit TestMp3',
      'Ends with Id3v1 tag',
      'Last frame truncated',
      'Last frame invalid',
      'Aborted',
      'Finished',
      'Sort',
      'Sort the file list by file name or by directory',
      'Name',
      'Directory',
      'About',
      'Brava tag',
      'Brava tag found',
      'Directory not found',
      'Unit',
      'Decimal',
      'Time'
      ) ;

implementation
  var
    IniFile : TIniFile ;
    Section, TranslatedMessage : string ;
    MsgNum : TEXT_MESSAGES ;

begin
  Section := IntToHex (GetSystemDefaultLangID and $0F, 2) ;
  IniFile := TIniFile.Create (ChangeFileExt (ParamStr (0), '.msg')) ;
  try
    for MsgNum := Low (TEXT_MESSAGES) to High (TEXT_MESSAGES) do begin
      TranslatedMessage := IniFile.ReadString (Section, IntToStr (Ord (MsgNum)), '') ;
      if TranslatedMessage > ''
        then MSGS [MsgNum] := TranslatedMessage
    end {for} ;
  finally IniFile.Free end
end.

