unit MainForm;

// TestMp3 user interface
// (c) 2002 Frederic DA VITORIA

interface

uses
  Windows,
  StdCtrls, Controls, Classes, ExtCtrls,
  SysUtils,
  Forms,
  ShellAPI, // ShellExecute
  AudioTest,
  Globals,
  Translation,
  FilUtils, // LongFileSize
  Dialogs, // ShowMessage
  About,
  ComCtrls, BrowseDr, ImgList;

type
  Tfrm_Main = class(TForm)
    btn_Browse: TButton;
    btn_Quit: TButton;
    btn_Execute: TButton;
    dfsBrowseDirectoryDlg1: TdfsBrowseDirectoryDlg;
    ed_Directory: TEdit;
    gb_Files: TGroupBox;
    gb_SynchroErrors: TGroupBox;
    ImageList1: TImageList;
    lbl_BravaTag: TLabel;
    lbl_CalculatedSize: TLabel;
    lbl_DateTime: TLabel;
    lbl_Directory: TLabel;
    lbl_FileFullName: TLabel;
    lbl_Id3v1: TLabel;
    lbl_LastFrame: TLabel;
    lbl_RealSize: TLabel;
    lbl_SizeDifference: TLabel;
    lbl_Status: TLabel;
    lbl_SynchroDifference: TLabel;
    lbl_SynchroErrors: TLabel;
    lbl_SynchroExpected: TLabel;
    lbl_SynchroFound: TLabel;
    lbl_SynchroLast: TLabel;
    lv_Files: TListView;
    lv_SynchroErrors: TListView;
    pnl_Bottom: TPanel;
    pnl_FileDetails: TPanel;
    pnl_FilesBorder: TPanel;
    pnl_FileFullName: TPanel;
    pnl_InSynchroBorder: TPanel;
    pnl_MiddleBorder: TPanel;
    pnl_Top: TPanel;
    pnl_Status: TPanel;
    pnl_SynchroBorder: TPanel;
    rg_Sort: TRadioGroup;
    SaveDialog1: TSaveDialog;
    rg_Unit: TRadioGroup;
    btn_Save: TButton;
    btn_About: TButton;
    procedure btn_AboutClick(Sender: TObject);
    procedure btn_BrowseClick(Sender: TObject);
    procedure btn_ExecuteClick(Sender: TObject);
    procedure btn_QuitClick(Sender: TObject);
    procedure btn_SaveClick(Sender: TObject);
    procedure DisplayHint(Sender: TObject);
    procedure ed_DirectoryChange(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ListViewEnter(Sender: TObject);
    procedure lv_FilesCompare(Sender: TObject; Item1, Item2: TListItem;
      Data: Integer; var Compare: Integer);
    procedure lv_FilesDblClick(Sender: TObject);
    procedure lv_FilesKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure lv_FilesSelectItem(Sender: TObject; Item: TListItem;
      Selected: Boolean);
    procedure lv_SynchroErrorsExit(Sender: TObject);
    procedure lv_SynchroErrorsSelectItem(Sender: TObject; Item: TListItem;
      Selected: Boolean);
    procedure rg_SortClick(Sender: TObject);
    procedure rg_UnitClick(Sender: TObject);
  private
    AbortRequested : boolean ;
    AudioTester : TAudioTester ;
    Running : boolean ;
    procedure LoadDir (directory : string) ;
    procedure SetLabelsCaptions ;
  public
  end;

var frm_Main: Tfrm_Main;

implementation

{$R *.DFM}

  procedure Tfrm_Main.btn_AboutClick(Sender: TObject);
    begin
      frm_About.ShowModal
    end;

  procedure Tfrm_Main.btn_QuitClick (Sender : TObject) ;
    begin                                               { btn_CloseClick }
      if Running
	then QuitRequested := TRUE ;            // stop if running
      Close
    end ;                                               { btn_CloseClick }

  procedure Tfrm_Main.btn_BrowseClick (Sender : TObject) ;
    begin                                               { btn_DirectoryClick }
      with dfsBrowseDirectoryDlg1 do begin
	dfsBrowseDirectoryDlg1.Selection := ed_Directory.Text ;
	if Execute
	   then ed_Directory.Text := dfsBrowseDirectoryDlg1.Selection
      end {with}
    end ;                                               { btn_DirectoryClick }

  procedure Tfrm_Main.btn_ExecuteClick (Sender : TObject) ;
    begin                                               { btn_ExecuteClick }
      if Running
	then AbortRequested := TRUE
	else begin
          if not DirectoryExists (ed_Directory.Text)
            then begin
              ShowMessage (MSGS [msg_DIRECTORY_NOT_FOUND]) ;
              Exit
            end {then} ;
	  Screen.Cursor := crHOURGLASS ;        // prepare screen
          SetLabelsCaptions ;
	  Running := TRUE ;
	  btn_Browse.Enabled := FALSE ;
	  btn_Execute.Caption := 'Stop' ;
	  btn_Save.Enabled := FALSE ;
	  ed_Directory.Enabled := FALSE ;
	  lbl_Directory.Enabled := FALSE ;
	  lv_Files.Clear ;                      // perform treatment
	  lv_SynchroErrors.Clear ;
	  try
	    try
              lv_Files.SortType := stNONE ;
              LoadDir (ed_Directory.Text)
	    except on EAbort do end
	  finally
            if AbortRequested
              then begin
                lbl_Status.Caption := MSGS [msg_ABORTED] ;
                AbortRequested := FALSE
              end {then}
              else lbl_Status.Caption := MSGS [msg_FINISHED] ;
            lv_Files.SortType := stTEXT ;       // restore screen
            lv_Files.AlphaSort ;
            btn_Browse.Enabled := TRUE ;
            btn_Execute.Caption := MSGS [msg_EXECUTE] ;
	    btn_Save.Enabled := (lv_Files.Items.Count > 0) ;
	    rg_Unit.Enabled := (lv_Files.Items.Count > 0) ;
	    rg_Sort.Enabled := (lv_Files.Items.Count > 0) ;
            ed_Directory.Enabled := TRUE ;
            lbl_Directory.Enabled := TRUE ;
            Running := FALSE ;
            ActiveControl := lv_Files ;
            Screen.Cursor := crDEFAULT
          end {finally}
        end {else}
    end ;                                               { btn_ExecuteClick }

  procedure Tfrm_Main.btn_SaveClick (Sender : TObject) ;
  // the contents of the list are saved in a text file, columns separated by tabs
    var
      f : TextFile ;
      i : integer ;
    begin
      SaveDialog1.InitialDir := ed_Directory.Text ;
      if SaveDialog1.Execute
        then begin
          AssignFile (f, SaveDialog1.FileName) ;
          Rewrite (f) ;
          try
            with lv_Files do
              for i := 0 to Items.Count-1 do
                with Items [i] do
                  if SubItems.Count > 0
                    then WriteLn (f, Caption, #9, SubItems [0], #9, SubItems [1],
                                     #9, SubItems [2], #9, SubItems [3],
                                     #9, SubItems [4], #9, SubItems [5],
                                     #9, SubItems [6], #9, SubItems [7])
                    else WriteLn (f, Caption) ;
          finally CloseFile (f) end
        end {then}
    end ;

  procedure Tfrm_Main.DisplayHint(Sender: TObject);
    begin
      lbl_Status.Caption := GetLongHint(Application.Hint);
    end;

  procedure Tfrm_Main.ed_DirectoryChange (Sender : TObject) ;
    begin
      btn_Execute.Enabled := (ed_Directory.Text > '')
    end ;

  procedure Tfrm_Main.FormCloseQuery (Sender : TObject ; var CanClose : Boolean) ;
    begin
      AbortRequested := TRUE ; // stop if running
      CanClose := TRUE
    end ;

  procedure Tfrm_Main.FormCreate (Sender : TObject) ;
    begin                                               { FormCreate }
      // load translated messages
      SetLabelsCaptions ;
      btn_About.Caption := MSGS [msg_ABOUT] ;
      btn_Browse.Caption := MSGS [msg_BROWSE] ;
      btn_Quit.Caption := MSGS [msg_CLOSE] ;
      btn_Quit.Hint := MSGS [msg_CLOSE_HINT] ;
      btn_Execute.Caption := MSGS [msg_EXECUTE] ;
      btn_Execute.Hint := MSGS [msg_EXECUTE_HINT] ;
      btn_Save.Caption := MSGS [msg_SAVE] ;
      btn_Save.Hint := MSGS [msg_SAVE_HINT] ;
      ed_Directory.Hint := MSGS [msg_DIRECTORY_HINT] ;
      gb_Files.Caption := MSGS [msg_FILES] ;
      gb_SynchroErrors.Caption := MSGS [msg_SYNCHRO_ERRORS_LIST] ;
      lbl_CalculatedSize.Hint := MSGS [msg_CALCULATED_SIZE_HINT] ;
      lbl_Directory.Caption := MSGS [msg_DIRECTORY] ;
      lbl_Id3v1.Hint := MSGS [msg_ID3V1_HINT] ;
      lbl_LastFrame.Hint := MSGS [msg_LAST_FRAME_HINT] ;
      lbl_RealSize.Hint := MSGS [msg_REAL_SIZE_HINT] ;
      lbl_SizeDifference.Hint := MSGS [msg_SIZE_DIFFERENCE_HINT] ;
      lbl_SynchroLast.Hint := MSGS [msg_LAST_OK_FRAME_FOUND_HINT] ;
      lbl_SynchroExpected.Hint := MSGS [msg_NEXT_EXPECTED_FRAME_HINT] ;
      lbl_SynchroFound.Hint := MSGS [msg_NEXT_FRAME_FOUND_HINT] ;
      lbl_SynchroDifference.Hint := MSGS [msg_SYNCHRO_DIFFERENCE_HINT] ;
      lv_Files.Hint := MSGS [msg_FILES_HINT] ;
      lv_SynchroErrors.Hint := MSGS [msg_SYNCHRO_ERRORS_LIST_HINT] ;
      rg_Sort.Caption := MSGS [msg_SORT] ;
      rg_Sort.Hint:= MSGS [msg_SORT_HINT] ;
      rg_Sort.Items[0] := MSGS [msg_NAME] ;
      rg_Sort.Items[1] := MSGS [msg_DIRECTORY_SORT] ;
      rg_Unit.Caption := MSGS [msg_UNIT] ;
      rg_Unit.Hint := MSGS [msg_UNIT_HINT] ;
      rg_Unit.Items[0] := MSGS [msg_DECIMAL_MODE] ;
      rg_Unit.Items[1] := MSGS [msg_HEXADECIMAL_MODE] ;
      rg_Unit.Items[2] := MSGS [msg_TIME_MODE] ;
      // initialize variables
      AudioTester := TAudioTester.Create ;
      btn_Execute.Enabled := (ed_Directory.Text > '') ;
      Application.OnHint := DisplayHint ;
      QuitRequested := FALSE
    end ;                                               { FormCreate }

  procedure Tfrm_Main.FormDestroy (Sender : TObject) ;
    begin
      AudioTester.Free
    end ;

  procedure Tfrm_Main.ListViewEnter (Sender : TObject) ;
  // give automatically the focus to the first line of the list
  // this handler is called by both ListViews
    begin
      with (Sender as TListView) do
        if (ItemFocused = NIL) and (Items.Count > 0)
          then begin
            ItemFocused := Items [0] ;
            Selected := Items [0]
          end {then}
    end ;

  procedure Tfrm_Main.LoadDir (directory : string) ;
  // this procedure is recursive, of course !
    var
      column_brava_tag        : string ;        // to prepare columns contents
      column_calculated_size  : string ;
      column_calculated_time  : string ;
      column_id3v1            : string ;
      column_last_frame       : string ;
      column_real_size        : string ;
      column_synchro_errors   : string ;
      find_result             : integer ;       // FindFirst or FindNext result
      file_size	              : longint ;
      full_path               : string ;
      last_frame_end_pos      : longint ;
      last_frame_end_time     : longint ;
      last_frame_ok           : boolean ;
      brava_tag               : boolean ;
      list_item	              : TListItem ;
      max_synchro_shift       : integer ;
      s_track                 : string ;
      search_rec              : TSearchRec ;
      synchro_errors          : integer ;
      s_synchro_errors        : string ;
    begin                                               { LoadDir }
      lbl_Status.Caption := directory ;
      find_result := FindFirst (directory+'\*.mp3',
				{$WARNINGS OFF} faARCHIVE {$WARNINGS ON}, // avoid warning about platform
				search_rec) ;
      try
	while find_result = 0 do begin          // file loop
	  s_track := search_rec.Name ;
	  if (    UpperCase (ExtractFileExt (s_track)) = '.MP3') // to filter out files such as *.mp32
	      and (search_rec.Size >= 8)
	    then begin
	      full_path := directory+'\'+s_track ;
	      file_size := LongFileSize (full_path) ;
	      lbl_Status.Caption :=  Copy (full_path, Length (ed_Directory.Text)+2, 255) ;
	      Refresh ;                         // display the status as soon as treatment starts
	      AudioTester.TestMp3File (full_path, last_frame_end_pos,
                                       last_frame_end_time, last_frame_ok,
                                       brava_tag, synchro_errors,
                                       max_synchro_shift, s_synchro_errors,
                                       Application.ProcessMessages) ;
	      list_item := lv_Files.Items.Add ; // store results in listview
	      list_item.Caption := s_track ;
	      if AudioTester.ID3v1.Ok
		then Dec (file_size, 128) ;     // if there is an Id3v1 tag,
                                                // adjust the expected size
              column_calculated_size := IntToStr (last_frame_end_pos) ;
              column_calculated_time := IntToStr (last_frame_end_time) ;
              column_real_size := IntToStr (file_size) ;
              if AudioTester.ID3v1.Ok
                then column_id3v1 := MSGS [msg_ENDS_WITH_ID3V1]
                else column_id3v1 := '' ;
              if brava_tag
                then column_brava_tag := MSGS [msg_BRAVA_TAG_FOUND]
                else column_brava_tag := '' ;
              if column_calculated_size <> column_real_size
                then if last_frame_ok
                  then column_last_frame := MSGS [msg_LAST_FRAME_TRUNCATED]
                  else column_last_frame := MSGS [msg_LAST_FRAME_INVALID]
                else if last_frame_ok
                  then column_last_frame := ''
                  else column_last_frame := 'a';
              if synchro_errors <> 0
                then column_synchro_errors := IntToStr (synchro_errors)+' / '+IntToStr(max_synchro_shift)
                else column_synchro_errors := '' ;
              if column_last_frame > ''
                then if synchro_errors <> 0
                  then list_item.StateIndex := 3
                  else list_item.StateIndex := 1
                else if synchro_errors <> 0
                  then list_item.StateIndex := 2
                  else list_item.StateIndex := 0 ;
              list_item.SubItems.Add (column_calculated_size) ;
              list_item.SubItems.Add (column_real_size) ;
              list_item.SubItems.Add (column_id3v1) ;
              list_item.SubItems.Add (column_last_frame) ;
              list_item.SubItems.Add (column_synchro_errors) ;
              list_item.SubItems.Add (s_synchro_errors) ;
              list_item.SubItems.Add (Copy (directory, Length (ed_Directory.Text)+2, 255)) ;
              list_item.SubItems.Add (DateTimeToStr (FileDateToDateTime (search_rec.time))) ;
              list_item.SubItems.Add (column_brava_tag) ;
              list_item.SubItems.Add (column_calculated_time)
	    end {then with} ;
	  if AbortRequested
	    then Abort ;
	  Application.ProcessMessages ;
	  find_result := FindNext (search_rec)
	end {while} ;

        find_result := FindFirst (directory+'\*.*', faDIRECTORY, search_rec) ;
        while find_result = 0 do begin          // directory loop
	  if     (search_rec.Name <> '.') and (search_rec.Name <> '..')
             and ((search_rec.Attr and faDIRECTORY) > 0)
	    then LoadDir (directory+'\'+search_rec.Name) ; // recursion
	  find_result := FindNext (search_rec)
	end {while} ;
      finally FindClose (search_rec) end
    end ;                                               { LoadDir }

  procedure Tfrm_Main.lv_FilesCompare (Sender : TObject ; Item1, Item2 : TListItem ;
                                       data : Integer ; var Compare : Integer) ;
    begin
      if rg_Sort.ItemIndex = 0
        then Compare := CompareText (Item1.Caption, Item2.Caption)
        // else : sort by directory + file name
        else Compare := CompareText (Item1.SubItems [6] + '\' + Item1.Caption,
                                     Item2.SubItems [6] + '\' + Item2.Caption)
    end;

  procedure Tfrm_Main.lv_FilesDblClick (Sender: TObject);
  // calls mp3 player (if defined)
    var
      result : integer ;
      ws : ansistring ;
    begin
      with lv_Files.Selected do begin
        ws := SubItems [6] + '\' + Caption;
        result := ShellExecute (Application.MainForm.Handle, NIL,
                                PChar (SubItems [6] + '\' + Caption),
                                '',
                                PChar (SubItems [6]), SW_SHOW) ;
        if result <= 0
          then ShowMessage (SysErrorMessage (result))
      end {with}
    end;

  procedure Tfrm_Main.lv_FilesKeyDown (Sender: TObject; var Key: Word;
                                       Shift: TShiftState);
    begin
      if Key = vk_RETURN
        then lv_FilesDblClick (Sender)
    end;

  procedure Tfrm_Main.lv_FilesSelectItem (Sender : TObject ; Item : TListItem ;
                                          Selected : Boolean) ;
  // displays results for selected file
    var
      i           : integer ;
      list_item   : TListItem ;
      ws          : string ;
      calc_pos, calc_time, real_pos  : longint ;
    begin
      if not Selected
        then Exit ;
      calc_pos := StrToInt (Item.SubItems [0]) ;
      real_pos := StrToInt (Item.SubItems [1]) ;
      case rg_Unit.ItemIndex of
        0 : begin                               // decimal
          lbl_CalculatedSize.Caption :=  MSGS [msg_CALCULATED_SIZE]+' '
                                        +FormatFloat ('0,', calc_pos) ;
          lbl_RealSize.Caption :=  MSGS [msg_REAL_SIZE]+' '+FormatFloat ('0,', real_pos) ;
          lbl_SizeDifference.Caption :=  MSGS [msg_SIZE_DIFFERENCE]+' '
                                        +FormatFloat ('0,',   StrToInt (Item.SubItems [1])
                                                            - StrToInt (Item.SubItems [0])) ;
        end {0} ;
        1 : begin                               // hexadecimal
          lbl_CalculatedSize.Caption :=  MSGS [msg_CALCULATED_SIZE]+' '
                                        +IntToHex (calc_pos, 6) ;
          lbl_RealSize.Caption :=  MSGS [msg_REAL_SIZE]+' '+IntToHex (real_pos, 6) ;
          lbl_SizeDifference.Caption :=  MSGS [msg_SIZE_DIFFERENCE]+' '
                                        +IntToHex (  StrToInt (Item.SubItems [1])
                                                   - StrToInt (Item.SubItems [0]),
                                                   6)
        end {1} ;
        2 : begin                               // time
          calc_time := StrToInt (Item.SubItems [9]) ;
          lbl_CalculatedSize.Caption :=  MSGS [msg_CALCULATED_SIZE]+' '
                                        +TimeToStr (calc_time/(1000*60*60*24)) ;
          if calc_pos <> 0
            then begin
              lbl_RealSize.Caption :=  MSGS [msg_REAL_SIZE]+' '
                      +TimeToStr (calc_time/calc_pos*real_pos/(1000*60*60*24)) ;
              lbl_SizeDifference.Caption :=  MSGS [msg_SIZE_DIFFERENCE]+' '
                      +TimeToStr (((calc_time/calc_pos*real_pos)-calc_time)/(1000*60*60*24))
            end {then}
            else begin
              lbl_RealSize.Caption := '' ;
              lbl_SizeDifference.Caption := ''
            end {else}
        end {2} ;
      end {case} ;
      lbl_Id3v1.Caption := Item.SubItems [2] ;
      lbl_LastFrame.Caption := Item.SubItems [3] ;
      if Item.SubItems [4] > ''
        then begin
          lbl_SynchroErrors.Caption := MSGS [msg_SYNCHRO_ERRORS]+' '+Item.SubItems [4] ;
          gb_SynchroErrors.Enabled := TRUE ;
          lv_SynchroErrors.Enabled := TRUE
        end {then}
        else begin
          lbl_SynchroErrors.Caption := '' ;
          gb_SynchroErrors.Enabled := FALSE ;
          lv_SynchroErrors.Enabled := FALSE
        end {then} ;
      lv_SynchroErrors.Clear ;                  // refresh the synchro errors list
      if Item.SubItems [5] > ''
        then begin
          ws := Item.SubItems [5] + '#' ;
          i := 1 ;
          while i <= Length (ws) do             // fill the synchro errors list
            if (ws [i] = '#') or (i = Length (ws))
              then begin
                list_item := lv_SynchroErrors.Items.Add ;
                list_item.Caption := Copy (ws, 2, 7) ;
                list_item.SubItems.Add (Copy (ws, 10, 6)) ;
                list_item.SubItems.Add (Copy (ws, 17, 6)) ;
                list_item.SubItems.Add (Copy (ws, 24, 6)) ;
                Delete (ws, 1, i) ;
                i := 1
              end {then}
              else Inc (i)
        end {then} ;
      if Item.SubItems [6] > ''
        then lbl_FileFullName.Caption := Item.SubItems [6] + '\' + Item.Caption
        else lbl_FileFullName.Caption := Item.Caption ;
      lbl_DateTime.Caption := Item.SubItems [7] ;
      lbl_BravaTag.Caption := Item.SubItems [8]
    end ;

  procedure Tfrm_Main.lv_SynchroErrorsSelectItem (Sender : TObject ; Item : TListItem ;
                                            Selected : Boolean) ;
  // displays details of selected synchro error
    begin
      if not Selected
        then Exit ;
      lbl_SynchroLast.Caption := MSGS [msg_LAST_OK_FRAME_FOUND]+' '+Item.SubItems [0] ;
      lbl_SynchroExpected.Caption := MSGS [msg_NEXT_EXPECTED_FRAME]+' '+Item.SubItems [1] ;
      lbl_SynchroFound.Caption := MSGS [msg_NEXT_FRAME_FOUND]+' '+Item.SubItems [2] ;
      if Item.SubItems [2] > Item.SubItems [1]
        then lbl_SynchroDifference.Caption := MSGS [msg_SYNCHRO_DIFFERENCE]+' '
                                              +IntToHex (  StrToInt ('$'+Item.SubItems [2])
                                                         - StrToInt ('$'+Item.SubItems [1]),
                                                         6)
        else lbl_SynchroDifference.Caption := MSGS [msg_SYNCHRO_DIFFERENCE]+' '
                                              +IntToHex (  StrToInt ('$'+Item.SubItems [1])
                                                         - StrToInt ('$'+Item.SubItems [2]),
                                                         6)
    end ;

  procedure Tfrm_Main.lv_SynchroErrorsExit (Sender : TObject) ;
  // clear the synchro details
    begin
      lbl_SynchroLast.Caption := '' ;
      lbl_SynchroExpected.Caption := '' ;
      lbl_SynchroFound.Caption := '' ;
      lbl_SynchroDifference.Caption := ''
    end ;

  procedure Tfrm_Main.rg_SortClick(Sender: TObject);
    begin
      lv_Files.AlphaSort
    end;

  procedure Tfrm_Main.rg_UnitClick(Sender: TObject);
  // refresh display immediately
    begin
      if lv_Files.Selected <> NIL
        then lv_FilesSelectItem (Sender, lv_Files.Selected, TRUE)
    end;

  procedure Tfrm_Main.SetLabelsCaptions ;
  // reset all the "dynamic" labels to their default values
    begin
      lbl_DateTime.Caption := MSGS [msg_FILE_DATE] ;
      lbl_CalculatedSize.Caption := MSGS [msg_CALCULATED_SIZE] ;
      lbl_RealSize.Caption := MSGS [msg_REAL_SIZE] ;
      lbl_SizeDifference.Caption := MSGS [msg_SIZE_DIFFERENCE] ;
      lbl_Id3v1.Caption := MSGS [msg_ID3V1] ;
      lbl_BravaTag.Caption := MSGS [msg_BRAVA_TAG] ;
      lbl_LastFrame.Caption := MSGS [msg_LAST_FRAME] ;
      lbl_SynchroErrors.Caption := MSGS [msg_SYNCHRO_ERRORS] ;
      lbl_SynchroLast.Caption := MSGS [msg_LAST_OK_FRAME_FOUND] ;
      lbl_SynchroExpected.Caption := MSGS [msg_NEXT_EXPECTED_FRAME] ;
      lbl_SynchroFound.Caption := MSGS [msg_NEXT_FRAME_FOUND] ;
      lbl_SynchroDifference.Caption := MSGS [msg_SYNCHRO_DIFFERENCE] ;
    end ;

end.

