unit FilUtils;

// general unit for reading file information
// TestMp3 uses GetFullVersion and LongFileSize
// (c) 2002 Frederic DA VITORIA

interface

  type
    Str13 = string [13] ;

  procedure GetFullVersion (fn : string ;
                            var FileVersion, ProductVersion, OperatingSystem,
                                FileType, FileDescription, LegalCopyright,
                                StringVersion, Comments : ShortString ;
                            var Patched, PreRelease, PrivateBuild, SpecialBuild : boolean) ;
  procedure GetWin32Data (fn : string ;
                          var Creation, LastWrite, LastAccess : TDateTime ;
                          var ShortName : str13) ;
  function LongFileSize (fn : string) : cardinal ;

implementation

  uses SysUtils, Windows ;

  procedure GetFullVersion (fn : string ;
                            var FileVersion, ProductVersion, OperatingSystem,
                                FileType, FileDescription, LegalCopyright,
                                StringVersion, Comments : ShortString ;
                            var Patched, PreRelease, PrivateBuild, SpecialBuild : boolean) ;
  type
    CharArr = array [0..1000] of char ;
  var
    dwf : longint ;
    fHnd  : tHandle;
    FixedInfoLength : UINT ;
    fName : array[0..512] of Char;
    LanguageLength : UINT ;
    pFixedFileInfo : pointer ;
    pLanguageInfo : pointer ;
    pVersion : pointer ;
    pVersionInfo : pointer ;
    VersionLength : UINT ;
    VersionSize  : integer ;
    VersionString : array [1..1024] of char ;
  procedure GetString (sstr : string ; var DStr : ShortString) ;
    var i : integer ;
    begin
      StrFmt (Addr (VersionString),
              PChar ('\\StringFileInfo\\%4.4X%4.4X\\'+sstr),
              [pWordArray (pLanguageInfo)^ [0],
               pWordArray (pLanguageInfo)^ [1]]) ;
      if VerQueryValue (pVersion, Addr (VersionString),
                        pVersionInfo, VersionLength)
        then for i := 0 to (VersionLength-1) do
          System.Insert (CharArr (pVersionInfo^) [i],
                         DStr, 255) ;
    end ;
  begin
    StrPCopy (fName, fn) ;
    FileDescription := '' ;
    FileType := '' ;
    FileVersion := '' ;
    LegalCopyright := '' ;
    OperatingSystem := '' ;
    ProductVersion := '' ;
    StringVersion := '' ;
    Comments := '' ;
    Patched := FALSE ;
    PreRelease := FALSE ;
    PrivateBuild := FALSE ;
    SpecialBuild := FALSE ;
    VersionSize := GetFileVersionInfoSize (fName, fHnd) ;
    if VersionSize > 0
      then begin
        GetMem (pVersion, VersionSize) ;
        if pVersion <> NIL
          then try
            if GetFileVersionInfo (fName, 0, VersionSize, pVersion)
              then begin
                if VerQueryValue (pVersion, '\', pFixedFileInfo, FixedInfoLength)
                  then with PVSFixedFileInfo (pFixedFileInfo)^ do begin
                    FileVersion :=  IntToStr (LongRec (dwFileVersionMS).Hi)+'.'
                                   +IntToStr (LongRec (dwFileVersionMS).Lo)+'.'
                                   +IntToStr (LongRec (dwFileVersionLS).Hi)+'.'
                                   +IntToStr (LongRec (dwFileVersionLS).Lo) ;
                    ProductVersion :=  IntToStr (LongRec (dwProductVersionMS).Hi)
                                      +'.'
                                      +IntToStr (LongRec (dwProductVersionMS).Lo)
                                      +'.'
                                      +IntToStr (LongRec (dwProductVersionLS).Hi)
                                      +'.'
                                      +IntToStr (LongRec (dwProductVersionLS).Lo) ;
                    dwf := dwFileFlags and dwFileFlagsMask ;
                    Patched := (dwf and VS_FF_PATCHED) <> 0 ;
                    PreRelease := (dwf and VS_FF_PRERELEASE) <> 0 ;
                    PrivateBuild := (dwf and VS_FF_PRIVATEBUILD) <> 0 ;
                    SpecialBuild := (dwf and VS_FF_SPECIALBUILD) <> 0 ;
                    case dwFileOS of
                      VOS_DOS : OperatingSystem := 'DOS' ;
                      VOS_NT : OperatingSystem := 'NT' ;
                      VOS__WINDOWS16 : OperatingSystem := 'Windows 3.X' ;
                      VOS__WINDOWS32 : OperatingSystem := 'Windows 32 bits' ;
                      VOS_DOS_WINDOWS16 : OperatingSystem := 'Windows 16 bits + DOS' ;
                      VOS_DOS_WINDOWS32 : OperatingSystem := 'Windows 32 bits + DOS' ;
                      VOS_NT_WINDOWS32 : OperatingSystem := 'Windows 32 bits + NT' ;
                    end {case} ;
                    case dwFileType of
                      VFT_APP : FileType := 'Application' ;
                      VFT_DLL : FileType := 'DLL' ;
                      VFT_DRV : case dwFileSubType of
                        VFT2_DRV_COMM : FileType := 'Pilote communications' ;
                        VFT2_DRV_PRINTER : FileType := 'Pilote imprimante' ;
                        VFT2_DRV_KEYBOARD : FileType := 'Pilote clavier' ;
                        VFT2_DRV_LANGUAGE : FileType := 'Pilote langage' ;
                        VFT2_DRV_DISPLAY : FileType := 'Pilote affichage' ;
                        VFT2_DRV_MOUSE : FileType := 'Pilote souris' ;
                        VFT2_DRV_NETWORK : FileType := 'Pilote rseau' ;
                        VFT2_DRV_SYSTEM : FileType := 'Pilote systme' ;
                        VFT2_DRV_INSTALLABLE : FileType := 'Pilote installable' ;
                        VFT2_DRV_SOUND : FileType := 'Pilote son' ;
                      end {case} ;
                      VFT_FONT : case dwFileSubType of
                        VFT2_FONT_RASTER : FileType := 'Police matricielle' ;
                        VFT2_FONT_VECTOR : FileType := 'Police vectorielle' ;
                        VFT2_FONT_TRUETYPE : FileType := 'Police TrueType' ;
                      end {font} ;
                      VFT_VXD : FileType := 'Priphrique virtuel' ;
                      VFT_STATIC_LIB : FileType := 'Librairie statique' ;
                    end {case}
                  end {then} ;
                if VerQueryValue (pVersion, '\\VarFileInfo\\Translation',
                                  pLanguageInfo, LanguageLength)
                  then begin
                    GetString ('FileDescription', FileDescription) ;
                    GetString ('LegalCopyright', LegalCopyright) ;
                    GetString ('FileVersion', StringVersion) ;
                    GetString ('Comments', Comments) ;
                  end {then}
              end {then}
          finally FreeMem (pVersion, VersionSize) end {finally}
      end {then}
  end ;

  procedure GetWin32Data (fn : string ;
                          var Creation, LastWrite, LastAccess : TDateTime ;
                          var ShortName : str13) ;
  var
    f : TSearchRec ;
    st : TSystemTime ;
  begin
    if FindFirst (fn, faAnyFile, f) = 0
      then with f.FindData do begin
        FileTimeToSystemTime (ftCreationTime, st) ;
        with st do
          Creation :=   EncodeDate (wYear, wMonth, wDay)
                      + EncodeTime (wHour, wMinute, wSecond, wMilliSeconds) ;
        FileTimeToSystemTime (ftLastWriteTime, st) ;
        with st do
          LastWrite :=   EncodeDate (wYear, wMonth, wDay)
                       + EncodeTime (wHour, wMinute, wSecond, wMilliSeconds) ;
        FileTimeToSystemTime (ftLastAccessTime, st) ;
        with st do
          LastAccess := EncodeDate (wYear, wMonth, wDay) + 1 ;
        ShortName := cAlternateFileName
      end {then}
      else begin
        Creation := 0 ;
        LastWrite := 0 ;
        LastAccess := 0 ;
        ShortName := ''
      end {else}
  end ;

  function LongFileSize (fn : string) : cardinal ;
  var f : TSearchRec ;
  begin
    if FindFirst (fn, faAnyFile, f) = 0
      then (*with f.FindData do begin
      end {then} *)
      result := f.Size
      else result := 0
  end ;

end.
