unit About;

// (c) 2002 Frederic DA VITORIA

interface

uses Classes, Forms, Controls, StdCtrls,
  Buttons, ExtCtrls, Graphics,
  FilUtils,
  Translation; // GetFullVersion TFileName

type
  Tfrm_About = class(TForm)
    Panel1: TPanel;
    ProgramIcon: TImage;
    lbl_ProductName: TLabel;
    lbl_Version: TLabel;
    lbl_Copyright: TLabel;
    lbl_Comments: TLabel;
    OKButton: TButton;
    lbl_OtherComponents: TLabel;
    Label1: TLabel;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frm_About : Tfrm_About;

implementation

{$R *.dfm}

procedure Tfrm_About.FormCreate(Sender: TObject);
{$OPTIMIZATION OFF}
  var
    file_version, product_version, operating_system,
    file_type, file_description, legal_copyright,
    string_version, comments : ShortString ;
    patched, pre_release, private_build, special_build : boolean ;
  begin
    Caption := MSGS [msg_ABOUT_TITLE] ;
    GetFullVersion (ParamStr (0),
                    file_version, product_version, operating_system,
                    file_type, file_description, legal_copyright,
                    string_version, comments,
                    patched, pre_release, private_build, special_build) ;
    lbl_Comments.Caption := comments ;
    lbl_Comments.Width := Panel1.Width - 2 * lbl_Comments.Left ;
    lbl_Copyright.Caption := 'Copyright ' + legal_copyright ;
    lbl_ProductName.Caption := file_description ;
    ProgramIcon.Picture.Graphic := Application.Icon ;
    lbl_Version.Caption := file_version
  end;

end.

