unit ri_test1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, Grids, MPHexEditor, ComCtrls,
  rgnimg, inifiles;

type
  Tfmri_test = class(TForm)
    StatusBar1: TStatusBar;
    Panel1: TPanel;
    Panel2: TPanel;
    Panel3: TPanel;
    Label1: TLabel;
    cbCountries: TComboBox;
    Bevel1: TBevel;
    Panel4: TPanel;
    edInfo: TRichEdit;
    RegionImage1: TmpRegionImage;
    Panel5: TPanel;
    Button2: TButton;
    procedure cbCountriesSelect(Sender: TObject);
    procedure RegionImage1SelectionChange(Sender: TObject);
    procedure LoadPkg(sFile: string);
    procedure FormCreate(Sender: TObject);
    procedure Panel2MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: integer);
    procedure FormDestroy(Sender: TObject);
    procedure RegionImage1DblClick(Sender: TObject);
    procedure RegionImage1LeaveRegion(Sender: TObject;
      const AIndex: integer);
    procedure RegionImage1EnterRegion(Sender: TObject;
      const AIndex: integer);
    procedure Button2Click(Sender: TObject);
  private
    { Private-Deklarationen }
    slInfo,
    slHeader: TStrings;
    slMulti: TStrings;
    sMulti: string;
    sIni: TMemIniFile;
    procedure FillEdit(sD: string);
    function FindIniSection(s: string): string;
    procedure MultiSelFillEdit;
  public
    { Public-Deklarationen }
  end;

var
  fmri_test: Tfmri_test;

implementation

uses rgnpkg;

{$R *.dfm}

procedure Tfmri_test.cbCountriesSelect(Sender: TObject);
var
  s: string;
begin
  with cbCountries do
    s := Items[ItemIndex];

  with RegionImage1 do
    ItemIndex := IndexOfStrTag(FindIniSection(s));
end;

procedure Tfmri_test.RegionImage1SelectionChange(Sender: TObject);
var
  i, j: integer;
begin
  with RegionImage1 do
  begin
    if SelCount < 2 then
    begin
      i := ItemIndex;
      if i > -1 then
      begin
        j := i;
        i := cbCountries.Items.IndexOf(sIni.ReadString(StrTag[i], 'title', ''));
        FillEdit(StrTag[j]);
      end
      else
        edInfo.Text := '';
      cbCountries.ItemIndex := i;
    end
    else
    begin
      edInfo.Text := '';
      cbCountries.ItemIndex := -1;
      MultiSelFillEdit;
    end;
  end;
end;

procedure Tfmri_test.LoadPkg(sFile: string);
var
  i: integer;
begin
  cbCountries.Clear;
  slHeader.Clear;
  slInfo.Clear;
  edInfo.Clear;
  sIni.Rename(ChangeFileExt(sFile, '.ini'), True);
  sIni.UpdateFile;

  with RegionImage1 do
  begin
    ItemIndex := -1;
    Regions.Text := '';
    LoadRegionImage(RegionImage1, sFile);
    for i := 0 to Pred(RegionsCount) do
      cbCountries.Items.Add(sIni.ReadString(StrTag[i], 'title', ''));
    cbCountries.Sorted := True;
  end;

  Caption := Format('TRegionImage-Beispiel (%s)',
    [sIni.ReadString('options', 'title', '')]);
  slMulti.CommaText := sIni.ReadString('options', 'multi-data', '');
  sMulti := sIni.ReadString('options', 'multi', '%s');
  slHeader.CommaText := sIni.ReadString('options', 'headers', '');
  with slHeader
  do
    for i := 0 to Pred(Count)
    do
      Objects[i] := Pointer(sIni.ReadInteger('options',IntToStr(i),1));
end;

procedure Tfmri_test.FormCreate(Sender: TObject);
begin
  slInfo := TStringList.Create;
  slHeader := TStringList.Create;
  slMulti := TStringList.Create;
  sIni := TMemIniFile.Create('');
  LoadPkg('EU.pkg');
end;

procedure Tfmri_test.Panel2MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: integer);
begin
  Panel2.SetFocus;
end;

procedure Tfmri_test.FormDestroy(Sender: TObject);
begin
  slInfo.Free;
  slHeader.Free;
  slMulti.Free;
end;

procedure Tfmri_test.FillEdit(sD: string);
var
  i,f: integer;
  sl: TStrings;
  s: string;
begin
  edInfo.Clear;
  sl := TStringList.Create;
  try
    sl.CommaText := sIni.ReadString(sD, 'items', '');
    if sl.Count = slHeader.Count then
    begin
      for i := 0 to Pred(sl.Count) do
        with edInfo do
        begin
          Paragraph.FirstIndent := 0;
          SelAttributes.Style := [fsBold];
          SelAttributes.Size := 11;
          SelAttributes.Color := clNavy;
          Lines.Add(' ' + slHeader[i] + ':');

          Paragraph.FirstIndent := 8;
          SelAttributes.Style := [fsBold];
          SelAttributes.Size := 10;
          SelAttributes.Color := clWindowText;
          s := sl[i];
          f := Integer(slHeader.Objects[i]);
          if f <> 1 then
          begin
            s := FormatFloat(',0.##', StrToInt(s) / f);
          end;
          Lines.Add(s + #13#10);
        end;
    end
    else
      LoadPkg(sD + '.pkg');
  finally
    sl.Free;
  end;
end;

procedure Tfmri_test.RegionImage1DblClick(Sender: TObject);
var
  s: string;
begin
  with RegionImage1 do
    if ItemIndex > -1 then
    begin
      s := StrTag[ItemIndex];
      if FileExists(s + '.pkg') then
        LoadPkg(s + '.pkg');
    end;
end;

procedure Tfmri_test.RegionImage1LeaveRegion(Sender: TObject;
  const AIndex: integer);
begin
  StatusBar1.SimpleText := '';
end;

procedure Tfmri_test.RegionImage1EnterRegion(Sender: TObject;
  const AIndex: integer);
begin
  with RegionImage1 do
    StatusBar1.SimpleText := sIni.ReadString(StrTag[AIndex], 'title', '')
end;

function Tfmri_test.FindIniSection(s: string): string;
var
  i: integer;
begin
  Result := '';
  sIni.ReadSections(slInfo);
  for i := 0 to Pred(slInfo.Count) do
    if sIni.ReadString(slInfo[i], 'Title', '') = s then
    begin
      Result := slInfo[i];
      Break;
    end;
end;

procedure Tfmri_test.Button2Click(Sender: TObject);
begin
  Close;
end;

function DelimitText(sl: TStrings): string;
var
  i: Integer;
begin
  with sl
  do
    for i := 0 to Pred(Count) do
    begin
      Result:=Result+sl[i];
      if i < Pred(sl.Count)
      then
        Result := Result+', ';
    end;
end;

procedure Tfmri_test.MultiSelFillEdit;
var
  sl: TStrings;
  i,j,k: Integer;
  s: string;
begin
  with edInfo do
  begin
    Clear;
    sl := TStringList.Create;
    try
      with RegionImage1
      do
        for i := 0 to Pred(RegionsCount)
        do
          if Selected[i] and (sIni.ReadString(StrTag[i],'items','') <> '')
          then
            sl.Add(sIni.ReadString(StrTag[i],'title',''));
      Paragraph.FirstIndent := 0;
      SelAttributes.Style := [fsBold];
      SelAttributes.Size := 11;
      SelAttributes.Color := clNavy;
      Lines.Add(Format(sMulti,[DelimitText(sl)]));
      Lines.Add('');

      for i := 0 to Pred(slHeader.Count)
      do
        if slMulti.IndexOf(IntToStr(i)) > -1 then
        begin

          Paragraph.FirstIndent := 0;
          SelAttributes.Style := [fsBold];
          SelAttributes.Size := 11;
          SelAttributes.Color := clNavy;
          Lines.Add(' ' + slHeader[i] + ':');

          k := 0;
          with RegionImage1
          do
            for j := 0 to Pred(RegionsCount)
            do
              if Selected[j] and (sIni.ReadString(StrTag[j],'items','') <> '') then
              begin
                sl.CommaText := sIni.ReadString(StrTag[j], 'items', '');
                k := k + StrToInt(sl[i]);
              end;

          Paragraph.FirstIndent := 8;
          SelAttributes.Style := [fsBold];
          SelAttributes.Size := 10;
          SelAttributes.Color := clWindowText;
          j := Integer(slHeader.Objects[i]);
          if j <> 1
          then
            s := FormatFloat(',0.##', k / j)
          else
            s := IntToStr(k);
          Lines.Add(s + #13#10);
        end;

    finally
      sl.Free;
    end;
  end;
end;

end.
