unit u_zoomwin;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls;

type
  TfmZoom = class(TForm)
    procedure FormPaint(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormCanResize(Sender: TObject; var NewWidth,
      NewHeight: integer; var Resize: boolean);
    procedure FormResize(Sender: TObject);
    procedure FormClick(Sender: TObject);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: integer);
    procedure FormMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: integer);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: integer);
  private
    { Private-Deklarationen }
    FRatio: single;
    FPosRect: TRect;
    FZoomBitmap: TBitmap;
    FDiffY,
    fDiffX: integer;
    FDown: boolean;
    procedure SetPosRect(const Value: TRect);
    procedure SetZoomBitmap(const Value: TBitmap);
    procedure ReCalc;
  public
    { Public-Deklarationen }
    property PosRect: TRect read FPosRect write SetPosRect;
    property ZoomBitmap: TBitmap read FZoomBitmap write SetZoomBitmap;
  end;

var
  fmZoom: TfmZoom;

implementation

uses
  u_main;

{$R *.DFM}

procedure TfmZoom.FormPaint(Sender: TObject);
var
  tRatio: single;
begin
  if Assigned(FZoomBitmap) and (FZoomBitmap.Height > 0) and Visible then
  begin
    Canvas.StretchDraw(Rect(0,0,ClientWidth, ClientHeight), FZoomBitmap);
    if not EqualRect(FPosRect, Rect(0,0,FZoomBitmap.Width - 1, FZoomBitmap.Height - 1)) then
    begin
      // posrect anpassen
      tRatio := ClientHeight / FZoomBitmap.Height;
      Canvas.Rectangle(Round(FPosRect.Left * tRatio),
        Round(FPosRect.Top * tRatio),
        Round(FPosRect.Right * tRatio),
        Round(FPosRect.Bottom * tRatio));
    end;
  end;
end;

procedure TfmZoom.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  fmMain.NotifyZoomOpen(False);
end;

procedure TfmZoom.FormShow(Sender: TObject);
begin
  fmMain.NotifyZoomOpen(True);
end;

procedure TfmZoom.SetPosRect(const Value: TRect);
begin
  if Visible and (not EqualRect(FPosRect, Value)) then
  begin
    FPosRect := Value;
    Paint;
  end;
end;

procedure TfmZoom.FormCreate(Sender: TObject);
begin
  Canvas.Brush.Style := bsDiagCross;
  FRatio := 1;
  FPosRect := Rect(0,0,0,0);
  FZoomBitmap := nil;
  FDiffX := -ClientWidth + Width;
  FDiffY := -ClientHeight + Height;
  FDown := False;
end;

procedure TfmZoom.SetZoomBitmap(const Value: TBitmap);
begin
  FZoomBitmap := Value;
  ReCalc;
end;

procedure TfmZoom.ReCalc;
begin
  try
    if Assigned(FZoomBitmap) and (FZoomBitmap.Width > 0) then
      FRatio := FZoomBitmap.Height / FZoomBitmap.Width
    else
      FRatio := 1;
  except
    FRatio := 1;
  end;
  ClientHeight := Round(FRatio * ClientWidth);
end;

procedure TfmZoom.FormCanResize(Sender: TObject; var NewWidth,
  NewHeight: integer; var Resize: boolean);
begin
  Resize := True;
  NewHeight := Round((NewWidth - FDiffX) * FRatio) + FDiffY;
end;

procedure TfmZoom.FormResize(Sender: TObject);
begin
  Invalidate;
end;

procedure TfmZoom.FormClick(Sender: TObject);
var
  pt: TPoint;
begin
  if Assigned(FZoomBitmap) and (FZoomBitmap.Height > 0) then
  begin
    GetCursorPos(pt);
    pt := ScreenToClient(pt);
    fmMain.SetCenterPos(Round(pt.X * FZoomBitmap.Height / ClientHeight),
      Round(pt.Y * FZoomBitmap.Height / ClientHeight));
  end;
end;

procedure TfmZoom.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: integer);
begin
  FDown := True;
end;

procedure TfmZoom.FormMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: integer);
begin
  FDown := False;
end;

procedure TfmZoom.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: integer);
begin
  if FDown and Assigned(FZoomBitmap) and (FZoomBitmap.Height > 0) then
    fmMain.SetCenterPos(Round(X * FZoomBitmap.Height / ClientHeight),
      Round(Y * FZoomBitmap.Height / ClientHeight));
end;

end.
