unit u_utils;

interface

uses
  Windows, Graphics, Classes, rgnimg;

type
  TToolMode = (tmRect = 1, tmEllipse, tmPoly, tmFill, tmSelect, tmCombi);
  TPoints = array of TPoint;
  TFindRegion = function(x, y: integer): boolean of object;

function IsKeyDown(iVK: integer): boolean;

  // by Brendan Delumpa
function BitmapToRegion(bmp: TBitmap): HRGN;

  // by Ing.Bro R.Tschaggelar
procedure GrassfireFill(clMax, clMin: DWord; // min, max color
  xMax, yMax: integer;  // max coords
  x, y: integer;         // coords
  cvRead, cvSet: TCanvas;
  bInterior: boolean;
  BoundRegions: TIntArray;
  OnUpdate: TNotifyEvent);

function ExtractDescription(var s: string; var cmd: char): string;
function SplitCoords(s: string): TIntArray;

implementation

uses
  SysUtils;

function IsKeyDown(iVK: integer): boolean;
begin
  Result := (GetAsyncKeyState(iVK) and (not 1)) <> 0;
end;

// By Brendan Delumpa
function BitmapToRegion(bmp: TBitmap): HRGN;  
var
  ix, iy: integer;    // loop variables
  b1: boolean;    // am looking through "real"
  c1: cardinal;   // region helper variable
  i1: integer;    // first position of real pixel
begin
  Result := 0;
  i1 := 0;
  with bmp.canvas do
    // scan through all lines
    for iy := 0 to bmp.Height - 1 do
    begin
      b1 := False;
      // scan through all pixels in this line
      for ix := 0 to bmp.Width - 1 do
        // did we find the first/last real pixel in a row
        if (pixels[ix, iy] <> clWhite) <> b1 then
        begin
          // yes, and it was the last pixel,
          //so we can add a line style region...
          if b1 then
          begin
            c1 := CreateRectRgn(i1, iy, ix, iy + 1);
            if Result <> 0 then
            begin
              // it's not the first region
              CombineRgn(Result, Result, c1, RGN_OR);
              DeleteObject(c1);
              // it's the first region
            end
            else
              Result := c1;
          end
          else
            i1 := ix;
          // change mode, looking for the first or last real pixel?
          b1 := not b1;
        end;
      // was the last pixel in this row a real pixel?
      if b1 then
      begin
        c1 := CreateRectRgn(i1, iy, bmp.Width - 1, iy + 1);
        if (Result <> 0) then
        begin
          CombineRgn(Result, Result, c1, RGN_OR);
          DeleteObject(c1);
        end
        else
          Result := c1;
      end;
    end;
end;

// by Ing.Bro R.Tschaggelar
procedure GrassfireFill(clMax, clMin: DWord; // min, max color
  xMax, yMax: integer;  // max coords
  x, y: integer;         // coords
  cvRead, cvSet: TCanvas;
  bInterior: boolean;
  BoundRegions: TIntArray;
  OnUpdate: TNotifyEvent);
type
  pixel = TPoint;
  pixellist = array of TPoint;
var
  processlist, nextlist: pixellist;
  cp: pixel;


  procedure push(var list: pixellist; const ax, ay: integer);
  begin
    SetLength(list, Succ(Length(list)));
    with List[Pred(Length(List))] do
    begin
      x := ax;
      y := ay;
    end;
  end;

  function pop(var list: pixellist): pixel;
  begin
    if list = nil then
      Result.X := MaxInt
    else
    begin
      Result := list[Pred(Length(list))];
      SetLength(list, Pred(Length(list)));
    end;
  end;

  function ColorInRange(clQuery, clMin, clMax: DWORD): boolean;
  var
    R, G, B: byte;
  begin
    R := GetRValue(clQuery);
    G := GetGValue(clQuery);
    B := GetBValue(clQuery);
    Result := (R <= GetRValue(clMax)) and
      (G <= GetGValue(clMax)) and
      (B <= GetBValue(clMax)) and
      (R >= GetRValue(clMin)) and
      (G >= GetGValue(clMin)) and
      (B >= GetBValue(clMin));
  end;

  function inside(x, y: integer): boolean;
  begin
    Result := not ((x < 0) or (y < 0) or (x >= xMax) or (y >= yMax))
  end;

  procedure gf(x, y: integer);
  var
    i: integer;
  begin
    if IsKeyDown(VK_ESCAPE) then
      Abort;

    if ColorInRange(ColorToRGB(cvRead.Pixels[x, y]), clMin, clMax) <> bInterior then
      Exit;

    if cvSet.Pixels[x, y] <> clWhite then
      Exit;


    for i := 0 to Pred(Length(BoundRegions)) do
      if PtInRegion(BoundRegions[i], x, y) then
        Exit;

    cvSet.Pixels[x, y] := clBlack;
    cvRead.Pixels[x, y] := clRed;

    if inside(x, y + 1) then push(nextlist, x, y + 1);
    //if inside(x-1,y-1) then push(nextlist, x-1,y-1);
    if inside(x - 1,y) then push(nextlist, x - 1,y);
    //if inside(x-1,y+1) then push(nextlist, x-1,y+1);
    if inside(x, y - 1) then push(nextlist, x, y - 1);
    //if inside(x+1,y-1) then push(nextlist, x+1,y-1);
    if inside(x + 1,y) then push(nextlist, x + 1,y);
    //if inside(x+1,y+1) then push(nextlist, x+1,y+1);
  end;
var
  tc: cardinal;
begin
  tc := GetTickCount;
  push(processlist, x, y);  // start with give pixel
  repeat
    nextlist := nil;
    cp := pop(processlist);             // loop over all pixels in the list
    while cp.X <> MaxInt do
    begin
      gf(cp.x, cp.y);                 // pushes all next pixels onto list
      cp := pop(processlist);
    end;
    if (GetTickCount - tc) > 25 then
    begin
      if Assigned(OnUpdate) then
        OnUpdate(nil);
      tc := GetTickCount;
    end;
    //Application.ProcessMessages;
    processlist := nil;
    processlist := nextlist;           // initiate new round
    nextlist := nil;
  until processlist = nil;
end;

function ExtractDescription(var s: string; var cmd: char): string;
var
  j: integer;
begin
  cmd := #0;
  Result := '';
  j := Pos(';', s);
  if j > 0 then
  begin
    Result := Copy(s, 1,j - 1);
    Delete(s, 1,j);
  end;
  if s <> '' then
  begin
    cmd := s[1];
    Delete(s, 1,2);
  end;
end;

function SplitCoords(s: string): TIntArray;
var
  i, j: integer;
  c: int64;
  s1: string;
begin
  Result := nil;
  repeat
    i := Pos(',', s);
    if i = 0 then
      i := MaxInt;
    s1 := Copy(s, 1, i - 1);
    Delete(s, 1,i);

    if s1 = '' then
      Break;

    if not TryStrToInt64(s1, c) then
    begin
      (*Result := nil;
      Exit;*)
      raise Exception.CreateFmt('Invalid coordinates (%s)', [s1]);
    end
    else
      j := integer(cardinal(c));

    SetLength(Result, Succ(Length(Result)));
    Result[Pred(Length(Result))] := j;

  until s = '';
end;

end.
