unit u_pkg;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, ComCtrls, ExtDlgs;

type
  TdlgPackage = class(TForm)
    GroupBox1: TGroupBox;
    ListBox1: TListBox;
    Button1: TButton;
    Button2: TButton;
    Image1: TImage;
    Label1: TLabel;
    GroupBox2: TGroupBox;
    Button3: TButton;
    Button4: TButton;
    RichEdit1: TRichEdit;
    Button5: TButton;
    Button6: TButton;
    dlgO: TOpenDialog;
    dlgOP: TOpenPictureDialog;
    dlgS: TSaveDialog;
    dlgSP: TSavePictureDialog;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure Button5Click(Sender: TObject);
    procedure Button6Click(Sender: TObject);
  private
    { Private-Deklarationen }
    fBMPS: array [0..2] of TBitmap;
    sFile: string;
    function SelectIn(sTitle, sFilter, sDef: string; bIsBMP: boolean): string;
    function SelectOut(sTitle, sFilter, sDef: string; bIsBMP: boolean): string;
  public
    { Public-Deklarationen }
    function Execute(b1, b2, b3: TBitmap; sl: TStringList; s: string): boolean;
  end;

var
  dlgPackage: TdlgPackage;

implementation

uses u_selpkgbmp, rgnpkg;

{$R *.dfm}

function TdlgPackage.Execute(b1, b2, b3: TBitmap; sl: TStringList; s: string): boolean;
begin
  RichEdit1.Lines.Assign(sl);
  fbmps[0].Assign(b1);
  fbmps[1].Assign(b2);
  fbmps[2].Assign(b3);
  sFile := s;
  ListBox1.ItemIndex := 0;
  ListBox1Click(nil);
  Result := ShowModal = mrOk;
end;

procedure TdlgPackage.FormCreate(Sender: TObject);
begin
  fBMPs[0] := TBitmap.Create;
  fBMPs[1] := TBitmap.Create;
  fBMPs[2] := TBitmap.Create;
end;

procedure TdlgPackage.FormDestroy(Sender: TObject);
begin
  fBMPs[0].Free;
  fBMPs[1].Free;
  fBMPs[2].Free;
end;

procedure TdlgPackage.ListBox1Click(Sender: TObject);
begin
  Image1.Picture.Bitmap.Assign(fBmps[ListBox1.ItemIndex]);
  Label1.Caption := Format('Width: %d Height: %d',
    [Image1.Picture.Bitmap.Width, Image1.Picture.Bitmap.Height]);
  Caption := Format('Package Manager [%s]', [sFile]);
end;

function TdlgPackage.SelectIn(sTitle, sFilter, sDef: string;
  bIsBMP: boolean): string;
var
  dlg: TOpenDialog;
begin
  if bIsBMP then
    dlg := dlgOP
  else
    dlg := dlgO;
  with dlg do
  begin
    Title := sTitle;
    Filter := sFilter;
    DefaultExt := sDef;
    if not Execute then
      Abort;
    Result := FileName;
  end;
end;

function TdlgPackage.SelectOut(sTitle, sFilter, sDef: string;
  bIsBMP: boolean): string;
var
  dlg: TOpenDialog;
begin
  if bIsBMP then
    dlg := dlgSP
  else
    dlg := dlgS;
  with dlg do
  begin
    Title := sTitle;
    Filter := sFilter;
    DefaultExt := sDef;
    if not Execute then
      Abort;
    Result := FileName;
  end;
end;

procedure TdlgPackage.Button1Click(Sender: TObject);
var
  s: string;
begin
  s := SelectOut('Save ' + ListBox1.Items[ListBox1.ItemIndex] + ' as',
    'Bitmap files (*.bmp)|*.bmp', 'bmp', True);
  fBMPs[ListBox1.ItemIndex].SaveToFile(s);
end;

procedure TdlgPackage.Button2Click(Sender: TObject);
var
  s: string;
  i: integer;
begin
  s := SelectIn('Import ' + ListBox1.Items[ListBox1.ItemIndex],
    'Supported files (*.bmp, *.pkg)|*.bmp;*.pkg', 'bmp', True);
  if LowerCase(ExtractFileExt(s)) = '.pkg' then
  begin
    i := SelectPKGBitmap(ListBox1.ItemIndex);
    case i of
      0: ExtractPackage(s, fBMPs[ListBox1.ItemIndex], nil, nil, nil);
      1: ExtractPackage(s, nil, fBMPs[ListBox1.ItemIndex], nil, nil);
      2: ExtractPackage(s, nil, nil, fBMPs[ListBox1.ItemIndex], nil);
      else
        Abort;
    end;
  end
  else
    fBMPs[ListBox1.ItemIndex].LoadFromFile(s);
  ListBox1Click(nil);
end;

procedure TdlgPackage.Button3Click(Sender: TObject);
var
  sl: TStringList;
begin
  if sFile = '' then
  try
    sFile := SelectOut('Save package as', 'Package files (*.pkg)|*.pkg', 'pkg', True);
  except
    ModalResult := mrNone;
    Raise;
  end;
  Screen.Cursor := crHourGlass;
  sl := TStringList.Create;
  try
    sl.Assign(RichEdit1.Lines);
    CollectPackage(sFile, fBMPs[0], fBMPs[1], fBMPs[2], sl);
  finally
    sl.Free;
    Screen.Cursor := crDefault;
  end;
end;

procedure TdlgPackage.Button5Click(Sender: TObject);
var
  s: string;
begin
  s := SelectOut('Save Regions list as', 'Supported files (*.map, *.txt)|*.map;*.txt',
    'map', False);
  RichEdit1.Lines.SaveToFile(s);
end;

procedure TdlgPackage.Button6Click(Sender: TObject);
var
  s: string;
  sl1: TStringList;
begin
  s := SelectIn('Import Regions list',
    'Supported files (*.map, *.txt, *.pkg)|*.map;*.txt;*.pkg', 'map', False);
  if LowerCase(ExtractFileExt(s)) = '.pkg' then
  begin
    sl1 := TStringList.Create;
    try
      ExtractPackage(s, nil, nil, nil, sl1);
      RichEdit1.Lines.Assign(sl1);
    finally
      sl1.Free;
    end
  end
  else
    RichEdit1.Lines.LoadFromFile(s);
  ListBox1Click(nil);
end;

end.
