unit u_main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, Buttons, StdCtrls, Menus, ComCtrls, ToolWin, ImgList, ExtDlgs, u_utils,
  ActnList, AppEvnts;

type
  TfmMain = class(TForm)
    ScrollBox1: TScrollBox;
    Leinwand: TPaintBox;
    pmLeinwand: TPopupMenu;
    pm21: TMenuItem;
    pm22: TMenuItem;
    pm23: TMenuItem;
    ImageList1: TImageList;
    dlgOpen: TOpenPictureDialog;
    dlgSave: TSaveDialog;
    Changedescription1: TMenuItem;
    N2: TMenuItem;
    Combine1: TMenuItem;
    N1: TMenuItem;
    bStatus: TStatusBar;
    ToolBar2: TToolBar;
    tbx1: TToolButton;
    tbx2: TToolButton;
    ToolButton2: TToolButton;
    tbx4: TToolButton;
    ToolButton3: TToolButton;
    tbx5: TToolButton;
    Panel1: TPanel;
    ToolBar1: TToolBar;
    pbZoom: TPaintBox;
    Bevel1: TBevel;
    Bevel2: TBevel;
    tbx6: TToolButton;
    tbx3: TToolButton;
    ActionList1: TActionList;
    acOpen: TAction;
    acSave: TAction;
    acUndo: TAction;
    acZoomIn: TAction;
    acZoomOut: TAction;
    acZoomWin: TAction;
    acRegList: TAction;
    ToolButton1: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    ToolButton6: TToolButton;
    ToolButton7: TToolButton;
    ToolButton8: TToolButton;
    acTRect: TAction;
    acTEllipse: TAction;
    acTPolygon: TAction;
    acTFill: TAction;
    acTCombi: TAction;
    acTSelect: TAction;
    acSaveAs: TAction;
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    Edit1: TMenuItem;
    View1: TMenuItem;
    ools1: TMenuItem;
    help1: TMenuItem;
    Open1: TMenuItem;
    Save1: TMenuItem;
    Saveas1: TMenuItem;
    N3: TMenuItem;
    Exit1: TMenuItem;
    Undo1: TMenuItem;
    Zoomin1: TMenuItem;
    Zoomout1: TMenuItem;
    Zoom1: TMenuItem;
    N4: TMenuItem;
    x11: TMenuItem;
    x21: TMenuItem;
    x41: TMenuItem;
    x81: TMenuItem;
    Zoomwindow1: TMenuItem;
    Regionslist1: TMenuItem;
    RectangleSquare1: TMenuItem;
    EllipseCircle1: TMenuItem;
    Polygon1: TMenuItem;
    Fill1: TMenuItem;
    Combine2: TMenuItem;
    Select1: TMenuItem;
    About1: TMenuItem;
    acNewPackage: TAction;
    acModifyPackage: TAction;
    Package1: TMenuItem;
    Createpackage1: TMenuItem;
    Modifypackage1: TMenuItem;
    dlgSelect: TOpenPictureDialog;
    Index1: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure LeinwandPaint(Sender: TObject);
    procedure LeinwandMouseMove(Sender: TObject; Shift: TShiftState; aX,
      aY: integer);
    procedure ScrollBox1MouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: integer);
    procedure mnZoomIndexClick(Sender: TObject);
    procedure ToolButton4Click(Sender: TObject);
    procedure Zoom1Click(Sender: TObject);
    procedure ScrollBox1Resize(Sender: TObject);
    procedure LeinwandMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; aX, aY: integer);
    procedure LeinwandMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; aX, aY: integer);
    procedure FormKeyDown(Sender: TObject; var Key: word;
      Shift: TShiftState);
    procedure pbZoomPaint(Sender: TObject);
    procedure LeinwandDblClick(Sender: TObject);
    procedure pm23Click(Sender: TObject);
    procedure Changedescription1Click(Sender: TObject);
    procedure pm21Click(Sender: TObject);
    procedure pm22Click(Sender: TObject);
    procedure pmLeinwandPopup(Sender: TObject);
    procedure Combine1Click(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: boolean);
    procedure ApplicationEvents1Idle(Sender: TObject; var Done: boolean);
    procedure acUndoExecute(Sender: TObject);
    procedure acUndoUpdate(Sender: TObject);
    procedure acZoomOutExecute(Sender: TObject);
    procedure acZoomWinExecute(Sender: TObject);
    procedure acRegListExecute(Sender: TObject);
    procedure acToolExec(Sender: TObject);
    procedure acSaveUpdate(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure tbx4Click(Sender: TObject);
    procedure acZoomInUpdate(Sender: TObject);
    procedure acZoomOutUpdate(Sender: TObject);
    procedure acZoomInExecute(Sender: TObject);
    procedure acOpenExecute(Sender: TObject);
    procedure acSaveExecute(Sender: TObject);
    procedure acSaveAsExecute(Sender: TObject);
    procedure acSaveAsUpdate(Sender: TObject);
    procedure btnOKClick(Sender: TObject);
    procedure btnCancelClick(Sender: TObject);
    procedure About1Click(Sender: TObject);
    procedure acNewPackageUpdate(Sender: TObject);
    procedure acNewPackageExecute(Sender: TObject);
    procedure acModifyPackageUpdate(Sender: TObject);
    procedure acModifyPackageExecute(Sender: TObject);
    procedure Index1Click(Sender: TObject);
  private
    { Private-Deklarationen }
    iZoom: integer;
    bmpWork, bmpTmp: TBitmap;
    slMap: TStringList;
    eToolMode: TToolMode;
    sUndo: string;
    bUndo: boolean;
    bTooling: boolean;
    bWorkIsPKG: boolean;
    iDownX, iDownY, iMoveX, iMoveY: integer;
    aPolyPoints: TPoints;
    bBeginPoly: boolean;
    FItemIndex: integer;
    hSelect: HRGN;
    bPopUp: boolean;
    FModified: boolean;
    sWorkFile: string;
    procedure UpdateBild;
    function GetVisibleRect: TRect;
    function GetVisibleZRect: TRect;
    procedure UpdateZoom(iNew: integer);
    function AdjustLeinwandRect(X, Y: integer): boolean;
    procedure DrawMaps;
    procedure DrawMap(i: integer);
    procedure AddPolyPoint(X, Y: integer);
    function AdjustDrawRect(x1, y1, x2, y2: integer): TRect;
    procedure DrawInMove;
    procedure GetFillMap(X, Y: integer);
    function FindRegionAtPos(X, Y: integer): integer;
    function CreateRegionFromString(iIndex: integer): HRGN;
    procedure ClearHSelect;
    procedure MoveRegion(Index, dX, dY: integer);
    procedure SetItemIndex(iNew: integer);
    procedure DeleteCurrent;
    procedure Combine(i1, i2: integer);
    procedure MapChanged(Sender: TObject);
    procedure SetModified(const Value: boolean);
    function CheckModified: boolean;
    procedure OnGFF(Sender: TObject);
    procedure UndoPossible(b: boolean);
    procedure SaveTo(sFile: string; bIsPKG: boolean; bmp1, bmp2, bmp3: TBitmap;
      sl: TStringList);
    procedure SelectBitmap(b: TBitmap; const sTitle: string);
    procedure SetFileCaption(const Value: string);
    property FileCaption: string write SetFileCaption;
    procedure LoadFrom(sFile: string);
    procedure WMUser(var Msg: TMsg); message WM_USER;
  public
    { Public-Deklarationen }
    procedure NotifyZoomOpen(bOpen: boolean);
    procedure NotifyListOpen(bOpen: boolean);
    procedure SetCenterPos(X, Y: integer);
    procedure ChangeDescription(Index: integer);
    property Modified: boolean read FModified write SetModified;
    property Regions: TStringList read slMap;
    property ItemIndex: integer read FItemIndex write SetItemIndex;
  end;

var
  fmMain: TfmMain;


implementation

uses
  Sysconst, u_zoomwin, u_fillopts, Math, rgnimg, u_listwin, rgnpkg, u_about,
  u_pkg;

{$R *.DFM}
{$R mecursor.res}


type
  TModStringList = class(TStringList)
  protected
    procedure Put(Index: integer; const S: string); override;
  end;


  { TfmMain }

function TfmMain.GetVisibleRect: TRect;
begin
  with ScrollBox1 do
  begin
    Result.Left := HorzScrollBar.ScrollPos;
    Result.Top := VertScrollBar.ScrollPos;
    Result.Right := ClientWidth + Result.Left;
    Result.Bottom := ClientHeight + Result.Top;

    if Result.Right >= Leinwand.Width then
      Result.Right := Pred(Leinwand.Width);

    if Result.Bottom >= Leinwand.Height then
      Result.Bottom := Pred(Leinwand.Height);
  end;
  //Result := Leinwand.Canvas.ClipRect;
end;


procedure TfmMain.UpdateBild;
begin
  Leinwand.Width := bmpWork.Width * iZoom;
  Leinwand.Height := bmpWork.Height * iZoom;
  bStatus.Panels[2].Text := Format('Z: %d', [iZoom]);
  Leinwand.Invalidate;
end;


procedure TfmMain.FormCreate(Sender: TObject);
begin
  Application.HelpFile := ExtractFilePath(ParamStr(0))+'\hlp\rgnedit.hlp';
  bTooling := False;
  bPopUp := False;
  iZoom := 1;
  FItemIndex := -1;
  bmpWork := TBitmap.Create;
  hSelect := 0;
  slMap := TModStringList.Create;
  bmpTmp := TBitmap.Create;
  eToolMode := tmSelect;
  bBeginPoly := True;
  with pbZoom do
    ControlStyle := ControlStyle + [csOpaque];
  with Leinwand do
  begin
    ControlStyle := ControlStyle + [csOpaque];
    Width := 0;
    Height := 0;
  end;

  // cursors laden
  Screen.Cursors[integer(tmRect)] := LoadCursor(HINSTANCE, 'CUR_RECT');
  Screen.Cursors[integer(tmEllipse)] := LoadCursor(HINSTANCE, 'CUR_CIRCLE');
  Screen.Cursors[integer(tmPoly)] := LoadCursor(HINSTANCE, 'CUR_POLY');
  Screen.Cursors[integer(tmFill)] := LoadCursor(HINSTANCE, 'CUR_FILL');
  Screen.Cursors[integer(tmSelect)] := Screen.Cursors[crArrow];
  Screen.Cursors[integer(tmCombi)] := LoadCursor(HINSTANCE, 'CUR_COMBI');

  Modified := False;
  slMap.OnChange := MapChanged;
  sUndo := '';
  bUndo := False;
  sWorkFile := '';
  FileCaption := '';
  PostMessage(Handle, WM_USER, 0,0);
end;

procedure TfmMain.FormDestroy(Sender: TObject);
begin
  bmpWork.Free;
  bmpTmp.Free;
  ClearHSelect;
  slMap.Free;
end;


procedure TfmMain.LeinwandPaint(Sender: TObject);
var
  rc: TRect;
begin
  fmZoom.PosRect := GetVisibleZRect;
  bmpTmp.Assign(bmpWork);
  DrawMaps;
  if bTooling then
    DrawInMove;
  //Leinwand.Canvas.StretchDraw(Rect(0,0,Leinwand.Width, Leinwand.Height),bmpTmp);
  rc := GetVisibleZRect;
  Inc(rc.Right);
  Inc(rc.Bottom);
  Dec(rc.Left);
  Dec(rc.Top);
  Leinwand.Canvas.CopyRect(Rect(rc.Left * iZoom, rc.Top * iZoom,
    rc.Right * iZoom, rc.Bottom * iZoom), bmpTmp.Canvas, rc);
end;


procedure TfmMain.LeinwandMouseMove(Sender: TObject; Shift: TShiftState; aX,
  aY: integer);
begin
  bPopUp := False;
  iMoveX := aX div iZoom;
  iMoveY := aY div iZoom;
  bStatus.Panels[0].Text := Format('X: %d', [iMovex]);
  bStatus.Panels[1].Text := Format('Y: %d', [iMovey]);
  pbZoom.Invalidate;

  if bTooling then
  begin
    AdjustLeinwandRect(iMoveX * iZoom, iMoveY * iZoom);
    LeinwandPaint(nil);
  end
end;

procedure TfmMain.NotifyZoomOpen(bOpen: boolean);
begin
  acZoomWin.Checked := bOpen;
  if bOpen then
  begin
    fmZoom.PosRect := GetVisibleZRect;
    fmZoom.ZoomBitmap := bmpWork;
  end;
end;

function TfmMain.GetVisibleZRect: TRect;
begin
  Result := GetVisibleRect;
  Result.Left := Result.Left div iZoom;
  Result.Top := Result.Top div iZoom;
  Result.Right := Result.Right div iZoom;
  Result.Bottom := Result.Bottom div iZoom;
end;

procedure TfmMain.ScrollBox1MouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: integer);
begin
  fmZoom.PosRect := GetVisibleZRect;
end;

procedure TfmMain.SetCenterPos(X, Y: integer);
begin
  try
    ScrollBox1.HorzScrollBar.Position := (X * iZoom) - (ScrollBox1.ClientWidth div 2);
    ScrollBox1.VertScrollBar.Position := (Y * iZoom) - (ScrollBox1.ClientHeight div 2);
  except
  end;
end;

procedure TfmMain.mnZoomIndexClick(Sender: TObject);
begin
  UpdateZoom(TMenuItem(Sender).Tag);
end;

procedure TfmMain.ToolButton4Click(Sender: TObject);
var
  iZoom: integer;
begin
  iZoom := self.iZoom * 2;
  if iZoom > 8 then
    iZoom := 1;
  UpdateZoom(iZoom);
end;

procedure TfmMain.Zoom1Click(Sender: TObject);
begin
  case iZoom of
    1: x11.Checked := True;
    2: x21.Checked := True;
    4: x41.Checked := True;
    8: x81.Checked := True;
  end;
end;

procedure TfmMain.ScrollBox1Resize(Sender: TObject);
begin
  fmZoom.PosRect := GetVisibleZRect;
end;

procedure TfmMain.UpdateZoom(iNew: integer);
var
  rc: TRect;
begin
  if iNew <> iZoom then
  begin
    rc := GetVisibleZRect;
    iZoom := iNew;
    UpdateBild;
    SetCenterPos((rc.Right + rc.Left) div 2, (rc.Bottom + rc.Top) div 2);
  end;
end;

procedure TfmMain.LeinwandMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; aX, aY: integer);
var
  i: integer;
begin
  UndoPossible(True);
  ScrollBox1.SetFocus;
  if not bPopUp then
  begin
    if (ssLeft in Shift) and bBeginPoly then
    begin
      if not bTooling then
        aPolyPoints := nil;
      bTooling := True;
      iDownX := aX div iZoom;
      iDownY := ay div iZoom;
      if eToolMode = tmPoly then
      begin
        // punkt hinzufgen
        AddPolyPoint(iDownX, iDownY);
      end;
      if (eToolMode = tmSelect) then
      begin
        ItemIndex := FindRegionAtPos(iDownX, iDownY);
        //meMap.ItemIndex := iCurrent;
        if ItemIndex > -1 then
          pmLeinwand.AutoPopup := True
        else
          bTooling := False;
      end;
      if (eToolMode = tmCombi) then
      begin
        i := FindRegionAtPos(iDownX, iDownY);
        if (ItemIndex > -1) and (i <> -1) and (i <> ItemIndex) then
          Combine(i, ItemIndex);
        ItemIndex := FindRegionAtPos(iDownX, iDownY);
        if ItemIndex <> -1 then
          pmLeinwand.AutoPopup := True
        else
          bTooling := False;
      end;
      if (eToolMode = tmFill) then
      begin
        if (ssShift in Shift) then
          with fmFillOpts.ColorBox1 do
          begin
            // err...
            Selected := clWhite;
            Update;
            Selected := clBlack;
            Update;
            Selected := bmpTmp.Canvas.Pixels[iDownX, iDownY];
            Update;
          end
        else
        begin
          GetFillMap(iDownX, iDownY);
        end;
        bTooling := False;
      end;
    end;
  end;
  bBeginPoly := True;
  bPopUp := False;
end;

procedure TfmMain.LeinwandMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; aX, aY: integer);
var
  rc: TRect;
begin
  if bTooling and (eToolMode = tmPoly) then
  begin
  end
  else
  begin
    if bTooling then
      case eToolMode of
        tmRect:
          begin
            rc := AdjustDrawRect(iDownX, iDownY, iMoveX, iMoveY);
            slMap.Add(Format('R,%d,%d,%d,%d,', [rc.Left, rc.Top, rc.Right, rc.Bottom]));
            ItemIndex := MaxInt;
          end;
        tmEllipse:
          begin
            rc := AdjustDrawRect(iDownX, iDownY, iMoveX, iMoveY);
            slMap.Add(Format('E,%d,%d,%d,%d,', [rc.Left, rc.Top, rc.Right, rc.Bottom]));
            ItemIndex := MaxInt;
          end;
        tmSelect:
          begin
            MoveRegion(ItemIndex, iMoveX - iDownX, iMoveY - iDownY);
            OffsetRgn(hSelect, iMoveX - iDownX, iMoveY - iDownY);
          end;
      end;
    bTooling := False;
    UpdateBild;
  end;
end;

function TfmMain.AdjustLeinwandRect(X, Y: integer): boolean;
var
  pt: TPoint;
  rc: TRect;
begin
  pt.X := X;
  pt.Y := Y;
  Result := False;
  rc := Leinwand.Canvas.ClipRect;
  if not PtInRect(rc, pt) then
    with ScrollBox1 do
    begin
      if Y <= rc.Top then
      begin
        Result := True;
        VertScrollBar.Position := VertScrollBar.Position - (rc.Top - Y);
      end
      else if Y >= Pred(rc.Bottom) then
      begin
        Result := True;
        VertScrollBar.Position := VertScrollBar.Position + (Y - rc.Bottom);
      end;

      if X <= rc.Left then
      begin
        Result := True;
        HorzScrollBar.Position := HorzScrollBar.Position - (rc.Left - X);
      end
      else if X >= Pred(rc.Right) then
      begin
        Result := True;
        HorzScrollBar.Position := HorzScrollBar.Position + (X - rc.Right);
      end;
    end;
(*  if Result
  then
    Application.ProcessMessages;*)
end;

procedure TfmMain.FormKeyDown(Sender: TObject; var Key: word;
  Shift: TShiftState);
begin
  if Key = VK_ADD then
    acZoomIn.Execute;

  if Key = VK_SUBTRACT then
    acZoomOut.Execute;

  if (Key = VK_ESCAPE) and bTooling then
  begin
    bTooling := False;
    aPolyPoints := nil;
    ClearHSelect;
    UpdateBild;
  end;

  if (Key = VK_ESCAPE) and (eToolMode = tmCombi) then
  begin
    bTooling := False;
    aPolyPoints := nil;
    ItemIndex := -1;
  end;

  if ScrollBox1.Focused then
  begin
    if (Key in [VK_BACK, VK_DELETE]) and bTooling and (eToolMode = tmPoly) then
    begin
      Key := 0;
      if Length(aPolyPoints) < 2 then
      begin
        bTooling := False;
        aPolyPoints := nil;
        UpdateBild;
      end
      else
      begin
        SetLength(aPolyPoints, Pred(Length(aPolyPoints)));
        LeinwandPaint(nil);
      end;
    end;
    if (Key in [VK_BACK, VK_DELETE]) and (eToolMode = tmSelect) and (ItemIndex > -1) then
    begin
      DeleteCurrent;
    end;
  end;
end;

procedure TfmMain.DrawMaps;
var
  i: integer;
begin
  // regionen zeichnen
  with bmpTmp.Canvas do
  begin
    Pen.Color := clGray;
    Pen.Style := psDashDotDot;
    Brush.Style := bsDiagCross;
    Pen.Mode := pmNotMerge;
    Brush.Color := clGray;
  end;

  with slMap do
    if Count > 0 then
      for i := 0 to Pred(Count) do
        DrawMap(i);

  if (ItemIndex <> -1) and (hSelect <> 0) then
  begin
    if bTooling and (eToolMode = tmSelect) then
      OffsetRgn(hSelect, iMoveX - iDownX, iMoveY - iDownY);
    TmpRegionImageCanvas(bmpTmp.Canvas).InvertRegion(hSelect);
    if bTooling and (eToolMode = tmSelect) then
      OffsetRgn(hSelect, - iMoveX + iDownX, - iMoveY + iDownY);
  end;
end;

procedure TfmMain.DrawMap(i: integer);
var
  h: HRGN;
begin
  h := CreateRegionFromString(i);
  try
    TmpRegionImageCanvas(bmpTmp.Canvas).PaintRegion(h);
  finally
    DeleteObject(h);
  end;
end;

procedure TfmMain.AddPolyPoint(X, Y: integer);
begin
  SetLength(aPolyPoints, Succ(Length(aPolyPoints)));
  aPolyPoints[Pred(Length(aPolyPoints))].X := X;
  aPolyPoints[Pred(Length(aPolyPoints))].Y := Y;
end;

function TfmMain.AdjustDrawRect(x1, y1, x2, y2: integer): TRect;

  procedure Swap(var x, y: integer);
  var
    iSwap: integer;
  begin
    iSwap := x;
    x := y;
    y := iSwap;
  end;
begin
  if x1 > x2 then
    Swap(x1, x2);
  if y1 > y2 then
    Swap(y1, y2);
  Result := Rect(x1, y1, x2 + 1,y2 + 1);
end;

procedure TfmMain.DrawInMove;
var
  pts: TPoints;
  i: integer;
begin
  with bmpTmp.Canvas do
  begin
    Pen.Mode := pmNot;
    Brush.Style := bsClear;
    Pen.Width := 1;
    Pen.Style := psSolid;
    case eToolMode of
      tmRect:
        begin
          if IsKeyDown(VK_CONTROL) then
            iMoveY := iDownY + (iMoveX - iDownX);
          bStatus.Panels[3].Text := Format('Rect(%d/%d - %d/%d)',
            [iDownX, iDownY, iMoveX, iMoveY]);
          Rectangle(AdjustDrawRect(iDownX, iDownY, iMoveX, iMoveY));
        end;
      tmEllipse:
        begin
          if IsKeyDown(VK_CONTROL) then
            iMoveY := iDownY + (iMoveX - iDownX);
          bStatus.Panels[3].Text := Format('Ellipse(%d/%d - %d/%d)',
            [iDownX, iDownY, iMoveX, iMoveY]);
          Ellipse(AdjustDrawRect(iDownX, iDownY, iMoveX, iMoveY));
        end;
      tmPoly:
        begin
          bStatus.Panels[3].Text := 'Polygon';
          SetLength(pts, Length(aPolyPoints) + 1);
          for i := 0 to Pred(Length(aPolyPoints)) do
            pts[i] := aPolyPoints[i];
          pts[Length(aPolyPoints)].X := iMoveX;
          pts[Length(aPolyPoints)].Y := iMoveY;
          PolyLine(pts);
        end;
    end;
  end;
end;

procedure TfmMain.pbZoomPaint(Sender: TObject);

  procedure DrawZoomPixel(xPix, yPix, cl, x, y: integer);
  begin
    with pbZoom.Canvas do
    begin
      Brush.Color := bmpWork.Canvas.Pixels[xPix, yPix];
      Pen.Color := cl;
      Rectangle(x + 2,y, x + 18,y + 16);
    end;
  end;
begin
  DrawZoomPixel(iMoveX - 1,iMoveY - 1,clBtnFace, 0,0);
  DrawZoomPixel(iMoveX, iMoveY - 1,clBtnFace, 16,0);
  DrawZoomPixel(iMoveX + 1,iMoveY - 1,clBtnFace, 32,0);

  DrawZoomPixel(iMoveX - 1,iMoveY, clBtnFace, 0,16);
  DrawZoomPixel(iMoveX, iMoveY, clBlack, 16,16);
  DrawZoomPixel(iMoveX + 1,iMoveY, clBtnFace, 32,16);

  DrawZoomPixel(iMoveX - 1,iMoveY + 1,clBtnFace, 0,32);
  DrawZoomPixel(iMoveX, iMoveY + 1,clBtnFace, 16,32);
  DrawZoomPixel(iMoveX + 1,iMoveY + 1,clBtnFace, 32,32);
end;

procedure TfmMain.LeinwandDblClick(Sender: TObject);
var
  i: integer;
  s: string;
begin
  if (eToolMode = tmPoly) and bTooling then
  begin
    AddPolyPoint(iMoveX, iMoveY);
    bTooling := False;
    s := 'P,';
    for i := 0 to Pred(Length(aPolyPoints)) do
      with aPolyPoints[i] do
        s := s + IntToStr(X) + ',' + IntToStr(Y) + ',';
    slMap.Add(s);
    aPolyPoints := nil;
    ItemIndex := MaxInt;
    UpdateBild;
    bBeginPoly := False;
  end;
  if (eToolMode = tmSelect) and (ItemIndex <> -1) then
    ChangeDescription(ItemIndex);
end;


procedure TfmMain.GetFillMap(X, Y: integer);
var
  bmp, bmpSave: TBitmap;
  clMin, clMax: cardinal;
  h: HRGN;
  s: string;
  rgs: TIntArray;
  i: integer;
begin
  bmp := TBitmap.Create;
  bmpSave := TBitmap.Create;
  Screen.Cursor := crHourGlass;
  try
    bmpSave.Assign(bmpWork);
    bmp.Width := bmpWork.Width;
    bmp.Height := bmpWork.Height;
    bmp.PixelFormat := pf1Bit;
    bmp.Canvas.Brush.Color := clWhite;
    bmp.Canvas.Pen.Color := clWhite;
    bmp.Canvas.Brush.Style := bsSolid;
    bmp.Canvas.FillRect(Rect(0,0,bmp.Width, bmp.Height));
    clMin := ColorToRGB(fmFillOpts.ColorBox1.Selected);
    clMax := clMin;
    clMin := RGB(Max(0, GetRValue(clMin) - fmFillOpts.Updown1.Position),
      Max(0, GetGValue(clMin) - fmFillOpts.Updown1.Position),
      Max(0, GetBValue(clMin) - fmFillOpts.Updown1.Position));
    clMax := RGB(Min(255, GetRValue(clMax) + fmFillOpts.Updown1.Position),
      Min(255, GetGValue(clMax) + fmFillOpts.Updown1.Position),
      Min(255, GetBValue(clMax) + fmFillOpts.Updown1.Position));

    rgs := nil;
    if fmFillOpts.CheckBox1.Checked then
    begin
      for i := 0 to Pred(slMap.Count) do
      begin
        h := CreateRegionFromString(i);
        SetLength(rgs, Succ(Length(rgs)));
        rgs[Pred(Length(rgs))] := h;
      end;
    end;

    try
      GrassFireFill(clMax, clMin, bmp.Width, bmp.Height, X, Y,
        bmpWork.Canvas, bmp.Canvas,
        fmFillOpts.RadioButton1.Checked, rgs, OnGFF);
    finally
      for i := 0 to Pred(Length(rgs)) do
        DeleteObject(rgs[i]);
      rgs := nil;
    end;

    UpdateBild;
    LeinwandPaint(nil);
    h := BitmapToRegion(bmp);
    try
      s := XRegion(h);
      if Length(s) > 2 then
      begin
        slMap.Add(XRegion(h));
        ItemIndex := MaxInt;
      end;
    finally
      DeleteObject(h);
    end;
  finally
    bmp.Free;
    bmpWork.Assign(bmpSave);
    UpdateBild;
    Screen.Cursor := crDefault;
    bmpSave.Free;
  end;
end;

function TfmMain.FindRegionAtPos(X, Y: integer): integer;
var
  i: integer;
  h: HRGN;
begin
  Result := -1;
  with slMap do
    for i := Pred(Count) downto 0 do
    begin
      h := CreateRegionFromString(i);
      if h <> 0 then
        try
          if PtInRegion(h, X, Y) then
          begin
            Result := i;
            Break;
          end;
        finally
          DeleteObject(h);
        end;
    end;
end;


function TfmMain.CreateRegionFromString(iIndex: integer): HRGN;
var
  cmd: char;
  rCoords: TIntArray;
  s, s2: string;
  m, i: integer;
  h: HRGN;
begin
  rCoords := nil;
  Result := 0;
  s := slMap[iIndex];

  s2 := ExtractDescription(s, cmd);
  if cmd = #0 then
    Exit;

  rCoords := SplitCoords(s);
  case UpCase(cmd) of
    'R', 'S':  // rect/square
      begin
        if Length(rCoords) = 3 then
          Result := CreateRectRgn(rCoords[0], rCoords[1], rCoords[2],
            (rCoords[1] - rCoords[0]) + rCoords[2])
        else
          Result := CreateRectRgn(rCoords[0], rCoords[1], rCoords[2], rCoords[3]);
      end;
    'E', 'C':  // ellipse/circle
      begin
        if Length(rCoords) = 3 then
          Result := CreateEllipticRgn(rCoords[0], rCoords[1], rCoords[2],
            (rCoords[1] - rCoords[0]) + rCoords[2])
        else
          Result := CreateEllipticRgn(rCoords[0], rCoords[1], rCoords[2], rCoords[3]);
      end;
    'P': Result := CreatePolygonRgn(rCoords[0], Length(rCoords) div 2, WINDING);
    'X': Result := ExtCreateRegion(nil, sizeof(cardinal) * Length(rCoords),
        PRGNDATA(@rCoords[0])^);
    '+':
      begin
        m := RGN_OR;
        if Length(rCoords) > 1 then
          m := rCoords[1];
        Result := CreateRegionFromString(iIndex - rCoords[0]);
        for i := (iIndex - rCoords[0] + 1) to (iIndex - 1) do
        begin
          h := CreateRegionFromString(i);
          CombineRgn(Result, Result, h, m);
          DeleteObject(h);
        end;
      end;
  end;
end;

procedure TfmMain.ClearHSelect;
begin
  if hSelect <> 0 then
    DeleteObject(hSelect);
  hSelect := 0;
  FItemIndex := -1;
  pmLeinwand.AutoPopup := False;
end;

procedure TfmMain.MoveRegion(Index, dX, dY: integer);
var
  j: integer;
  cmd: char;
  rCoords: TIntArray;
  s, sDesc: string;
  h: HRGN;
begin
  rCoords := nil;
  s := slMap[Index];

  sDesc := ExtractDescription(s, cmd);
  if cmd = #0 then
    Exit;

  rCoords := SplitCoords(s);
  case UpCase(cmd) of
    'R', 'S', 'E', 'C':  // vier koordinaten
      begin
        if Length(rCoords) = 3 then
        begin
          SetLength(rCoords, Succ(Length(rCoords)));
          rCoords[Pred(Length(rCoords))] := (rCoords[1] - rCoords[0]) + rCoords[2];
        end;
        OffsetRect(PRect(@rCoords[0])^, dX, dY);
        slMap[Index] := Format('%s;%s,%d,%d,%d,%d,',
          [sDesc, UpCase(cmd), rCoords[0], rCoords[1], rCoords[2], rCoords[3]]);
      end;
    'P': //polygon
      begin
        slMap[Index] := sDesc + ';' + UpCase(cmd) + ',';
        j := 0;
        while j < Length(rCoords) do
        begin
          Inc(rCoords[j], dX);
          Inc(rCoords[j + 1], dY);
          slMap[Index] := slMap[Index] + Format('%d,%d,', [rCoords[j], rCoords[j + 1]]);
          Inc(j, 2);
        end;
      end;
    'X': // extended region
      begin
        if (Length(rCoords) mod 4) <> 0 then
          raise EmpRegionImage.CreateFmt('Invalid X coordinates count (%d, line %d)',
            [Length(rCoords), Index + 1]);

        // header + region data (hope, they are four byte aligned)
        Assert(rCoords[0] = sizeof(TRGNDATAHEADER));
        h := ExtCreateRegion(nil, sizeof(cardinal) * Length(rCoords),
          PRGNDATA(@rCoords[0])^);
        try
          OffsetRgn(h, dx, dy);
          slMap[Index] := sDesc + ';' + XRegion(h);
        finally
          DeleteObject(h);
        end;
      end;
    '+':
      begin
        for j := Index -rCoords[0] to (Index -1) do
          MoveRegion(j, dX, dY);
      end;
  end;
end;

procedure TfmMain.ChangeDescription(Index: integer);
var
  s1, sd: string;
  cmd: char;
begin
  UndoPossible(True);
  s1 := slMap[Index];

  sd := ExtractDescription(s1, cmd);

  if InputQuery('Change StrTag', 'Enter new StrTag value (no ";" allowed):',
    sd) and (Pos(';', sd) = 0) then
    slMap[Index] := sd + ';' + cmd + ',' + s1;
  bPopUp := True;
end;

procedure TfmMain.pm23Click(Sender: TObject);
begin
  DeleteCurrent;
end;

procedure TfmMain.Changedescription1Click(Sender: TObject);
begin
  ChangeDescription(ItemIndex);
end;

procedure TfmMain.SetItemIndex(iNew: integer);
begin
  if ItemIndex > -1 then
  begin
    // alte selection aufheben
    ClearHSelect;
    FItemIndex := -1;
    UpdateBild;
  end;
  if iNew = MaxInt then
    FItemIndex := Pred(slMap.Count)
  else
    FItemIndex := iNew;
  if FItemIndex <> -1 then
  begin
    hSelect := CreateRegionFromString(ItemIndex);
    pmLeinwand.AutoPopup := True;
    UpdateBild;
  end;
  //meMap.ItemIndex := iCurrent;
  if dlgRegionList.Visible then
    dlgRegionlist.BuildList(FItemIndex);
end;

procedure TfmMain.pm21Click(Sender: TObject);
var
  s: string;
  sl: TStrings;
  ia: TIntArray;
  cmd: char;
  i: integer;
begin
  UndoPossible(True);
  ia := nil;
  sl := TStringList.Create;
  try
    s := slMap[ItemIndex];
    ExtractDescription(s, cmd);
    if cmd = '+' then
    begin
      ia := SplitCoords(s);
      for i := ItemIndex - ia[0] to ItemIndex - 1 do
      begin
        sl.Add(slMap[i]);
        slMap[i] := '-';
      end;
    end;
    sl.Add(slMap[ItemIndex]);
    slMap[ItemIndex] := '-';
    with slMap do
      for i := Pred(Count) downto 0 do
        if Strings[i] = '-' then
          Delete(i);
    slMap.AddStrings(sl);
    ItemIndex := Pred(slMap.Count);
  finally
    sl.Free;
  end;
  //meMap.ItemIndex := iCurrent;
end;

procedure TfmMain.pm22Click(Sender: TObject);
var
  s: string;
  sl: TStrings;
  ia: TIntArray;
  cmd: char;
  i: integer;
begin
  UndoPossible(True);
  ia := nil;
  sl := TStringList.Create;
  try
    s := slMap[ItemIndex];
    ExtractDescription(s, cmd);
    if cmd = '+' then
    begin
      ia := SplitCoords(s);
      for i := ItemIndex - ia[0] to ItemIndex - 1 do
      begin
        sl.Add(slMap[i]);
        slMap[i] := '-';
      end;
    end;
    sl.Add(slMap[ItemIndex]);
    slMap[ItemIndex] := '-';
    with slMap do
      for i := Pred(Count) downto 0 do
        if Strings[i] = '-' then
          Delete(i);
    for i := Pred(sl.Count) downto 0 do
      slMap.Insert(0, sl[i]);
    ItemIndex := Pred(sl.Count);
  finally
    sl.Free;
  end;
  //meMap.ItemIndex := iCurrent;
end;

procedure TfmMain.pmLeinwandPopup(Sender: TObject);
var
  bCombi: boolean;
  s: string;
  cmd: char;
begin
  bCombi := False;
  if ItemIndex > -1 then
  begin
    s := slMap[ItemIndex];
    ExtractDescription(s, cmd);
    bCombi := cmd = '+';
  end;
  Combine1.Enabled := bCombi;
  Combine1.Checked := bCombi;
end;

procedure TfmMain.Combine1Click(Sender: TObject);
begin
  if (ItemIndex <> -1) and (Combine1.Checked) then
  begin
    UndoPossible(True);
    slMap.Delete(ItemIndex);
    ItemIndex := ItemIndex - 1;
  end;
end;

procedure TfmMain.DeleteCurrent;
var
  cmd: char;
  s: string;
  i: integer;
  ia: TIntArray;
begin
  UndoPossible(True);
  ia := nil;
  if ItemIndex > -1 then
  begin
    s := slMap[ItemIndex];
    ExtractDescription(s, cmd);
    if cmd = '+' then
    begin
      ia := SplitCoords(s);
      for i := 1 to ia[0] do
        slMap[ItemIndex - i] := '-';
    end;
    slMap[ItemIndex] := '-';
    with slMap do
      for i := Pred(Count) downto 0 do
        if Strings[i] = '-' then
          Delete(i);
    ItemIndex := -1;
    bTooling := False;
  end;
end;

procedure TfmMain.Combine(i1, i2: integer);

  procedure GetList(iIndex: integer; sl: TStrings; var sd: string);
  var
    i: integer;
    s: string;
    cmd: char;
    ia: TIntArray;
  begin
    sl.Clear;
    ia := nil;
    s := slMap[iIndex];
    sd := ExtractDescription(s, cmd);
    if cmd = '+' then
    begin
      ia := SplitCoords(s);
      for i := iIndex - ia[0] to iIndex - 1 do
      begin
        sl.Add(slMap[i]);
        slMap[i] := '-';
      end;
    end
    else
      sl.Add(slMap[iIndex]);
    slMap[iIndex] := '-';
  end;
var
  sl1, sl2: TStrings;
  sd1, sd2: string;
  i: integer;
begin
  sl1 := TStringList.Create;
  sl2 := TStringList.Create;
  try
    GetList(i1, sl1, sd1);
    GetList(i2, sl2, sd2);

    with slMap do
      for i := Pred(Count) downto 0 do
        if Strings[i] = '-' then
          Delete(i);
    slMap.AddStrings(sl1);
    slMap.AddStrings(sl2);
    if (sd2 <> '') and (sd1 <> '') then
      sd1 := sd1 + '/' + sd2
    else if sd2 <> '' then
      sd1 := sd2;
    slMap.Add(sd1 + ';+,' + IntToStr(sl1.Count + sl2.Count))
  finally
    sl1.Free;
    sl2.Free;
  end;
end;

procedure TfmMain.MapChanged(Sender: TObject);
begin
  Modified := True;
end;

procedure TfmMain.SetModified(const Value: boolean);
begin
  FModified := Value;

  if Assigned(dlgRegionList) and dlgRegionList.Visible then
    dlgRegionList.BuildList(ItemIndex);

  if FModified then
    bStatus.Panels[3].Text := '*'
  else
    bStatus.Panels[3].Text := '';

  if not FModified then
    UndoPossible(False);
end;

procedure TfmMain.FormCloseQuery(Sender: TObject; var CanClose: boolean);
begin
  try
    if CheckModified then
      acSave.Execute
    except
      CanClose := False;
  end
end;

function TfmMain.CheckModified: boolean;
begin
  Result := False;
  if Modified then
    case MessageDlg('Save changes ?', mtConfirmation, [mbYes, mbNo, mbCancel], 0) of
      ID_YES: Result := True;
      ID_NO: Result := False;
      else
        Abort;
    end
end;

procedure TfmMain.NotifyListOpen(bOpen: boolean);
begin
  acRegList.Checked := bOpen;
  if bOpen then
  begin
    dlgRegionList.BuildList(ItemIndex);
  end;
end;

procedure TfmMain.OnGFF(Sender: TObject);
begin
  UpdateBild;
  LeinwandPaint(nil);
  Sleep(0);
end;

procedure TfmMain.UndoPossible(b: boolean);
begin
  if b then
  begin
    sUndo := slMap.Text;
    bUndo := True
  end
  else
  begin
    sUndo := '';
    bUndo := False;
  end;
  acUndo.Enabled := (bUndo and FModified);
end;


procedure TfmMain.SaveTo(sFile: string; bIsPKG: boolean; bmp1, bmp2,
  bmp3: TBitmap; sl: TStringList);
begin
  Screen.Cursor := crHourGlass;
  try
    if bIsPKG then
      CollectPackage(sFile, bmp1, bmp2, bmp3, sl)
    else
      sl.SaveToFile(sFile);
    Modified := False;
    FileCaption := sFile;
  finally
    Screen.Cursor := crDefault;
  end;
end;

procedure TfmMain.SelectBitmap(b: TBitmap; const sTitle: string);
begin
  with dlgSelect do
  begin
    Title := sTitle;
    if Execute then
      b.LoadFromFile(FileName)
    else
      Abort;
  end;
end;

procedure TfmMain.SetFileCaption(const Value: string);
begin
  if Value = '' then
    Caption := 'TmpRegionImage Editor'
  else
    Caption := Format('TmpRegionImage Editor [%s]', [Value]);
end;

procedure TfmMain.LoadFrom(sFile: string);
var
  s: TFileName;
begin
  ClearhSelect;

  if CheckModified then
    acSave.Execute;

  s := sFile;

  if LowerCase(ExtractFileExt(s)) = '.bmp' then
  begin
    bmpWork.LoadFromFile(s);

    s := ChangeFileExt(s, '.map');

    slMap.Clear;
    if FileExists(s) then
      slMap.LoadFromFile(s);
    bWorkIsPKG := False;
  end
  else
  begin
    ExtractPackage(s, bmpWork, nil, nil, slMap);
    bWorkIsPKG := True;
  end;

  sWorkFile := s;

  FileCaption := s;

  fmZoom.ZoomBitmap := bmpWork;
  Modified := False;

  bTooling := False;
  UpdateBild;
end;

procedure TfmMain.WMUser(var Msg: TMsg);
begin
  if ParamCount > 0 then
    if FileExists(ParamStr(1)) then
      LoadFrom(ParamStr(1));
end;

(*procedure TfmMain.SelectStrings(s: TStringList; const sTitle: string);
begin
  with dlgSelectS do
  begin
    Title := sTitle;
    if Execute then
      s.LoadFromFile(FileName)
    else
      Abort;
  end;
end;

function TfmMain.SelectOut(s1, s2, s3: string): string;
begin
  with DlgSelectOut do
  begin
    Title := s1;
    Filter := s2;
    DefaultExt := s3;
    if not Execute
    then
      Abort;
    Result := FileName;
  end;
end;

function TfmMain.SelectIn(s1, s2, s3: string): string;
begin
  with DlgSelectIn do
  begin
    Title := s1;
    Filter := s2;
    DefaultExt := s3;
    if not Execute
    then
      Abort;
    Result := FileName;
  end;
end;*)


procedure TfmMain.ApplicationEvents1Idle(Sender: TObject;
  var Done: boolean);
begin
  UpdateActions;
end;



procedure TfmMain.acUndoExecute(Sender: TObject);
var
  s: string;
begin
  s := sUndo;
  UniqueString(s);
  slMap.Text := s;
  UndoPossible(False);
  Modified := True;
  bTooling := False;
  aPolyPoints := nil;
  ClearHSelect;
  UpdateBild;
end;

procedure TfmMain.acUndoUpdate(Sender: TObject);
begin
  acUndo.Enabled := (bUndo and FModified);
end;

procedure TfmMain.acZoomOutExecute(Sender: TObject);
var
  i: integer;
begin
  i := iZoom div 2;
  if i < 1 then
    i := 1;
  UpdateZoom(i);
end;

procedure TfmMain.acZoomWinExecute(Sender: TObject);
begin
  fmZoom.Visible := acZoomWin.Checked;
  if fmZoom.Visible then
    fmZoom.Repaint;
end;

procedure TfmMain.acRegListExecute(Sender: TObject);
begin
  dlgRegionList.Visible := acRegList.Checked;
  if dlgRegionList.Visible then
    dlgRegionList.BuildList(ItemIndex);
end;

procedure TfmMain.acToolExec(Sender: TObject);
begin
  ClearhSelect;
  eToolMode := TToolMode((Sender as TAction).Tag);
  case eToolMode of
    tmRect: acTRect.Checked := True;
    tmEllipse: acTEllipse.Checked := True;
    tmPoly: acTPolygon.Checked := True;
    tmFill: acTFill.Checked := True;
    tmSelect: acTSelect.Checked := True;
    tmCombi: acTCombi.Checked := True;
  end;
  Leinwand.Cursor := integer(eToolMode);
  UpdateBild;
  fmFillOpts.Visible := eToolMode = tmFill;
end;

procedure TfmMain.acSaveUpdate(Sender: TObject);
begin
  acSave.Enabled := (sWorkFile <> '') and Modified;
end;

procedure TfmMain.Exit1Click(Sender: TObject);
begin
  Close;
end;

procedure TfmMain.tbx4Click(Sender: TObject);
var
  iZoom: integer;
begin
  iZoom := self.iZoom * 2;
  if iZoom > 8 then
    iZoom := 1;
  UpdateZoom(iZoom);
end;

procedure TfmMain.acZoomInUpdate(Sender: TObject);
begin
  acZoomIn.Enabled := iZoom < 8;
end;

procedure TfmMain.acZoomOutUpdate(Sender: TObject);
begin
  acZoomOut.Enabled := iZoom > 1;
end;

procedure TfmMain.acZoomInExecute(Sender: TObject);
var
  i: integer;
begin
  i := iZoom * 2;
  if i > 8 then
    i := 8;
  UpdateZoom(i);
end;

procedure TfmMain.acOpenExecute(Sender: TObject);
begin
  with dlgOpen do
    if Execute then
      LoadFrom(FileName);
end;

procedure TfmMain.acSaveExecute(Sender: TObject);
var
  b1, b2: TBitmap;
begin
  if not FileExists(sWorkFile) then
    acSaveAs.Execute
  else
  begin
    if not bWorkIsPKG then
      SaveTo(sWorkFile, False, bmpWork, nil, nil, slMap)
    else
    begin
      b1 := TBitmap.Create;
      b2 := TBitmap.Create;
      Screen.Cursor := crHourGlass;
      try
        ExtractPackage(sWorkFile, nil, b1, b2, nil);
        SaveTo(sWorkFile, True, bmpWork, b1, b2, slMap)
      finally
        Screen.Cursor := crDefault;
        b1.Free;
        b2.Free;
      end;
    end;
  end;
end;

procedure TfmMain.acSaveAsExecute(Sender: TObject);
var
  b1, b2: TBitmap;
begin
  with dlgSave do
  begin
    FileName := sWorkFile;
    if Execute then
    begin
      if LowerCase(ExtractFileExt(FileName)) = '.pkg' then
      begin
        b1 := TBitmap.Create;
        b2 := TBitmap.Create;
        try
          if bWorkIsPKG then
            try
              ExtractPackage(sWorkFile, nil, b1, b2, nil);
            finally
              Screen.Cursor := crDefault;
            end
          else
          begin
            SelectBitmap(b1, 'Choose Highlight bitmap');
            SelectBitmap(b2, 'Choose Selected bitmap');
          end;
          SaveTo(FileName, True, bmpWork, b1, b2, slMap);
          sWorkFile := FileName;
          bWorkIsPKG := True;
        finally
          b1.Free;
          b2.Free;
        end;
      end
      else
      begin
        SaveTo(FileName, False, nil, nil, nil, slMap);
        sWorkFile := FileName;
        bWorkIsPKG := False;
      end;
    end;
  end;
end;

procedure TfmMain.acSaveAsUpdate(Sender: TObject);
begin
  acSaveAs.Enabled := sWorkFile <> '';
end;

procedure TfmMain.btnOKClick(Sender: TObject);
begin
  acSave.Execute;
  ExitCode := 0;
  Close;
end;

procedure TfmMain.btnCancelClick(Sender: TObject);
begin
  ExitCode := 1;
  Modified := False;
  Close;
end;

procedure TfmMain.About1Click(Sender: TObject);
begin
  with TAboutBox.Create(Application) do
    try
      ShowModal;
    finally
      Free;
    end;
end;

(*procedure TfmMain.acNewPackageClick(Sender: TObject);
var
  b1,b2,b3: TBitmap;
  s1: TStringList;
  sF: string;
begin
  b1 := TBitmap.Create;
  b2 := TBitmap.Create;
  b3 := TBitmap.Create;
  s1 := TStringList.Create;
  try
    SelectBitmap(b1,'Choose Normal bitmap');
    SelectBitmap(b2,'Choose Highlight bitmap');
    SelectBitmap(b3,'Choose Selected bitmap');
    SelectStrings(s1, 'Choose Regions list');
    sF := SelectOut('Save package to', 'Packages (*.pkg)|*.pkg', 'pkg');
    Screen.Cursor := crHourGlass;
    CollectPackage(sF, b1,b2,b3,s1);
  finally
    Screen.Cursor := crDefault;
    b1.Free;
    b2.Free;
    b3.Free;
    s1.Free;
  end;
end;

procedure TfmMain.acExtractPackageExecute(Sender: TObject);
var
  b1,b2,b3: TBitmap;
  s1: TStringList;
  sF,s2: string;
begin
  b1 := TBitmap.Create;
  b2 := TBitmap.Create;
  b3 := TBitmap.Create;
  s1 := TStringList.Create;
  try
    sF := SelectIn('Choose package', 'Packages (*.pkg)|*.pkg', 'pkg');
    s2 := ExtractFileName(sF);
    Screen.Cursor := crHourGlass;
    ExtractPackage(sF, b1,b2,b3,s1);
    Screen.Cursor := crDefault;
    b1.SaveToFile(SelectOut('Save Normal bitmap of '+s2+' to', 'Bitmaps (*.bmp)|*.bmp', 'bmp'));
    b2.SaveToFile(SelectOut('Save Hilight bitmap of '+s2+' to', 'Bitmaps (*.bmp)|*.bmp', 'bmp'));
    b3.SaveToFile(SelectOut('Save Selected bitmap of '+s2+' to', 'Bitmaps (*.bmp)|*.bmp', 'bmp'));
    s1.SaveToFile(SelectOut('Save Regions list of '+s2+' to', 'Regions lists (*.map)|*.map', 'map'));
  finally
    Screen.Cursor := crDefault;
    b1.Free;
    b2.Free;
    b3.Free;
    s1.Free;
  end;
end;*)

procedure TfmMain.acNewPackageUpdate(Sender: TObject);
begin
  acNewPackage.Enabled := sWorkFile <> '';
end;

procedure TfmMain.acNewPackageExecute(Sender: TObject);
var
  b1, b2: TBitmap;
begin
  with TdlgPackage.Create(Application) do
    try
      if not bWorkIsPKG then
        Execute(bmpWork, bmpWork, bmpWork, slMap, '')
      else
      begin
        b1 := TBitmap.Create;
        b2 := TBitmap.Create;
        try
          Screen.Cursor := crHourGlass;
          ExtractPackage(sWorkFile, nil, b1, b2, nil);
          Screen.Cursor := crDefault;
          Execute(bmpWork, b1, b2, slMap, '');
        finally
          Screen.Cursor := crDefault;
          b1.Free;
          b2.Free;
        end;
      end;
    finally
      Free;
    end;
end;



procedure TfmMain.acModifyPackageUpdate(Sender: TObject);
begin
  acModifyPackage.Enabled := (sWorkFile <> '') and bWorkIsPKG;
end;

procedure TfmMain.acModifyPackageExecute(Sender: TObject);
var
  b1, b2: TBitmap;
begin
  with TdlgPackage.Create(Application) do
    try
      b1 := TBitmap.Create;
      b2 := TBitmap.Create;
      try
        Screen.Cursor := crHourGlass;
        ExtractPackage(sWorkFile, nil, b1, b2, nil);
        Screen.Cursor := crDefault;
        if Execute(bmpWork, b1, b2, slMap, sWorkFile) then
        begin
          Modified := False;
          LoadFrom(sWorkFile);
        end;
      finally
        Screen.Cursor := crDefault;
        b1.Free;
        b2.Free;
      end;
    finally
      Free;
    end;
end;

{ TModStringList }

procedure TModStringList.Put(Index: integer; const S: string);
var
  oc: TNotifyEvent;
  s1: string;
begin
  oc := self.OnChange;
  try
    self.OnChange := nil;
    s1 := Strings[Index];
    inherited;
  finally
    self.OnChange := oc;
  end;
  if s1 <> Strings[Index] then
    Changed;
end;



procedure TfmMain.Index1Click(Sender: TObject);
begin
  Application.HelpContext(1)
end;

end.
