unit u_listwin;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls;

type
  TdlgRegionList = class(TForm)
    lbMap: TListBox;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure FormShow(Sender: TObject);
    procedure lbMapClick(Sender: TObject);
    procedure lbMapDblClick(Sender: TObject);
    procedure lbMapMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: integer);
    procedure lbMapKeyPress(Sender: TObject; var Key: char);
  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
    procedure BuildList(iCurrent: integer);
  end;

var
  dlgRegionList: TdlgRegionList;

implementation

uses u_main, u_utils, rgnimg;

{$R *.dfm}

{ TdlgRegionList }

function Desc(c: char): string;
begin
  case UpCase(c) of
    'R', 'S': Result := 'Rectangle';
    'C', 'E': Result := 'Ellipse';
    'X': Result := 'Irregular';
    'P': Result := 'Polygon';
    '+': Result := 'Combination';
    else
      Result := '';
  end;
end;

procedure TdlgRegionList.BuildList(iCurrent: integer);
var
  i: integer;
  s, sd: string;
  cmd: char;
  ia: TIntArray;
begin
  ia := nil;
  with lbMap.Items do
    try
      BeginUpdate;
      Clear;
      with fmMain.Regions do
      begin
        i := Pred(Count);
        while i >= 0 do
        begin
          s := Strings[i];
          sd := ExtractDescription(s, cmd);
          lbMap.Items.AddObject(sd + ' (' + Desc(cmd) + ')', Pointer(i));
          if cmd = '+' then
          begin
            ia := SplitCoords(s);
            Dec(i, ia[0]);
          end;
          Dec(i);
        end;
      end;
    finally
      EndUpdate;
    end;
  lbMap.ItemIndex := lbMap.Items.IndexOfObject(Pointer(iCurrent));
end;

procedure TdlgRegionList.FormClose(Sender: TObject;
  var Action: TCloseAction);
begin
  fmMain.NotifyListOpen(False);
end;

procedure TdlgRegionList.FormShow(Sender: TObject);
begin
  fmMain.NotifyListOpen(True);
end;

procedure TdlgRegionList.lbMapClick(Sender: TObject);
var
  i: integer;
begin
  with lbMap do
  begin
    i := ItemIndex;
    if i > -1 then
      i := integer(Items.Objects[i]);
    fmMain.ItemIndex := i;
  end;
end;

procedure TdlgRegionList.lbMapDblClick(Sender: TObject);
begin
  fmMain.ChangeDescription(fmMain.ItemIndex);
end;

procedure TdlgRegionList.lbMapMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: integer);
begin
  if Shift = [ssRight] then
  begin
    lbMap.ItemIndex := lbMap.ItemAtPos(Point(X, Y), True);
    lbMapClick(Sender);
  end;
end;

procedure TdlgRegionList.lbMapKeyPress(Sender: TObject; var Key: char);
begin
  if Key = #13 then
    lbMapDblClick(Sender);
end;

end.
