unit RRFResizeDT;
  (* Design-time components of the RRFResize package:
       property editors
       register procedure
  *)

  interface
    uses
      Classes       (* tGetStrProc, RegisterComponents, tStringList *),
      DesignEditors (* tStringProperty *),
      DesignIntf    (* tPropertyAttribute, tPropertyAttributes,
                         RegisterPropertyEditor, RegisterPropertyInCategory *);

    type
      tDBNameProperty = class(tStringProperty)
        (* property editor for DatabaseName property *)
        public
          function GetAttributes: tPropertyAttributes; override;
          function GetName: string;                    override;
          procedure GetValues(Proc: tGetStrProc);      override;
        end (* tDBNameProperty *);

      tTableNameProperty = class(tStringProperty)
        (* property Editor for TableName property *)
        public
          function GetAttributes: tPropertyAttributes; override;
          function GetName: string;                    override;
          procedure GetValues(Proc: tGetStrProc);      override;
        end (* tTableNameProperty *);

    procedure Register;

  implementation
    uses
      Controls  (* tCursor *),
      DB        (* tFieldType *),
      DBTables  (* Session, tTable, tTableType *),
      Forms     (* Screen *),
      {MyConsts  (* nullstring *),}
      RRFResize (* tRRFResizer *);

    const
      nullstring = '';

    type
      tCracker = class(tRRFResizer)
        (* for access to non-public fields *)
        end (* tCracker *);

    procedure Register;
      (* Install into palette *)

      begin (* Register *)
        RegisterComponents('RRF', [tRRFResizer]);
        RegisterPropertyInCategory('RRF', tRRFResizer, 'DatabaseName');
        RegisterPropertyInCategory('RRF', tRRFResizer, 'Name');
        RegisterPropertyInCategory('RRF', tRRFResizer, 'TableName');
        RegisterPropertyEditor
          (TypeInfo(string), tRRFResizer, 'DatabaseName', tDBNameProperty);
        RegisterPropertyEditor
          (TypeInfo(string), tRRFResizer, 'TableName',    tTableNameProperty);
      end   (* Register *);
      (* eject *)
{ tDBNameProperty }

    function tDBNameProperty.GetAttributes: tPropertyAttributes;
      (* property is a sorted list of values *)

      begin (* tDBNameProperty.GetAttributes *)
        Result := [paSortList, paValueList]
      end   (* tDBNameProperty.GetAttributes *);

    function tDBNameProperty.GetName: string;
      (* Name of the property *)

      begin (* tDBNameProperty.GetName *)
        Result := 'DatabaseName'
      end   (* tDBNameProperty.GetName *);

    procedure tDBNameProperty.GetValues(Proc: tGetStrProc);
      (* Names of possible databases *)

      var
        I: integer;
        List: tStringList;

      begin (* tDBNameProperty.GetValues *)
        Session.Active := true;
        List := tStringList.Create;

        try     (* list must be freed *)
          Session.GetDatabaseNames(List);
          for I := 1 to List.Count do
            Proc(List.Strings[I-1])
        finally (* list must be freed *)
          List.Free;
          Session.Active := false
        end     (* list must be freed *)
      end   (* tDBNameProperty.GetValues *);
      (* eject *)
{ tTableNameProperty }

    function tTableNameProperty.GetAttributes: tPropertyAttributes;
      (* property is a sorted list of values *)

      begin (* tTableNameProperty.GetAttributes *)
        Result := [paSortList, paValueList]
      end   (* tTableNameProperty.GetAttributes *);

    function tTableNameProperty.GetName: string;
      (* Name of the property *)

      begin (* tTableNameProperty.GetName *)
        Result := 'TableName'
      end   (* tTableNameProperty.GetName *);

    procedure tTableNameProperty.GetValues(Proc: tGetStrProc);
      (* Names of tables in the named database.  This code discovered on
      dejanews *)

      const
        FileFilter = '*.db';
        Paradox = true;
        SQL = false;

      var
        OldCursor: tCursor;
        I: integer;
        DBName: string;
        List: tStringList;
        Table: tTable;

      function FType(const FieldName: string): tFieldType;
        (* If no such field exists, return ftUnknown *)

        var
          Field: tField;

        begin (* FType *)
          Field := Table.FindField(FieldName);
          if Assigned(Field) then
            Result := Field.DataType
          else
            Result := ftUnknown
        end   (* FTYpe *);
        (* eject *)
      begin (* tTableNameProperty.GetValues *)
        OldCursor := Screen.Cursor;
        Screen.Cursor := crHourGlass;
        Session.Active := true;
        DBName := (GetComponent(0) as tRRFResizer).DatabaseName;
        List := tStringList.Create;

        try     (* list must be freed *)
          if DBName <> nullstring then
            begin (* have DBName *)
              Table := tTable.Create(nil);

              with Table do
                try (* table must be freed *)
                  TableType := ttParadox;
                  DatabaseName := DBName;

                  with tCracker(GetComponent(0)).Table do
                    DBSession.GetTableNames(DBName, FileFilter, Paradox, SQL, List);
                  for I := 1 to List.Count do
                    begin (* this candidate is List.Strings[I-1] *)
                      TableName := List.Strings[I-1];
                      try (* table must be closed *)
                        Open;
                        if ((FType('ScreenHeight') = ftInteger) and
                            (FType( 'ScreenWidth') = ftInteger) and
                            (FType(  'FormName'  ) = ftString ) and
                            (FType( 'ControlName') = ftString ) and
                            (FType(   'Height'   ) = ftInteger) and
                            (FType(    'Left'    ) = ftInteger) and
                            (FType(     'Top'    ) = ftInteger) and
                            (FType(    'Width'   ) = ftInteger)) then
                          Proc(TableName)
                      finally (* table must be closed *)
                        Close
                      end     (* table must be closed *)
                    end   (* this candidate is List.Strings[I-1] *)
                finally (* table must be freed *)
                  Free
                end     (* table must be freed *)
            end   (* have DBName *)
        finally (* list must be freed *)
          List.Free;
          Session.Active := false;
          Screen.Cursor := OldCursor
        end     (* list must be freed *)
      end   (* tTableNameProperty.GetValues *);

end.
