unit KACDOTreeView;

interface

uses
  Windows, Messages, SysUtils, Classes, Controls, ComCtrls, KACDOMessage,
  Variants, Graphics, ShellApi, Dialogs;

type
  PNodeData=^TNodeData;
  TNodeData=Record
              ID               : OleVariant;
              ContentMediaType : String;
              ContentID        : String;
              FileName         : String;                                     
            End;

  TKACDOTreeView = class(TTreeView)
  private
    { Private declarations }
    F_CDOMessage : TKACDOMessage;
    F_ImageList  : TImageList;
    F_BigIcons   : TImageList;
    F_TempPath   : String;
    F_ExtList    : TStringList;
  protected
    { Protected declarations }
    Procedure         F_Set_CDOMessage    (Value:TKACDOMessage);
    Function          AlreadyLoaded(Ext:String):Integer;
    Procedure         BuildNode(ParentPart : OleVariant; ParentNode : TTreeNode;Var Number:Integer);
    Procedure         Notification(AComponent: TComponent; Operation: TOperation); override;
  public
    { Public declarations }
    Function          GetFileIcon(FileName:String;SmallIcon: Boolean):TIcon;
    Function          SaveNodeToFile(Node : TTreeNode; FileName : String):Boolean;
    Procedure         AddNodeFromFile(FileName:String);
    Procedure         DeleteSelectedNode;
    Procedure         BuildCDOTree;
    Property          SmallIcons : TImageList Read F_ImageList Write F_ImageList;
    Property          BigIcons   : TImageList Read F_BigIcons  Write F_BigIcons;
    Constructor       Create(AOwner:TComponent); override;
    Destructor        Destroy; override;
  published
    { Published declarations }
    Property          CDOMessage : TKACDOMessage Read F_CDOMessage Write F_Set_CDOMessage;
  end;

procedure Register;

implementation
{$R KACDOTreeView.Res}

end.
