unit KACDOMessage;
{$I KACDOCommonDirectives.pas}
interface

uses
  Windows, Messages, SysUtils, Classes, Variants, Forms, Dialogs, ComCtrls, Registry;

const
  //****************************************************************************
  adTypeBinary                 =  $00000001;
  adTypeText                   =  $00000002;

  cdoAnonymous                 =  $00000000;
  cdoBasic                     =  $00000001;
  cdoNTLM                      =  $00000002;

  cdoSendUsingPickup           =  $00000001;
  cdoSendUsingPort             =  $00000002;

  cdoPostUsingPickup           =  $00000001;
  cdoPostUsingPort             =  $00000002;

  cdoPriorityNonUrgent         = -$00000001;
  cdoPriorityNormal            =  $00000000;
  cdoPriorityUrgent            =  $00000001;

  cdoSourceDefaults            = -$00000001;
  cdoSourceIIS                 =  $00000001;
  cdoSourceOutlookExpress      =  $00000002;

  cdoStatSuccess               =  $00000000;
  cdoStatAbortDelivery         =  $00000002;
  cdoStatBadMail               =  $00000003;

  cdoSuppressNone              =  $00000000;
  cdoSuppressImages            =  $00000001;
  cdoSuppressBGSounds          =  $00000002;
  cdoSuppressFrames            =  $00000004;
  cdoSuppressObjects           =  $00000008;
  cdoSuppressStyleSheets       =  $00000010;
  cdoSuppressAll               =  $0000001F;
  //****************************************************************************

  //****************************************************************************
  cdoDSNDefault                =  $00000000;
  cdoDSNNever                  =  $00000001;
  cdoDSNFailure                =  $00000002;
  cdoDSNSuccess                =  $00000004;
  cdoDSNDelay                  =  $00000008;
  cdoDSNSuccessFailOrDelay     =  $0000000E;
  //****************************************************************************


  //****************************************************************************
  cdo7bit                      =  '7bit';
  cdo8bit                      =  '8bit';
  cdoBase64                    =  'base64';
  cdoBinary                    =  'binary';
  cdoMacBinHex40               =  'mac-binhex40';
  cdoQuotedPrintable           =  'quoted-printable';
  cdoUuencode                  =  'uuencode';
  //****************************************************************************

  //****************************************************************************
  cdoBIG5                      =  'big5';
  cdoEUC_JP                    =  'euc-jp';
  cdoEUC_KR                    =  'euc-kr';
  cdoGB2312                    =  'gb2312';
  cdoISO_2022_JP               =  'iso-2022-jp';
  cdoISO_2022_KR               =  'iso-2022-kr';
  cdoISO_8859_1                =  'iso-8859-1';
  cdoISO_8859_2                =  'iso-8859-2';
  cdoISO_8859_3                =  'iso-8859-3';
  cdoISO_8859_4                =  'iso-8859-4';
  cdoISO_8859_5                =  'iso-8859-5';
  cdoISO_8859_6                =  'iso-8859-6';
  cdoISO_8859_7                =  'iso-8859-7';
  cdoISO_8859_8                =  'iso-8859-8';
  cdoISO_8859_9                =  'iso-8859-9';
  cdoKOI8_R                    =  'koi8-r';
  cdoShift_JIS                 =  'shift-jis';
  cdoUS_ASCII                  =  'us-ascii';
  cdoUTF_7                     =  'utf-7';
  cdoUTF_8                     =  'utf-8';

  {*****************************************************************************
  ISO-8859-1  (Latin 1)
  ISO-8859-2  (Latin 2)
  ISO-8859-3  (Latin 3)
  ISO-8859-4  (Baltic)
  ISO-8859-5  (Cyrillic)
  ISO-8859-6  (Arabic)
  ISO-8859-7  (Greek)
  ISO-8859-8  (Hebrew)
  ISO-8859-9  (Turkish)
  ISO-8859-15 (Latin 9)
  ******************************************************************************}

  //****************************************************************************
  cdoGif                  = 'image/gif';
  cdoJpeg                 = 'image/jpeg';
  cdoMessageExternalBody  = 'message/external-body';
  cdoMessagePartial       = 'message/partial';
  cdoMessageRFC822        = 'message/rfc822';
  cdoMultipartAlternative = 'multipart/alternative';
  cdoMultipartDigest      = 'multipart/digest';
  cdoMultipartMixed       = 'multipart/mixed';
  cdoMultipartRelated     = 'multipart/related';
  cdoTextHtml             = 'text/html';
  cdoTextPlain            = 'text/plain';
  //****************************************************************************

  //****************************************************************************
  cdoArrivalTime          = 'http://schemas.microsoft.com/cdo/smtpenvelope/arrivaltime';
  cdoClientIPAddress      = 'http://schemas.microsoft.com/cdo/smtpenvelope/clientipaddress';
  cdoMessageStatus        = 'http://schemas.microsoft.com/cdo/smtpenvelope/messagestatus';
  cdoPickupFileName       = 'http://schemas.microsoft.com/cdo/smtpenvelope/pickupfilename';
  cdoRecipientList        = 'http://schemas.microsoft.com/cdo/smtpenvelope/recipientlist';
  cdoSenderEmailAddress   = 'http://schemas.microsoft.com/cdo/smtpenvelope/senderemailaddress';
  //****************************************************************************

  //****************************************************************************
  cdoAutoPromoteBodyParts      = 'http://schemas.microsoft.com/cdo/configuration/autopromotebodyparts';
  cdoFlushBuffersOnWrite       = 'http://schemas.microsoft.com/cdo/configuration/flushbuffersonwrite';
  cdoHTTPCookies               = 'http://schemas.microsoft.com/cdo/configuration/httpcookies';
  cdoLanguageCode              = 'http://schemas.microsoft.com/cdo/configuration/languagecode';
  cdoNNTPAccountName           = 'http://schemas.microsoft.com/cdo/configuration/nntpaccountname';
  cdoNNTPAuthenticate          = 'http://schemas.microsoft.com/cdo/configuration/nntpauthenticate';
  cdoNNTPConnectionTimeout     = 'http://schemas.microsoft.com/cdo/configuration/nntpconnectiontimeout';
  cdoNNTPServer                = 'http://schemas.microsoft.com/cdo/configuration/nntpserver';
  cdoNNTPServerPickupDirectory = 'http://schemas.microsoft.com/cdo/configuration/nntpserverpickupdirectory';
  cdoNNTPServerPort            = 'http://schemas.microsoft.com/cdo/configuration/nntpserverport';
  cdoNNTPUseSSL                = 'http://schemas.microsoft.com/cdo/configuration/nntpusessl';
  cdoPostEmailAddress          = 'http://schemas.microsoft.com/cdo/configuration/postemailaddress';
  cdoPostPassword              = 'http://schemas.microsoft.com/cdo/configuration/postpassword';
  cdoPostUserName              = 'http://schemas.microsoft.com/cdo/configuration/postusername';
  cdoPostUserReplyEmailAddress = 'http://schemas.microsoft.com/cdo/configuration/postuserreplyemailaddress';
  cdoPostUsingMethod           = 'http://schemas.microsoft.com/cdo/configuration/postusing';
  cdoSaveSentItems             = 'http://schemas.microsoft.com/cdo/configuration/savesentitems';
  cdoSendEmailAddress          = 'http://schemas.microsoft.com/cdo/configuration/sendemailaddress';
  cdoSendPassword              = 'http://schemas.microsoft.com/cdo/configuration/sendpassword';
  cdoSendUserName              = 'http://schemas.microsoft.com/cdo/configuration/sendusername';
  cdoSendUserReplyEmailAddress = 'http://schemas.microsoft.com/cdo/configuration/senduserreplyemailaddress';
  cdoSendUsingMethod           = 'http://schemas.microsoft.com/cdo/configuration/sendusing';
  cdoSMTPAccountName           = 'http://schemas.microsoft.com/cdo/configuration/smtpaccountname';
  cdoSMTPAuthenticate          = 'http://schemas.microsoft.com/cdo/configuration/smtpauthenticate';
  cdoSMTPConnectionTimeout     = 'http://schemas.microsoft.com/cdo/configuration/smtpconnectiontimeout';
  cdoSMTPServer                = 'http://schemas.microsoft.com/cdo/configuration/smtpserver';
  cdoSMTPServerPickupDirectory = 'http://schemas.microsoft.com/cdo/configuration/smtpserverpickupdirectory';
  cdoSMTPServerPort            = 'http://schemas.microsoft.com/cdo/configuration/smtpserverport';
  cdoSMTPUseSSL                = 'http://schemas.microsoft.com/cdo/configuration/smtpusessl';
  cdoURLGetLatestVersion       = 'http://schemas.microsoft.com/cdo/configuration/urlgetlatestversion';
  cdoURLProxyBypass            = 'http://schemas.microsoft.com/cdo/configuration/urlproxybypass';
  cdoURLProxyServer            = 'http://schemas.microsoft.com/cdo/configuration/urlproxyserver';
  cdoUseMessageResponseText    = 'http://schemas.microsoft.com/cdo/configuration/usemessageresponsetext';
  //****************************************************************************

  //****************************************************************************
  cdoApproved                  = 'urn:schemas:mailheader:approved';
  cdoComment                   = 'urn:schemas:mailheader:comment';
  cdoContentBase               = 'urn:schemas:mailheader:content-base';
  cdoContentDescription        = 'urn:schemas:mailheader:content-description';
  cdoContentDisposition        = 'urn:schemas:mailheader:content-disposition';
  cdoContentId                 = 'urn:schemas:mailheader:content-id';
  cdoContentLanguage           = 'urn:schemas:mailheader:content-language';
  cdoContentLocation           = 'urn:schemas:mailheader:content-location';
  cdoContentTransferEncoding   = 'urn:schemas:mailheader:content-transfer-encoding';
  cdoContentType               = 'urn:schemas:mailheader:content-type';
  cdoControl                   = 'urn:schemas:mailheader:control';
  cdoDisposition               = 'urn:schemas:mailheader:disposition';
  cdoDispositionNotificationTo = 'urn:schemas:mailheader:disposition-notification-to';
  cdoDistribution              = 'urn:schemas:mailheader:distribution';
  cdoExpires                   = 'urn:schemas:mailheader:expires';
  cdoFollowupTo                = 'urn:schemas:mailheader:followup-to';
  cdoInReplyTo                 = 'urn:schemas:mailheader:in-reply-to';
  cdoLines                     = 'urn:schemas:mailheader:lines';
  cdoMessageId                 = 'urn:schemas:mailheader:message-id';
  cdoMIMEVersion               = 'urn:schemas:mailheader:mime-version';
  cdoNewsgroups                = 'urn:schemas:mailheader:newsgroups';
  cdoOrganization              = 'urn:schemas:mailheader:organization';
  cdoOriginalRecipient         = 'urn:schemas:mailheader:original-recipient';
  cdoPath                      = 'urn:schemas:mailheader:path';
  cdoPostingVersion            = 'urn:schemas:mailheader:posting-version';
  cdoReceived                  = 'urn:schemas:mailheader:received';
  cdoReferences                = 'urn:schemas:mailheader:references';
  cdoRelayVersion              = 'urn:schemas:mailheader:relay-version';
  cdoReturnPath                = 'urn:schemas:mailheader:return-path';
  cdoReturnReceiptTo           = 'urn:schemas:mailheader:return-receipt-to';
  cdoSummary                   = 'urn:schemas:mailheader:summary';
  cdoThreadIndex               = 'urn:schemas:mailheader:thread-index';
  cdoXMailer                   = 'urn:schemas:mailheader:x-mailer';
  cdoXref                      = 'urn:schemas:mailheader:xref';
  cdoXUnsent                   = 'urn:schemas:mailheader:x-unsent';
  //****************************************************************************

  //****************************************************************************
  cdoAttachmentFilename        = 'urn:schemas:httpmail:attachmentfilename';
  cdoBcc                       = 'urn:schemas:httpmail:bcc';
  cdoCc                        = 'urn:schemas:httpmail:cc';
  cdoContentDispositionType    = 'urn:schemas:httpmail:content-disposition-type';
  cdoContentMediaType          = 'urn:schemas:httpmail:content-media-type';
  cdoDate                      = 'urn:schemas:httpmail:date';
  cdoDateReceived              = 'urn:schemas:httpmail:datereceived';
  cdoFrom                      = 'urn:schemas:httpmail:from';
  cdoHasAttachment             = 'urn:schemas:httpmail:hasattachment';
  cdoHTMLDescription           = 'urn:schemas:httpmail:htmldescription';
  cdoImportance                = 'urn:schemas:httpmail:importance';
  cdoNormalizedSubject         = 'urn:schemas:httpmail:normalizedsubject';
  cdoPriority                  = 'urn:schemas:httpmail:priority';
  cdoReplyTo                   = 'urn:schemas:httpmail:reply-to';
  cdoSender                    = 'urn:schemas:httpmail:sender';
  cdoSubject                   = 'urn:schemas:httpmail:subject';
  cdoTextDescription           = 'urn:schemas:httpmail:textdescription';
  cdoThreadTopic               = 'urn:schemas:httpmail:thread-topic';
  cdoTo                        = 'urn:schemas:httpmail:to';
  //****************************************************************************

  //****************************************************************************
  cdoNewsgroupList             = 'http://schemas.microsoft.com/cdo/nntpenvelope/newsgrouplist';
  cdoNNTPProcessing            = 'http://schemas.microsoft.com/cdo/nntpenvelope/nntpprocessing';
  cdoTimeZoneIDURN             = 'urn:schemas:calendar:timezoneid';
  cdoNSConfiguration           = 'http://schemas.microsoft.com/cdo/configuration/';
  cdoNSContacts                = 'urn:schemas:contacts:';
  cdoNSHTTPMail                = 'urn:schemas:httpmail:';
  cdoNSMailHeader              = 'urn:schemas:mailheader:';
  cdoNSNNTPEnvelope            = 'http://schemas.microsoft.com/cdo/nntpenvelope/';
  cdoNSSMTPEnvelope            = 'http://schemas.microsoft.com/cdo/smtpenvelope/';
  //****************************************************************************


type
  TAuthMethod    = (cdo_Anonymous, cdo_Basic, cdo_NTLM);
  TActionType    = (SendMessage,PostMessage);
  TSendMethod    = (cdo_SendUsingPort, cdo_SendUsingPickup);
  TPostMethod    = (cdo_PostUsingPort, cdo_PostUsingPickup);
  TPriority      = (NonUrgent, Normal, Urgent);
  TXPriority     = (prHighest, prHigh, prNormal, prLow, prLowest);
  TDSNOptions    = (DSNNever, DSNFailure, DSNSuccess, DSNDelay, DSNSuccessFailOrDelay);
  TDSNOptionsSet = Set of TDSNOptions;
  TTextEncoding  = (te7bit, te8Bit, teBase64, teBinary, teMacBinHex40, teQuotedPrintable, teUuencode);
  TANotifyEvent  = Procedure (Sender : TObject; FileName:String; Var Attach:Boolean) Of Object;
  TLFileEvent    = Procedure (Sender : TObject; FileName:String; Var Load:Boolean) Of Object;
  TSFileEvent    = Procedure (Sender : TObject; FileName:String; Var Load:Boolean) Of Object;

  TAttachments   = Class;
  TKACDOMessage  = Class;


  TMimeList    = Class(TPersistent)
  Private
   F_Extensions  : TStringList;
   F_MimeTypes   : TStringList;
  Protected
    Procedure Build;
  Public
    Function GetExtensionByMimeType(MimeType  : String) : String;
    Function GetMimeTypeByExtension(Extension : String) : String;
    Constructor Create;
    Destructor  Destroy; override;
  End;

  TCDOCoder     = Class(TPersistent)
  Private
    F_CTS       : String;
    F_Charset   : String;
  Protected
  Public
    Constructor Create;
    Destructor  Destroy; override;
    Function    EncodeString(Const S : String):String;
    Procedure   EncodeStream(StreamIn, StreamOut:TStream);
    Procedure   EncodeFile(FileNameIn, FileNameOut:String);
    Function    DecodeString(Const S : String):String;
    Procedure   DecodeStream(StreamIn, StreamOut:TStream);
    Procedure   DecodeFile(FileNameIn, FileNameOut:String);
    Property    ContentTransferEncoding  : String  Read F_CTS      Write F_CTS;
    Property    Charset                  : String  Read F_Charset  Write F_Charset;
  End;


  TAttachmentType=(Attachment, BodyPart);
  TAttachment   = Class(TPersistent)
  Private
    Parent            : TAttachments;
    F_IsAttachment    : Boolean;
    F_FileName        : String;
    F_FullFileName    : String;
    F_Stream          : TMemoryStream;
    F_CTS             : String;
    F_CL              : String;
    F_ID              : OleVariant;
    F_AttType         : TAttachmentType;
    Function  F_Get_Stream : TMemoryStream;
    Procedure F_Set_Stream(Value : TMemoryStream);
  Protected
    Property            Stream                   : TMemoryStream   Read F_Get_Stream    Write F_Set_Stream;
    Property            AttachmentType           : TAttachmentType Read F_AttType       Write F_AttType;
  Public
    Procedure           SaveToFile(FileName:String);
    Property            FileName                 : String          Read F_FileName      Write F_FileName;
    Property            FullFileName             : String          Read F_FullFileName  Write F_FullFileName;
    Property            ContentTransferEncoding  : String          Read F_CTS           Write F_CTS;
    Property            ContentLocation          : String          Read F_CL            Write F_CL;
    Property            ID                       : OleVariant      Read F_ID            Write F_ID;
    Property            BodyBin                  : TMemoryStream   Read F_Get_Stream    Write F_Set_Stream;
    Property            IsAttachment             : Boolean         Read F_IsAttachment;
    Constructor         Create(AOwner:TAttachments);
    Destructor          Destroy; override;
  End;

  TAttachments  = Class(TPersistent)
  Private
    Parent           : TKACDOMessage;
    HoldType         : TAttachmentType;
    F_List           : TStringList;
    F_FullList       : TStringList;
    F_SavedList      : TStringList;
    F_AutoOverwrite  : Boolean;
    F_CTS            : String;
    Function           F_Get_Count:Integer;
    Function           F_Get_Item(Index:Integer) : TAttachment;
    Procedure          F_Set_Item(Index:Integer; Item : TAttachment);
    Function           F_Get_AutoOverwrite:Boolean;
    Procedure          F_Set_AutoOverwrite(Value:Boolean);
    Procedure          F_DeleteOleAttachment(Att : TAttachment);
    Property           AutoOverwrite       : Boolean     Read F_Get_AutoOverwrite  Write F_Set_AutoOverwrite;
  Protected
    Function    ExtractDocumentName(URL:String):String;
    Function    GetUniqueFileName(Path,FileName : String):String;
    Function    CheckInAttachments(Item : OleVariant):Boolean;
    Function    AddFromMemory(Item : OleVariant):Integer;
    Procedure   InternalClear;
  Public
    Procedure   Clear;
    Function    Add:Integer;Overload;
    Function    Add(FileName : String):Integer;Overload;
    Function    Add(URL, Username, Password: String):Integer;Overload;
    Function    AddFromBodyPart(Item : OleVariant):Integer;
    Procedure   Delete(Index:Integer);
    Function    IndexOf(Attachment:TAttachment):Integer;
    Function    IndexOfFileName(FileName:String):TAttachment;
    Function    IndexOfFullFileName(FileName:String):TAttachment;
    Function    IndexOfBodyPart(BodyPart:OleVariant):TAttachment;
    Function    SaveAll(Path:String):Boolean;
    Function    DeleteSaved(Path:String):Boolean;
    Constructor Create(AOwner:TComponent);
    Destructor  Destroy; override;
    Property    Count                      : Integer     Read F_Get_Count;
    Property    ContentTransferEncoding    : String      Read F_CTS        Write F_CTS;
    Property    SavedFiles                 : TStringList Read F_SavedList  Write F_SavedList;
    Property    Items[Index:Integer]       : TAttachment Read F_Get_Item   Write F_Set_Item;
  End;

  TKACDOMessage = class(TComponent)
  private
   { Private declarations }
   F_From                : String;
   F_Sender              : String;
   F_ReplyTo             : String;
   F_Receiver            : String;
   F_CC                  : String;
   F_BCC                 : String;
   F_FollowUpTo          : String;
   F_Keywords            : String;
   F_Newsgroups          : String;
   F_Organization        : String;
   F_Subject             : String;
   F_Body                : TStringList;
   F_HTMLBody            : TStringList;
   F_Headers             : TStringList;
   F_RawMail             : TStringList;
   F_Attachments         : TAttachments;
   F_BodyParts           : TAttachments;
   F_MimeFormatted       : Boolean;
   F_ReceivedTime        : TDateTime;
   F_SentOn              : TDateTime;
   F_Date                : String;
   F_FileName            : String;
   F_Charset             : String;
   F_AutoOverwrite       : Boolean;
   F_Priority            : TPriority;
   F_XPriority           : TXPriority;
   F_UserName            : String;
   F_TextEncoding        : TTextEncoding;
   F_HTMLEncoding        : TTextEncoding;
   F_XMailer             : String;
   F_MDNRequested        : Boolean;
   F_DSNOptions          : TDSNOptionsSet;
   F_NotificationTo      : String;
   F_ReturnReceiptTo     : String;
   F_ContentType         : String;
   F_AutoGenerateTextBody: Boolean;

   F_MimeList            : TMimeList;

   F_Activate            : Boolean;

   F_SMTPServer          : String;
   F_SMTPServerPort      : Integer;
   F_SMTPAuthMethod      : TAuthMethod;
   F_SMTPUsername        : String;
   F_SMTPPassword        : String;
   F_SMTPSendMethod      : TSendMethod;
   F_SMTPTimeOut         : Integer;
   F_SMTPPickupDir       : String;


   F_NNTPServer          : String;
   F_NNTPServerPort      : Integer;
   F_NNTPAuthMethod      : TAuthMethod;
   F_NNTPUsername        : String;
   F_NNTPPassword        : String;
   F_NNTPPostMethod      : TPostMethod;
   F_NNTPTimeOut         : Integer;
   F_NNTPPickupDir       : String;
   F_NNTPAccountName     : String;

   F_LastError           : String;
   F_Version             : String;
   F_AttachmentsEditor   : String;
   F_BodyPartsEditor     : String;
   F_ViewStyle           : TViewStyle;

   F_JITCharsetCoding    : Boolean;
   F_ActionType          : TActionType;


   F_BeforeAttach        : TANotifyEvent;
   F_AfterAttach         : TNotifyEvent;
   F_BeforeCompose       : TNotifyEvent;
   F_AfterCompose        : TNotifyEvent;
   F_BeforeSend          : TNotifyEvent;
   F_AfterSend           : TNotifyEvent;
   F_BeforeLoadFromFile  : TLFileEvent;
   F_AfterLoadFromFile   : TNotifyEvent;
   F_BeforeSaveToFile    : TSFileEvent;
   F_AfterSaveToFile     : TNotifyEvent;

   Procedure Sync_;
   Procedure TextBodyChange_(Sender:TObject);
   Procedure HTMLBodyChange_(Sender:TObject);

   Function  F_Get_From              : String;
   Function  F_Get_Username          : String;
   Function  F_Get_Sender            : String;
   Function  F_Get_ReplyTo           : String;
   Function  F_Get_Receiver          : String;
   Function  F_Get_CC                : String;
   Function  F_Get_BCC               : String;
   Function  F_Get_FollowUpTo        : String;
   Function  F_Get_Keywords          : String;
   Function  F_Get_Newsgroups        : String;
   Function  F_Get_Organization      : String;
   Function  F_Get_Subject           : String;
   Function  F_Get_Body              : TStrings;
   Function  F_Get_HTMLBody          : TStrings;
   Function  F_Get_ContentType       : String;
   Function  F_Get_Headers           : TStrings;
   Function  F_Get_RawMail           : TStrings;
   Function  F_Get_Attachments       : TAttachments;
   Function  F_Get_BodyParts         : TAttachments;
   Function  F_Get_MimeFormatted     : Boolean;
   Function  F_Get_TextEncoding      : TTextEncoding;
   Function  F_Get_HTMLEncoding      : TTextEncoding;
   Function  F_Get_ReceivedTime      : TDateTime;
   Function  F_Get_SentOn            : TDateTime;
   Function  F_Get_Date              : String;
   Function  F_Get_FileName          : String;
   Function  F_Get_Charset           : String;
   Function  F_Get_Priority          : TPriority;
   Function  F_Get_XPriority         : TXPriority;
   Function  F_Get_XMailer           : String;
   Function  F_Get_MDNRequested      : Boolean;
   Function  F_Get_NotificationTo    : String;
   Function  F_Get_ReturnReceiptTo   : String;
   Function  F_Get_DSNOptions        : TDSNOptionsSet;
   Function  F_Get_AutoGenerateText  : Boolean;
   Function  F_Get_Activate          : Boolean;



   Procedure F_Set_From                (Value : String);
   Procedure F_Set_Username            (Value : String);
   Procedure F_Set_Sender              (Value : String);
   Procedure F_Set_ReplyTo             (Value : String);
   Procedure F_Set_Receiver            (Value : String);
   Procedure F_Set_CC                  (Value : String);
   Procedure F_Set_BCC                 (Value : String);
   Procedure F_Set_FollowUpTo          (Value : String);
   Procedure F_Set_Keywords            (Value : String);
   Procedure F_Set_Newsgroups          (Value : String);
   Procedure F_Set_Organization        (Value : String);
   Procedure F_Set_Subject             (Value : String);
   Procedure F_Set_Body                (Value : TStrings);
   Procedure F_Set_HTMLBody            (Value : TStrings);
   Procedure F_Set_ContentType         (Value : String);
   Procedure F_Set_Headers             (Value : TStrings);
   Procedure F_Set_RawMail             (Value : TStrings);
   Procedure F_Set_Attachments         (Value : TAttachments);
   Procedure F_Set_BodyParts           (Value : TAttachments);
   Procedure F_Set_MimeFormatted       (Value : Boolean);
   Procedure F_Set_TextEncoding        (Value : TTextEncoding);
   Procedure F_Set_HTMLEncoding        (Value : TTextEncoding);
   Procedure F_Set_ReceivedTime        (Value : TDateTime);
   Procedure F_Set_SentOn              (Value : TDateTime);
   Procedure F_Set_Date                (Value : String);
   Procedure F_Set_FileName            (Value : String);
   Procedure F_Set_Charset             (Value : String);
   Procedure F_Set_AutoOverwrite       (Value : Boolean);
   Procedure F_Set_Priority            (Value : TPriority);
   Procedure F_Set_XPriority           (Value : TXPriority);
   Procedure F_Set_XMailer             (Value : String);
   Procedure F_Set_MDNRequested        (Value : Boolean);
   Procedure F_Set_DSNOptions          (Value : TDSNOptionsSet);
   Procedure F_Set_NotificationTo      (Value : String);
   Procedure F_Set_ReturnReceiptTo     (Value : String);
   Procedure F_Set_Version             (Value : String);
   Procedure F_Set_AutoGenerateText    (Value : Boolean);
   Procedure F_Set_AttachmentsEditor   (Value : String);
   Procedure F_Set_BodyPartsEditor     (Value : String);
   Procedure F_Set_Activate            (Value : Boolean);
  protected
   { Protected declarations }
   Function  FieldExists(Name:String):Boolean;
   Procedure AddHeaders;
   Procedure SetConfiguration;
   Procedure RebuildConfiguration;
   Procedure RefreshBodyPartNode(Part:OleVariant);
   Procedure RefreshMessage;
   Procedure ComposeMessage;

   Procedure Loaded; Override;
  public
   { Public declarations }
   CoreMessage : OleVariant;
   CoreConfig  : OleVariant;
   Coder       : TCdoCoder;
   Constructor   Create(AOwner: TComponent); override;
   Destructor    Destroy; override;
   Procedure     RestoreDefaults;

   Procedure     RefreshBodyParts;
   Procedure     RefreshAttachments;
   Procedure     FillRawMail;
   Procedure     UpdateMessage;

   Procedure     SaveToFile(FileName:String);
   Procedure     SaveToStream(Stream : TStream);

   Procedure     LoadFromFile(FileName:String);
   Procedure     LoadFromTextFile(FileName:String);
   Procedure     LoadFromStream(Stream : TStream);
   Procedure     LoadFromCDOMessage(CDOMessage:OleVariant);

   Procedure     CreateHTMLBodyFromURL(URL, Username, Password : String; Options : Integer);
   Function      GetURLAsMHTML(URL, Username, Password : String; Options : Integer):String;
   Procedure     SaveURLAsMHTML(URL, Username, Password, FileName : String; Options : Integer);
   Function      ExtractTextFromHTMLURL(URL, Username, Password : String):String;
   Function      ExtractTextFromHTMLFile(FileName : String):String;

   Procedure     NewMessage;
   Procedure     Send;
   Procedure     Post;

   Procedure     GetPostReply;
   Procedure     GetReply;
   Procedure     GetReplyAll;
   Procedure     GetForwardMessage;

   Function      GetName:String;
   Function      GetAddress:String;
   Procedure     GetNameAndAddress(Var Name : String; Var Address: String);
   Function      ConvertToCharset(Text, SrcCharset, DstCharset : String):WideString;
   /////////////////////////////////////////////////////////////////////////////////////////////////////////////
   Procedure     SetConfigField(FieldName:String; Value : OleVariant);
   Function      GetConfigField(FieldName:String) : OleVariant;

   Procedure     SetEnvelopeField(FieldName:String; Value : OleVariant);
   Function      GetEnvelopeField(FieldName:String) : OleVariant;
   /////////////////////////////////////////////////////////////////////////////////////////////////////////////
   {$IFDEF USE_EDITORS}
   Function      ManageAttachments : Boolean;
   Function      ManageBodyParts : Boolean;
   Function      ViewBodyParts   : Boolean;
   {$ENDIF}
   /////////////////////////////////////////////////////////////////////////////////////////////////////////////
   Property      Attachments         : TAttachments     Read F_Get_Attachments              Write F_Set_Attachments;
   Property      AttachedFiles       : TAttachments     Read F_Get_Attachments              Write F_Set_Attachments;
   Property      BodyParts           : TAttachments     Read F_Get_BodyParts                Write F_Set_BodyParts;

   Property      Text                : TStrings         Read F_Get_Body                     Write F_Set_Body;
   Property      HTML                : TStrings         Read F_Get_HTMLBody                 Write F_Set_HTMLBody;
   Property      SendTo              : String           Read F_Get_Receiver                 Write F_Set_Receiver;
   Property      Receiver            : String           Read F_Get_Receiver                 Write F_Set_Receiver;
   Property      UserName            : String           Read F_Get_Username                 Write F_Set_Username;
   /////////////////////////////////////////////////////////////////////////////////////////////////////////////
   Property      From                : String           Read F_Get_From                     Write F_Set_From;
   Property      FullName            : String           Read F_Get_Username                 Write F_Set_Username;
   Property      To_                 : String           Read F_Get_Receiver                 Write F_Set_Receiver;
   Property      CC                  : String           Read F_Get_CC                       Write F_Set_CC;
   Property      BCC                 : String           Read F_Get_BCC                      Write F_Set_BCC;
   Property      Subject             : String           Read F_Get_Subject                  Write F_Set_Subject;
   Property      Body                : TStrings         Read F_Get_Body                     Write F_Set_Body;
   Property      HTMLBody            : TStrings         Read F_Get_HTMLBody                 Write F_Set_HTMLBody;
   Property      TextEncoding        : TTextEncoding    Read F_Get_TextEncoding             Write F_Set_TextEncoding;
   Property      HTMLEncoding        : TTextEncoding    Read F_Get_HTMLEncoding             Write F_Set_HTMLEncoding;
   Property      MimeList            : TMimeList        Read F_MimeList;
  published
   { Published declarations }
   /////////////////////////////////////////////////////////////////////////////////////////////////////////////
   Property      AutoGenerateTextBody     : Boolean         Read F_Get_AutoGenerateText  Write  F_Set_AutoGenerateText;
   Property      FileName                 : String          Read F_Get_FileName          Write F_Set_FileName;
   Property      CDO01_From               : String          Read F_Get_From              Write F_Set_From;
   Property      CDO02_FullName           : String          Read F_Get_Username          Write F_Set_Username;
   Property      CDO03_To                 : String          Read F_Get_Receiver          Write F_Set_Receiver;
   Property      CDO04_CC                 : String          Read F_Get_CC                Write F_Set_CC;
   Property      CDO05_BCC                : String          Read F_Get_BCC               Write F_Set_BCC;
   Property      CDO06_Subject            : String          Read F_Get_Subject           Write F_Set_Subject;
   Property      CDO07_Body               : TStrings        Read F_Get_Body              Write F_Set_Body;
   Property      CDO08_HTMLBody           : TStrings        Read F_Get_HTMLBody          Write F_Set_HTMLBody;
   Property      CDO09_TextEncoding       : TTextEncoding   Read F_Get_TextEncoding      Write F_Set_TextEncoding;
   Property      CDO10_HTMLEncoding       : TTextEncoding   Read F_Get_HTMLEncoding      Write F_Set_HTMLEncoding;
   Property      ContentType              : String          Read F_Get_ContentType       Write F_Set_ContentType;
   Property      FollowUpTo               : String          Read F_Get_FollowUpTo        Write F_Set_FollowUpTo;
   Property      Keywords                 : String          Read F_Get_Keywords          Write F_Set_Keywords;
   Property      Newsgroups               : String          Read F_Get_Newsgroups        Write F_Set_Newsgroups;
   Property      Organization             : String          Read F_Get_Organization      Write F_Set_Organization;
   Property      Sender                   : String          Read F_Get_Sender            Write F_Set_Sender;
   Property      ReplyTo                  : String          Read F_Get_ReplyTo           Write F_Set_ReplyTo;
   /////////////////////////////////////////////////////////////////////////////////////////////////////////////
   Property      Headers                  : TStrings        Read F_Get_Headers           Write F_Set_Headers;
   Property      MimeFormatted            : Boolean         Read F_Get_MimeFormatted     Write F_Set_MimeFormatted;
   Property      ReceivedTime             : TDateTime       Read F_Get_ReceivedTime      Write F_Set_ReceivedTime;
   Property      SentOn                   : TDateTime       Read F_Get_SentOn            Write F_Set_SentOn;
   Property      Date                     : String          Read F_Get_Date              Write F_Set_Date;
   Property      Priority                 : TPriority       Read F_Get_Priority          Write F_Set_Priority;
   Property      XPriority                : TXPriority      Read F_Get_XPriority         Write F_Set_XPriority;
   Property      XMailer                  : String          Read F_Get_XMailer           Write F_Set_XMailer;
   Property      MDNRequested             : Boolean         Read F_Get_MDNRequested      Write F_Set_MDNRequested;
   Property      DSNOptions               : TDSNOptionsSet  Read F_Get_DSNOptions        Write F_Set_DSNOptions;
   Property      NotificationTo           : String          Read F_Get_NotificationTo    Write F_Set_NotificationTo;
   Property      ReturnReceiptTo          : String          Read F_Get_ReturnReceiptTo   Write F_Set_ReturnReceiptTo;
   /////////////////////////////////////////////////////////////////////////////////////////////////////////////
   Property      JITCharsetCoding         : Boolean         Read F_JITCharsetCoding      Write F_JITCharsetCoding;
   Property      Charset                  : String          Read F_Get_Charset           Write F_Set_Charset;
   /////////////////////////////////////////////////////////////////////////////////////////////////////////////
   Property      SMTPServer               : String          Read F_SMTPServer            Write F_SMTPServer;
   Property      SMTPServerPort           : Integer         Read F_SMTPServerPort        Write F_SMTPServerPort;
   Property      SMTPAuthMethod           : TAuthMethod     Read F_SMTPAuthMethod        Write F_SMTPAuthMethod;
   Property      SMTPUsername             : String          Read F_SMTPUsername          Write F_SMTPUsername;
   Property      SMTPPassword             : String          Read F_SMTPPassword          Write F_SMTPPassword;
   Property      SMTPSendMethod           : TSendMethod     Read F_SMTPSendMethod        Write F_SMTPSendMethod;
   Property      SMTPTimeOut              : Integer         Read F_SMTPTimeOut           Write F_SMTPTimeOut;
   Property      SMTPPickupDir            : String          Read F_SMTPPickupDir         Write F_SMTPPickupDir;
   /////////////////////////////////////////////////////////////////////////////////////////////////////////////
   Property      NNTPServer               : String          Read F_NNTPServer            Write F_NNTPServer;
   Property      NNTPServerPort           : Integer         Read F_NNTPServerPort        Write F_NNTPServerPort;
   Property      NNTPAuthMethod           : TAuthMethod     Read F_NNTPAuthMethod        Write F_NNTPAuthMethod;
   Property      NNTPUsername             : String          Read F_NNTPUsername          Write F_NNTPUsername;
   Property      NNTPPassword             : String          Read F_NNTPPassword          Write F_NNTPPassword;
   Property      NNTPPostMethod           : TPostMethod     Read F_NNTPPostMethod        Write F_NNTPPostMethod;
   Property      NNTPTimeOut              : Integer         Read F_NNTPTimeOut           Write F_NNTPTimeOut;
   Property      NNTPPickupDir            : String          Read F_NNTPPickupDir         Write F_NNTPPickupDir;
   Property      NNTPAccountName          : String          Read F_NNTPAccountName       Write F_NNTPAccountName;
   /////////////////////////////////////////////////////////////////////////////////////////////////////////////
   Property      BeforeAttach             : TANotifyEvent   Read F_BeforeAttach          Write F_BeforeAttach;
   Property      AfterAttach              : TNotifyEvent    Read F_AfterAttach           Write F_AfterAttach;
   Property      BeforeLoadFromFile       : TLFileEvent     Read F_BeforeLoadFromFile    Write F_BeforeLoadFromFile;
   Property      AfterLoadFromFile        : TNotifyEvent    Read F_AfterLoadFromFile     Write F_AfterLoadFromFile;
   Property      BeforeSaveToFile         : TSFileEvent     Read F_BeforeSaveToFile      Write F_BeforeSaveToFile;
   Property      AfterSaveToFile          : TNotifyEvent    Read F_AfterSaveToFile       Write F_AfterSaveToFile;
   Property      BeforeCompose            : TNotifyEvent    Read F_BeforeCompose         Write F_BeforeCompose;
   Property      AfterCompose             : TNotifyEvent    Read F_AfterCompose          Write F_AfterCompose;
   Property      BeforeSend               : TNotifyEvent    Read F_BeforeSend            Write F_BeforeSend;
   Property      AfterSend                : TNotifyEvent    Read F_AfterSend             Write F_AfterSend;
   /////////////////////////////////////////////////////////////////////////////////////////////////////////////
   Property      LastError                : String          Read F_LastError             Write F_LastError;
   Property      AttachmentsEditor        : String          Read F_AttachmentsEditor     Write F_Set_AttachmentsEditor;
   Property      BodyPartsEditor          : String          Read F_BodyPartsEditor       Write F_Set_BodyPartsEditor;
   Property      ViewStyle                : TViewStyle      Read F_ViewStyle             Write F_ViewStyle;
   Property      Version                  : String          Read F_Version               Write F_Set_Version;
   Property      AutoOverwrite            : Boolean         Read F_AutoOverwrite         Write F_Set_AutoOverwrite;
   Property      ActionType               : TActionType     Read F_ActionType            Write F_ActionType;
   /////////////////////////////////////////////////////////////////////////////////////////////////////////////
   Property      RawMail                  : TStrings        Read F_Get_RawMail           Write F_Set_RawMail;
   Property      Activate                 : Boolean         Read F_Get_Activate          Write F_Set_Activate;
  end;

procedure Register;

implementation
Uses
  ComObj, ActiveX {$IFDEF USE_EDITORS},KACDOAttachmentsUnit, KACDOBodyPartsUnit{$ENDIF};

end.