unit KACDOManager;
{$I KACDOCommonDirectives.pas}
interface

uses
  Windows, Messages, SysUtils, Classes, Variants, KACDOMessage, Dialogs;

Type                                                                
  TKACDOManager = class(TComponent)
  private
    { Private declarations }
    F_CDOMessage    : TKACDOMessage;
    F_Version       : String;
    F_DropDir       : String;
    F_FileName      : String;
    F_FullFileNames : TStringList;
    F_FileNames     : TStringList;

    Function           F_Get_Count : Integer;
    Function           F_Get_FileNames : TStrings;
    Function           F_Get_FullFileNames : TStrings;

    Procedure          F_Set_DropDir       (Value:String);
    Procedure          F_Set_FileName      (Value:String);
    Procedure          F_Set_FileNames     (Value:TStrings);
    Procedure          F_Set_FullFileNames (Value:TStrings);
    Procedure          F_Set_Version       (Value:String);
    Procedure          F_Set_CDOMessage    (Value:TKACDOMessage);

  protected
    { Protected declarations }
    Procedure         GetAllMessages;
    Procedure         Notification(AComponent: TComponent; Operation: TOperation); override;
    Procedure         Loaded; override;
  public
    { Public declarations }
    CoreMessages    : OleVariant;
    CoreDropDir     : OleVariant;
    CoreConfig      : OleVariant;
    Procedure         DeleteMessage(Index:Integer);
    Procedure         DeleteAllMessages;
    Constructor       Create(AOwner:TComponent); override;
    Destructor        Destroy; override;
    Property          Count          : Integer       Read F_Get_Count;
    Property          FileNames      : TStrings      Read F_Get_FileNames     Write F_Set_FileNames;
    Property          FullFileNames  : TStrings      Read F_Get_FullFileNames Write F_Set_FullFileNames;
  published
    { Published declarations }
    Property          CDOMessage     : TKACDOMessage Read F_CDOMessage        Write F_Set_CDOMessage;
    Property          DropDirectory  : String        Read F_DropDir           Write F_Set_DropDir;
    Property          FileName       : String        Read F_FileName          Write F_Set_FileName;
    Property          Version        : String        Read F_Version           Write F_Set_Version;
  end;

procedure Register;

implementation
Uses
  ComObj, ActiveX;

end.
 