{ PLEASE, READ THIS IMPORTANT INFORMATION FIRST.
  Class TURLBtn,  Benot Standaert, 2001.
  TURLBtn is a component derived from the class TSpeedbutton.

  Install this component via Delphi as usual
    - Menu Component, Install Component
    - Choose to install into an existing package or create one
    - Compile, then install

  This component is used to launch the default browser on a URL using these
  properties :
  - URL :       just complete this field to launch the browser at this address.
                It contains a pre-set field : http://www. to help you. The URL
                must be complete and have the format of a normal URL regarding
                the target browser. STRING.
  - Active :    set it to true to launch the browser on the URL of your choice,
                see above. If this property is set to False, TURLBtn will just
                act like a normal speedbutton. By default this property is set
                to true. BOOLEAN

  Note: If you give the Fullpath of an application, something like
  application.exename (C:\MeApp\MeApp.exe), it will launch this application

  It uses the Event onclick and the property Active set to true to launch the
  default browser on the URL of your choice (property URL).
  It is important to use a proper URL and of course to be connected on the
  Internet to have a correct result.
  A boolean property called ACTIVE is set by defaut on True.
  Once ACTIVE is true the OnClick event should no more be used or the
  procedure ControlActive and GoToURLNow will never be executed and/or an
  unexpected result should appear.
  The component uses the event onclick to launch the
  procedure ControlActive that checks if the field Active is set to true,
  if it is the case it launches the procedure GoToURLNow. GoToURLNow is the
  procedure to launch the default browser on the URL set inside the property
  URL but the procedure GoToURLNow doesn't check the validity of the URL.
  It's up to you to control the validity of the URL.

  These properties should also have your interest :
  - Warning :   this a boolean property. It is set by default on true. If true
                and if for any reason while trying to launch the default browser
                an error occurs, the software will show a single message.
                You can set this message via the property WarningMsg, see
                bellow.
  - WarningMsg: this is a string property. It contains the message to show if
                for any reason an error occurs while trying to launch the
                default Internet Browser and also if the Warning property is set
                to true. This message is by default :
                           'This machine has no Internet Browser'.


  IMPORTANT REMARKS :
  - If the property Active is set to false, the URLBtn is just acting like a
    speedbutton.
  - If the property Active is set to true, please DO NOT USE THE EVENT ONCLICK,
    or nothing will happend and the URLBtn will just act like a speedbutton.
  - This component doesn't verify the validity of this proprety :
        URL : no control of the URL address.
  - It uses your default Internet browser. Hope you have one.
  - If against all odds you'll want to use the OnClick event and you'll want
    to use the component procedure GoToURLNow, do something like this :

     You do use the ACTIVE property here :

        procedure TForm1.URLBtn1click (Sender: TObject);
        ...
        begin
         URLBtn1.ControlActive (sender);
         ...
        end;

     You do not use the ACTIVE property here :

        procedure TForm1.URLBtn1click (Sender: TObject);
        ...
        begin
         URLBtn1.GoToURLNow (Sender);
         ...
        end;

      ((TForm1 is the name of your form (where did you drop the URLBtn?) and
      URLBtn1 the name of the component))

     You might expect some weird result, you'll have to test, and IT IS YOUR
     RESPONSABILITY.


  This property is also new and gives you a STRING result :

  COPYRIGHT : hey, I did this component after all.

  The component register itself into you palette component under the tab:
  'TicTacToe'

  I hate this but here is a disclaimer.

  DISCLAIMER :
  This component is FREEWARE but it is still the property of it's author :
   Benot Standaert, 2001.
  You use this component AT YOUR OWN RISK. I wont be responsible for
  any kind of problem you might encounter. This component is given AS IS.
  If you do not agree with this disclaimer YOU CANNOT INSTALL THIS COMPONENT
  AND ALSO YOU CANNOT USE IT.

  Please, report any bugs and or comments to this Email : b_standaert@iinet.net.au
  I would also appreciate notification of any improvements or/and modification
  you might make to this component!
  }
unit URLBtn;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Buttons, ShellApi;

type
  TURLBtn = class(TSpeedButton)
  private
    { Private declarations }

  protected
    { Protected declarations }
   FURL : String;
   FCopyright  : String;
   FActive : Boolean;
   FWarning : Boolean;
   FWarningMsg : String;
  public
    { Public declarations }
   constructor create (aowner: tcomponent); override;
   destructor destroy; override;
   procedure GoToURLNow (Sender: TObject);
   procedure ControlActive (Sender: TObject);
  published
    { Published declarations }
   property URL:String          read FURL        write FURL;
   property Copyright:String    read FCopyright;
   property Active:Boolean      read FActive     write FActive;
   property Warning:Boolean     read FWarning    write FWarning;
   property WarningMsg:String   Read FWarningMsg write FWarningMsg;
  end;

procedure Register;

implementation

constructor TURLBtn.create;
 begin
  inherited create (AOwner);
  FActive := true;
  FCopyright := ' Benot Standaert, 2001';
  FUrl := 'http://www.';
  FWarning := true;
  FWarningMsg := 'This machine has no Internet Browser.';
  Onclick := ControlActive;
 end;

destructor TURLBtn.destroy;
 begin
  inherited destroy;
 end;

procedure TURLBtn.ControlActive (Sender: TObject);
 begin
  If FActive = true then GotoURLNow (Sender);
 end;

procedure TURLBtn.GoToURLNow (Sender: TOBject);
 begin
  try
   ShellExecute(0,nil,PChar (FUrl),nil,nil,SW_NORMAL);
  except
   if Fwarning = true then
    begin
     showmessage (FWarningMsg);
    end;
  end;

 end;

procedure Register;
begin
  RegisterComponents('TicTacToe', [TURLBtn]);
end;

end.
