unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ShellAPI, StdCtrls, Buttons, ExtCtrls, URLBtn, FileCtrl, SBPro;

type
  TForm1 = class(TForm)
    OpenDialog1: TOpenDialog;
    Panel1: TPanel;
    Edit1: TEdit;
    SpeedButton1: TSpeedButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Panel2: TPanel;
    URLBtn1: TURLBtn;
    URLBtn2: TURLBtn;
    URLBtn3: TURLBtn;
    SpeedButton2: TSpeedButton;
    Label5: TLabel;
    Label6: TLabel;
    SpeedButton3: TSpeedButton;
    procedure SpeedButton1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure GetIcon(Filename,IconFilename:String;MiniIcon:Boolean);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

// Just a nice function to extract part of a string
function GetToken(aString, SepChar: string; TokenN: Byte): string;
var
  Token: string;
  StrL, N, EofToken: Byte;
begin
  StrL := Length(aString);
  N := 1;
  EofToken := StrL;
  while ((N <= TokenN) and (EofToken <> 0)) do
  begin
    EofToken := Pos(SepChar, aString);
    if EofToken <> 0 then
    begin
      Token := Copy(aString, 1, EofToken - 1);
      Delete(aString, 1, EofToken);
      Inc(N);
    end
    else
      Token := aString;
  end;
  if N >= TokenN then
    Result := Token
  else
    Result := '';
end;

// Nice trick to find the Associated program
function FindAssociatedApp(const Doc: string): string;
var
  //This a buffer
  PExecFile: array[0..Windows.MAX_PATH] of Char;
begin
  // A little call to a win api
  if ShellAPI.FindExecutable(PChar(Doc), nil, PExecFile) < 32 then
    // Oops Nothing was found
    Result := ''
  else
    // Yes we got something
    Result := PExecFile;
end;

// Get icon from the Associated progam
procedure TForm1.GetIcon(Filename,IconFilename:String;MiniIcon:Boolean);
var
  Icon32, Icon16 : HIcon;  //Icon can be 32x32 pixel but only the 16x16 is nice for Speedbutton
  Icon : TIcon;        // Need an Icon
  Bitmap : TBitmap;    // Need a Bitmap
  Bitmapname : string; // Need to save the file
begin
  // Extraction of the icon out of the Associated software
  ExtractIconEx(Pchar(Filename),0,Icon32,Icon16,1);
  try
  // If an Icon 16x16 pixels is able to be create then ...
  if (Icon16<>0) and MiniIcon then
    begin
     // Creation of an Icon
     Icon:=TIcon.Create;
     Icon.handle:=Icon16;
     // Determine the Path where to save this bitmap
     BitmapName := Label1.Caption;
     BitmapName := (ExtractFilePath (Application.ExeName) + GetToken (BitmapName, '.', 1) + '.bmp');
     //Creation of a bitmap
     Bitmap:=TBitmap.create;
     Bitmap.Height := Icon.Height;
     Bitmap.Width  := Icon.Width;
     //Draw the icon on the bitmap canvas
     Bitmap.Canvas.Draw(7, 7, Icon);
     //Saving the bitmap
     Bitmap.SaveToFile(bitmapname);
     //Loading the bitmap on a button
     UrlBtn2.Transparent := true;
     UrlBtn2.Glyph.LoadFromFile (Bitmapname);
     //Delete the bitmap previously saved
     deletefile (bitmapname);
     //Let's free the bitmap and the icon, delphi will not do it
     Bitmap.Free;
     Icon.Free;
   end;
   except
     // silent error or whatever message can be placed here
   end;
end;

procedure TForm1.SpeedButton1Click(Sender: TObject);
var
 IconName : string;
begin
  // Obtain a valid filename
  if opendialog1.Execute then
    begin
      //The filename is placed into the edit box
      Edit1.Text := ExtractFileName (OpenDialog1.FileName);
      //Let's get an associated program for this file
      Label1.Caption :=  ExtractFileName (FindAssociatedApp (edit1.Text));
      // If the resul is NOT '' then we can do something
      if label1.Caption <> '' then
        begin
          //Label1.hint gives the full path of the associated program
          Label1.ShowHint := true;
          Label1.hint := FindAssociatedApp (edit1.Text);
          //Label6.Caption will contains the path too but adapted to it's canvas (Autosize is false, and the width pushed to the max)
          Label6.Caption :=  MinimizeName(ExtractFilePath (Label1.Hint),label6.Canvas, label6.Width);

          // This button contains the Folder path of the associated path
          UrlBtn1.URL := ExtractFilePath (Label1.Hint);
          UrlBtn1.Enabled := true;
          //This button contains the 'associated_program.filename'
          UrlBtn2.URL := Label1.Hint;
          UrlBtn2.Enabled := true;
          // This button contains the 'selected_document.filename'
          UrlBtn3.URL := Edit1.Text;
          UrlBtn3.Enabled := true;
                        //SpeedButton3.Enabled := true;  // You can associate this button to whatever you like
          //Now let's get an icon for the UrlBtn2.gliph
          IconName := ExtractFileName (Label1.Hint);
          IconName := (GetToken (IconName, '.' , 1) + '.ico');
          GetIcon (Label1.Hint, IconName, true);  // Always the mini icon
        end
      else
        begin
          Label1.ShowHint := false;
          label1.Caption := 'Unknown';
          Label6.Caption := 'None';
          UrlBtn1.Enabled := false;
          UrlBtn2.Enabled := false;
          UrlBtn3.Enabled := false;
          //SpeedButton3.Enabled := false;
        end;
    end;

end;

procedure TForm1.FormCreate(Sender: TObject);
begin
  Edit1.Text := 'Click the button right this edit box';
end;

procedure TForm1.SpeedButton2Click(Sender: TObject);
begin
  close;
end;

procedure TForm1.SpeedButton3Click(Sender: TObject);
begin
 // Do something with this button here.
end;

end.
