{|
  Unit   : uEstSearchDialogZeos
  Date   : 01-01-2004
  Auteur : Erik Stok
  Doel   : Zeos versie van het search dialog component
|}
unit uEstSearchDialogZeos;

interface

uses
  Classes, DB, ZConnection, ZDataSet, uEstSearchDialog;

type

  TEstSearchDialogZeos = class(TEstSearchDialog)
  private
    FConnection: TZConnection;
    FSearchQuery: TZReadOnlyQuery;
    FcountQuery: TZReadOnlyQuery;
  protected
    procedure SetConnection(const Value: TZConnection); virtual;

    function SearchDataSet: TDataSet; override;
    function CountDataSet: TDataSet; override;

    procedure DoSetSearchQuery(Sender: TObject; SQL: String); override;
    procedure DoSetCountQuery(Sender: TObject; SQL: String); override;

    function ValidConnection: Boolean; override;

    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;

    procedure AssignTo(Dest: TPersistent); override;

  published
    property Connection: TZConnection read FConnection write SetConnection;
  end;


implementation

{ TEstSearchDialogZeos }

constructor TEstSearchDialogZeos.Create(AOwner: TComponent);
begin
  inherited;

  // Init privates
  FConnection := nil;

  FSearchQuery := TZReadOnlyQuery.Create(Self);
  FcountQuery := TZReadOnlyQuery.Create(Self);
end;

destructor TEstSearchDialogZeos.Destroy;
begin
  // Ruim alles netjes op
  FSearchQuery.Free;
  FcountQuery.Free;

  inherited;
end;

{|
  Procedure : TEstSearchDialogZeos.SetConnection
  Auteur    : Erik Stok
  Doel      : Stel de connection van het search dialog component in
|}
procedure TEstSearchDialogZeos.SetConnection(const Value: TZConnection);
begin
  if Value <> FConnection then
  begin
    // Stel connection in op gegeven waarde
    FConnection := Value;

    // Stel van de search en count queries ook de connections in
    FSearchQuery.Connection := FConnection;
    FcountQuery.Connection := FConnection;
  end;
end;

function TEstSearchDialogZeos.CountDataSet: TDataSet;
begin
  Result := FCountQuery;
end;

function TEstSearchDialogZeos.SearchDataSet: TDataSet;
begin
  Result := FSearchQuery;
end;

procedure TEstSearchDialogZeos.DoSetSearchQuery(Sender: TObject; SQL: String);
begin
  inherited;

  // Stel search query in
  FSearchQuery.Close;
  FSearchQuery.SQL.Text := SQL;
end;

procedure TEstSearchDialogZeos.DoSetCountQuery(Sender: TObject; SQL: String);
begin
  inherited;

  // Stel count query in
  FCountQuery.Close;
  FCountQuery.SQL.Text := SQL;
end;

{|
  Procedure : TEstSearchDialogZeos.AssignTo
  Auteur    : Erik Stok
  Doel      : Assign ook de connection
|}
procedure TEstSearchDialogZeos.AssignTo(Dest: TPersistent);
var
  DestSearchDialog : TEstSearchDialogZeos;
begin
  inherited AssignTo(Dest);

  DestSearchDialog := Dest as TEstSearchDialogZeos;
  DestSearchDialog.Connection := Connection;
end;

{|
  Procedure : TEstSearchDialogZeos.ValidConnection
  Auteur    : Erik Stok
  Doel      : Controleer of de opgegeven connection geldig is
|}
function TEstSearchDialogZeos.ValidConnection: Boolean;
begin
  Result := Assigned(Connection);
end;

procedure TEstSearchDialogZeos.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited;

  // Als de connection verwijderd wordt, zet dan de property op nil
  if (AComponent = FConnection) and (Operation = opRemove) then
    Connection := nil;
end;

end.
