{|
  Unit   : uEstSearchDialogNexus
  Date   : 01-01-2004
  Auteur : Erik Stok
  Doel   : Nexus versie van het search dialog component
|}
unit uEstSearchDialogNexus;

interface

uses
  Classes, DB, nxDB, uEstSearchDialog;

type

  TEstSearchDialogNexus = class(TEstSearchDialog)
  private
    FConnection: TnxDatabase;
    FSearchQuery: TnxQuery;
    FcountQuery: TnxQuery;
  protected
    procedure SetConnection(const Value: TnxDatabase); virtual;

    function SearchDataSet: TDataSet; override;
    function CountDataSet: TDataSet; override;

    procedure DoSetSearchQuery(Sender: TObject; SQL: String); override;
    procedure DoSetCountQuery(Sender: TObject; SQL: String); override;

    function ValidConnection: Boolean; override;

    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;

    procedure AssignTo(Dest: TPersistent); override;

  published
    property Connection: TnxDatabase read FConnection write SetConnection;
  end;


implementation

{ TEstSearchDialogNexus }

constructor TEstSearchDialogNexus.Create(AOwner: TComponent);
begin
  inherited;

  // Init privates
  FConnection := nil;

  FSearchQuery := TnxQuery.Create(Self);
  FcountQuery := TnxQuery.Create(Self);
end;

destructor TEstSearchDialogNexus.Destroy;
begin
  // Ruim alles netjes op
  FSearchQuery.Free;
  FcountQuery.Free;

  inherited;
end;

{|
  Procedure : TEstSearchDialogNexus.SetConnection
  Auteur    : Erik Stok
  Doel      : Stel de connection van het search dialog component in
|}
procedure TEstSearchDialogNexus.SetConnection(const Value: TnxDatabase);
begin
  if Value <> FConnection then
  begin
    // Stel connection in op gegeven waarde
    FConnection := Value;

    // Stel van de search en count queries ook de connections in
    FSearchQuery.Database := FConnection;
    FcountQuery.Database := FConnection;
  end;
end;

function TEstSearchDialogNexus.CountDataSet: TDataSet;
begin
  Result := FCountQuery;
end;

function TEstSearchDialogNexus.SearchDataSet: TDataSet;
begin
  Result := FSearchQuery;
end;

procedure TEstSearchDialogNexus.DoSetSearchQuery(Sender: TObject; SQL: String);
begin
  inherited;

  // Stel search query in
  FSearchQuery.Close;
  FSearchQuery.SQL.Text := SQL;
end;

procedure TEstSearchDialogNexus.DoSetCountQuery(Sender: TObject; SQL: String);
begin
  inherited;

  // Stel count query in
  FCountQuery.Close;
  FCountQuery.SQL.Text := SQL;
end;

{|
  Procedure : TEstSearchDialogNexus.AssignTo
  Auteur    : Erik Stok
  Doel      : Assign ook de connection
|}
procedure TEstSearchDialogNexus.AssignTo(Dest: TPersistent);
var
  DestSearchDialog : TEstSearchDialogNexus;
begin
  inherited AssignTo(Dest);

  DestSearchDialog := Dest as TEstSearchDialogNexus;
  DestSearchDialog.Connection := Connection;
end;

{|
  Procedure : TEstSearchDialogNexus.ValidConnection
  Auteur    : Erik Stok
  Doel      : Controleer of de opgegeven connection geldig is
|}
function TEstSearchDialogNexus.ValidConnection: Boolean;
begin
  Result := Assigned(Connection);
end;

procedure TEstSearchDialogNexus.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited;

  // Als de connection verwijderd wordt, zet dan de property op nil
  if (AComponent = FConnection) and (Operation = opRemove) then
    Connection := nil;
end;

end.
