{
  Unit   : uEstSearchDialogIntl
  Datum  : 5-5-2004
  Auteur : Erik Stok
  Doel   : Vertalingen van de dialoogvensters
}
unit uEstSearchDialogIntl;

interface

uses
  Classes;

type
  TEstSearchDialogIntl = class(TObject)
  private
    FCaptionDialog: String;
    FLabelField: String;
    FLabelComparison: String;
    FLabelValue: String;
    FLabelOperator: String;

    FButtonMore: String;
    FButtonLess: String;
    FButtonSearch: String;
    FButtonOK: String;
    FButtonCancel: String;
    FButtonSelect: String;
    FButtonClose: String;

    FErrorInvalidDateTimeFormula: String;
    FErrorInvalidDate: String;
    FErrorInvalidTime: String;
    FErrorInvalidDateTime: String;
    FErrorInvalidNumber: String;

    FMessageTooManyRecords: String;

    FDateTimeValueNow: String;
    FDateTimeValueSecond: String;
    FDateTimeValueMinute: String;
    FDateTimeValueHour: String;
    FDateTimeValueDay: String;
    FDateTimeValueWeek: String;
    FDateTimeValueMonth: String;
    FDateTimeValueQuarter: String;
    FDateTimeValueYear: String;

    FComparisonBeginsWith: String;
    FComparisonNotBeginsWith: String;
    FComparisonContains: String;
    FComparisonNotContains: String;
    FComparisonEndsWith: String;
    FComparisonNotEndsWith: String;
    FComparisonEmpty: String;
    FComparisonNotEmpty: String;

    FOperatorAnd: String;
    FOperatorOr: String;
    FOperatorAndAll: String;
    FOperatorOrAll: String;
  public
    constructor Create;

    procedure DefaultTranslations; virtual;

    property CaptionDialog: String read FCaptionDialog write FCaptionDialog;
    property LabelField: String read FLabelField write FLabelField;
    property LabelComparison: String read FLabelComparison write FLabelComparison;
    property LabelValue: String read FLabelValue write FLabelValue;
    property LabelOperator: String read FLabelOperator write FLabelOperator;

    property ButtonMore: String read FButtonMore write FButtonMore;
    property ButtonLess: String read FButtonLess write FButtonLess;
    property ButtonSearch: String read FButtonSearch write FButtonSearch;
    property ButtonOK: String read FButtonOK write FButtonOK;
    property ButtonCancel: String read FButtonCancel write FButtonCancel;
    property ButtonSelect: String read FButtonSelect write FButtonSelect;
    property ButtonClose: String read FButtonClose write FButtonClose;

    property ErrorInvalidDateTimeFormula: String read FErrorInvalidDateTimeFormula write FErrorInvalidDateTimeFormula;
    property ErrorInvalidDate: String read FErrorInvalidDate write FErrorInvalidDate;
    property ErrorInvalidTime: String read FErrorInvalidTime write FErrorInvalidTime;
    property ErrorInvalidDateTime: String read FErrorInvalidDateTime write FErrorInvalidDateTime;
    property ErrorInvalidNumber: String read FErrorInvalidNumber write FErrorInvalidNumber;

    property MessageTooManyRecords: String read FMessageTooManyRecords write FMessageTooManyRecords;

    property DateTimeValueNow: String read FDateTimeValueNow write FDateTimeValueNow;
    property DateTimeValueSecond: String read FDateTimeValueSecond write FDateTimeValueSecond;
    property DateTimeValueMinute: String read FDateTimeValueMinute write FDateTimeValueMinute;
    property DateTimeValueHour: String read FDateTimeValueHour write FDateTimeValueHour;
    property DateTimeValueDay: String read FDateTimeValueDay write FDateTimeValueDay;
    property DateTimeValueWeek: String read FDateTimeValueWeek write FDateTimeValueWeek;
    property DateTimeValueMonth: String read FDateTimeValueMonth write FDateTimeValueMonth;
    property DateTimeValueQuarter: String read FDateTimeValueQuarter write FDateTimeValueQuarter;
    property DateTimeValueYear: String read FDateTimeValueYear write FDateTimeValueYear;

    property ComparisonBeginsWith: String read FComparisonBeginsWith write FComparisonBeginsWith;
    property ComparisonNotBeginsWith: String read FComparisonNotBeginsWith write FComparisonNotBeginsWith;
    property ComparisonContains: String read FComparisonContains write FComparisonContains;
    property ComparisonNotContains: String read FComparisonNotContains write FComparisonNotContains;
    property ComparisonEndsWith: String read FComparisonEndsWith write FComparisonEndsWith;
    property ComparisonNotEndsWith: String read FComparisonNotEndsWith write FComparisonNotEndsWith;
    property ComparisonEmpty: String read FComparisonEmpty write FComparisonEmpty;
    property ComparisonNotEmpty: String read FComparisonNotEmpty write FComparisonNotEmpty;

    property OperatorAnd: String read FOperatorAnd write FOperatorAnd;
    property OperatorOr: String read FOperatorOr write FOperatorOr;
    property OperatorAndAll: String read FOperatorAndAll write FOperatorAndAll;
    property OperatorOrAll: String read FOperatorOrAll write FOperatorOrAll;
  end;

  TEstSearchDialogInternational = class(TComponent)
  private
    FActive: Boolean;

    FCaptionDialog: String;
    FLabelField: String;
    FLabelComparison: String;
    FLabelValue: String;
    FLabelOperator: String;

    FButtonMore: String;
    FButtonLess: String;
    FButtonSearch: String;
    FButtonOK: String;
    FButtonCancel: String;
    FButtonSelect: String;
    FButtonClose: String;

    FErrorInvalidDateTimeFormula: String;
    FErrorInvalidDate: String;
    FErrorInvalidTime: String;
    FErrorInvalidDateTime: String;
    FErrorInvalidNumber: String;

    FMessageTooManyRecords: String;

    FDateTimeValueNow: String;
    FDateTimeValueSecond: String;
    FDateTimeValueMinute: String;
    FDateTimeValueHour: String;
    FDateTimeValueDay: String;
    FDateTimeValueWeek: String;
    FDateTimeValueMonth: String;
    FDateTimeValueQuarter: String;
    FDateTimeValueYear: String;

    FComparisonBeginsWith: String;
    FComparisonNotBeginsWith: String;
    FComparisonContains: String;
    FComparisonNotContains: String;
    FComparisonEndsWith: String;
    FComparisonNotEndsWith: String;
    FComparisonEmpty: String;
    FComparisonNotEmpty: String;

    FOperatorAnd: String;
    FOperatorOr: String;
    FOperatorAndAll: String;
    FOperatorOrAll: String;
  protected
    procedure SetActive(const Value: Boolean); virtual;

    procedure SetTranslations; virtual;
    procedure DefaultTranslations; virtual;
  public
    constructor Create(AOwner: TComponent); override;
  published
    property Active: Boolean read FActive write SetActive;

    property CaptionDialog: String read FCaptionDialog write FCaptionDialog;
    property LabelField: String read FLabelField write FLabelField;
    property LabelComparison: String read FLabelComparison write FLabelComparison;
    property LabelValue: String read FLabelValue write FLabelValue;
    property LabelOperator: String read FLabelOperator write FLabelOperator;

    property ButtonMore: String read FButtonMore write FButtonMore;
    property ButtonLess: String read FButtonLess write FButtonLess;
    property ButtonSearch: String read FButtonSearch write FButtonSearch;
    property ButtonOK: String read FButtonOK write FButtonOK;
    property ButtonCancel: String read FButtonCancel write FButtonCancel;
    property ButtonSelect: String read FButtonSelect write FButtonSelect;
    property ButtonClose: String read FButtonClose write FButtonClose;

    property ErrorInvalidDateTimeFormula: String read FErrorInvalidDateTimeFormula write FErrorInvalidDateTimeFormula;
    property ErrorInvalidDate: String read FErrorInvalidDate write FErrorInvalidDate;
    property ErrorInvalidTime: String read FErrorInvalidTime write FErrorInvalidTime;
    property ErrorInvalidDateTime: String read FErrorInvalidDateTime write FErrorInvalidDateTime;
    property ErrorInvalidNumber: String read FErrorInvalidNumber write FErrorInvalidNumber;

    property MessageTooManyRecords: String read FMessageTooManyRecords write FMessageTooManyRecords;

    property DateTimeValueNow: String read FDateTimeValueNow write FDateTimeValueNow;
    property DateTimeValueSecond: String read FDateTimeValueSecond write FDateTimeValueSecond;
    property DateTimeValueMinute: String read FDateTimeValueMinute write FDateTimeValueMinute;
    property DateTimeValueHour: String read FDateTimeValueHour write FDateTimeValueHour;
    property DateTimeValueDay: String read FDateTimeValueDay write FDateTimeValueDay;
    property DateTimeValueWeek: String read FDateTimeValueWeek write FDateTimeValueWeek;
    property DateTimeValueMonth: String read FDateTimeValueMonth write FDateTimeValueMonth;
    property DateTimeValueQuarter: String read FDateTimeValueQuarter write FDateTimeValueQuarter;
    property DateTimeValueYear: String read FDateTimeValueYear write FDateTimeValueYear;

    property ComparisonBeginsWith: String read FComparisonBeginsWith write FComparisonBeginsWith;
    property ComparisonNotBeginsWith: String read FComparisonNotBeginsWith write FComparisonNotBeginsWith;
    property ComparisonContains: String read FComparisonContains write FComparisonContains;
    property ComparisonNotContains: String read FComparisonNotContains write FComparisonNotContains;
    property ComparisonEndsWith: String read FComparisonEndsWith write FComparisonEndsWith;
    property ComparisonNotEndsWith: String read FComparisonNotEndsWith write FComparisonNotEndsWith;
    property ComparisonEmpty: String read FComparisonEmpty write FComparisonEmpty;
    property ComparisonNotEmpty: String read FComparisonNotEmpty write FComparisonNotEmpty;

    property OperatorAnd: String read FOperatorAnd write FOperatorAnd;
    property OperatorOr: String read FOperatorOr write FOperatorOr;
    property OperatorAndAll: String read FOperatorAndAll write FOperatorAndAll;
    property OperatorOrAll: String read FOperatorOrAll write FOperatorOrAll;
  end;

  // EstSearchDialogIntl singleton functie
  function EstSearchDialogIntl: TEstSearchDialogIntl;

implementation

var
  InternalEstSearchDialogIntl: TEstSearchDialogIntl;

function EstSearchDialogIntl: TEstSearchDialogIntl;
begin
  // Maak als er nog geen instantie is van InternalEstSearchDialogIntl een
  // nieuwe instantie aan
  if not Assigned(InternalEstSearchDialogIntl) then
    InternalEstSearchDialogIntl := TEstSearchDialogIntl.Create;

  // Geef de gemaakte instantie als resultaat
  Result := InternalEstSearchDialogIntl;
end;

{ TEstSearchDialogIntl }

constructor TEstSearchDialogIntl.Create;
begin
  DefaultTranslations;
end;

{
  Procedure : TEstSearchDialogIntl.DefaultTranslations
  Auteur    : Erik Stok
  Doel      : Stel standaardvertalingen in
}

procedure TEstSearchDialogIntl.DefaultTranslations;
begin
  // Caption
  FCaptionDialog := 'Search';

  // Labels
  FLabelField := 'Field:';
  FLabelComparison := 'Comparison:';
  FLabelValue := 'Value:';
  FLabelOperator := 'Operator:';

  // Buttons
  FButtonMore := 'More';
  FButtonLess := 'Less';
  FButtonSearch := 'Search';
  FButtonOK := 'OK';
  FButtonCancel := 'Cancel';
  FButtonSelect := 'Select';
  FButtonClose := 'Close';

  // Errors
  FErrorInvalidDateTimeFormula := 'Invalid datetime formula value';
  FErrorInvalidDate := 'Invalid date';
  FErrorInvalidTime := 'Invalid time';
  FErrorInvalidDateTime := 'Invalid date/time';
  FErrorInvalidNumber := 'Invalid number';

  // Messages
  FMessageTooManyRecords := 'The nr of result records %0:d exceeds the maximum of %1:d. Use more specific search criteria.';

  // Special datetime values
  FDateTimeValueNow := 'NOW';
  FDateTimeValueSecond := 'SECOND';
  FDateTimeValueMinute := 'MINUTE';
  FDateTimeValueHour := 'HOUR';
  FDateTimeValueDay := 'DAY';
  FDateTimeValueWeek := 'WEEK';
  FDateTimeValueMonth := 'MONTH';
  FDateTimeValueQuarter := 'QUARTER';
  FDateTimeValueYear := 'YEAR';

  // Comparison text
  FComparisonBeginsWith := 'starts with';
  FComparisonNotBeginsWith := 'does not start with';
  FComparisonContains := 'contains';
  FComparisonNotContains := 'does not contain';
  FComparisonEndsWith := 'ends with';
  FComparisonNotEndsWith := 'does not end with';
  FComparisonEmpty := 'is empty';
  FComparisonNotEmpty := 'is not empty';

  // Operator text
  FOperatorAnd := 'and';
  FOperatorOr := 'or';
  FOperatorAndAll := 'and all';
  FOperatorOrAll := 'or all';
end;

{ TEstSearchDialogInternational }

constructor TEstSearchDialogInternational.Create(AOwner: TComponent);
begin
  inherited;

  // Stel in op de standaard
  FCaptionDialog := EstSearchDialogIntl.CaptionDialog;

  FLabelField := EstSearchDialogIntl.LabelField;
  FLabelComparison := EstSearchDialogIntl.LabelComparison;
  FLabelValue := EstSearchDialogIntl.LabelValue;
  FLabelOperator := EstSearchDialogIntl.LabelOperator;

  FButtonMore := EstSearchDialogIntl.ButtonMore;
  FButtonLess := EstSearchDialogIntl.ButtonLess;
  FButtonSearch := EstSearchDialogIntl.ButtonSearch;
  FButtonOK := EstSearchDialogIntl.ButtonOK;
  FButtonCancel := EstSearchDialogIntl.ButtonCancel;
  FButtonSelect := EstSearchDialogIntl.ButtonSelect;
  FButtonClose := EstSearchDialogIntl.ButtonClose;

  FErrorInvalidDateTimeFormula := EstSearchDialogIntl.ErrorInvalidDateTimeFormula;
  FErrorInvalidDate := EstSearchDialogIntl.ErrorInvalidDate;
  FErrorInvalidTime := EstSearchDialogIntl.ErrorInvalidTime;
  FErrorInvalidDateTime := EstSearchDialogIntl.ErrorInvalidDateTime;
  FErrorInvalidNumber := EstSearchDialogIntl.ErrorInvalidNumber;

  FMessageTooManyRecords := EstSearchDialogIntl.MessageTooManyRecords;

  FDateTimeValueNow := EstSearchDialogIntl.DateTimeValueNow;
  FDateTimeValueSecond := EstSearchDialogIntl.DateTimeValueSecond;
  FDateTimeValueMinute := EstSearchDialogIntl.DateTimeValueMinute;
  FDateTimeValueHour := EstSearchDialogIntl.DateTimeValueHour;
  FDateTimeValueDay := EstSearchDialogIntl.DateTimeValueDay;
  FDateTimeValueWeek := EstSearchDialogIntl.DateTimeValueWeek;
  FDateTimeValueMonth := EstSearchDialogIntl.DateTimeValueMonth;
  FDateTimeValueQuarter := EstSearchDialogIntl.DateTimeValueQuarter;
  FDateTimeValueYear := EstSearchDialogIntl.DateTimeValueYear;

  FComparisonBeginsWith := EstSearchDialogIntl.ComparisonBeginsWith;
  FComparisonNotBeginsWith := EstSearchDialogIntl.ComparisonNotBeginsWith;
  FComparisonContains := EstSearchDialogIntl.ComparisonContains;
  FComparisonNotContains := EstSearchDialogIntl.ComparisonNotContains;
  FComparisonEndsWith := EstSearchDialogIntl.ComparisonEndsWith;
  FComparisonNotEndsWith := EstSearchDialogIntl.ComparisonNotEndsWith;
  FComparisonEmpty := EstSearchDialogIntl.ComparisonEmpty;
  FComparisonNotEmpty := EstSearchDialogIntl.ComparisonNotEmpty;

  FOperatorAnd := EstSearchDialogIntl.OperatorAnd;
  FOperatorOr := EstSearchDialogIntl.OperatorOr;
  FOperatorAndAll := EstSearchDialogIntl.OperatorAndAll;
  FOperatorOrAll := EstSearchDialogIntl.OperatorOrAll;
end;

procedure TEstSearchDialogInternational.SetActive(const Value: Boolean);
begin
  FActive := Value;

  if FActive then
    SetTranslations;
end;

{
  Procedure : TEstSearchDialogInternational.SetTranslations
  Auteur    : Erik Stok
  Doel      : Stel vertalingen in
}
procedure TEstSearchDialogInternational.SetTranslations;
begin
  // Stel singleton in op waarden van het component
  EstSearchDialogIntl.CaptionDialog := FCaptionDialog;

  EstSearchDialogIntl.LabelField := FLabelField;
  EstSearchDialogIntl.LabelComparison := FLabelComparison;
  EstSearchDialogIntl.LabelValue := FLabelValue;
  EstSearchDialogIntl.LabelOperator := FLabelOperator;

  EstSearchDialogIntl.ButtonMore := FButtonMore;
  EstSearchDialogIntl.ButtonLess := FButtonLess;
  EstSearchDialogIntl.ButtonSearch := FButtonSearch;
  EstSearchDialogIntl.ButtonOK := FButtonOK;
  EstSearchDialogIntl.ButtonCancel := FButtonCancel;
  EstSearchDialogIntl.ButtonSelect := FButtonSelect;
  EstSearchDialogIntl.ButtonClose := FButtonClose;

  EstSearchDialogIntl.ErrorInvalidDateTimeFormula := FErrorInvalidDateTimeFormula;
  EstSearchDialogIntl.ErrorInvalidDate := FErrorInvalidDate;
  EstSearchDialogIntl.ErrorInvalidTime := FErrorInvalidTime;
  EstSearchDialogIntl.ErrorInvalidDateTime := FErrorInvalidDateTime;
  EstSearchDialogIntl.ErrorInvalidNumber := FErrorInvalidNumber;

  EstSearchDialogIntl.MessageTooManyRecords := FMessageTooManyRecords;

  EstSearchDialogIntl.DateTimeValueNow := FDateTimeValueNow;
  EstSearchDialogIntl.DateTimeValueSecond := FDateTimeValueSecond;
  EstSearchDialogIntl.DateTimeValueMinute := FDateTimeValueMinute;
  EstSearchDialogIntl.DateTimeValueHour := FDateTimeValueHour;
  EstSearchDialogIntl.DateTimeValueDay := FDateTimeValueDay;
  EstSearchDialogIntl.DateTimeValueWeek := FDateTimeValueWeek;
  EstSearchDialogIntl.DateTimeValueMonth := FDateTimeValueMonth;
  EstSearchDialogIntl.DateTimeValueQuarter := FDateTimeValueQuarter;
  EstSearchDialogIntl.DateTimeValueYear := FDateTimeValueYear;

  EstSearchDialogIntl.ComparisonBeginsWith := FComparisonBeginsWith;
  EstSearchDialogIntl.ComparisonNotBeginsWith := FComparisonNotBeginsWith;
  EstSearchDialogIntl.ComparisonContains := FComparisonContains;
  EstSearchDialogIntl.ComparisonNotContains := FComparisonNotContains;
  EstSearchDialogIntl.ComparisonEndsWith := FComparisonEndsWith;
  EstSearchDialogIntl.ComparisonNotEndsWith := FComparisonNotEndsWith;
  EstSearchDialogIntl.ComparisonEmpty := FComparisonEmpty;
  EstSearchDialogIntl.ComparisonNotEmpty := FComparisonNotEmpty;

  EstSearchDialogIntl.OperatorAnd := FOperatorAnd;
  EstSearchDialogIntl.OperatorOr := FOperatorOr;
  EstSearchDialogIntl.OperatorAndAll := FOperatorAndAll;
  EstSearchDialogIntl.OperatorOrAll := FOperatorOrAll;
end;

{
  Procedure : TEstSearchDialogInternational.DefaultTranslations
  Auteur    : Erik Stok
  Doel      : Stel vertalingen op standaard waarden in
}

procedure TEstSearchDialogInternational.DefaultTranslations;
begin
  InternalEstSearchDialogIntl.DefaultTranslations;
end;

initialization
  // Initialiseer singleton interne variabele op leeg
  InternalEstSearchDialogIntl := nil;

finalization
  // Ruim eventuele singleton instantie op
  if Assigned(InternalEstSearchDialogIntl) then
    InternalEstSearchDialogIntl.Free;

end.
