{|
  Unit   : uEstSearchDialogIbx
  Date   : 01-01-2004
  Auteur : Erik Stok
  Doel   : Ibx versie van het search dialog component
|}
unit uEstSearchDialogIbx;

interface

uses
  Classes, DB, uEstSearchDialog, IBDatabase, IBCustomDataSet;

type

  TEstSearchDialogIbx = class(TEstSearchDialog)
  private
    FConnection: TIBDatabase;
    FSearchQuery: TIBDataSet;
    FcountQuery: TIBDataSet;
  protected
    procedure SetConnection(const Value: TIBDatabase); virtual;

    function SearchDataSet: TDataSet; override;
    function CountDataSet: TDataSet; override;

    procedure DoSetSearchQuery(Sender: TObject; SQL: String); override;
    procedure DoSetCountQuery(Sender: TObject; SQL: String); override;

    function ValidConnection: Boolean; override;

    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;

    procedure AssignTo(Dest: TPersistent); override;

  published
    property Connection: TIBDatabase read FConnection write SetConnection;
  end;


implementation

{ TEstSearchDialogIbx }

constructor TEstSearchDialogIbx.Create(AOwner: TComponent);
begin
  inherited;

  // Init privates
  FConnection := nil;

  FSearchQuery := TIBDataSet.Create(Self);
  FcountQuery := TIBDataSet.Create(Self);
end;

destructor TEstSearchDialogIbx.Destroy;
begin
  // Ruim alles netjes op
  FSearchQuery.Free;
  FcountQuery.Free;

  inherited;
end;

{|
  Procedure : TEstSearchDialogIbx.SetConnection
  Auteur    : Erik Stok
  Doel      : Stel de connection van het search dialog component in
|}
procedure TEstSearchDialogIbx.SetConnection(const Value: TIBDatabase);
begin
  if Value <> FConnection then
  begin
    // Stel connection in op gegeven waarde
    FConnection := Value;

    // Stel van de search en count queries ook de connections in
    FSearchQuery.Database := FConnection;
    FcountQuery.Database := FConnection;
  end;
end;

function TEstSearchDialogIbx.CountDataSet: TDataSet;
begin
  Result := FCountQuery;
end;

function TEstSearchDialogIbx.SearchDataSet: TDataSet;
begin
  Result := FSearchQuery;
end;

procedure TEstSearchDialogIbx.DoSetSearchQuery(Sender: TObject; SQL: String);
begin
  inherited;

  // Stel search query in
  FSearchQuery.Close;
  FSearchQuery.SelectSQL.Text := SQL;
end;

procedure TEstSearchDialogIbx.DoSetCountQuery(Sender: TObject; SQL: String);
begin
  inherited;

  // Stel count query in
  FCountQuery.Close;
  FCountQuery.SelectSQL.Text := SQL;
end;

{|
  Procedure : TEstSearchDialogIbx.AssignTo
  Auteur    : Erik Stok
  Doel      : Assign ook de connection
|}
procedure TEstSearchDialogIbx.AssignTo(Dest: TPersistent);
var
  DestSearchDialog : TEstSearchDialogIbx;
begin
  inherited AssignTo(Dest);

  DestSearchDialog := Dest as TEstSearchDialogIbx;
  DestSearchDialog.Connection := Connection;
end;

{|
  Procedure : TEstSearchDialogIbx.ValidConnection
  Auteur    : Erik Stok
  Doel      : Controleer of de opgegeven connection geldig is
|}
function TEstSearchDialogIbx.ValidConnection: Boolean;
begin
  Result := Assigned(Connection);
end;

procedure TEstSearchDialogIbx.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited;

  // Als de connection verwijderd wordt, zet dan de property op nil
  if (AComponent = FConnection) and (Operation = opRemove) then
    Connection := nil;
end;

end.
