{|
  Unit   : uEstSearchDialogFF
  Date   : 01-01-2004
  Auteur : Erik Stok
  Doel   : FF versie van het search dialog component
|}
unit uEstSearchDialogFF;

interface

uses
  Classes, DB, ffDB, uEstSearchDialog;

type

  TEstSearchDialogFF = class(TEstSearchDialog)
  private
    FConnection: TffDatabase;
    FSearchQuery: TffQuery;
    FcountQuery: TffQuery;
  protected
    procedure SetConnection(const Value: TffDatabase); virtual;

    function SearchDataSet: TDataSet; override;
    function CountDataSet: TDataSet; override;

    procedure DoSetSearchQuery(Sender: TObject; SQL: String); override;
    procedure DoSetCountQuery(Sender: TObject; SQL: String); override;

    function ValidConnection: Boolean; override;

    procedure Notification(AComponent: TComponent; Operation: TOperation); override;
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;

    procedure AssignTo(Dest: TPersistent); override;

  published
    property Connection: TffDatabase read FConnection write SetConnection;
  end;


implementation

{ TEstSearchDialogFF }

constructor TEstSearchDialogFF.Create(AOwner: TComponent);
begin
  inherited;

  // Init privates
  FConnection := nil;

  FSearchQuery := TffQuery.Create(Self);
  FcountQuery := TffQuery.Create(Self);
end;

destructor TEstSearchDialogFF.Destroy;
begin
  // Ruim alles netjes op
  FSearchQuery.Free;
  FcountQuery.Free;

  inherited;
end;

{|
  Procedure : TEstSearchDialogFF.SetConnection
  Auteur    : Erik Stok
  Doel      : Stel de connection van het search dialog component in
|}
procedure TEstSearchDialogFF.SetConnection(const Value: TffDatabase);
begin
  if Value <> FConnection then
  begin
    // Stel connection in op gegeven waarde
    FConnection := Value;

    // Stel van de search en count queries ook de connections in
    FSearchQuery.DatabaseName := FConnection.DatabaseName;
    FcountQuery.DatabaseName := FConnection.DatabaseName;
  end;
end;

function TEstSearchDialogFF.CountDataSet: TDataSet;
begin
  Result := FCountQuery;
end;

function TEstSearchDialogFF.SearchDataSet: TDataSet;
begin
  Result := FSearchQuery;
end;

procedure TEstSearchDialogFF.DoSetSearchQuery(Sender: TObject; SQL: String);
begin
  inherited;

  // Stel search query in
  FSearchQuery.Close;
  FSearchQuery.SQL.Text := SQL;
end;

procedure TEstSearchDialogFF.DoSetCountQuery(Sender: TObject; SQL: String);
begin
  inherited;

  // Stel count query in
  FCountQuery.Close;
  FCountQuery.SQL.Text := SQL;
end;

{|
  Procedure : TEstSearchDialogFF.AssignTo
  Auteur    : Erik Stok
  Doel      : Assign ook de connection
|}
procedure TEstSearchDialogFF.AssignTo(Dest: TPersistent);
var
  DestSearchDialog : TEstSearchDialogFF;
begin
  inherited AssignTo(Dest);

  DestSearchDialog := Dest as TEstSearchDialogFF;
  DestSearchDialog.Connection := Connection;
end;

{|
  Procedure : TEstSearchDialogFF.ValidConnection
  Auteur    : Erik Stok
  Doel      : Controleer of de opgegeven connection geldig is
|}
function TEstSearchDialogFF.ValidConnection: Boolean;
begin
  Result := Assigned(Connection);
end;

procedure TEstSearchDialogFF.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited;

  // Als de connection verwijderd wordt, zet dan de property op nil
  if (AComponent = FConnection) and (Operation = opRemove) then
    Connection := nil;
end;

end.
