{|
  Unit   : uEstSearchDialogEditor
  Datum  : 14-12-2003
  Auteur : Erik Stok
  Doel   : Component- en propertyeditors voor TEstSearchDialog
|}

unit uEstSearchDialogEditors;

interface

uses
  Classes, SysUtils, DesignEditors, DesignIntf, Controls, Dialogs,
  uEstSearchDialog, fEstSearchDialogEditor;

type
  TFrmEstSearchDialogEditorClass = class of TFrmEstSearchDialogEditor;

  TEstSearchDialogEditor = class(TComponentEditor)
  private
    procedure Configure;
    function EstSearchDialog: TEstSearchDialog;
  protected
    function SearchDialogEditorClass: TFrmEstSearchDialogEditorClass; virtual; abstract;
    function SearchDialogClass: TEstSearchDialogClass; virtual; abstract;
  public
    function GetVerbCount: Integer; override;
    function GetVerb(Index: Integer): string; override;
    procedure ExecuteVerb(Index: Integer); override;
  end;

  TEstSearchDialogPropertyEditor = class(TPropertyEditor)
  private
    function EstSearchDialog: TEstSearchDialog;
  protected
    function SearchDialogEditorClass: TFrmEstSearchDialogEditorClass; virtual; abstract;
    function SearchDialogClass: TEstSearchDialogClass; virtual; abstract;
  public
    procedure Edit; override;
    function GetValue: String; override;
    procedure SetValue(const Value: String); override;
    function GetAttributes: TPropertyAttributes; override;
  end;

implementation

{ TEstSearchDialogEditor }

{|
  Procedure : TEstSearchDialogEditor.GetVerbCount
  Auteur    : Erik Stok
  Doel      : Geef het aantal verbs
|}
function TEstSearchDialogEditor.GetVerbCount: Integer;
begin
  Result := 1;
end;

{|
  Procedure : TEstSearchDialogEditor.GetVerb
  Auteur    : Erik Stok
  Doel      : Geef de caption voor een verb
|}
function TEstSearchDialogEditor.GetVerb(Index: Integer): string;
begin
  Result := 'Configure...';
end;

{|
  Procedure : TEstSearchDialogEditor.ExecuteVerb
  Auteur    : Erik Stok
  Doel      : Voer een verb uit
|}
procedure TEstSearchDialogEditor.ExecuteVerb(Index: Integer);
begin
  // Voer geselecteerde verb uit
  Configure;
end;

{|
  Procedure : TEstSearchDialogEditor.EstSearchDialog
  Auteur    : Erik Stok
  Doel      : Geef het component waarop de component editor werkt als een
              TEstSearchDialog (easy access)
|}
function TEstSearchDialogEditor.EstSearchDialog: TEstSearchDialog;
begin
  Result := TEstSearchDialog(Component);
end;

{|
  Procedure : TEstSearchDialogEditor.Configure
  Auteur    : Erik Stok
  Doel      : Voer de configuratie van het component uit
|}
procedure TEstSearchDialogEditor.Configure;
var
  FrmEstSearchDialogEditor : TFrmEstSearchDialogEditor;
begin

  // Toon editor form
  FrmEstSearchDialogEditor := SearchDialogEditorClass.Create(nil);

  try
    FrmEstSearchDialogEditor.SearchDialog := EstSearchDialog;
    FrmEstSearchDialogEditor.SearchDialogClass := SearchDialogClass;

    if FrmEstSearchDialogEditor.ShowModal = mrOK then
      Designer.Modified;
  finally
    FrmEstSearchDialogEditor.Free;
  end;

end;

{ TEstSearchDialogPropertyEditor }

function TEstSearchDialogPropertyEditor.GetAttributes: TPropertyAttributes;
begin
  Result := [paDialog];
end;

procedure TEstSearchDialogPropertyEditor.Edit;
var
  FrmEstSearchDialogEditor : TFrmEstSearchDialogEditor;
begin
  inherited;

  // Toon editor form
  FrmEstSearchDialogEditor := SearchDialogEditorClass.Create(nil);

  try
    FrmEstSearchDialogEditor.SearchDialog := EstSearchDialog;
    FrmEstSearchDialogEditor.SearchDialogClass := SearchDialogClass; 

    if FrmEstSearchDialogEditor.ShowModal = mrOK then
      Designer.Modified;
  finally
    FrmEstSearchDialogEditor.Free;
  end;

end;

{|
  Procedure : TEstSearchDialogPropertyEditor.EstSearchDialog
  Auteur    : Erik Stok
  Doel      : Geef het component waarop de component editor werkt als een
              TEstSearchDialog (easy access)
|}
function TEstSearchDialogPropertyEditor.EstSearchDialog: TEstSearchDialog;
begin
  Result := TEstSearchDialog(GetComponent(0));
end;

function TEstSearchDialogPropertyEditor.GetValue: String;
begin
  // Geef de count query
  if GetName = 'CountQuery' then
    Result := EstSearchDialog.CountQuery.Text;

  // Geef de search query
  if GetName = 'SearchQuery' then
    Result := EstSearchDialog.SearchQuery.Text;

  // Geef het aantal items in de field list
  if GetName = 'SearchDialogFieldList' then
    Result := Format('<%d items>', [EstSearchDialog.SearchDialogFieldList.Count]);
end;

procedure TEstSearchDialogPropertyEditor.SetValue(const Value: String);
begin
  // Sla niets op
end;

end.
