{|
  Unit   : uEstSearchDialogDbx
  Date   : 01-01-2004
  Auteur : Erik Stok
  Doel   : Dbx versie van het search dialog component
|}
unit uEstSearchDialogDbx;

interface

uses
  Classes, DB, uEstSearchDialog, SQLExpr, DBClient, Provider, SysUtils;

type

  TEstSearchDialogDbx = class(TEstSearchDialog)
  private
    FConnection: TSQLConnection;
    FSearchQuery: TSQLDataSet;
    FSearchClientDataset: TClientDataSet;
    FSearchProvider: TDataSetProvider;
    FCountQuery: TSQLDataSet;
    FCountClientDataset: TClientDataSet;
    FCountProvider: TDataSetProvider;
  protected
    procedure SetConnection(const Value: TSQLConnection); virtual;

    function SearchDataSet: TDataSet; override;
    function CountDataSet: TDataSet; override;

    procedure DoSetSearchQuery(Sender: TObject; SQL: String); override;
    procedure DoSetCountQuery(Sender: TObject; SQL: String); override;

    function ValidConnection: Boolean; override;

    procedure Notification(AComponent: TComponent; Operation: TOperation); override;

  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;

    procedure AssignTo(Dest: TPersistent); override;

  published
    property Connection: TSQLConnection read FConnection write SetConnection;
  end;


implementation

{ TEstSearchDialogDbx }

constructor TEstSearchDialogDbx.Create(AOwner: TComponent);
begin
  inherited;

  // Init privates
  FConnection := nil;

  FSearchQuery := TSQLDataSet.Create(Self);
  FSearchClientDataset := TClientDataSet.Create(Self);
  FSearchProvider := TDataSetProvider.Create(Self);

  FSearchProvider.Name := Name + 'SearchProvider' + FormatDateTime('HHNNSSZZZ', Now);
  FSearchProvider.DataSet := FSearchQuery;
  FSearchClientDataset.ProviderName := FSearchProvider.Name;

  FCountQuery := TSQLDataSet.Create(Self);
  FCountClientDataset := TClientDataSet.Create(Self);
  FCountProvider := TDataSetProvider.Create(Self);

  FCountProvider.Name := Name + 'CountProvider' + FormatDateTime('HHNNSSZZZ', Now);
  FCountProvider.DataSet := FCountQuery;
  FCountClientDataset.ProviderName := FCountProvider.Name;

end;

destructor TEstSearchDialogDbx.Destroy;
begin
  // Ruim alles netjes op
  FSearchClientDataset.Free;
  FSearchProvider.Free;
  FSearchQuery.Free;

  FCountClientDataset.Free;
  FCountProvider.Free;
  FCountQuery.Free;

  inherited;
end;

{|
  Procedure : TEstSearchDialogDbx.SetConnection
  Auteur    : Erik Stok
  Doel      : Stel de connection van het search dialog component in
|}
procedure TEstSearchDialogDbx.SetConnection(const Value: TSQLConnection);
begin
  if Value <> FConnection then
  begin
    // Stel connection in op gegeven waarde
    FConnection := Value;

    // Stel van de search en count queries ook de connections in
    FSearchQuery.SqlConnection := FConnection;
    FcountQuery.SqlConnection := FConnection;
  end;
end;

function TEstSearchDialogDbx.CountDataSet: TDataSet;
begin
  Result := FCountClientDataset;
end;

function TEstSearchDialogDbx.SearchDataSet: TDataSet;
begin
  Result := FSearchClientDataSet;
end;

procedure TEstSearchDialogDbx.DoSetSearchQuery(Sender: TObject; SQL: String);
begin
  inherited;

  // Stel search query in
  FSearchClientDataset.Close;
  FSearchQuery.Close;
  FSearchQuery.CommandText := SQL;
end;

procedure TEstSearchDialogDbx.DoSetCountQuery(Sender: TObject; SQL: String);
begin
  inherited;

  // Stel count query in
  FCountClientDataset.Close;
  FCountQuery.Close;
  FCountQuery.CommandText := SQL;
end;

{|
  Procedure : TEstSearchDialogDbx.AssignTo
  Auteur    : Erik Stok
  Doel      : Assign ook de connection
|}
procedure TEstSearchDialogDbx.AssignTo(Dest: TPersistent);
var
  DestSearchDialog : TEstSearchDialogDbx;
begin
  inherited AssignTo(Dest);

  DestSearchDialog := Dest as TEstSearchDialogDbx;
  DestSearchDialog.Connection := Connection;
end;

{|
  Procedure : TEstSearchDialogDbx.ValidConnection
  Auteur    : Erik Stok
  Doel      : Controleer of de opgegeven connection geldig is
|}
function TEstSearchDialogDbx.ValidConnection: Boolean;
begin
  Result := Assigned(Connection);
end;

procedure TEstSearchDialogDbx.Notification(AComponent: TComponent; Operation: TOperation);
begin
  inherited;

  // Als de connection verwijderd wordt, zet dan de property op nil
  if (AComponent = FConnection) and (Operation = opRemove) then
    Connection := nil;
end;

end.
