{|
  Unit   : uEstSearchDialogDateUtils
  Datum  : 6-12-2003
  Auteur : Erik Stok
  Doel   : Zoekdialoog datum/tijd functies
|}

unit uEstSearchDialogDateUtils;

interface

uses
  SysUtils, DateUtils;

function OffsetForSecond(Offset: Integer): TDateTime;
function OffsetForMinute(OffSet: Integer): TDateTime;
function OffsetForHour(OffSet: Integer): TDateTime;
function OffsetForDay(OffSet: Integer): TDateTime;
function OffsetForWeek(OffSet: Integer): TDateTime;
function OffsetForMonth(OffSet: Integer): TDateTime;
function OffsetForQuarter(OffSet: Integer): TDateTime;
function OffsetForYear(OffSet: Integer): TDateTime;

implementation

function IncQuarter(const DateTime: TDateTime; NumberOfQuarters: Integer): TDateTime;
var
  Year, Month, Day, Quarter: Word;
begin
  DecodeDate(DateTime, Year, Month, Day);
  Quarter := (Month - 1) div 3;
  Result := IncMonth(EncodeDate(Year, (Quarter * 3) + 1, Day), NumberOfQuarters * 3);
  ReplaceTime(Result, DateTime);
end;

function StartOfTheMinute(const AValue: TDateTime): TDateTime;
var
  Year, Month, Day: Word;
  Hour, Minute, Second, Millisecond: Word;
begin
  DecodeDateTime(AValue, Year, Month, Day, Hour, Minute, Second, Millisecond);
  Result := EncodeDateTime(Year, Month, Day, Hour, Minute, 0, 0);
end;

function StartOfTheHour(const AValue: TDateTime): TDateTime;
var
  Year, Month, Day: Word;
  Hour, Minute, Second, Millisecond: Word;
begin
  DecodeDateTime(AValue, Year, Month, Day, Hour, Minute, Second, Millisecond);
  Result := EncodeDateTime(Year, Month, Day, Hour, 0, 0, 0);
end;

function StartOfTheQuarter(const AValue: TDateTime): TDateTime;
var
  Year, Month, Day, Quarter: Word;
begin
  DecodeDate(AValue, Year, Month, Day);
  Quarter := (Month - 1) div 3;
  Result := EncodeDate(Year, (Quarter * 3) + 1, 1);
end;

function OffsetForSecond(Offset: Integer): TDateTime;
begin
  Result := IncSecond(Now, Offset);
end;

function OffsetForMinute(OffSet: Integer): TDateTime;
begin
  Result := IncMinute(StartOfTheMinute(Now), Offset);
end;

function OffsetForHour(OffSet: Integer): TDateTime;
begin
  Result := IncHour(StartOfTheHour(Now), Offset);
end;

function OffsetForDay(OffSet: Integer): TDateTime;
begin
  Result := IncDay(StartOfTheDay(Now), Offset);
end;

function OffsetForWeek(OffSet: Integer): TDateTime;
begin
  Result := IncWeek(StartOfTheWeek(Now), Offset);
end;

function OffsetForMonth(OffSet: Integer): TDateTime;
begin
  Result := IncMonth(StartOfTheMonth(Now), Offset);
end;

function OffsetForQuarter(OffSet: Integer): TDateTime;
begin
  Result := IncQuarter(StartOfTheQuarter(Now), Offset);
end;

function OffsetForYear(OffSet: Integer): TDateTime;
begin
  Result := IncYear(StartOfTheYear(Now), Offset);
end;

end.
